/* IntegerMatrixValue.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.values;

import java.util.ResourceBundle;

import org.grinvin.invariants.InvariantComputer;
import org.grinvin.invariants.InvariantType;
import org.grinvin.util.GrinvinUtilities;

/**
 * 
 */
public class IntegerMatrixValue extends AbstractInvariantValue {
    
    //
    private static final String BUNDLE_NAME = "org.grinvin.invariants.resources";
    
    //
    private int[][] values;
    
    //
    public IntegerMatrixValue(int[][] values, InvariantComputer computer) {
        super(InvariantType.INTEGERMATRIX, computer);
        this.values = values;
    }
    
    //
    public String toText() {
        if (values.length == 0)
            return ResourceBundle.getBundle(BUNDLE_NAME).getString("empty");
        else {
            StringBuilder sb = new StringBuilder();
            for (int valuelist[] : values) {
                if (valuelist.length != 0) {
                    sb.append(IntegerValue.toText(valuelist[0]));
                    for(int i=1; i<valuelist.length; i++) {
                        sb.append(", ");
                        sb.append(IntegerValue.toText(valuelist[i]));
                    }
                    sb.append("; ");
                }
            }
            return sb.toString();
        }
    }
    
    //
    public String toHtml() {
        if (values.length == 0)
            return ResourceBundle.getBundle(BUNDLE_NAME).getString("empty");
        else {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<head>");
            sb.append("<style><!--body{");
            sb.append(GrinvinUtilities.getStyleSheetForFont("ToolTip.font"));
            sb.append("margin: 1px;}--></style>");
            sb.append("</head>");
            sb.append("<body>");
            sb.append("<table>");
            for (int valuelist[] : values) {
                if (valuelist.length != 0) {
                    sb.append("<tr>");
                    for (int value : valuelist) {
                        sb.append("<td>");
                        sb.append(IntegerValue.toText(value));
                        sb.append("</td>");
                    }
                    sb.append("</tr>");
                }
            }
            sb.append("</table>");
            sb.append("</body>");
            sb.append("</html>");
            return sb.toString();
        }
    }
    
}
