/* GraphListMultiPanelComponent.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */
package org.grinvin.gui.components;

import be.ugent.caagt.swirl.GenericSelectionModel;
import be.ugent.caagt.swirl.menus.MenuBuilder;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.grinvin.preferences.GrinvinPreferences;
import org.grinvin.worksheet.GraphListComponentType;
import org.grinvin.worksheet.WorksheetWindowModel;


/**
 * Component that holds different views for a
 * {@link org.grinvin.list.graphs.GraphListModel}.
 */
public class GraphListMultiPanelComponent extends JPanel {
    // TODO: do not use CardLayout - it is inefficient
    // see eg. http://java.sun.com/products/jfc/tsc/articles/cardpanel/index.html

    //
    private final Map<GraphListComponentType, JComponent> panels;
    //
    private final CardLayout cardLayout;

    //
    private final GenericSelectionModel<GraphListComponentType> model;
    //
    private final JPanel panel;

    //
    public GraphListMultiPanelComponent(WorksheetWindowModel worksheetWindowModel, ListSelectionModel selectionModel) {
        super(new BorderLayout());

        this.cardLayout = new CardLayout();
        this.panels = new HashMap<GraphListComponentType, JComponent>();
        this.model = worksheetWindowModel.getGlctModel();
        model.addChangeListener(new ChangeListener() {

            public void stateChanged(ChangeEvent e) {
                showCurrentComponent();
            }
        });
        
        MenuBuilder menuBuilder = new MenuBuilder();
        menuBuilder.load("/org/grinvin/gui/components/multipanel-actions.xml",
                "org.grinvin.gui.components.multipanel-actions");
        if (GrinvinPreferences.getInstance().getOsType() == GrinvinPreferences.OsType.MAC_OS_X) {
            menuBuilder.setPredicate("mac");
        }
        menuBuilder.registerGroup(
                "view.component", 
                model,
                "view.component.CELL", GraphListComponentType.CELL,
                "view.component.TABLE", GraphListComponentType.TABLE,
                "view.component.LIST", GraphListComponentType.LIST
                );
        panel = new JPanel(cardLayout);

        add(panel, BorderLayout.CENTER);
        add(menuBuilder.createJToolBar("toolbar"), BorderLayout.NORTH);

        
        for (GraphListComponentType glct : GraphListComponentType.values()) {
            JComponent component = glct.createComponent (worksheetWindowModel, selectionModel);
            panels.put(glct, component);
            panel.add(component, glct.toString());
        }
        
        showCurrentComponent();
    }

    private void showCurrentComponent() {
        GraphListComponentType type = model.getSelection();
        cardLayout.show(panel, type.toString());
        panels.get(type).requestFocusInWindow();
    }
}
