/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.util.Collection;
import java.util.Locale;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditCardTypeConverter
implements TypeConverter<String> {
    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public String convert(String input, Class<? extends String> targetType, Collection<ValidationError> errors) {
        String cardNumber = input.replaceAll("\\D", "");
        if (CreditCardTypeConverter.getCardType(cardNumber) != null) {
            return cardNumber;
        }
        errors.add(new ScopedLocalizableError("converter.creditCard", "invalidCreditCard", new Object[0]));
        return null;
    }

    public static Type getCardType(String cardNumber) {
        if (!CreditCardTypeConverter.isLuhnValid(cardNumber)) {
            return null;
        }
        if (CreditCardTypeConverter.checkCard(cardNumber, 15, "34", "37")) {
            return Type.AMEX;
        }
        if (CreditCardTypeConverter.checkCard(cardNumber, 14, "30", "36", "38")) {
            return Type.DinersClub;
        }
        if (CreditCardTypeConverter.checkCard(cardNumber, 16, "6011")) {
            return Type.Discover;
        }
        if (CreditCardTypeConverter.checkCard(cardNumber, 15, "2014", "2149")) {
            return Type.enRoute;
        }
        if (CreditCardTypeConverter.checkCard(cardNumber, 16, "3088", "3096", "3112", "3158", "3337", "3528")) {
            return Type.JCB;
        }
        if (CreditCardTypeConverter.checkCard(cardNumber, 16, "51", "52", "53", "54", "55")) {
            return Type.MasterCard;
        }
        if (CreditCardTypeConverter.checkCard(cardNumber, 13, "4") || CreditCardTypeConverter.checkCard(cardNumber, 16, "4")) {
            return Type.VISA;
        }
        return null;
    }

    private static boolean checkCard(String cardNumber, int length, String ... prefixes) {
        if (cardNumber.length() != length) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!cardNumber.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLuhnValid(String cardNumber) {
        if (cardNumber.length() < 13 || cardNumber.length() > 16) {
            return false;
        }
        int sum = 0;
        int length = cardNumber.length();
        for (int i = 0; i < length; ++i) {
            int pos = length - i - 1;
            int v = Integer.parseInt(cardNumber.substring(pos, pos + 1));
            if (i % 2 == 1) {
                v *= 2;
            }
            sum += v / 10 + v % 10;
        }
        return sum % 10 == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        AMEX,
        DinersClub,
        Discover,
        enRoute,
        JCB,
        MasterCard,
        VISA;

    }
}

