/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.action;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.util.UrlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OnwardResolution<T extends OnwardResolution<T>>
implements Resolution {
    private String path;
    private String event;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String anchor;

    public OnwardResolution(String path) {
        this.path = path;
    }

    public OnwardResolution(Class<? extends ActionBean> beanType) {
        this(StripesFilter.getConfiguration().getActionResolver().getUrlBinding(beanType));
    }

    public OnwardResolution(Class<? extends ActionBean> beanType, String event) {
        this(beanType);
        this.event = event;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected String getAnchor() {
        return this.anchor;
    }

    protected T setAnchor(String anchor) {
        this.anchor = anchor;
        return (T)this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "path='" + this.path + "'" + "}";
    }

    public T addParameter(String name, Object ... values) {
        if (this.parameters.containsKey(name)) {
            Object[] src = (Object[])this.parameters.get(name);
            Object[] dst = new Object[src.length + values.length];
            System.arraycopy(src, 0, dst, 0, src.length);
            System.arraycopy(values, 0, dst, src.length, values.length);
            this.parameters.put(name, dst);
        } else {
            this.parameters.put(name, values);
        }
        return (T)this;
    }

    public T addParameters(Map<String, ? extends Object> parameters) {
        for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
            this.addParameter(entry.getKey(), entry.getValue());
        }
        return (T)this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Deprecated
    public String getUrl() {
        return this.getUrl(Locale.getDefault());
    }

    public String getUrl(Locale locale) {
        UrlBuilder builder = new UrlBuilder(locale, this.path, false);
        if (this.event != null) {
            builder.setEvent(this.event);
        }
        if (this.anchor != null) {
            builder.setAnchor(this.anchor);
        }
        builder.addParameters(this.parameters);
        return builder.toString();
    }
}

