package org.inria.bmajwatcher.client.ui;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.RestDataSource;
import com.smartgwt.client.data.fields.DataSourceIntegerField;
import com.smartgwt.client.data.fields.DataSourceTextField;

public class BankTreeDataSource extends RestDataSource {

	public static final String VALUE = "value";
	
	private static Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
	
	private BankTreeDataSource(String bankName) {
		setID("treeDataSource_" + bankName);
		
		DataSourceIntegerField pkField = new DataSourceIntegerField("id");
		pkField.setHidden(true);
		pkField.setPrimaryKey(true);
		pkField.setRequired(true);
		
		DataSourceIntegerField fkField = new DataSourceIntegerField("parent");
		fkField.setHidden(true);
		fkField.setForeignKey(".id");
		fkField.setRootValue("1");
		fkField.setRequired(true);
		
		DataSourceTextField value = new DataSourceTextField(VALUE);
		
		
		setFields(pkField, fkField, value);
		
		// Url of the servlet to contact
		setDataURL(GWT.getModuleName() + "/bankDetailService?getxml=" + bankName);
		
	}
	
	public static DataSource getInstance(String bankName) {
		
		DataSource ds; 
		if ((ds = dataSources.get(bankName)) == null) {
			ds = new BankTreeDataSource(bankName);
			dataSources.put(bankName, ds);
		}
		
		return ds;
	}

}
