/*
 * Copyright 2005 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: PageSequenceWrapper.java 198354 2005-01-31 22:29:13Z gmazza $ */

package org.apache.fop.fo.pagination;

// Java
import java.util.List;
import java.util.ListIterator;

import org.xml.sax.Locator;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;

/**
 * The fo:page-sequence-wrapper formatting object, first introduced
 * in the XSL 1.1 WD.  Prototype version only, subject to change as
 * XSL 1.1 WD evolves.
 */
public class PageSequenceWrapper extends FObj {
    // The value of properties relevant for this FO
    private String id;
    private String indexClass;
    private String indexKey;
    // End of property values
    
    /**
     * @param parent FONode that is the parent of this object
     */
    public PageSequenceWrapper(FONode parent) {
        super(parent);
    }

    /**
     * @see org.apache.fop.fo.FObj#bind(PropertyList)
     */
    public void bind(PropertyList pList) throws FOPException {
        id = pList.get(PR_ID).getString();
        indexClass = pList.get(PR_INDEX_CLASS).getString();
        indexKey = pList.get(PR_INDEX_KEY).getString();
    }

    /**
     * @see org.apache.fop.fo.FONode#startOfNode
     */
    protected void startOfNode() throws FOPException {
        checkId(id);
    }

    /**
     * @see org.apache.fop.fo.FONode#validateChildNode(Locator, String, String)
        XSL/FOP: (bookmark+)
     */
    protected void validateChildNode(Locator loc, String nsURI, String localName) 
        throws ValidationException {
        if (!(nsURI == FO_URI && (localName.equals("page-sequence") || 
            localName.equals("page-sequence-wrapper")))) {
                invalidChildError(loc, nsURI, localName);
        }
    }

    /**
     * Return the "id" property.
     */
    public String getId() {
        return id;
    }

    /**
     * Return the "id" property.
     */
    public String getIndexClass() {
        return indexClass;
    }

    /**
     * Return the "id" property.
     */
    public String getIndexKey() {
        return indexKey;
    }

    /**
     * @see org.apache.fop.fo.FObj#getName()
     */
    public String getName() {
        return "fo:page-sequence-wrapper";
    }

    /**
     * @see org.apache.fop.fo.FObj#getNameId()
     */
    public int getNameId() {
        return FO_PAGE_SEQUENCE_WRAPPER;
    }
}

