/*
 * Copyright 1999-2005 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: Constants.java 198353 2005-01-31 22:27:20Z gmazza $ */


package org.apache.fop.fo;

public interface Constants {

    /* These constants are used by apps.CommandLineOptions and
       apps.Fop to describe the input (either .FO or .XML/.XSL)
       and desired output (PDF, PS, AWT, etc.) of the document */
       
    /** render constants for bounds checking */
    int RENDER_MIN_CONST = 1;
    int RENDER_MAX_CONST = 10;
    /** input / output not set */
    int NOT_SET = 0;
    /** input: fo file */
    int FO_INPUT = 1;
    /** input: xml+xsl file */
    int XSLT_INPUT = 2;
    /** output: pdf file */
    int RENDER_PDF = 1;
    /** output: screen using swing */
    int RENDER_AWT = 2;
    /** output: mif file */
    int RENDER_MIF = 3;
    /** output: sent swing rendered file to printer */
    int RENDER_PRINT = 4;
    /** output: pcl file */
    int RENDER_PCL = 5;
    /** output: postscript file */
    int RENDER_PS = 6;
    /** output: text file */
    int RENDER_TXT = 7;
    /** output: svg file */
    int RENDER_SVG = 8;
    /** output: XML area tree */
    int RENDER_XML = 9;
    /** output: RTF file */
    int RENDER_RTF = 10;
    
    // element constants
    int FO_UNKNOWN_NODE = 0;  // FObj base class
    int FO_BASIC_LINK = 1;
    int FO_BIDI_OVERRIDE = 2;
    int FO_BLOCK = 3;
    int FO_BLOCK_CONTAINER = 4;
    int FO_CHARACTER = 5;
    int FO_COLOR_PROFILE = 6;
    int FO_CONDITIONAL_PAGE_MASTER_REFERENCE = 7;
    int FO_DECLARATIONS = 8;
    int FO_EXTERNAL_GRAPHIC = 9;
    int FO_FLOAT = 10;
    int FO_FLOW = 11;
    int FO_FOOTNOTE = 12;
    int FO_FOOTNOTE_BODY = 13;
    int FO_INITIAL_PROPERTY_SET = 14;
    int FO_INLINE = 15;
    int FO_INLINE_CONTAINER = 16;
    int FO_INSTREAM_FOREIGN_OBJECT = 17;
    int FO_LAYOUT_MASTER_SET = 18;
    int FO_LEADER = 19;
    int FO_LIST_BLOCK = 20;
    int FO_LIST_ITEM = 21;
    int FO_LIST_ITEM_BODY = 22;
    int FO_LIST_ITEM_LABEL = 23;
    int FO_MARKER = 24;
    int FO_MULTI_CASE = 25;
    int FO_MULTI_PROPERTIES = 26;
    int FO_MULTI_PROPERTY_SET = 27;
    int FO_MULTI_SWITCH = 28;
    int FO_MULTI_TOGGLE = 29;
    int FO_PAGE_NUMBER = 30;
    int FO_PAGE_NUMBER_CITATION = 31;
    int FO_PAGE_SEQUENCE = 32;
    int FO_PAGE_SEQUENCE_MASTER = 33;
    int FO_REGION_AFTER = 34;
    int FO_REGION_BEFORE = 35;
    int FO_REGION_BODY = 36;
    int FO_REGION_END = 37;
    int FO_REGION_START = 38;
    int FO_REPEATABLE_PAGE_MASTER_ALTERNATIVES = 39;
    int FO_REPEATABLE_PAGE_MASTER_REFERENCE = 40;
    int FO_RETRIEVE_MARKER = 41;
    int FO_ROOT = 42;
    int FO_SIMPLE_PAGE_MASTER = 43;
    int FO_SINGLE_PAGE_MASTER_REFERENCE = 44;
    int FO_STATIC_CONTENT = 45;
    int FO_TABLE = 46;
    int FO_TABLE_AND_CAPTION = 47;
    int FO_TABLE_BODY = 48;
    int FO_TABLE_CAPTION = 49;
    int FO_TABLE_CELL = 50;
    int FO_TABLE_COLUMN = 51;
    int FO_TABLE_FOOTER = 52;
    int FO_TABLE_HEADER = 53;
    int FO_TABLE_ROW = 54;
    int FO_TITLE = 55;
    int FO_WRAPPER = 56;
    int FO_BOOKMARK_TREE = 57;          // XSL 1.1
    int FO_BOOKMARK = 58;               // XSL 1.1
    int FO_BOOKMARK_TITLE = 59;         // XSL 1.1
    int FO_PAGE_SEQUENCE_WRAPPER = 60;  // XSL 1.1
    int FRM_OBJ_COUNT = 60;
    
    // Masks
    int COMPOUND_SHIFT = 9;
    int PROPERTY_MASK = (1 << COMPOUND_SHIFT)-1;
    int COMPOUND_MASK = ~PROPERTY_MASK;
    int COMPOUND_COUNT = 11;
    
    // property constants
    int PR_ABSOLUTE_POSITION = 1;
    int PR_ACTIVE_STATE = 2;
    int PR_ALIGNMENT_ADJUST = 3;
    int PR_ALIGNMENT_BASELINE = 4;
    int PR_AUTO_RESTORE = 5;
    int PR_AZIMUTH = 6;
    int PR_BACKGROUND = 7;
    int PR_BACKGROUND_ATTACHMENT = 8;
    int PR_BACKGROUND_COLOR = 9;
    int PR_BACKGROUND_IMAGE = 10;
    int PR_BACKGROUND_POSITION = 11;
    int PR_BACKGROUND_POSITION_HORIZONTAL = 12;
    int PR_BACKGROUND_POSITION_VERTICAL = 13;
    int PR_BACKGROUND_REPEAT = 14;
    int PR_BASELINE_SHIFT = 15;
    int PR_BLANK_OR_NOT_BLANK = 16;
    int PR_BLOCK_PROGRESSION_DIMENSION = 17;
    int PR_BORDER = 18;
    int PR_BORDER_AFTER_COLOR = 19;
    int PR_BORDER_AFTER_PRECEDENCE = 20;
    int PR_BORDER_AFTER_STYLE = 21;
    int PR_BORDER_AFTER_WIDTH = 22;
    int PR_BORDER_BEFORE_COLOR = 23;
    int PR_BORDER_BEFORE_PRECEDENCE = 24;
    int PR_BORDER_BEFORE_STYLE = 25;
    int PR_BORDER_BEFORE_WIDTH = 26;
    int PR_BORDER_BOTTOM = 27;
    int PR_BORDER_BOTTOM_COLOR = 28;
    int PR_BORDER_BOTTOM_STYLE = 29;
    int PR_BORDER_BOTTOM_WIDTH = 30;
    int PR_BORDER_COLLAPSE = 31;
    int PR_BORDER_COLOR = 32;
    int PR_BORDER_END_COLOR = 33;
    int PR_BORDER_END_PRECEDENCE = 34;
    int PR_BORDER_END_STYLE = 35;
    int PR_BORDER_END_WIDTH = 36;
    int PR_BORDER_LEFT = 37;
    int PR_BORDER_LEFT_COLOR = 38;
    int PR_BORDER_LEFT_STYLE = 39;
    int PR_BORDER_LEFT_WIDTH = 40;
    int PR_BORDER_RIGHT = 41;
    int PR_BORDER_RIGHT_COLOR = 42;
    int PR_BORDER_RIGHT_STYLE = 43;
    int PR_BORDER_RIGHT_WIDTH = 44;
    int PR_BORDER_SEPARATION = 45;
    int PR_BORDER_SPACING = 46;
    int PR_BORDER_START_COLOR = 47;
    int PR_BORDER_START_PRECEDENCE = 48;
    int PR_BORDER_START_STYLE = 49;
    int PR_BORDER_START_WIDTH = 50;
    int PR_BORDER_STYLE = 51;
    int PR_BORDER_TOP = 52;
    int PR_BORDER_TOP_COLOR = 53;
    int PR_BORDER_TOP_STYLE = 54;
    int PR_BORDER_TOP_WIDTH = 55;
    int PR_BORDER_WIDTH = 56;
    int PR_BOTTOM = 57;
    int PR_BREAK_AFTER = 58;
    int PR_BREAK_BEFORE = 59;
    int PR_CAPTION_SIDE = 60;
    int PR_CASE_NAME = 61;
    int PR_CASE_TITLE = 62;
    int PR_CHARACTER = 63;
    int PR_CLEAR = 64;
    int PR_CLIP = 65;
    int PR_COLOR = 66;
    int PR_COLOR_PROFILE_NAME = 67;
    int PR_COLUMN_COUNT = 68;
    int PR_COLUMN_GAP = 69;
    int PR_COLUMN_NUMBER = 70;
    int PR_COLUMN_WIDTH = 71;
    int PR_CONTENT_HEIGHT = 72;
    int PR_CONTENT_TYPE = 73;
    int PR_CONTENT_WIDTH = 74;
    int PR_COUNTRY = 75;
    int PR_CUE = 76;
    int PR_CUE_AFTER = 77;
    int PR_CUE_BEFORE = 78;
    int PR_DESTINATION_PLACEMENT_OFFSET = 79;
    int PR_DIRECTION = 80;
    int PR_DISPLAY_ALIGN = 81;
    int PR_DOMINANT_BASELINE = 82;
    int PR_ELEVATION = 83;
    int PR_EMPTY_CELLS = 84;
    int PR_END_INDENT = 85;
    int PR_ENDS_ROW = 86;
    int PR_EXTENT = 87;
    int PR_EXTERNAL_DESTINATION = 88;
    int PR_FLOAT = 89;
    int PR_FLOW_NAME = 90;
    int PR_FONT = 91;
    int PR_FONT_FAMILY = 92;
    int PR_FONT_SELECTION_STRATEGY = 93;
    int PR_FONT_SIZE = 94;
    int PR_FONT_SIZE_ADJUST = 95;
    int PR_FONT_STRETCH = 96;
    int PR_FONT_STYLE = 97;
    int PR_FONT_VARIANT = 98;
    int PR_FONT_WEIGHT = 99;
    int PR_FORCE_PAGE_COUNT = 100;
    int PR_FORMAT = 101;
    int PR_GLYPH_ORIENTATION_HORIZONTAL = 102;
    int PR_GLYPH_ORIENTATION_VERTICAL = 103;
    int PR_GROUPING_SEPARATOR = 104;
    int PR_GROUPING_SIZE = 105;
    int PR_HEIGHT = 106;
    int PR_HYPHENATE = 107;
    int PR_HYPHENATION_CHARACTER = 108;
    int PR_HYPHENATION_KEEP = 109;
    int PR_HYPHENATION_LADDER_COUNT = 110;
    int PR_HYPHENATION_PUSH_CHARACTER_COUNT = 111;
    int PR_HYPHENATION_REMAIN_CHARACTER_COUNT = 112;
    int PR_ID = 113;
    int PR_INDICATE_DESTINATION = 114;
    int PR_INITIAL_PAGE_NUMBER = 115;
    int PR_INLINE_PROGRESSION_DIMENSION = 116;
    int PR_INTERNAL_DESTINATION = 117;
    int PR_KEEP_TOGETHER = 118;
    int PR_KEEP_WITH_NEXT = 119;
    int PR_KEEP_WITH_PREVIOUS = 120;
    int PR_LANGUAGE = 121;
    int PR_LAST_LINE_END_INDENT = 122;
    int PR_LEADER_ALIGNMENT = 123;
    int PR_LEADER_LENGTH = 124;
    int PR_LEADER_PATTERN = 125;
    int PR_LEADER_PATTERN_WIDTH = 126;
    int PR_LEFT = 127;
    int PR_LETTER_SPACING = 128;
    int PR_LETTER_VALUE = 129;
    int PR_LINEFEED_TREATMENT = 130;
    int PR_LINE_HEIGHT = 131;
    int PR_LINE_HEIGHT_SHIFT_ADJUSTMENT = 132;
    int PR_LINE_STACKING_STRATEGY = 133;
    int PR_MARGIN = 134;
    int PR_MARGIN_BOTTOM = 135;
    int PR_MARGIN_LEFT = 136;
    int PR_MARGIN_RIGHT = 137;
    int PR_MARGIN_TOP = 138;
    int PR_MARKER_CLASS_NAME = 139;
    int PR_MASTER_NAME = 140;
    int PR_MASTER_REFERENCE = 141;
    int PR_MAX_HEIGHT = 142;
    int PR_MAXIMUM_REPEATS = 143;
    int PR_MAX_WIDTH = 144;
    int PR_MEDIA_USAGE = 145;
    int PR_MIN_HEIGHT = 146;
    int PR_MIN_WIDTH = 147;
    int PR_NUMBER_COLUMNS_REPEATED = 148;
    int PR_NUMBER_COLUMNS_SPANNED = 149;
    int PR_NUMBER_ROWS_SPANNED = 150;
    int PR_ODD_OR_EVEN = 151;
    int PR_ORPHANS = 152;
    int PR_OVERFLOW = 153;
    int PR_PADDING = 154;
    int PR_PADDING_AFTER = 155;
    int PR_PADDING_BEFORE = 156;
    int PR_PADDING_BOTTOM = 157;
    int PR_PADDING_END = 158;
    int PR_PADDING_LEFT = 159;
    int PR_PADDING_RIGHT = 160;
    int PR_PADDING_START = 161;
    int PR_PADDING_TOP = 162;
    int PR_PAGE_BREAK_AFTER = 163;
    int PR_PAGE_BREAK_BEFORE = 164;
    int PR_PAGE_BREAK_INSIDE = 165;
    int PR_PAGE_HEIGHT = 166;
    int PR_PAGE_POSITION = 167;
    int PR_PAGE_WIDTH = 168;
    int PR_PAUSE = 169;
    int PR_PAUSE_AFTER = 170;
    int PR_PAUSE_BEFORE = 171;
    int PR_PITCH = 172;
    int PR_PITCH_RANGE = 173;
    int PR_PLAY_DURING = 174;
    int PR_POSITION = 175;
    int PR_PRECEDENCE = 176;
    int PR_PROVISIONAL_DISTANCE_BETWEEN_STARTS = 177;
    int PR_PROVISIONAL_LABEL_SEPARATION = 178;
    int PR_REFERENCE_ORIENTATION = 179;
    int PR_REF_ID = 180;
    int PR_REGION_NAME = 181;
    int PR_RELATIVE_ALIGN = 182;
    int PR_RELATIVE_POSITION = 183;
    int PR_RENDERING_INTENT = 184;
    int PR_RETRIEVE_BOUNDARY = 185;
    int PR_RETRIEVE_CLASS_NAME = 186;
    int PR_RETRIEVE_POSITION = 187;
    int PR_RICHNESS = 188;
    int PR_RIGHT = 189;
    int PR_ROLE = 190;
    int PR_RULE_STYLE = 191;
    int PR_RULE_THICKNESS = 192;
    int PR_SCALING = 193;
    int PR_SCALING_METHOD = 194;
    int PR_SCORE_SPACES = 195;
    int PR_SCRIPT = 196;
    int PR_SHOW_DESTINATION = 197;
    int PR_SIZE = 198;
    int PR_SOURCE_DOCUMENT = 199;
    int PR_SPACE_AFTER = 200;
    int PR_SPACE_BEFORE = 201;
    int PR_SPACE_END = 202;
    int PR_SPACE_START = 203;
    int PR_SPAN = 204;
    int PR_SPEAK = 205;
    int PR_SPEAK_HEADER = 206;
    int PR_SPEAK_NUMERAL = 207;
    int PR_SPEAK_PUNCTUATION = 208;
    int PR_SPEECH_RATE = 209;
    int PR_SRC = 210;
    int PR_START_INDENT = 211;
    int PR_STARTING_STATE = 212;
    int PR_STARTS_ROW = 213;
    int PR_STRESS = 214;
    int PR_SUPPRESS_AT_LINE_BREAK = 215;
    int PR_SWITCH_TO = 216;
    int PR_TABLE_LAYOUT = 217;
    int PR_TABLE_OMIT_FOOTER_AT_BREAK = 218;
    int PR_TABLE_OMIT_HEADER_AT_BREAK = 219;
    int PR_TARGET_PRESENTATION_CONTEXT = 220;
    int PR_TARGET_PROCESSING_CONTEXT = 221;
    int PR_TARGET_STYLESHEET = 222;
    int PR_TEXT_ALIGN = 223;
    int PR_TEXT_ALIGN_LAST = 224;
    int PR_TEXT_ALTITUDE = 225;
    int PR_TEXT_DECORATION = 226;
    int PR_TEXT_DEPTH = 227;
    int PR_TEXT_INDENT = 228;
    int PR_TEXT_SHADOW = 229;
    int PR_TEXT_TRANSFORM = 230;
    int PR_TOP = 231;
    int PR_TREAT_AS_WORD_SPACE = 232;
    int PR_UNICODE_BIDI = 233;
    int PR_VERTICAL_ALIGN = 234;
    int PR_VISIBILITY = 235;
    int PR_VOICE_FAMILY = 236;
    int PR_VOLUME = 237;
    int PR_WHITE_SPACE_COLLAPSE = 238;
    int PR_WHITE_SPACE_TREATMENT = 239;
    int PR_WIDOWS = 240;
    int PR_WIDTH = 241;
    int PR_WORD_SPACING = 242;
    int PR_WRAP_OPTION = 243;
    int PR_WRITING_MODE = 244;
    int PR_XML_LANG = 245;
    int PR_Z_INDEX = 246;
    int PR_INTRUSION_DISPLACE = 247;
    int PR_INDEX_CLASS = 248;   // XSL 1.1
    int PR_INDEX_KEY = 249;     // XSL 1.1
    int PROPERTY_COUNT = 249;

    // compound property constants

    int CP_BLOCK_PROGRESSION_DIRECTION = 1 << COMPOUND_SHIFT;
    int CP_CONDITIONALITY = 2 << COMPOUND_SHIFT;
    int CP_INLINE_PROGRESSION_DIRECTION = 3 << COMPOUND_SHIFT;
    int CP_LENGTH = 4 << COMPOUND_SHIFT;
    int CP_MAXIMUM = 5 << COMPOUND_SHIFT;
    int CP_MINIMUM = 6 << COMPOUND_SHIFT;
    int CP_OPTIMUM = 7 << COMPOUND_SHIFT;
    int CP_PRECEDENCE = 8 << COMPOUND_SHIFT;
    int CP_WITHIN_COLUMN = 9 << COMPOUND_SHIFT;
    int CP_WITHIN_LINE = 10 << COMPOUND_SHIFT;
    int CP_WITHIN_PAGE = 11 << COMPOUND_SHIFT;

    // Enumeration constants
    int EN_ABSOLUTE = 1;
    int EN_ABSOLUTE_COLORMETRIC = 2;
    int EN_AFTER = 3;
    int EN_AFTER_EDGE = 4;
    int EN_ALL = 5;
    int EN_ALPHABETIC = 6;
    int EN_ALWAYS = 7;
    int EN_ANY = 8;
    int EN_AUTO = 9;
    int EN_AUTO_EVEN = 10;
    int EN_AUTO_ODD = 11;
    int EN_BASELINE = 12;
    int EN_BEFORE = 13;
    int EN_BEFORE_EDGE = 14;
    int EN_BIDI_OVERRIDE = 15;
    int EN_BLANK = 16;
    int EN_BLINK = 17;
    int EN_BLOCK = 18;
    int EN_BOTH = 19;
    int EN_BOTTOM = 20;
    int EN_BOUNDED_IN_ONE_DIMENSION = 21;
    int EN_CAPITALIZE = 22;
    int EN_CENTER = 23;
    int EN_CENTRAL = 24;
    int EN_CHARACTER_BY_CHARACTER = 25;
    int EN_COLLAPSE = 26;
    int EN_COLLAPSE_WITH_PRECEDENCE = 27;
    int EN_COLUMN = 28;
    int EN_CONDENSED = 29;
    int EN_CONSIDER_SHIFTS = 30;
    int EN_DASHED = 31;
    int EN_DISCARD = 32;
    int EN_DISREGARD_SHIFTS = 33;
    int EN_DOCUMENT = 34;
    int EN_DOTS = 35;
    int EN_DOTTED = 36;
    int EN_DOUBLE = 37;
    int EN_EMBED = 38;
    int EN_END = 39;
    int EN_END_ON_EVEN = 40;
    int EN_END_ON_ODD = 41;
    int EN_ERROR_IF_OVERFLOW = 42;
    int EN_EVEN = 43;
    int EN_EVEN_PAGE = 44;
    int EN_EXPANDED = 45;
    int EN_EXTRA_CONDENSED = 46;
    int EN_EXTRA_EXPANDED = 47;
    int EN_FALSE = 48;
    int EN_FIC = 49;
    int EN_FIRST = 50;
    int EN_FIXED = 51;
    int EN_FONT_HEIGHT = 52;
    int EN_FORCE = 53;
    int EN_FSWP = 54;
    int EN_GROOVE = 55;
    int EN_HANGING = 56;
    int EN_HIDDEN = 57;
    int EN_HIDE = 58;
    int EN_IDEOGRAPHIC = 59;
    int EN_IGNORE = 60;
    int EN_IGNORE_IF_AFTER_LINEFEED = 61;
    int EN_IGNORE_IF_BEFORE_LINEFEED = 62;
    int EN_IGNORE_IF_SURROUNDING_LINEFEED = 63;
    int EN_INDEFINITE = 64;
    int EN_INDENT = 65;
    int EN_INHERIT = 66;
    int EN_INSET = 67;
    int EN_INSIDE = 68;
    int EN_INTEGER_PIXELS = 69;
    int EN_JUSTIFY = 70;
    int EN_LARGER = 71;
    int EN_LAST = 72;
    int EN_LEFT = 73;
    int EN_LEWP = 74;
    int EN_LINE = 75;
    int EN_LINE_HEIGHT = 76;
    int EN_LINE_THROUGH = 77;
    int EN_LOWERCASE = 78;
    int EN_LR_TB = 79;
    int EN_LTR = 80;
    int EN_LSWP = 81;
    int EN_MATHEMATICAL = 82;
    int EN_MAX_HEIGHT = 83;
    int EN_MIDDLE = 84;
    int EN_NARROWER = 85;
    int EN_NO_BLINK = 86;
    int EN_NO_CHANGE = 87;
    int EN_NO_FORCE = 88;
    int EN_NO_LIMIT = 89;
    int EN_NO_LINE_THROUGH = 90;
    int EN_NO_OVERLINE = 91;
    int EN_NO_UNDERLINE = 92;
    int EN_NO_WRAP = 93;
    int EN_NON_UNIFORM = 94;
    int EN_NONE = 95;
    int EN_NOREPEAT = 96;
    int EN_NORMAL = 97;
    int EN_NOT_BLANK = 98;
    int EN_ODD = 99;
    int EN_ODD_PAGE = 100;
    int EN_OUTSET = 101;
    int EN_OUTSIDE = 102;
    int EN_OVERLINE = 103;
    int EN_PAGE = 104;
    int EN_PAGE_SEQUENCE = 105;
    int EN_PAGINATE = 106;
    int EN_PERCEPTUAL = 107;
    int EN_PRESERVE = 108;
    int EN_REFERENCE_AREA = 109;
    int EN_RELATIVE = 110;
    int EN_RELATIVE_COLOMETRIC = 111;
    int EN_REPEAT = 112;
    int EN_REPEATX = 113;
    int EN_REPEATY = 114;
    int EN_RESAMPLE_ANY_METHOD = 115;
    int EN_RESET_SIZE = 116;
    int EN_REST = 117;
    int EN_RETAIN = 118;
    int EN_RIDGE = 119;
    int EN_RIGHT = 120;
    int EN_RL_TB = 121;
    int EN_RTL = 122;
    int EN_RULE = 123;
    int EN_SATURATION = 124;
    int EN_SCALE_TO_FIT = 125;
    int EN_SCROLL = 126;
    int EN_SEMI_CONDENSED = 127;
    int EN_SEMI_EXPANDED = 128;
    int EN_SEPARATE = 129;
    int EN_SHOW = 130;
    int EN_SMALL_CAPS = 131;
    int EN_SMALLER = 132;
    int EN_SOLID = 133;
    int EN_SPACE = 134;
    int EN_START = 135;
    int EN_STATIC = 136;
    int EN_SUB = 137;
    int EN_SUPER = 138;
    int EN_SUPPRESS = 139;
    int EN_TB_RL = 140;
    int EN_TEXT_AFTER_EDGE = 141;
    int EN_TEXT_BEFORE_EDGE = 142;
    int EN_TEXT_BOTTOM = 143;
    int EN_TEXT_TOP = 144;
    int EN_TOP = 145;
    int EN_TRADITIONAL = 146;
    int EN_TREAT_AS_SPACE = 147;
    int EN_TREAT_AS_ZERO_WIDTH_SPACE = 148;
    int EN_TRUE = 149;
    int EN_ULTRA_CONDENSED = 150;
    int EN_ULTRA_EXPANDED = 151;
    int EN_UNBOUNDED = 152;
    int EN_UNDERLINE = 153;
    int EN_UNIFORM = 154;
    int EN_UPPERCASE = 155;
    int EN_USE_FONT_METRICS = 156;
    int EN_USE_SCRIPT = 157;
    int EN_USECONTENT = 158;
    int EN_VISIBLE = 159;
    int EN_WIDER = 160;
    int EN_WRAP = 161;
    int ENUM_COUNT = 161;
}
