/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.AWTPermission;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AllPermission;
import java.security.Permission;
import java.sql.SQLPermission;
import java.util.PropertyPermission;
import java.util.Vector;
import javax.sound.sampled.AudioPermission;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.script.ScriptHandler;
import org.apache.batik.script.Window;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class JarCheckPermissionsGranted
implements ScriptHandler {
    public static final String svgNS = "http://www.w3.org/2000/svg";
    public static final String testNS = "http://xml.apache.org/batik/test";
    public static final String testedPath = "build.sh";
    public static final String testedHost = "nagoya.apache.org:8080";
    protected static Object[][] basePermissions = new Object[][]{{"AllPermission", new AllPermission()}, {"FilePermission read", new FilePermission("build.sh", "read")}, {"FilePermission write", new FilePermission("build.sh", "write")}, {"FilePermission execute", new FilePermission("build.sh", "execute")}, {"FilePermission delete", new FilePermission("build.sh", "delete")}, {"SocketPermission accept", new SocketPermission("nagoya.apache.org:8080", "accept")}, {"SocketPermission connect", new SocketPermission("nagoya.apache.org:8080", "connect")}, {"SocketPermission listen", new SocketPermission("nagoya.apache.org:8080", "listen")}, {"SocketPermission resolve", new SocketPermission("nagoya.apache.org:8080", "resolve")}, {"AudioPermission play", new AudioPermission("play")}, {"AudioPermission record", new AudioPermission("record")}, {"AWTPermission accessClipboard", new AWTPermission("accessClipboard")}, {"AWTPermission accessEventQueue", new AWTPermission("accessEventQueue")}, {"AWTPermission listenToAllAWTEvents", new AWTPermission("listenToAllAWTEvents")}, {"AWTPermission showWindowWithoutWarningBanner", new AWTPermission("showWindowWithoutWarningBanner")}, {"AWTPermission readDisplayPixels", new AWTPermission("readDisplayPixels")}, {"AWTPermission createRobot", new AWTPermission("createRobot")}, {"AWTPermission fullScreenExclusive", new AWTPermission("fullScreenExclusive")}, {"NetPermission setDefaultAuthenticator", new NetPermission("setDefaultAuthenticator")}, {"NetPermission requestPasswordAuthentication", new NetPermission("requestPasswordAuthentication")}, {"NetPermission specifyStreamHandler", new NetPermission("specifyStreamHandler")}, {"PropertyPermission java.home read", new PropertyPermission("java.home", "read")}, {"PropertyPermission java.home write", new PropertyPermission("java.home", "write")}, {"ReflectPermission", new ReflectPermission("suppressAccessChecks")}, {"RuntimePermission createClassLoader", new RuntimePermission("createClassLoader")}, {"RuntimePermission getClassLoader", new RuntimePermission("getClassLoader")}, {"RuntimePermission setContextClassLoader", new RuntimePermission("setContextClassLoader")}, {"RuntimePermission setSecurityManager", new RuntimePermission("setSecurityManager")}, {"RuntimePermission createSecurityManager", new RuntimePermission("createSecurityManager")}, {"RuntimePermission exitVM", new RuntimePermission("exitVM")}, {"RuntimePermission shutdownHooks", new RuntimePermission("shutdownHooks")}, {"RuntimePermission setFactory", new RuntimePermission("setFactory")}, {"RuntimePermission setIO", new RuntimePermission("setIO")}, {"RuntimePermission modifyThread", new RuntimePermission("modifyThread")}, {"RuntimePermission stopThread", new RuntimePermission("stopThread")}, {"RuntimePermission modifyThreadGroup", new RuntimePermission("modifyThreadGroup")}, {"RuntimePermission getProtectionDomain", new RuntimePermission("getProtectionDomain")}, {"RuntimePermission readFileDescriptor", new RuntimePermission("readFileDescriptor")}, {"RuntimePermission writeFileDescriptor", new RuntimePermission("writeFileDescriptor")}, {"RuntimePermission loadLibrary.{library name}", new RuntimePermission("loadLibrary.{library name}")}, {"RuntimePermission accessClassInPackage.java.security", new RuntimePermission("accessClassInPackage.java.security")}, {"RuntimePermission defineClassInPackage.java.lang", new RuntimePermission("defineClassInPackage.java.lang")}, {"RuntimePermission accessDeclaredMembers", new RuntimePermission("accessDeclaredMembers")}, {"RuntimePermission queuePrintJob", new RuntimePermission("queuePrintJob")}, {"SecurityPermission createAccessControlContext", new SerializablePermission("createAccessControlContext")}, {"SecurityPermission getDomainCombiner", new SerializablePermission("getDomainCombiner")}, {"SecurityPermission getPolicy", new SerializablePermission("getPolicy")}, {"SecurityPermission setPolicy", new SerializablePermission("setPolicy")}, {"SecurityPermission setSystemScope", new SerializablePermission("setSystemScope")}, {"SecurityPermission setIdentityPublicKey", new SerializablePermission("setIdentityPublicKey")}, {"SecurityPermission setIdentityInfo", new SerializablePermission("setIdentityInfo")}, {"SecurityPermission addIdentityCertificate", new SerializablePermission("addIdentityCertificate")}, {"SecurityPermission removeIdentityCertificate", new SerializablePermission("removeIdentityCertificate")}, {"SecurityPermission printIdentity", new SerializablePermission("printIdentity")}, {"SecurityPermission getSignerPrivateKey", new SerializablePermission("getSignerPrivateKey")}, {"SecurityPermission setSignerKeyPair", new SerializablePermission("setSignerKeyPair")}, {"SerializablePermission enableSubclassImplementation", new SerializablePermission("enableSubclassImplementation")}, {"SerializablePermission enableSubstitution", new SerializablePermission("enableSubstitution")}, {"SQLPermission", new SQLPermission("setLog")}};
    private Object[][] permissions;
    private Element[] statusRects;

    public void run(final Document document, Window win) {
        URL docURL = ((SVGOMDocument)document).getURLObject();
        if (docURL != null && docURL.getHost() != null && !"".equals(docURL.getHost())) {
            this.permissions = new Object[basePermissions.length + 3][2];
            System.arraycopy(basePermissions, 0, this.permissions, 3, basePermissions.length);
            String docHost = docURL.getHost();
            if (docURL.getPort() != -1) {
                docHost = docHost + ":" + docURL.getPort();
            }
            this.permissions[0][0] = "SocketPermission accept " + docHost;
            this.permissions[0][1] = new SocketPermission(docHost, "accept");
            this.permissions[1][0] = "SocketPermission connect " + docHost;
            this.permissions[1][1] = new SocketPermission(docHost, "connect");
            this.permissions[2][0] = "SocketPermission resolve " + docHost;
            this.permissions[2][1] = new SocketPermission(docHost, "resolve");
        } else {
            this.permissions = basePermissions;
        }
        EventTarget root = (EventTarget)((Object)document.getDocumentElement());
        root.addEventListener("SVGLoad", new EventListener(){

            public void handleEvent(Event evt) {
                int i;
                SecurityManager sm = System.getSecurityManager();
                int successCnt = 0;
                Vector<Object> unexpectedDenial = new Vector<Object>();
                int unexpectedDenialCnt = 0;
                int unexpectedGrantsCnt = 0;
                if (sm == null) {
                    i = 0;
                    while (i < JarCheckPermissionsGranted.this.permissions.length) {
                        ++successCnt;
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < JarCheckPermissionsGranted.this.permissions.length) {
                        Permission p = (Permission)JarCheckPermissionsGranted.this.permissions[i][1];
                        try {
                            sm.checkPermission(p);
                            ++successCnt;
                        }
                        catch (SecurityException se) {
                            unexpectedDenial.add(JarCheckPermissionsGranted.this.permissions[i][0]);
                            ++unexpectedDenialCnt;
                        }
                        ++i;
                    }
                }
                Element result = document.getElementById("testResult");
                if (successCnt == JarCheckPermissionsGranted.this.permissions.length) {
                    result.setAttributeNS(null, "result", "passed");
                } else {
                    System.out.println("test failed: " + unexpectedGrantsCnt + " / " + unexpectedDenialCnt);
                    result.setAttributeNS(null, "result", "failed");
                    result.setAttributeNS(null, "errorCode", "unexpected.grants.or.denials");
                    String unexpectedDenialString = "";
                    int i2 = 0;
                    while (i2 < unexpectedDenialCnt) {
                        unexpectedDenialString = unexpectedDenialString + unexpectedDenial.elementAt(i2).toString();
                        ++i2;
                    }
                    Element entry = null;
                    entry = document.createElementNS(JarCheckPermissionsGranted.testNS, "errorDescriptiongEntry");
                    entry.setAttributeNS(null, "id", "unexpected.denials.count");
                    entry.setAttributeNS(null, "value", "" + unexpectedDenialCnt);
                    result.appendChild(entry);
                    System.out.println("unexpected.denials : " + unexpectedDenialString);
                    entry = document.createElementNS(JarCheckPermissionsGranted.testNS, "errorDescriptionEntry");
                    entry.setAttributeNS(null, "id", "unexpected.denials");
                    entry.setAttributeNS(null, "value", unexpectedDenialString);
                    result.appendChild(entry);
                }
            }
        }, false);
    }
}

