// Copyright 2017 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/cxfa_issuers.h"

#include "fxjs/xfa/cjx_issuers.h"
#include "third_party/base/ptr_util.h"

namespace {

const CXFA_Node::AttributeData kIssuersAttributeData[] = {
    {XFA_Attribute::Id, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Use, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Type, XFA_AttributeType::Enum,
     (void*)XFA_AttributeEnum::Optional},
    {XFA_Attribute::Usehref, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Unknown, XFA_AttributeType::Integer, nullptr}};

constexpr wchar_t kIssuersName[] = L"issuers";

}  // namespace

CXFA_Issuers::CXFA_Issuers(CXFA_Document* doc, XFA_PacketType packet)
    : CXFA_Node(doc,
                packet,
                (XFA_XDPPACKET_Template | XFA_XDPPACKET_Form),
                XFA_ObjectType::Node,
                XFA_Element::Issuers,
                nullptr,
                kIssuersAttributeData,
                kIssuersName,
                pdfium::MakeUnique<CJX_Issuers>(this)) {}

CXFA_Issuers::~CXFA_Issuers() {}
