(** Bindings of a C library *)type net_nettle_cipher_t
type net_nettle_cipher_ctx_t
type net_nettle_gcm_aes_ctx_t
type net_nettle_hash_t
type net_nettle_hash_ctx_t
val net_nettle_ciphers : unit -> net_nettle_cipher_t array
val net_ext_ciphers : unit -> net_nettle_cipher_t array
val net_nettle_cipher_name : net_nettle_cipher_t -> string
val net_nettle_create_cipher_ctx : net_nettle_cipher_t -> net_nettle_cipher_ctx_t
val net_nettle_set_encrypt_key : net_nettle_cipher_t -> net_nettle_cipher_ctx_t -> Bytes.t -> unit
val net_nettle_set_decrypt_key : net_nettle_cipher_t -> net_nettle_cipher_ctx_t -> Bytes.t -> unit
val net_nettle_encrypt : net_nettle_cipher_t -> net_nettle_cipher_ctx_t -> int -> Netsys_mem.memory -> Netsys_mem.memory -> unit
val net_nettle_decrypt : net_nettle_cipher_t -> net_nettle_cipher_ctx_t -> int -> Netsys_mem.memory -> Netsys_mem.memory -> unit
val net_nettle_gcm_aes_init : unit -> net_nettle_gcm_aes_ctx_t
val nettle_gcm_aes_set_key : net_nettle_gcm_aes_ctx_t -> Bytes.t -> unit
val nettle_gcm_aes_set_iv : net_nettle_gcm_aes_ctx_t -> Bytes.t -> unit
val nettle_gcm_aes_update : net_nettle_gcm_aes_ctx_t -> Bytes.t -> unit
val nettle_gcm_aes_encrypt : net_nettle_gcm_aes_ctx_t -> int -> Netsys_mem.memory -> Netsys_mem.memory -> unit
val nettle_gcm_aes_decrypt : net_nettle_gcm_aes_ctx_t -> int -> Netsys_mem.memory -> Netsys_mem.memory -> unit
val nettle_gcm_aes_digest : net_nettle_gcm_aes_ctx_t -> Bytes.t -> unit
val net_have_gcm_aes : unit -> bool
val net_nettle_hashes : unit -> net_nettle_hash_t array
val net_nettle_hash_name : net_nettle_hash_t -> string
val net_nettle_create_hash_ctx : net_nettle_hash_t -> net_nettle_hash_ctx_t
val net_nettle_hash_init : net_nettle_hash_t -> net_nettle_hash_ctx_t -> unit
val net_nettle_hash_update : net_nettle_hash_t -> net_nettle_hash_ctx_t -> Netsys_mem.memory -> unit
val net_nettle_hash_digest : net_nettle_hash_t -> net_nettle_hash_ctx_t -> Bytes.t -> unit
(* This file is included into nettls_nettle_bindings.mli *)

