module Non_blocking =
struct
module CI = Cstubs_internals

external luv_stub_1_uv_strerror_r : int -> bytes CI.ocaml -> int -> unit
  = "luv_stub_1_uv_strerror_r" 

external luv_stub_2_uv_err_name_r : int -> bytes CI.ocaml -> int -> unit
  = "luv_stub_2_uv_err_name_r" 

external luv_stub_3_uv_translate_sys_error : int -> int
  = "luv_stub_3_uv_translate_sys_error" 

external luv_stub_4_luv_version_suffix : unit -> CI.voidp
  = "luv_stub_4_luv_version_suffix" 

external luv_stub_5_uv_version : unit -> int = "luv_stub_5_uv_version" 

external luv_stub_6_luv_version_string : unit -> CI.voidp
  = "luv_stub_6_luv_version_string" 

external luv_stub_7_uv_loop_init : _ CI.fatptr -> int
  = "luv_stub_7_uv_loop_init" 

external luv_stub_8_uv_loop_configure : _ CI.fatptr -> int -> int -> int
  = "luv_stub_8_uv_loop_configure" 

external luv_stub_9_uv_loop_close : _ CI.fatptr -> int
  = "luv_stub_9_uv_loop_close" 

external luv_stub_10_uv_default_loop : unit -> CI.voidp
  = "luv_stub_10_uv_default_loop" 

external luv_stub_11_uv_loop_alive : _ CI.fatptr -> bool
  = "luv_stub_11_uv_loop_alive" 

external luv_stub_12_uv_stop : _ CI.fatptr -> unit = "luv_stub_12_uv_stop" 

external luv_stub_13_uv_backend_fd : _ CI.fatptr -> int
  = "luv_stub_13_uv_backend_fd" 

external luv_stub_14_uv_backend_timeout : _ CI.fatptr -> int
  = "luv_stub_14_uv_backend_timeout" 

external luv_stub_15_uv_now : _ CI.fatptr -> Unsigned.uint64
  = "luv_stub_15_uv_now" 

external luv_stub_16_uv_update_time : _ CI.fatptr -> unit
  = "luv_stub_16_uv_update_time" 

external luv_stub_17_uv_loop_fork : _ CI.fatptr -> int
  = "luv_stub_17_uv_loop_fork" 

external luv_stub_18_uv_library_shutdown : unit -> unit
  = "luv_stub_18_uv_library_shutdown" 

external luv_stub_19_luv_get_close_trampoline : unit -> CI.voidp
  = "luv_stub_19_luv_get_close_trampoline" 

external luv_stub_20_luv_get_alloc_trampoline : unit -> CI.voidp
  = "luv_stub_20_luv_get_alloc_trampoline" 

external luv_stub_21_uv_is_active : _ CI.fatptr -> bool
  = "luv_stub_21_uv_is_active" 

external luv_stub_22_uv_is_closing : _ CI.fatptr -> bool
  = "luv_stub_22_uv_is_closing" 

external luv_stub_23_uv_close : _ CI.fatptr -> _ CI.fatfunptr -> unit
  = "luv_stub_23_uv_close" 

external luv_stub_24_uv_ref : _ CI.fatptr -> unit = "luv_stub_24_uv_ref" 

external luv_stub_25_uv_unref : _ CI.fatptr -> unit = "luv_stub_25_uv_unref" 

external luv_stub_26_uv_has_ref : _ CI.fatptr -> bool
  = "luv_stub_26_uv_has_ref" 

external luv_stub_27_uv_send_buffer_size : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_27_uv_send_buffer_size" 

external luv_stub_28_uv_recv_buffer_size : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_28_uv_recv_buffer_size" 

external luv_stub_29_uv_fileno : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_29_uv_fileno" 

external luv_stub_30_uv_handle_get_loop : _ CI.fatptr -> CI.voidp
  = "luv_stub_30_uv_handle_get_loop" 

external luv_stub_31_uv_handle_get_data : _ CI.fatptr -> CI.voidp
  = "luv_stub_31_uv_handle_get_data" 

external luv_stub_32_uv_handle_set_data : _ CI.fatptr -> _ CI.fatptr -> unit
  = "luv_stub_32_uv_handle_set_data" 

external luv_stub_33_uv_cancel : _ CI.fatptr -> int = "luv_stub_33_uv_cancel" 

external luv_stub_34_uv_req_get_data : _ CI.fatptr -> CI.voidp
  = "luv_stub_34_uv_req_get_data" 

external luv_stub_35_uv_req_set_data : _ CI.fatptr -> _ CI.fatptr -> unit
  = "luv_stub_35_uv_req_set_data" 

external luv_stub_36_luv_get_timer_trampoline : unit -> CI.voidp
  = "luv_stub_36_luv_get_timer_trampoline" 

external luv_stub_37_uv_timer_init : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_37_uv_timer_init" 

external luv_stub_38_uv_timer_start
  : _ CI.fatptr -> _ CI.fatfunptr -> Unsigned.uint64 -> Unsigned.uint64 ->
    int = "luv_stub_38_uv_timer_start" 

external luv_stub_39_uv_timer_stop : _ CI.fatptr -> int
  = "luv_stub_39_uv_timer_stop" 

external luv_stub_40_uv_timer_again : _ CI.fatptr -> int
  = "luv_stub_40_uv_timer_again" 

external luv_stub_41_uv_timer_set_repeat
  : _ CI.fatptr -> Unsigned.uint64 -> unit
  = "luv_stub_41_uv_timer_set_repeat" 

external luv_stub_42_uv_timer_get_repeat : _ CI.fatptr -> Unsigned.uint64
  = "luv_stub_42_uv_timer_get_repeat" 

external luv_stub_43_uv_timer_get_due_in : _ CI.fatptr -> Unsigned.uint64
  = "luv_stub_43_uv_timer_get_due_in" 

external luv_stub_44_luv_get_prepare_trampoline : unit -> CI.voidp
  = "luv_stub_44_luv_get_prepare_trampoline" 

external luv_stub_45_uv_prepare_init : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_45_uv_prepare_init" 

external luv_stub_46_uv_prepare_start : _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_46_uv_prepare_start" 

external luv_stub_47_uv_prepare_stop : _ CI.fatptr -> int
  = "luv_stub_47_uv_prepare_stop" 

external luv_stub_48_luv_get_check_trampoline : unit -> CI.voidp
  = "luv_stub_48_luv_get_check_trampoline" 

external luv_stub_49_uv_check_init : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_49_uv_check_init" 

external luv_stub_50_uv_check_start : _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_50_uv_check_start" 

external luv_stub_51_uv_check_stop : _ CI.fatptr -> int
  = "luv_stub_51_uv_check_stop" 

external luv_stub_52_luv_get_idle_trampoline : unit -> CI.voidp
  = "luv_stub_52_luv_get_idle_trampoline" 

external luv_stub_53_uv_idle_init : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_53_uv_idle_init" 

external luv_stub_54_uv_idle_start : _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_54_uv_idle_start" 

external luv_stub_55_uv_idle_stop : _ CI.fatptr -> int
  = "luv_stub_55_uv_idle_stop" 

external luv_stub_56_luv_get_async_trampoline : unit -> CI.voidp
  = "luv_stub_56_luv_get_async_trampoline" 

external luv_stub_57_uv_async_init
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_57_uv_async_init" 

external luv_stub_58_uv_async_send : _ CI.fatptr -> int
  = "luv_stub_58_uv_async_send" 

external luv_stub_59_luv_get_poll_trampoline : unit -> CI.voidp
  = "luv_stub_59_luv_get_poll_trampoline" 

external luv_stub_60_uv_poll_init : _ CI.fatptr -> _ CI.fatptr -> int -> int
  = "luv_stub_60_uv_poll_init" 

external luv_stub_61_uv_poll_init_socket
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_61_uv_poll_init_socket" 

external luv_stub_62_uv_poll_start
  : _ CI.fatptr -> int -> _ CI.fatfunptr -> int = "luv_stub_62_uv_poll_start" 

external luv_stub_63_uv_poll_stop : _ CI.fatptr -> int
  = "luv_stub_63_uv_poll_stop" 

external luv_stub_64_luv_get_signal_trampoline : unit -> CI.voidp
  = "luv_stub_64_luv_get_signal_trampoline" 

external luv_stub_65_uv_signal_init : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_65_uv_signal_init" 

external luv_stub_66_uv_signal_start
  : _ CI.fatptr -> _ CI.fatfunptr -> int -> int
  = "luv_stub_66_uv_signal_start" 

external luv_stub_67_uv_signal_start_oneshot
  : _ CI.fatptr -> _ CI.fatfunptr -> int -> int
  = "luv_stub_67_uv_signal_start_oneshot" 

external luv_stub_68_uv_signal_stop : _ CI.fatptr -> int
  = "luv_stub_68_uv_signal_stop" 

external luv_stub_69_luv_get_connect_trampoline : unit -> CI.voidp
  = "luv_stub_69_luv_get_connect_trampoline" 

external luv_stub_70_luv_get_shutdown_trampoline : unit -> CI.voidp
  = "luv_stub_70_luv_get_shutdown_trampoline" 

external luv_stub_71_luv_get_write_trampoline : unit -> CI.voidp
  = "luv_stub_71_luv_get_write_trampoline" 

external luv_stub_72_luv_get_connection_trampoline : unit -> CI.voidp
  = "luv_stub_72_luv_get_connection_trampoline" 

external luv_stub_73_luv_get_read_trampoline : unit -> CI.voidp
  = "luv_stub_73_luv_get_read_trampoline" 

external luv_stub_74_uv_shutdown
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_74_uv_shutdown" 

external luv_stub_75_uv_listen : _ CI.fatptr -> int -> _ CI.fatfunptr -> int
  = "luv_stub_75_uv_listen" 

external luv_stub_76_uv_accept : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_76_uv_accept" 

external luv_stub_77_luv_read_start
  : _ CI.fatptr -> _ CI.fatfunptr -> _ CI.fatfunptr -> int
  = "luv_stub_77_luv_read_start" 

external luv_stub_78_uv_read_stop : _ CI.fatptr -> int
  = "luv_stub_78_uv_read_stop" 

external luv_stub_79_uv_write2
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> Unsigned.uint ->
    _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_79_uv_write2_byte6" "luv_stub_79_uv_write2" 

external luv_stub_80_uv_try_write
  : _ CI.fatptr -> _ CI.fatptr -> Unsigned.uint -> int
  = "luv_stub_80_uv_try_write" 

external luv_stub_81_uv_try_write2
  : _ CI.fatptr -> _ CI.fatptr -> Unsigned.uint -> _ CI.fatptr -> int
  = "luv_stub_81_uv_try_write2" 

external luv_stub_82_uv_is_readable : _ CI.fatptr -> bool
  = "luv_stub_82_uv_is_readable" 

external luv_stub_83_uv_is_writable : _ CI.fatptr -> bool
  = "luv_stub_83_uv_is_writable" 

external luv_stub_84_uv_stream_set_blocking : _ CI.fatptr -> bool -> int
  = "luv_stub_84_uv_stream_set_blocking" 

external luv_stub_85_uv_stream_get_write_queue_size
  : _ CI.fatptr -> Unsigned.size_t
  = "luv_stub_85_uv_stream_get_write_queue_size" 

external luv_stub_86_uv_tcp_init : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_86_uv_tcp_init" 

external luv_stub_87_uv_tcp_init_ex
  : _ CI.fatptr -> _ CI.fatptr -> Unsigned.uint -> int
  = "luv_stub_87_uv_tcp_init_ex" 

external luv_stub_88_uv_tcp_open : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_88_uv_tcp_open" 

external luv_stub_89_uv_socketpair
  : int -> int -> _ CI.fatptr -> int -> int -> int
  = "luv_stub_89_uv_socketpair" 

external luv_stub_90_uv_tcp_nodelay : _ CI.fatptr -> bool -> int
  = "luv_stub_90_uv_tcp_nodelay" 

external luv_stub_91_uv_tcp_keepalive : _ CI.fatptr -> bool -> int -> int
  = "luv_stub_91_uv_tcp_keepalive" 

external luv_stub_92_uv_tcp_simultaneous_accepts : _ CI.fatptr -> bool -> int
  = "luv_stub_92_uv_tcp_simultaneous_accepts" 

external luv_stub_93_uv_tcp_bind : _ CI.fatptr -> _ CI.fatptr -> int -> int
  = "luv_stub_93_uv_tcp_bind" 

external luv_stub_94_uv_tcp_getsockname
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_94_uv_tcp_getsockname" 

external luv_stub_95_uv_tcp_getpeername
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_95_uv_tcp_getpeername" 

external luv_stub_96_uv_tcp_connect
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_96_uv_tcp_connect" 

external luv_stub_97_uv_tcp_close_reset
  : _ CI.fatptr -> _ CI.fatfunptr -> int = "luv_stub_97_uv_tcp_close_reset" 

external luv_stub_98_uv_pipe_init : _ CI.fatptr -> _ CI.fatptr -> bool -> int
  = "luv_stub_98_uv_pipe_init" 

external luv_stub_99_uv_pipe : _ CI.fatptr -> int -> int -> int
  = "luv_stub_99_uv_pipe" 

external luv_stub_100_uv_pipe_open : _ CI.fatptr -> int -> int
  = "luv_stub_100_uv_pipe_open" 

external luv_stub_101_uv_pipe_connect
  : _ CI.fatptr -> _ CI.fatptr -> string CI.ocaml -> _ CI.fatfunptr -> unit
  = "luv_stub_101_uv_pipe_connect" 

external luv_stub_102_uv_pipe_connect2
  : _ CI.fatptr -> _ CI.fatptr -> string CI.ocaml -> Unsigned.size_t ->
    int -> _ CI.fatfunptr -> unit
  = "luv_stub_102_uv_pipe_connect2_byte6" "luv_stub_102_uv_pipe_connect2" 

external luv_stub_103_uv_pipe_getsockname
  : _ CI.fatptr -> bytes CI.ocaml -> _ CI.fatptr -> int
  = "luv_stub_103_uv_pipe_getsockname" 

external luv_stub_104_uv_pipe_getpeername
  : _ CI.fatptr -> bytes CI.ocaml -> _ CI.fatptr -> int
  = "luv_stub_104_uv_pipe_getpeername" 

external luv_stub_105_uv_pipe_pending_instances : _ CI.fatptr -> int -> unit
  = "luv_stub_105_uv_pipe_pending_instances" 

external luv_stub_106_uv_pipe_pending_count : _ CI.fatptr -> int
  = "luv_stub_106_uv_pipe_pending_count" 

external luv_stub_107_uv_pipe_pending_type : _ CI.fatptr -> int
  = "luv_stub_107_uv_pipe_pending_type" 

external luv_stub_108_uv_pipe_chmod : _ CI.fatptr -> int -> int
  = "luv_stub_108_uv_pipe_chmod" 

external luv_stub_109_uv_tty_init
  : _ CI.fatptr -> _ CI.fatptr -> int -> int -> int
  = "luv_stub_109_uv_tty_init" 

external luv_stub_110_uv_tty_set_mode : _ CI.fatptr -> Unsigned.uint32 -> int
  = "luv_stub_110_uv_tty_set_mode" 

external luv_stub_111_uv_tty_reset_mode : unit -> int
  = "luv_stub_111_uv_tty_reset_mode" 

external luv_stub_112_uv_tty_get_winsize
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_112_uv_tty_get_winsize" 

external luv_stub_113_uv_tty_set_vterm_state : Unsigned.uint32 -> unit
  = "luv_stub_113_uv_tty_set_vterm_state" 

external luv_stub_114_uv_tty_get_vterm_state : _ CI.fatptr -> int
  = "luv_stub_114_uv_tty_get_vterm_state" 

external luv_stub_115_uv_udp_init : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_115_uv_udp_init" 

external luv_stub_116_uv_udp_init_ex
  : _ CI.fatptr -> _ CI.fatptr -> Unsigned.uint -> int
  = "luv_stub_116_uv_udp_init_ex" 

external luv_stub_117_uv_udp_open : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_117_uv_udp_open" 

external luv_stub_118_uv_udp_bind : _ CI.fatptr -> _ CI.fatptr -> int -> int
  = "luv_stub_118_uv_udp_bind" 

external luv_stub_119_uv_udp_connect : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_119_uv_udp_connect" 

external luv_stub_120_uv_udp_getpeername
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_120_uv_udp_getpeername" 

external luv_stub_121_uv_udp_getsockname
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_121_uv_udp_getsockname" 

external luv_stub_122_uv_udp_set_membership
  : _ CI.fatptr -> string CI.ocaml -> string CI.ocaml -> Unsigned.uint32 ->
    int = "luv_stub_122_uv_udp_set_membership" 

external luv_stub_123_uv_udp_set_source_membership
  : _ CI.fatptr -> string CI.ocaml -> string CI.ocaml -> string CI.ocaml ->
    Unsigned.uint32 -> int = "luv_stub_123_uv_udp_set_source_membership" 

external luv_stub_124_uv_udp_set_multicast_loop : _ CI.fatptr -> bool -> int
  = "luv_stub_124_uv_udp_set_multicast_loop" 

external luv_stub_125_uv_udp_set_multicast_ttl : _ CI.fatptr -> int -> int
  = "luv_stub_125_uv_udp_set_multicast_ttl" 

external luv_stub_126_uv_udp_set_multicast_interface
  : _ CI.fatptr -> string CI.ocaml -> int
  = "luv_stub_126_uv_udp_set_multicast_interface" 

external luv_stub_127_uv_udp_set_broadcast : _ CI.fatptr -> bool -> int
  = "luv_stub_127_uv_udp_set_broadcast" 

external luv_stub_128_uv_udp_set_ttl : _ CI.fatptr -> int -> int
  = "luv_stub_128_uv_udp_set_ttl" 

external luv_stub_129_luv_get_send_trampoline : unit -> CI.voidp
  = "luv_stub_129_luv_get_send_trampoline" 

external luv_stub_130_uv_udp_send
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> Unsigned.uint ->
    _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_130_uv_udp_send_byte6" "luv_stub_130_uv_udp_send" 

external luv_stub_131_uv_udp_try_send
  : _ CI.fatptr -> _ CI.fatptr -> Unsigned.uint -> _ CI.fatptr -> int
  = "luv_stub_131_uv_udp_try_send" 

external luv_stub_132_luv_get_recv_trampoline : unit -> CI.voidp
  = "luv_stub_132_luv_get_recv_trampoline" 

external luv_stub_133_luv_udp_recv_start
  : _ CI.fatptr -> _ CI.fatfunptr -> _ CI.fatfunptr -> int
  = "luv_stub_133_luv_udp_recv_start" 

external luv_stub_134_uv_udp_recv_stop : _ CI.fatptr -> int
  = "luv_stub_134_uv_udp_recv_stop" 

external luv_stub_135_uv_udp_using_recvmmsg : _ CI.fatptr -> bool
  = "luv_stub_135_uv_udp_using_recvmmsg" 

external luv_stub_136_uv_udp_get_send_queue_size
  : _ CI.fatptr -> Unsigned.size_t
  = "luv_stub_136_uv_udp_get_send_queue_size" 

external luv_stub_137_uv_udp_get_send_queue_count
  : _ CI.fatptr -> Unsigned.size_t
  = "luv_stub_137_uv_udp_get_send_queue_count" 

external luv_stub_138_luv_get_exit_trampoline : unit -> CI.voidp
  = "luv_stub_138_luv_get_exit_trampoline" 

external luv_stub_139_luv_null_exit_trampoline : unit -> CI.voidp
  = "luv_stub_139_luv_null_exit_trampoline" 

external luv_stub_140_uv_disable_stdio_inheritance : unit -> unit
  = "luv_stub_140_uv_disable_stdio_inheritance" 

external luv_stub_141_luv_spawn
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> _ CI.fatptr ->
    _ CI.fatptr -> int -> _ CI.fatptr -> int -> bool -> _ CI.fatptr ->
    bool -> int -> int -> _ CI.fatptr -> int -> int -> int
  = "luv_stub_141_luv_spawn_byte16" "luv_stub_141_luv_spawn" 

external luv_stub_142_uv_process_kill : _ CI.fatptr -> int -> int
  = "luv_stub_142_uv_process_kill" 

external luv_stub_143_uv_kill : int -> int -> int = "luv_stub_143_uv_kill" 

external luv_stub_144_uv_process_get_pid : _ CI.fatptr -> int
  = "luv_stub_144_uv_process_get_pid" 

external luv_stub_145_luv_get_fs_event_trampoline : unit -> CI.voidp
  = "luv_stub_145_luv_get_fs_event_trampoline" 

external luv_stub_146_uv_fs_event_init : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_146_uv_fs_event_init" 

external luv_stub_147_luv_fs_event_start
  : _ CI.fatptr -> _ CI.fatfunptr -> string CI.ocaml -> int -> int
  = "luv_stub_147_luv_fs_event_start" 

external luv_stub_148_uv_fs_event_stop : _ CI.fatptr -> int
  = "luv_stub_148_uv_fs_event_stop" 

external luv_stub_149_luv_get_fs_poll_trampoline : unit -> CI.voidp
  = "luv_stub_149_luv_get_fs_poll_trampoline" 

external luv_stub_150_uv_fs_poll_init : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_150_uv_fs_poll_init" 

external luv_stub_151_luv_fs_poll_start
  : _ CI.fatptr -> _ CI.fatfunptr -> string CI.ocaml -> int -> int
  = "luv_stub_151_luv_fs_poll_start" 

external luv_stub_152_uv_fs_poll_stop : _ CI.fatptr -> int
  = "luv_stub_152_uv_fs_poll_stop" 

external luv_stub_153_luv_get_getaddrinfo_trampoline : unit -> CI.voidp
  = "luv_stub_153_luv_get_getaddrinfo_trampoline" 

external luv_stub_154_uv_getaddrinfo
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> _ CI.fatptr ->
    _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_154_uv_getaddrinfo_byte6" "luv_stub_154_uv_getaddrinfo" 

external luv_stub_155_uv_freeaddrinfo : _ CI.fatptr -> unit
  = "luv_stub_155_uv_freeaddrinfo" 

external luv_stub_156_luv_get_getnameinfo_trampoline : unit -> CI.voidp
  = "luv_stub_156_luv_get_getnameinfo_trampoline" 

external luv_stub_157_uv_getnameinfo
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> _ CI.fatptr -> int -> int
  = "luv_stub_157_uv_getnameinfo" 

external luv_stub_158_uv_dlopen : string CI.ocaml -> _ CI.fatptr -> bool
  = "luv_stub_158_uv_dlopen" 

external luv_stub_159_uv_dlclose : _ CI.fatptr -> unit
  = "luv_stub_159_uv_dlclose" 

external luv_stub_160_uv_dlsym
  : _ CI.fatptr -> string CI.ocaml -> _ CI.fatptr -> bool
  = "luv_stub_160_uv_dlsym" 

external luv_stub_161_luv_dlerror : _ CI.fatptr -> CI.voidp
  = "luv_stub_161_luv_dlerror" 

external luv_stub_162_uv_get_osfhandle : int -> CI.managed_buffer
  = "luv_stub_162_uv_get_osfhandle" 

external luv_stub_163_uv_open_osfhandle : _ CI.fatptr -> int
  = "luv_stub_163_uv_open_osfhandle" 

external luv_stub_164_luv_is_invalid_handle_value : _ CI.fatptr -> bool
  = "luv_stub_164_luv_is_invalid_handle_value" 

external luv_stub_165_luv_is_invalid_socket_value : _ CI.fatptr -> bool
  = "luv_stub_165_luv_is_invalid_socket_value" 

external luv_stub_166_memcpy : bytes CI.ocaml -> _ CI.fatptr -> int -> unit
  = "luv_stub_166_memcpy" 

external luv_stub_167_memcpy : _ CI.fatptr -> bytes CI.ocaml -> int -> unit
  = "luv_stub_167_memcpy" 

external luv_stub_168_luv_get_work_trampoline : unit -> CI.voidp
  = "luv_stub_168_luv_get_work_trampoline" 

external luv_stub_169_luv_get_after_work_trampoline : unit -> CI.voidp
  = "luv_stub_169_luv_get_after_work_trampoline" 

external luv_stub_170_luv_get_c_work_trampoline : unit -> CI.voidp
  = "luv_stub_170_luv_get_c_work_trampoline" 

external luv_stub_171_luv_get_after_c_work_trampoline : unit -> CI.voidp
  = "luv_stub_171_luv_get_after_c_work_trampoline" 

external luv_stub_172_luv_add_c_function_and_argument
  : _ CI.fatptr -> nativeint -> nativeint -> bool
  = "luv_stub_172_luv_add_c_function_and_argument" 

external luv_stub_173_uv_queue_work
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> _ CI.fatfunptr -> int
  = "luv_stub_173_uv_queue_work" 

external luv_stub_174_luv_get_thread_trampoline : unit -> CI.voidp
  = "luv_stub_174_luv_get_thread_trampoline" 

external luv_stub_175_uv_thread_create_ex
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> _ CI.fatptr -> int
  = "luv_stub_175_uv_thread_create_ex" 

external luv_stub_176_luv_thread_create_c
  : _ CI.fatptr -> _ CI.fatptr -> nativeint -> nativeint -> int
  = "luv_stub_176_luv_thread_create_c" 

external luv_stub_177_uv_thread_self : unit -> CI.managed_buffer
  = "luv_stub_177_uv_thread_self" 

external luv_stub_178_uv_thread_equal : _ CI.fatptr -> _ CI.fatptr -> bool
  = "luv_stub_178_uv_thread_equal" 

external luv_stub_179_uv_thread_setpriority : _ CI.fatptr -> int -> int
  = "luv_stub_179_uv_thread_setpriority" 

external luv_stub_180_uv_thread_getpriority
  : _ CI.fatptr -> _ CI.fatptr -> int = "luv_stub_180_uv_thread_getpriority" 

external luv_stub_181_uv_cpumask_size : unit -> int
  = "luv_stub_181_uv_cpumask_size" 

external luv_stub_182_uv_thread_setaffinity
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> Unsigned.size_t -> int
  = "luv_stub_182_uv_thread_setaffinity" 

external luv_stub_183_uv_thread_getaffinity
  : _ CI.fatptr -> _ CI.fatptr -> Unsigned.size_t -> int
  = "luv_stub_183_uv_thread_getaffinity" 

external luv_stub_184_uv_thread_getcpu : unit -> int
  = "luv_stub_184_uv_thread_getcpu" 

external luv_stub_185_uv_key_create : _ CI.fatptr -> int
  = "luv_stub_185_uv_key_create" 

external luv_stub_186_uv_key_delete : _ CI.fatptr -> unit
  = "luv_stub_186_uv_key_delete" 

external luv_stub_187_uv_key_get : _ CI.fatptr -> CI.voidp
  = "luv_stub_187_uv_key_get" 

external luv_stub_188_uv_key_set : _ CI.fatptr -> _ CI.fatptr -> unit
  = "luv_stub_188_uv_key_set" 

external luv_stub_189_luv_get_once_trampoline : unit -> CI.voidp
  = "luv_stub_189_luv_get_once_trampoline" 

external luv_stub_190_luv_once_init : _ CI.fatptr -> int
  = "luv_stub_190_luv_once_init" 

external luv_stub_191_uv_once : _ CI.fatptr -> _ CI.fatfunptr -> unit
  = "luv_stub_191_uv_once" 

external luv_stub_192_uv_mutex_init : _ CI.fatptr -> int
  = "luv_stub_192_uv_mutex_init" 

external luv_stub_193_uv_mutex_init_recursive : _ CI.fatptr -> int
  = "luv_stub_193_uv_mutex_init_recursive" 

external luv_stub_194_uv_mutex_destroy : _ CI.fatptr -> unit
  = "luv_stub_194_uv_mutex_destroy" 

external luv_stub_195_uv_mutex_trylock : _ CI.fatptr -> int
  = "luv_stub_195_uv_mutex_trylock" 

external luv_stub_196_uv_mutex_unlock : _ CI.fatptr -> unit
  = "luv_stub_196_uv_mutex_unlock" 

external luv_stub_197_uv_rwlock_init : _ CI.fatptr -> int
  = "luv_stub_197_uv_rwlock_init" 

external luv_stub_198_uv_rwlock_destroy : _ CI.fatptr -> unit
  = "luv_stub_198_uv_rwlock_destroy" 

external luv_stub_199_uv_rwlock_tryrdlock : _ CI.fatptr -> int
  = "luv_stub_199_uv_rwlock_tryrdlock" 

external luv_stub_200_uv_rwlock_rdunlock : _ CI.fatptr -> unit
  = "luv_stub_200_uv_rwlock_rdunlock" 

external luv_stub_201_uv_rwlock_trywrlock : _ CI.fatptr -> int
  = "luv_stub_201_uv_rwlock_trywrlock" 

external luv_stub_202_uv_rwlock_wrunlock : _ CI.fatptr -> unit
  = "luv_stub_202_uv_rwlock_wrunlock" 

external luv_stub_203_uv_sem_init : _ CI.fatptr -> Unsigned.uint -> int
  = "luv_stub_203_uv_sem_init" 

external luv_stub_204_uv_sem_destroy : _ CI.fatptr -> unit
  = "luv_stub_204_uv_sem_destroy" 

external luv_stub_205_uv_sem_post : _ CI.fatptr -> unit
  = "luv_stub_205_uv_sem_post" 

external luv_stub_206_uv_sem_trywait : _ CI.fatptr -> int
  = "luv_stub_206_uv_sem_trywait" 

external luv_stub_207_uv_cond_init : _ CI.fatptr -> int
  = "luv_stub_207_uv_cond_init" 

external luv_stub_208_uv_cond_destroy : _ CI.fatptr -> unit
  = "luv_stub_208_uv_cond_destroy" 

external luv_stub_209_uv_cond_signal : _ CI.fatptr -> unit
  = "luv_stub_209_uv_cond_signal" 

external luv_stub_210_uv_cond_broadcast : _ CI.fatptr -> unit
  = "luv_stub_210_uv_cond_broadcast" 

external luv_stub_211_uv_barrier_init : _ CI.fatptr -> Unsigned.uint -> int
  = "luv_stub_211_uv_barrier_init" 

external luv_stub_212_uv_barrier_destroy : _ CI.fatptr -> unit
  = "luv_stub_212_uv_barrier_destroy" 

external luv_stub_213_uv_ip4_addr
  : string CI.ocaml -> int -> _ CI.fatptr -> int = "luv_stub_213_uv_ip4_addr" 

external luv_stub_214_uv_ip6_addr
  : string CI.ocaml -> int -> _ CI.fatptr -> int = "luv_stub_214_uv_ip6_addr" 

external luv_stub_215_uv_ip4_name
  : _ CI.fatptr -> bytes CI.ocaml -> Unsigned.size_t -> int
  = "luv_stub_215_uv_ip4_name" 

external luv_stub_216_uv_ip6_name
  : _ CI.fatptr -> bytes CI.ocaml -> Unsigned.size_t -> int
  = "luv_stub_216_uv_ip6_name" 

external luv_stub_217_memcpy : _ CI.fatptr -> _ CI.fatptr -> int -> unit
  = "luv_stub_217_memcpy" 

external luv_stub_218_ntohs : Unsigned.ushort -> Unsigned.ushort
  = "luv_stub_218_ntohs" 

external luv_stub_219_luv_sa_family_to_int : _ CI.fatptr -> int
  = "luv_stub_219_luv_sa_family_to_int" 

external luv_stub_220_uv_resident_set_memory : _ CI.fatptr -> int
  = "luv_stub_220_uv_resident_set_memory" 

external luv_stub_221_uv_uptime : _ CI.fatptr -> int
  = "luv_stub_221_uv_uptime" 

external luv_stub_222_uv_loadavg : _ CI.fatptr -> unit
  = "luv_stub_222_uv_loadavg" 

external luv_stub_223_uv_get_free_memory : unit -> Unsigned.uint64
  = "luv_stub_223_uv_get_free_memory" 

external luv_stub_224_uv_get_total_memory : unit -> Unsigned.uint64
  = "luv_stub_224_uv_get_total_memory" 

external luv_stub_225_uv_get_constrained_memory : unit -> Unsigned.uint64
  = "luv_stub_225_uv_get_constrained_memory" 

external luv_stub_226_uv_get_available_memory : unit -> Unsigned.uint64
  = "luv_stub_226_uv_get_available_memory" 

external luv_stub_227_uv_os_getpriority : int -> _ CI.fatptr -> int
  = "luv_stub_227_uv_os_getpriority" 

external luv_stub_228_uv_os_setpriority : int -> int -> int
  = "luv_stub_228_uv_os_setpriority" 

external luv_stub_229_uv_getrusage : _ CI.fatptr -> int
  = "luv_stub_229_uv_getrusage" 

external luv_stub_230_uv_os_getpid : unit -> int
  = "luv_stub_230_uv_os_getpid" 

external luv_stub_231_uv_os_getppid : unit -> int
  = "luv_stub_231_uv_os_getppid" 

external luv_stub_232_uv_available_parallelism : unit -> int
  = "luv_stub_232_uv_available_parallelism" 

external luv_stub_233_uv_cpu_info : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_233_uv_cpu_info" 

external luv_stub_234_uv_free_cpu_info : _ CI.fatptr -> int -> unit
  = "luv_stub_234_uv_free_cpu_info" 

external luv_stub_235_uv_interface_addresses
  : _ CI.fatptr -> _ CI.fatptr -> int = "luv_stub_235_uv_interface_addresses" 

external luv_stub_236_uv_free_interface_addresses
  : _ CI.fatptr -> int -> unit = "luv_stub_236_uv_free_interface_addresses" 

external luv_stub_237_uv_if_indextoname
  : Unsigned.uint -> bytes CI.ocaml -> _ CI.fatptr -> int
  = "luv_stub_237_uv_if_indextoname" 

external luv_stub_238_uv_if_indextoiid
  : Unsigned.uint -> bytes CI.ocaml -> _ CI.fatptr -> int
  = "luv_stub_238_uv_if_indextoiid" 

external luv_stub_239_uv_os_gethostname
  : bytes CI.ocaml -> _ CI.fatptr -> int = "luv_stub_239_uv_os_gethostname" 

external luv_stub_240_uv_exepath : bytes CI.ocaml -> _ CI.fatptr -> int
  = "luv_stub_240_uv_exepath" 

external luv_stub_241_uv_cwd : bytes CI.ocaml -> _ CI.fatptr -> int
  = "luv_stub_241_uv_cwd" 

external luv_stub_242_uv_chdir : string CI.ocaml -> int
  = "luv_stub_242_uv_chdir" 

external luv_stub_243_uv_os_homedir : bytes CI.ocaml -> _ CI.fatptr -> int
  = "luv_stub_243_uv_os_homedir" 

external luv_stub_244_uv_os_tmpdir : bytes CI.ocaml -> _ CI.fatptr -> int
  = "luv_stub_244_uv_os_tmpdir" 

external luv_stub_245_uv_os_get_passwd : _ CI.fatptr -> int
  = "luv_stub_245_uv_os_get_passwd" 

external luv_stub_246_uv_os_get_passwd2
  : _ CI.fatptr -> Unsigned.ulong -> int = "luv_stub_246_uv_os_get_passwd2" 

external luv_stub_247_uv_os_free_passwd : _ CI.fatptr -> unit
  = "luv_stub_247_uv_os_free_passwd" 

external luv_stub_248_uv_os_get_group : _ CI.fatptr -> Unsigned.ulong -> int
  = "luv_stub_248_uv_os_get_group" 

external luv_stub_249_uv_os_free_group : _ CI.fatptr -> unit
  = "luv_stub_249_uv_os_free_group" 

external luv_stub_250_uv_os_getenv
  : string CI.ocaml -> bytes CI.ocaml -> _ CI.fatptr -> int
  = "luv_stub_250_uv_os_getenv" 

external luv_stub_251_uv_os_setenv
  : string CI.ocaml -> string CI.ocaml -> int = "luv_stub_251_uv_os_setenv" 

external luv_stub_252_uv_os_unsetenv : string CI.ocaml -> int
  = "luv_stub_252_uv_os_unsetenv" 

external luv_stub_253_uv_os_environ : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_253_uv_os_environ" 

external luv_stub_254_uv_os_free_environ : _ CI.fatptr -> int -> unit
  = "luv_stub_254_uv_os_free_environ" 

external luv_stub_255_luv_os_uname : bytes CI.ocaml -> int
  = "luv_stub_255_luv_os_uname" 

external luv_stub_256_uv_gettimeofday : _ CI.fatptr -> int
  = "luv_stub_256_uv_gettimeofday" 

external luv_stub_257_uv_hrtime : unit -> Unsigned.uint64
  = "luv_stub_257_uv_hrtime" 

external luv_stub_258_uv_clock_gettime : int -> _ CI.fatptr -> int
  = "luv_stub_258_uv_clock_gettime" 

external luv_stub_259_luv_get_random_trampoline : unit -> CI.voidp
  = "luv_stub_259_luv_get_random_trampoline" 

external luv_stub_260_luv_null_random_trampoline : unit -> CI.voidp
  = "luv_stub_260_luv_null_random_trampoline" 

external luv_stub_261_uv_random
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> Unsigned.size_t ->
    Unsigned.uint -> _ CI.fatfunptr -> int
  = "luv_stub_261_uv_random_byte6" "luv_stub_261_uv_random" 

external luv_stub_262_uv_metrics_idle_time : _ CI.fatptr -> Unsigned.uint64
  = "luv_stub_262_uv_metrics_idle_time" 

external luv_stub_263_uv_metrics_info : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_263_uv_metrics_info" 

external luv_stub_264_luv_utf16_length_as_wtf8
  : _ CI.fatptr -> int64 -> Unsigned.size_t
  = "luv_stub_264_luv_utf16_length_as_wtf8" 

external luv_stub_265_luv_utf16_to_wtf8
  : _ CI.fatptr -> int64 -> _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_265_luv_utf16_to_wtf8" 

external luv_stub_266_uv_wtf8_length_as_utf16 : _ CI.fatptr -> int64
  = "luv_stub_266_uv_wtf8_length_as_utf16" 

external luv_stub_267_uv_wtf8_to_utf16
  : _ CI.fatptr -> _ CI.fatptr -> Unsigned.size_t -> unit
  = "luv_stub_267_uv_wtf8_to_utf16" 

external luv_stub_268_free : _ CI.fatptr -> unit = "luv_stub_268_free" 

type 'a result = 'a
type 'a return = 'a
type 'a fn =
 | Returns  : 'a CI.typ   -> 'a return fn
 | Function : 'a CI.typ * 'b fn  -> ('a -> 'b) fn
let map_result f x = f x
let returning t = Returns t
let (@->) f p = Function (f, p)
let foreign : type a b. string -> (a -> b) fn -> (a -> b) =
  fun name t -> match t, name with
| Function (CI.Pointer _, Returns CI.Void), "free" ->
  (fun x1 -> let CI.CPointer x2 = x1 in luv_stub_268_free x2)
| Function
    (CI.View {CI.ty = CI.Pointer _; write = x4; _},
     Function
       (CI.Pointer _, Function (CI.Primitive CI.Size_t, Returns CI.Void))),
  "uv_wtf8_to_utf16" ->
  (fun x3 x7 x9 ->
    let CI.CPointer x8 = x7 in
    let CI.CPointer x6 = x4 x3 in
    let x5 = x6 in luv_stub_267_uv_wtf8_to_utf16 x5 x8 x9)
| Function
    (CI.View {CI.ty = CI.Pointer _; write = x11; _},
     Returns (CI.View {CI.ty = CI.Primitive CI.Int64_t; read = x14; _})),
  "uv_wtf8_length_as_utf16" ->
  (fun x10 ->
    let CI.CPointer x13 = x11 x10 in
    let x12 = x13 in x14 (luv_stub_266_uv_wtf8_length_as_utf16 x12))
| Function
    (CI.View {CI.ty = CI.Pointer _; write = x16; _},
     Function
       (CI.View {CI.ty = CI.Primitive CI.Int64_t; write = x20; _},
        Function
          (CI.Pointer _,
           Function (CI.Pointer _, Returns (CI.Primitive CI.Int))))),
  "luv_utf16_to_wtf8" ->
  (fun x15 x19 x22 x24 ->
    let CI.CPointer x25 = x24 in
    let CI.CPointer x23 = x22 in
    let CI.CPointer x18 = x16 x15 in
    let x17 = x18 in
    let x21 = x20 x19 in luv_stub_265_luv_utf16_to_wtf8 x17 x21 x23 x25)
| Function
    (CI.View {CI.ty = CI.Pointer _; write = x27; _},
     Function
       (CI.View {CI.ty = CI.Primitive CI.Int64_t; write = x31; _},
        Returns (CI.Primitive CI.Size_t))),
  "luv_utf16_length_as_wtf8" ->
  (fun x26 x30 ->
    let CI.CPointer x29 = x27 x26 in
    let x28 = x29 in
    let x32 = x31 x30 in luv_stub_264_luv_utf16_length_as_wtf8 x28 x32)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_metrics_info" ->
  (fun x33 x35 ->
    let CI.CPointer x36 = x35 in
    let CI.CPointer x34 = x33 in luv_stub_263_uv_metrics_info x34 x36)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Uint64_t)),
  "uv_metrics_idle_time" ->
  (fun x37 ->
    let CI.CPointer x38 = x37 in luv_stub_262_uv_metrics_idle_time x38)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Pointer _,
           Function
             (CI.Primitive CI.Size_t,
              Function
                (CI.Primitive CI.Uint,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_random" ->
  (fun x39 x41 x43 x45 x46 x47 ->
    let CI.Static_funptr x48 = x47 in
    let CI.CPointer x44 = x43 in
    let CI.CPointer x42 = x41 in
    let CI.CPointer x40 = x39 in
    luv_stub_261_uv_random x40 x42 x44 x45 x46 x48)
| Function (CI.Void, Returns (CI.Funptr x50)), "luv_null_random_trampoline" ->
  (fun x49 ->
    CI.make_fun_ptr x50 (luv_stub_260_luv_null_random_trampoline x49))
| Function (CI.Void, Returns (CI.Funptr x52)), "luv_get_random_trampoline" ->
  (fun x51 ->
    CI.make_fun_ptr x52 (luv_stub_259_luv_get_random_trampoline x51))
| Function
    (CI.Primitive CI.Int,
     Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_clock_gettime" ->
  (fun x53 x54 ->
    let CI.CPointer x55 = x54 in luv_stub_258_uv_clock_gettime x53 x55)
| Function (CI.Void, Returns (CI.Primitive CI.Uint64_t)), "uv_hrtime" ->
  luv_stub_257_uv_hrtime
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_gettimeofday" ->
  (fun x57 -> let CI.CPointer x58 = x57 in luv_stub_256_uv_gettimeofday x58)
| Function (CI.OCaml CI.Bytes, Returns (CI.Primitive CI.Int)), "luv_os_uname" ->
  luv_stub_255_luv_os_uname
| Function (CI.Pointer _, Function (CI.Primitive CI.Int, Returns CI.Void)),
  "uv_os_free_environ" ->
  (fun x60 x62 ->
    let CI.CPointer x61 = x60 in luv_stub_254_uv_os_free_environ x61 x62)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_os_environ" ->
  (fun x63 x65 ->
    let CI.CPointer x66 = x65 in
    let CI.CPointer x64 = x63 in luv_stub_253_uv_os_environ x64 x66)
| Function (CI.OCaml CI.String, Returns (CI.Primitive CI.Int)),
  "uv_os_unsetenv" -> luv_stub_252_uv_os_unsetenv
| Function
    (CI.OCaml CI.String,
     Function (CI.OCaml CI.String, Returns (CI.Primitive CI.Int))),
  "uv_os_setenv" -> luv_stub_251_uv_os_setenv
| Function
    (CI.OCaml CI.String,
     Function
       (CI.OCaml CI.Bytes,
        Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_os_getenv" ->
  (fun x70 x71 x72 ->
    let CI.CPointer x73 = x72 in luv_stub_250_uv_os_getenv x70 x71 x73)
| Function (CI.Pointer _, Returns CI.Void), "uv_os_free_group" ->
  (fun x74 -> let CI.CPointer x75 = x74 in luv_stub_249_uv_os_free_group x75)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Ulong, Returns (CI.Primitive CI.Int))),
  "uv_os_get_group" ->
  (fun x76 x78 ->
    let CI.CPointer x77 = x76 in luv_stub_248_uv_os_get_group x77 x78)
| Function (CI.Pointer _, Returns CI.Void), "uv_os_free_passwd" ->
  (fun x79 ->
    let CI.CPointer x80 = x79 in luv_stub_247_uv_os_free_passwd x80)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Ulong, Returns (CI.Primitive CI.Int))),
  "uv_os_get_passwd2" ->
  (fun x81 x83 ->
    let CI.CPointer x82 = x81 in luv_stub_246_uv_os_get_passwd2 x82 x83)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_os_get_passwd" ->
  (fun x84 -> let CI.CPointer x85 = x84 in luv_stub_245_uv_os_get_passwd x85)
| Function
    (CI.OCaml CI.Bytes,
     Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_os_tmpdir" ->
  (fun x86 x87 ->
    let CI.CPointer x88 = x87 in luv_stub_244_uv_os_tmpdir x86 x88)
| Function
    (CI.OCaml CI.Bytes,
     Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_os_homedir" ->
  (fun x89 x90 ->
    let CI.CPointer x91 = x90 in luv_stub_243_uv_os_homedir x89 x91)
| Function (CI.OCaml CI.String, Returns (CI.Primitive CI.Int)), "uv_chdir" ->
  luv_stub_242_uv_chdir
| Function
    (CI.OCaml CI.Bytes,
     Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_cwd" ->
  (fun x93 x94 -> let CI.CPointer x95 = x94 in luv_stub_241_uv_cwd x93 x95)
| Function
    (CI.OCaml CI.Bytes,
     Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_exepath" ->
  (fun x96 x97 ->
    let CI.CPointer x98 = x97 in luv_stub_240_uv_exepath x96 x98)
| Function
    (CI.OCaml CI.Bytes,
     Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_os_gethostname" ->
  (fun x99 x100 ->
    let CI.CPointer x101 = x100 in luv_stub_239_uv_os_gethostname x99 x101)
| Function
    (CI.Primitive CI.Uint,
     Function
       (CI.OCaml CI.Bytes,
        Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_if_indextoiid" ->
  (fun x102 x103 x104 ->
    let CI.CPointer x105 = x104 in
    luv_stub_238_uv_if_indextoiid x102 x103 x105)
| Function
    (CI.Primitive CI.Uint,
     Function
       (CI.OCaml CI.Bytes,
        Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_if_indextoname" ->
  (fun x106 x107 x108 ->
    let CI.CPointer x109 = x108 in
    luv_stub_237_uv_if_indextoname x106 x107 x109)
| Function (CI.Pointer _, Function (CI.Primitive CI.Int, Returns CI.Void)),
  "uv_free_interface_addresses" ->
  (fun x110 x112 ->
    let CI.CPointer x111 = x110 in
    luv_stub_236_uv_free_interface_addresses x111 x112)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_interface_addresses" ->
  (fun x113 x115 ->
    let CI.CPointer x116 = x115 in
    let CI.CPointer x114 = x113 in
    luv_stub_235_uv_interface_addresses x114 x116)
| Function (CI.Pointer _, Function (CI.Primitive CI.Int, Returns CI.Void)),
  "uv_free_cpu_info" ->
  (fun x117 x119 ->
    let CI.CPointer x118 = x117 in luv_stub_234_uv_free_cpu_info x118 x119)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_cpu_info" ->
  (fun x120 x122 ->
    let CI.CPointer x123 = x122 in
    let CI.CPointer x121 = x120 in luv_stub_233_uv_cpu_info x121 x123)
| Function (CI.Void, Returns (CI.Primitive CI.Int)),
  "uv_available_parallelism" -> luv_stub_232_uv_available_parallelism
| Function (CI.Void, Returns (CI.Primitive CI.Int)), "uv_os_getppid" ->
  luv_stub_231_uv_os_getppid
| Function (CI.Void, Returns (CI.Primitive CI.Int)), "uv_os_getpid" ->
  luv_stub_230_uv_os_getpid
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_getrusage" ->
  (fun x127 -> let CI.CPointer x128 = x127 in luv_stub_229_uv_getrusage x128)
| Function
    (CI.Primitive CI.Int,
     Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))),
  "uv_os_setpriority" -> luv_stub_228_uv_os_setpriority
| Function
    (CI.Primitive CI.Int,
     Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_os_getpriority" ->
  (fun x131 x132 ->
    let CI.CPointer x133 = x132 in luv_stub_227_uv_os_getpriority x131 x133)
| Function (CI.Void, Returns (CI.Primitive CI.Uint64_t)),
  "uv_get_available_memory" -> luv_stub_226_uv_get_available_memory
| Function (CI.Void, Returns (CI.Primitive CI.Uint64_t)),
  "uv_get_constrained_memory" -> luv_stub_225_uv_get_constrained_memory
| Function (CI.Void, Returns (CI.Primitive CI.Uint64_t)),
  "uv_get_total_memory" -> luv_stub_224_uv_get_total_memory
| Function (CI.Void, Returns (CI.Primitive CI.Uint64_t)),
  "uv_get_free_memory" -> luv_stub_223_uv_get_free_memory
| Function (CI.Pointer _, Returns CI.Void), "uv_loadavg" ->
  (fun x138 -> let CI.CPointer x139 = x138 in luv_stub_222_uv_loadavg x139)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_uptime" ->
  (fun x140 -> let CI.CPointer x141 = x140 in luv_stub_221_uv_uptime x141)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)),
  "uv_resident_set_memory" ->
  (fun x142 ->
    let CI.CPointer x143 = x142 in luv_stub_220_uv_resident_set_memory x143)
| Function
    (CI.View {CI.ty = CI.Struct _; write = x145; _},
     Returns (CI.Primitive CI.Int)),
  "luv_sa_family_to_int" ->
  (fun x144 ->
    let CI.CPointer x147 = Ctypes.addr (x145 x144) in
    let x146 = x147 in luv_stub_219_luv_sa_family_to_int x146)
| Function (CI.Primitive CI.Ushort, Returns (CI.Primitive CI.Ushort)),
  "ntohs" -> luv_stub_218_ntohs
| Function
    (CI.Pointer _,
     Function (CI.Pointer _, Function (CI.Primitive CI.Int, Returns CI.Void))),
  "memcpy" ->
  (fun x149 x151 x153 ->
    let CI.CPointer x152 = x151 in
    let CI.CPointer x150 = x149 in luv_stub_217_memcpy x150 x152 x153)
| Function
    (CI.Pointer _,
     Function
       (CI.OCaml CI.Bytes,
        Function (CI.Primitive CI.Size_t, Returns (CI.Primitive CI.Int)))),
  "uv_ip6_name" ->
  (fun x154 x156 x157 ->
    let CI.CPointer x155 = x154 in luv_stub_216_uv_ip6_name x155 x156 x157)
| Function
    (CI.Pointer _,
     Function
       (CI.OCaml CI.Bytes,
        Function (CI.Primitive CI.Size_t, Returns (CI.Primitive CI.Int)))),
  "uv_ip4_name" ->
  (fun x158 x160 x161 ->
    let CI.CPointer x159 = x158 in luv_stub_215_uv_ip4_name x159 x160 x161)
| Function
    (CI.OCaml CI.String,
     Function
       (CI.Primitive CI.Int,
        Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_ip6_addr" ->
  (fun x162 x163 x164 ->
    let CI.CPointer x165 = x164 in luv_stub_214_uv_ip6_addr x162 x163 x165)
| Function
    (CI.OCaml CI.String,
     Function
       (CI.Primitive CI.Int,
        Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_ip4_addr" ->
  (fun x166 x167 x168 ->
    let CI.CPointer x169 = x168 in luv_stub_213_uv_ip4_addr x166 x167 x169)
| Function (CI.Pointer _, Returns CI.Void), "uv_barrier_destroy" ->
  (fun x170 ->
    let CI.CPointer x171 = x170 in luv_stub_212_uv_barrier_destroy x171)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Uint, Returns (CI.Primitive CI.Int))),
  "uv_barrier_init" ->
  (fun x172 x174 ->
    let CI.CPointer x173 = x172 in luv_stub_211_uv_barrier_init x173 x174)
| Function (CI.Pointer _, Returns CI.Void), "uv_cond_broadcast" ->
  (fun x175 ->
    let CI.CPointer x176 = x175 in luv_stub_210_uv_cond_broadcast x176)
| Function (CI.Pointer _, Returns CI.Void), "uv_cond_signal" ->
  (fun x177 ->
    let CI.CPointer x178 = x177 in luv_stub_209_uv_cond_signal x178)
| Function (CI.Pointer _, Returns CI.Void), "uv_cond_destroy" ->
  (fun x179 ->
    let CI.CPointer x180 = x179 in luv_stub_208_uv_cond_destroy x180)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_cond_init" ->
  (fun x181 -> let CI.CPointer x182 = x181 in luv_stub_207_uv_cond_init x182)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_sem_trywait" ->
  (fun x183 ->
    let CI.CPointer x184 = x183 in luv_stub_206_uv_sem_trywait x184)
| Function (CI.Pointer _, Returns CI.Void), "uv_sem_post" ->
  (fun x185 -> let CI.CPointer x186 = x185 in luv_stub_205_uv_sem_post x186)
| Function (CI.Pointer _, Returns CI.Void), "uv_sem_destroy" ->
  (fun x187 ->
    let CI.CPointer x188 = x187 in luv_stub_204_uv_sem_destroy x188)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Uint, Returns (CI.Primitive CI.Int))),
  "uv_sem_init" ->
  (fun x189 x191 ->
    let CI.CPointer x190 = x189 in luv_stub_203_uv_sem_init x190 x191)
| Function (CI.Pointer _, Returns CI.Void), "uv_rwlock_wrunlock" ->
  (fun x192 ->
    let CI.CPointer x193 = x192 in luv_stub_202_uv_rwlock_wrunlock x193)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)),
  "uv_rwlock_trywrlock" ->
  (fun x194 ->
    let CI.CPointer x195 = x194 in luv_stub_201_uv_rwlock_trywrlock x195)
| Function (CI.Pointer _, Returns CI.Void), "uv_rwlock_rdunlock" ->
  (fun x196 ->
    let CI.CPointer x197 = x196 in luv_stub_200_uv_rwlock_rdunlock x197)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)),
  "uv_rwlock_tryrdlock" ->
  (fun x198 ->
    let CI.CPointer x199 = x198 in luv_stub_199_uv_rwlock_tryrdlock x199)
| Function (CI.Pointer _, Returns CI.Void), "uv_rwlock_destroy" ->
  (fun x200 ->
    let CI.CPointer x201 = x200 in luv_stub_198_uv_rwlock_destroy x201)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_rwlock_init" ->
  (fun x202 ->
    let CI.CPointer x203 = x202 in luv_stub_197_uv_rwlock_init x203)
| Function (CI.Pointer _, Returns CI.Void), "uv_mutex_unlock" ->
  (fun x204 ->
    let CI.CPointer x205 = x204 in luv_stub_196_uv_mutex_unlock x205)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_mutex_trylock" ->
  (fun x206 ->
    let CI.CPointer x207 = x206 in luv_stub_195_uv_mutex_trylock x207)
| Function (CI.Pointer _, Returns CI.Void), "uv_mutex_destroy" ->
  (fun x208 ->
    let CI.CPointer x209 = x208 in luv_stub_194_uv_mutex_destroy x209)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)),
  "uv_mutex_init_recursive" ->
  (fun x210 ->
    let CI.CPointer x211 = x210 in luv_stub_193_uv_mutex_init_recursive x211)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_mutex_init" ->
  (fun x212 ->
    let CI.CPointer x213 = x212 in luv_stub_192_uv_mutex_init x213)
| Function (CI.Pointer _, Function (CI.Funptr _, Returns CI.Void)), "uv_once" ->
  (fun x214 x216 ->
    let CI.Static_funptr x217 = x216 in
    let CI.CPointer x215 = x214 in luv_stub_191_uv_once x215 x217)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "luv_once_init" ->
  (fun x218 ->
    let CI.CPointer x219 = x218 in luv_stub_190_luv_once_init x219)
| Function (CI.Void, Returns (CI.Funptr x221)), "luv_get_once_trampoline" ->
  (fun x220 ->
    CI.make_fun_ptr x221 (luv_stub_189_luv_get_once_trampoline x220))
| Function (CI.Pointer _, Function (CI.Pointer _, Returns CI.Void)),
  "uv_key_set" ->
  (fun x222 x224 ->
    let CI.CPointer x225 = x224 in
    let CI.CPointer x223 = x222 in luv_stub_188_uv_key_set x223 x225)
| Function (CI.Pointer _, Returns (CI.Pointer x228)), "uv_key_get" ->
  (fun x226 ->
    let CI.CPointer x227 = x226 in
    CI.make_ptr x228 (luv_stub_187_uv_key_get x227))
| Function (CI.Pointer _, Returns CI.Void), "uv_key_delete" ->
  (fun x229 ->
    let CI.CPointer x230 = x229 in luv_stub_186_uv_key_delete x230)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_key_create" ->
  (fun x231 ->
    let CI.CPointer x232 = x231 in luv_stub_185_uv_key_create x232)
| Function (CI.Void, Returns (CI.Primitive CI.Int)), "uv_thread_getcpu" ->
  luv_stub_184_uv_thread_getcpu
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function (CI.Primitive CI.Size_t, Returns (CI.Primitive CI.Int)))),
  "uv_thread_getaffinity" ->
  (fun x234 x236 x238 ->
    let CI.CPointer x237 = x236 in
    let CI.CPointer x235 = x234 in
    luv_stub_183_uv_thread_getaffinity x235 x237 x238)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Pointer _,
           Function (CI.Primitive CI.Size_t, Returns (CI.Primitive CI.Int))))),
  "uv_thread_setaffinity" ->
  (fun x239 x241 x243 x245 ->
    let CI.CPointer x244 = x243 in
    let CI.CPointer x242 = x241 in
    let CI.CPointer x240 = x239 in
    luv_stub_182_uv_thread_setaffinity x240 x242 x244 x245)
| Function (CI.Void, Returns (CI.Primitive CI.Int)), "uv_cpumask_size" ->
  luv_stub_181_uv_cpumask_size
| Function
    (CI.View {CI.ty = CI.Struct _; write = x248; _},
     Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_thread_getpriority" ->
  (fun x247 x251 ->
    let CI.CPointer x252 = x251 in
    let CI.CPointer x250 = Ctypes.addr (x248 x247) in
    let x249 = x250 in luv_stub_180_uv_thread_getpriority x249 x252)
| Function
    (CI.View {CI.ty = CI.Struct _; write = x254; _},
     Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))),
  "uv_thread_setpriority" ->
  (fun x253 x257 ->
    let CI.CPointer x256 = Ctypes.addr (x254 x253) in
    let x255 = x256 in luv_stub_179_uv_thread_setpriority x255 x257)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Bool))),
  "uv_thread_equal" ->
  (fun x258 x260 ->
    let CI.CPointer x261 = x260 in
    let CI.CPointer x259 = x258 in luv_stub_178_uv_thread_equal x259 x261)
| Function
    (CI.Void,
     Returns (CI.View {CI.ty = (CI.Struct _ as x263); read = x264; _})),
  "uv_thread_self" ->
  (fun x262 ->
    x264 (CI.make_structured x263 (luv_stub_177_uv_thread_self x262)))
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Nativeint,
           Function
             (CI.Primitive CI.Nativeint, Returns (CI.Primitive CI.Int))))),
  "luv_thread_create_c" ->
  (fun x265 x267 x269 x270 ->
    let CI.CPointer x268 = x267 in
    let CI.CPointer x266 = x265 in
    luv_stub_176_luv_thread_create_c x266 x268 x269 x270)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Funptr _,
           Function (CI.Pointer _, Returns (CI.Primitive CI.Int))))),
  "uv_thread_create_ex" ->
  (fun x271 x273 x275 x277 ->
    let CI.CPointer x278 = x277 in
    let CI.Static_funptr x276 = x275 in
    let CI.CPointer x274 = x273 in
    let CI.CPointer x272 = x271 in
    luv_stub_175_uv_thread_create_ex x272 x274 x276 x278)
| Function (CI.Void, Returns (CI.Funptr x280)), "luv_get_thread_trampoline" ->
  (fun x279 ->
    CI.make_fun_ptr x280 (luv_stub_174_luv_get_thread_trampoline x279))
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Funptr _,
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_queue_work" ->
  (fun x281 x283 x285 x287 ->
    let CI.Static_funptr x288 = x287 in
    let CI.Static_funptr x286 = x285 in
    let CI.CPointer x284 = x283 in
    let CI.CPointer x282 = x281 in
    luv_stub_173_uv_queue_work x282 x284 x286 x288)
| Function
    (CI.Pointer _,
     Function
       (CI.Primitive CI.Nativeint,
        Function (CI.Primitive CI.Nativeint, Returns (CI.Primitive CI.Bool)))),
  "luv_add_c_function_and_argument" ->
  (fun x289 x291 x292 ->
    let CI.CPointer x290 = x289 in
    luv_stub_172_luv_add_c_function_and_argument x290 x291 x292)
| Function (CI.Void, Returns (CI.Funptr x294)),
  "luv_get_after_c_work_trampoline" ->
  (fun x293 ->
    CI.make_fun_ptr x294 (luv_stub_171_luv_get_after_c_work_trampoline x293))
| Function (CI.Void, Returns (CI.Funptr x296)), "luv_get_c_work_trampoline" ->
  (fun x295 ->
    CI.make_fun_ptr x296 (luv_stub_170_luv_get_c_work_trampoline x295))
| Function (CI.Void, Returns (CI.Funptr x298)),
  "luv_get_after_work_trampoline" ->
  (fun x297 ->
    CI.make_fun_ptr x298 (luv_stub_169_luv_get_after_work_trampoline x297))
| Function (CI.Void, Returns (CI.Funptr x300)), "luv_get_work_trampoline" ->
  (fun x299 ->
    CI.make_fun_ptr x300 (luv_stub_168_luv_get_work_trampoline x299))
| Function
    (CI.Pointer _,
     Function
       (CI.OCaml CI.Bytes, Function (CI.Primitive CI.Int, Returns CI.Void))),
  "memcpy" ->
  (fun x301 x303 x304 ->
    let CI.CPointer x302 = x301 in luv_stub_167_memcpy x302 x303 x304)
| Function
    (CI.OCaml CI.Bytes,
     Function (CI.Pointer _, Function (CI.Primitive CI.Int, Returns CI.Void))),
  "memcpy" ->
  (fun x305 x306 x308 ->
    let CI.CPointer x307 = x306 in luv_stub_166_memcpy x305 x307 x308)
| Function
    (CI.View {CI.ty = CI.Struct _; write = x310; _},
     Returns (CI.Primitive CI.Bool)),
  "luv_is_invalid_socket_value" ->
  (fun x309 ->
    let CI.CPointer x312 = Ctypes.addr (x310 x309) in
    let x311 = x312 in luv_stub_165_luv_is_invalid_socket_value x311)
| Function
    (CI.View {CI.ty = CI.Struct _; write = x314; _},
     Returns (CI.Primitive CI.Bool)),
  "luv_is_invalid_handle_value" ->
  (fun x313 ->
    let CI.CPointer x316 = Ctypes.addr (x314 x313) in
    let x315 = x316 in luv_stub_164_luv_is_invalid_handle_value x315)
| Function
    (CI.View {CI.ty = CI.Struct _; write = x318; _},
     Returns (CI.Primitive CI.Int)),
  "uv_open_osfhandle" ->
  (fun x317 ->
    let CI.CPointer x320 = Ctypes.addr (x318 x317) in
    let x319 = x320 in luv_stub_163_uv_open_osfhandle x319)
| Function
    (CI.Primitive CI.Int,
     Returns (CI.View {CI.ty = (CI.Struct _ as x322); read = x323; _})),
  "uv_get_osfhandle" ->
  (fun x321 ->
    x323 (CI.make_structured x322 (luv_stub_162_uv_get_osfhandle x321)))
| Function
    (CI.Pointer _,
     Returns (CI.View {CI.ty = CI.Pointer x326; read = x327; _})),
  "luv_dlerror" ->
  (fun x324 ->
    let CI.CPointer x325 = x324 in
    x327 (CI.make_ptr x326 (luv_stub_161_luv_dlerror x325)))
| Function
    (CI.Pointer _,
     Function
       (CI.OCaml CI.String,
        Function (CI.Pointer _, Returns (CI.Primitive CI.Bool)))),
  "uv_dlsym" ->
  (fun x328 x330 x331 ->
    let CI.CPointer x332 = x331 in
    let CI.CPointer x329 = x328 in luv_stub_160_uv_dlsym x329 x330 x332)
| Function (CI.Pointer _, Returns CI.Void), "uv_dlclose" ->
  (fun x333 -> let CI.CPointer x334 = x333 in luv_stub_159_uv_dlclose x334)
| Function
    (CI.OCaml CI.String,
     Function (CI.Pointer _, Returns (CI.Primitive CI.Bool))),
  "uv_dlopen" ->
  (fun x335 x336 ->
    let CI.CPointer x337 = x336 in luv_stub_158_uv_dlopen x335 x337)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Funptr _,
           Function
             (CI.Pointer _,
              Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int)))))),
  "uv_getnameinfo" ->
  (fun x338 x340 x342 x344 x346 ->
    let CI.CPointer x345 = x344 in
    let CI.Static_funptr x343 = x342 in
    let CI.CPointer x341 = x340 in
    let CI.CPointer x339 = x338 in
    luv_stub_157_uv_getnameinfo x339 x341 x343 x345 x346)
| Function (CI.Void, Returns (CI.Funptr x348)),
  "luv_get_getnameinfo_trampoline" ->
  (fun x347 ->
    CI.make_fun_ptr x348 (luv_stub_156_luv_get_getnameinfo_trampoline x347))
| Function (CI.Pointer _, Returns CI.Void), "uv_freeaddrinfo" ->
  (fun x349 ->
    let CI.CPointer x350 = x349 in luv_stub_155_uv_freeaddrinfo x350)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Funptr _,
           Function
             (CI.View {CI.ty = CI.Pointer _; write = x358; _},
              Function
                (CI.View {CI.ty = CI.Pointer _; write = x362; _},
                 Function (CI.Pointer _, Returns (CI.Primitive CI.Int))))))),
  "uv_getaddrinfo" ->
  (fun x351 x353 x355 x357 x361 x365 ->
    let CI.CPointer x366 = x365 in
    let CI.CPointer x364 = x362 x361 in
    let CI.CPointer x360 = x358 x357 in
    let CI.Static_funptr x356 = x355 in
    let CI.CPointer x354 = x353 in
    let CI.CPointer x352 = x351 in
    let x359 = x360 in
    let x363 = x364 in
    luv_stub_154_uv_getaddrinfo x352 x354 x356 x359 x363 x366)
| Function (CI.Void, Returns (CI.Funptr x368)),
  "luv_get_getaddrinfo_trampoline" ->
  (fun x367 ->
    CI.make_fun_ptr x368 (luv_stub_153_luv_get_getaddrinfo_trampoline x367))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_fs_poll_stop" ->
  (fun x369 ->
    let CI.CPointer x370 = x369 in luv_stub_152_uv_fs_poll_stop x370)
| Function
    (CI.Pointer _,
     Function
       (CI.Funptr _,
        Function
          (CI.OCaml CI.String,
           Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))))),
  "luv_fs_poll_start" ->
  (fun x371 x373 x375 x376 ->
    let CI.Static_funptr x374 = x373 in
    let CI.CPointer x372 = x371 in
    luv_stub_151_luv_fs_poll_start x372 x374 x375 x376)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_fs_poll_init" ->
  (fun x377 x379 ->
    let CI.CPointer x380 = x379 in
    let CI.CPointer x378 = x377 in luv_stub_150_uv_fs_poll_init x378 x380)
| Function (CI.Void, Returns (CI.Funptr x382)), "luv_get_fs_poll_trampoline" ->
  (fun x381 ->
    CI.make_fun_ptr x382 (luv_stub_149_luv_get_fs_poll_trampoline x381))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_fs_event_stop" ->
  (fun x383 ->
    let CI.CPointer x384 = x383 in luv_stub_148_uv_fs_event_stop x384)
| Function
    (CI.Pointer _,
     Function
       (CI.Funptr _,
        Function
          (CI.OCaml CI.String,
           Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))))),
  "luv_fs_event_start" ->
  (fun x385 x387 x389 x390 ->
    let CI.Static_funptr x388 = x387 in
    let CI.CPointer x386 = x385 in
    luv_stub_147_luv_fs_event_start x386 x388 x389 x390)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_fs_event_init" ->
  (fun x391 x393 ->
    let CI.CPointer x394 = x393 in
    let CI.CPointer x392 = x391 in luv_stub_146_uv_fs_event_init x392 x394)
| Function (CI.Void, Returns (CI.Funptr x396)), "luv_get_fs_event_trampoline" ->
  (fun x395 ->
    CI.make_fun_ptr x396 (luv_stub_145_luv_get_fs_event_trampoline x395))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)),
  "uv_process_get_pid" ->
  (fun x397 ->
    let CI.CPointer x398 = x397 in luv_stub_144_uv_process_get_pid x398)
| Function
    (CI.Primitive CI.Int,
     Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))),
  "uv_kill" -> luv_stub_143_uv_kill
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))),
  "uv_process_kill" ->
  (fun x401 x403 ->
    let CI.CPointer x402 = x401 in luv_stub_142_uv_process_kill x402 x403)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Funptr _,
           Function
             (CI.Pointer _,
              Function
                (CI.Pointer _,
                 Function
                   (CI.Primitive CI.Int,
                    Function
                      (CI.Pointer _,
                       Function
                         (CI.Primitive CI.Int,
                          Function
                            (CI.Primitive CI.Bool,
                             Function
                               (CI.Pointer _,
                                Function
                                  (CI.Primitive CI.Bool,
                                   Function
                                     (CI.Primitive CI.Int,
                                      Function
                                        (CI.Primitive CI.Int,
                                         Function
                                           (CI.Pointer _,
                                            Function
                                              (CI.Primitive CI.Int,
                                               Function
                                                 (CI.Primitive CI.Int,
                                                  Returns
                                                    (CI.Primitive CI.Int))))))))))))))))),
  "luv_spawn" ->
  (fun x404 x406 x408 x410 x412 x414 x415 x417 x418 x419 x421 x422 x423 x424
    x426 x427 ->
    let CI.CPointer x425 = x424 in
    let CI.CPointer x420 = x419 in
    let CI.CPointer x416 = x415 in
    let CI.CPointer x413 = x412 in
    let CI.CPointer x411 = x410 in
    let CI.Static_funptr x409 = x408 in
    let CI.CPointer x407 = x406 in
    let CI.CPointer x405 = x404 in
    luv_stub_141_luv_spawn x405 x407 x409 x411 x413 x414 x416 x417 x418 x420
    x421 x422 x423 x425 x426 x427)
| Function (CI.Void, Returns CI.Void), "uv_disable_stdio_inheritance" ->
  luv_stub_140_uv_disable_stdio_inheritance
| Function (CI.Void, Returns (CI.Funptr x430)), "luv_null_exit_trampoline" ->
  (fun x429 ->
    CI.make_fun_ptr x430 (luv_stub_139_luv_null_exit_trampoline x429))
| Function (CI.Void, Returns (CI.Funptr x432)), "luv_get_exit_trampoline" ->
  (fun x431 ->
    CI.make_fun_ptr x432 (luv_stub_138_luv_get_exit_trampoline x431))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Size_t)),
  "uv_udp_get_send_queue_count" ->
  (fun x433 ->
    let CI.CPointer x434 = x433 in
    luv_stub_137_uv_udp_get_send_queue_count x434)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Size_t)),
  "uv_udp_get_send_queue_size" ->
  (fun x435 ->
    let CI.CPointer x436 = x435 in
    luv_stub_136_uv_udp_get_send_queue_size x436)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Bool)),
  "uv_udp_using_recvmmsg" ->
  (fun x437 ->
    let CI.CPointer x438 = x437 in luv_stub_135_uv_udp_using_recvmmsg x438)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_udp_recv_stop" ->
  (fun x439 ->
    let CI.CPointer x440 = x439 in luv_stub_134_uv_udp_recv_stop x440)
| Function
    (CI.Pointer _,
     Function
       (CI.Funptr _, Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))),
  "luv_udp_recv_start" ->
  (fun x441 x443 x445 ->
    let CI.Static_funptr x446 = x445 in
    let CI.Static_funptr x444 = x443 in
    let CI.CPointer x442 = x441 in
    luv_stub_133_luv_udp_recv_start x442 x444 x446)
| Function (CI.Void, Returns (CI.Funptr x448)), "luv_get_recv_trampoline" ->
  (fun x447 ->
    CI.make_fun_ptr x448 (luv_stub_132_luv_get_recv_trampoline x447))
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Uint,
           Function (CI.Pointer _, Returns (CI.Primitive CI.Int))))),
  "uv_udp_try_send" ->
  (fun x449 x451 x453 x454 ->
    let CI.CPointer x455 = x454 in
    let CI.CPointer x452 = x451 in
    let CI.CPointer x450 = x449 in
    luv_stub_131_uv_udp_try_send x450 x452 x453 x455)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Pointer _,
           Function
             (CI.Primitive CI.Uint,
              Function
                (CI.Pointer _,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_udp_send" ->
  (fun x456 x458 x460 x462 x463 x465 ->
    let CI.Static_funptr x466 = x465 in
    let CI.CPointer x464 = x463 in
    let CI.CPointer x461 = x460 in
    let CI.CPointer x459 = x458 in
    let CI.CPointer x457 = x456 in
    luv_stub_130_uv_udp_send x457 x459 x461 x462 x464 x466)
| Function (CI.Void, Returns (CI.Funptr x468)), "luv_get_send_trampoline" ->
  (fun x467 ->
    CI.make_fun_ptr x468 (luv_stub_129_luv_get_send_trampoline x467))
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))),
  "uv_udp_set_ttl" ->
  (fun x469 x471 ->
    let CI.CPointer x470 = x469 in luv_stub_128_uv_udp_set_ttl x470 x471)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Bool, Returns (CI.Primitive CI.Int))),
  "uv_udp_set_broadcast" ->
  (fun x472 x474 ->
    let CI.CPointer x473 = x472 in
    luv_stub_127_uv_udp_set_broadcast x473 x474)
| Function
    (CI.Pointer _,
     Function (CI.OCaml CI.String, Returns (CI.Primitive CI.Int))),
  "uv_udp_set_multicast_interface" ->
  (fun x475 x477 ->
    let CI.CPointer x476 = x475 in
    luv_stub_126_uv_udp_set_multicast_interface x476 x477)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))),
  "uv_udp_set_multicast_ttl" ->
  (fun x478 x480 ->
    let CI.CPointer x479 = x478 in
    luv_stub_125_uv_udp_set_multicast_ttl x479 x480)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Bool, Returns (CI.Primitive CI.Int))),
  "uv_udp_set_multicast_loop" ->
  (fun x481 x483 ->
    let CI.CPointer x482 = x481 in
    luv_stub_124_uv_udp_set_multicast_loop x482 x483)
| Function
    (CI.Pointer _,
     Function
       (CI.OCaml CI.String,
        Function
          (CI.OCaml CI.String,
           Function
             (CI.OCaml CI.String,
              Function
                (CI.View {CI.ty = CI.Primitive CI.Uint32_t; write = x490; _},
                 Returns (CI.Primitive CI.Int)))))),
  "uv_udp_set_source_membership" ->
  (fun x484 x486 x487 x488 x489 ->
    let CI.CPointer x485 = x484 in
    let x491 = x490 x489 in
    luv_stub_123_uv_udp_set_source_membership x485 x486 x487 x488 x491)
| Function
    (CI.Pointer _,
     Function
       (CI.OCaml CI.String,
        Function
          (CI.OCaml CI.String,
           Function
             (CI.View {CI.ty = CI.Primitive CI.Uint32_t; write = x497; _},
              Returns (CI.Primitive CI.Int))))),
  "uv_udp_set_membership" ->
  (fun x492 x494 x495 x496 ->
    let CI.CPointer x493 = x492 in
    let x498 = x497 x496 in
    luv_stub_122_uv_udp_set_membership x493 x494 x495 x498)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_udp_getsockname" ->
  (fun x499 x501 x503 ->
    let CI.CPointer x504 = x503 in
    let CI.CPointer x502 = x501 in
    let CI.CPointer x500 = x499 in
    luv_stub_121_uv_udp_getsockname x500 x502 x504)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_udp_getpeername" ->
  (fun x505 x507 x509 ->
    let CI.CPointer x510 = x509 in
    let CI.CPointer x508 = x507 in
    let CI.CPointer x506 = x505 in
    luv_stub_120_uv_udp_getpeername x506 x508 x510)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_udp_connect" ->
  (fun x511 x513 ->
    let CI.CPointer x514 = x513 in
    let CI.CPointer x512 = x511 in luv_stub_119_uv_udp_connect x512 x514)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int)))),
  "uv_udp_bind" ->
  (fun x515 x517 x519 ->
    let CI.CPointer x518 = x517 in
    let CI.CPointer x516 = x515 in luv_stub_118_uv_udp_bind x516 x518 x519)
| Function
    (CI.Pointer _,
     Function
       (CI.View {CI.ty = CI.Struct _; write = x523; _},
        Returns (CI.Primitive CI.Int))),
  "uv_udp_open" ->
  (fun x520 x522 ->
    let CI.CPointer x525 = Ctypes.addr (x523 x522) in
    let CI.CPointer x521 = x520 in
    let x524 = x525 in luv_stub_117_uv_udp_open x521 x524)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function (CI.Primitive CI.Uint, Returns (CI.Primitive CI.Int)))),
  "uv_udp_init_ex" ->
  (fun x526 x528 x530 ->
    let CI.CPointer x529 = x528 in
    let CI.CPointer x527 = x526 in luv_stub_116_uv_udp_init_ex x527 x529 x530)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_udp_init" ->
  (fun x531 x533 ->
    let CI.CPointer x534 = x533 in
    let CI.CPointer x532 = x531 in luv_stub_115_uv_udp_init x532 x534)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)),
  "uv_tty_get_vterm_state" ->
  (fun x535 ->
    let CI.CPointer x536 = x535 in luv_stub_114_uv_tty_get_vterm_state x536)
| Function
    (CI.View {CI.ty = CI.Primitive CI.Uint32_t; write = x538; _},
     Returns CI.Void),
  "uv_tty_set_vterm_state" ->
  (fun x537 ->
    let x539 = x538 x537 in luv_stub_113_uv_tty_set_vterm_state x539)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_tty_get_winsize" ->
  (fun x540 x542 x544 ->
    let CI.CPointer x545 = x544 in
    let CI.CPointer x543 = x542 in
    let CI.CPointer x541 = x540 in
    luv_stub_112_uv_tty_get_winsize x541 x543 x545)
| Function (CI.Void, Returns (CI.Primitive CI.Int)), "uv_tty_reset_mode" ->
  luv_stub_111_uv_tty_reset_mode
| Function
    (CI.Pointer _,
     Function
       (CI.View {CI.ty = CI.Primitive CI.Uint32_t; write = x550; _},
        Returns (CI.Primitive CI.Int))),
  "uv_tty_set_mode" ->
  (fun x547 x549 ->
    let CI.CPointer x548 = x547 in
    let x551 = x550 x549 in luv_stub_110_uv_tty_set_mode x548 x551)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))))),
  "uv_tty_init" ->
  (fun x552 x554 x556 x557 ->
    let CI.CPointer x555 = x554 in
    let CI.CPointer x553 = x552 in
    luv_stub_109_uv_tty_init x553 x555 x556 x557)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))),
  "uv_pipe_chmod" ->
  (fun x558 x560 ->
    let CI.CPointer x559 = x558 in luv_stub_108_uv_pipe_chmod x559 x560)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)),
  "uv_pipe_pending_type" ->
  (fun x561 ->
    let CI.CPointer x562 = x561 in luv_stub_107_uv_pipe_pending_type x562)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)),
  "uv_pipe_pending_count" ->
  (fun x563 ->
    let CI.CPointer x564 = x563 in luv_stub_106_uv_pipe_pending_count x564)
| Function (CI.Pointer _, Function (CI.Primitive CI.Int, Returns CI.Void)),
  "uv_pipe_pending_instances" ->
  (fun x565 x567 ->
    let CI.CPointer x566 = x565 in
    luv_stub_105_uv_pipe_pending_instances x566 x567)
| Function
    (CI.Pointer _,
     Function
       (CI.OCaml CI.Bytes,
        Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_pipe_getpeername" ->
  (fun x568 x570 x571 ->
    let CI.CPointer x572 = x571 in
    let CI.CPointer x569 = x568 in
    luv_stub_104_uv_pipe_getpeername x569 x570 x572)
| Function
    (CI.Pointer _,
     Function
       (CI.OCaml CI.Bytes,
        Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_pipe_getsockname" ->
  (fun x573 x575 x576 ->
    let CI.CPointer x577 = x576 in
    let CI.CPointer x574 = x573 in
    luv_stub_103_uv_pipe_getsockname x574 x575 x577)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.OCaml CI.String,
           Function
             (CI.Primitive CI.Size_t,
              Function
                (CI.Primitive CI.Int,
                 Function (CI.Funptr _, Returns CI.Void)))))),
  "uv_pipe_connect2" ->
  (fun x578 x580 x582 x583 x584 x585 ->
    let CI.Static_funptr x586 = x585 in
    let CI.CPointer x581 = x580 in
    let CI.CPointer x579 = x578 in
    luv_stub_102_uv_pipe_connect2 x579 x581 x582 x583 x584 x586)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.OCaml CI.String, Function (CI.Funptr _, Returns CI.Void)))),
  "uv_pipe_connect" ->
  (fun x587 x589 x591 x592 ->
    let CI.Static_funptr x593 = x592 in
    let CI.CPointer x590 = x589 in
    let CI.CPointer x588 = x587 in
    luv_stub_101_uv_pipe_connect x588 x590 x591 x593)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))),
  "uv_pipe_open" ->
  (fun x594 x596 ->
    let CI.CPointer x595 = x594 in luv_stub_100_uv_pipe_open x595 x596)
| Function
    (CI.Pointer _,
     Function
       (CI.Primitive CI.Int,
        Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int)))),
  "uv_pipe" ->
  (fun x597 x599 x600 ->
    let CI.CPointer x598 = x597 in luv_stub_99_uv_pipe x598 x599 x600)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function (CI.Primitive CI.Bool, Returns (CI.Primitive CI.Int)))),
  "uv_pipe_init" ->
  (fun x601 x603 x605 ->
    let CI.CPointer x604 = x603 in
    let CI.CPointer x602 = x601 in luv_stub_98_uv_pipe_init x602 x604 x605)
| Function
    (CI.Pointer _, Function (CI.Funptr _, Returns (CI.Primitive CI.Int))),
  "uv_tcp_close_reset" ->
  (fun x606 x608 ->
    let CI.Static_funptr x609 = x608 in
    let CI.CPointer x607 = x606 in luv_stub_97_uv_tcp_close_reset x607 x609)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Pointer _,
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_tcp_connect" ->
  (fun x610 x612 x614 x616 ->
    let CI.Static_funptr x617 = x616 in
    let CI.CPointer x615 = x614 in
    let CI.CPointer x613 = x612 in
    let CI.CPointer x611 = x610 in
    luv_stub_96_uv_tcp_connect x611 x613 x615 x617)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_tcp_getpeername" ->
  (fun x618 x620 x622 ->
    let CI.CPointer x623 = x622 in
    let CI.CPointer x621 = x620 in
    let CI.CPointer x619 = x618 in
    luv_stub_95_uv_tcp_getpeername x619 x621 x623)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int)))),
  "uv_tcp_getsockname" ->
  (fun x624 x626 x628 ->
    let CI.CPointer x629 = x628 in
    let CI.CPointer x627 = x626 in
    let CI.CPointer x625 = x624 in
    luv_stub_94_uv_tcp_getsockname x625 x627 x629)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int)))),
  "uv_tcp_bind" ->
  (fun x630 x632 x634 ->
    let CI.CPointer x633 = x632 in
    let CI.CPointer x631 = x630 in luv_stub_93_uv_tcp_bind x631 x633 x634)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Bool, Returns (CI.Primitive CI.Int))),
  "uv_tcp_simultaneous_accepts" ->
  (fun x635 x637 ->
    let CI.CPointer x636 = x635 in
    luv_stub_92_uv_tcp_simultaneous_accepts x636 x637)
| Function
    (CI.Pointer _,
     Function
       (CI.Primitive CI.Bool,
        Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int)))),
  "uv_tcp_keepalive" ->
  (fun x638 x640 x641 ->
    let CI.CPointer x639 = x638 in
    luv_stub_91_uv_tcp_keepalive x639 x640 x641)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Bool, Returns (CI.Primitive CI.Int))),
  "uv_tcp_nodelay" ->
  (fun x642 x644 ->
    let CI.CPointer x643 = x642 in luv_stub_90_uv_tcp_nodelay x643 x644)
| Function
    (CI.Primitive CI.Int,
     Function
       (CI.Primitive CI.Int,
        Function
          (CI.Pointer _,
           Function
             (CI.Primitive CI.Int,
              Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int)))))),
  "uv_socketpair" ->
  (fun x645 x646 x647 x649 x650 ->
    let CI.CPointer x648 = x647 in
    luv_stub_89_uv_socketpair x645 x646 x648 x649 x650)
| Function
    (CI.Pointer _,
     Function
       (CI.View {CI.ty = CI.Struct _; write = x654; _},
        Returns (CI.Primitive CI.Int))),
  "uv_tcp_open" ->
  (fun x651 x653 ->
    let CI.CPointer x656 = Ctypes.addr (x654 x653) in
    let CI.CPointer x652 = x651 in
    let x655 = x656 in luv_stub_88_uv_tcp_open x652 x655)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function (CI.Primitive CI.Uint, Returns (CI.Primitive CI.Int)))),
  "uv_tcp_init_ex" ->
  (fun x657 x659 x661 ->
    let CI.CPointer x660 = x659 in
    let CI.CPointer x658 = x657 in luv_stub_87_uv_tcp_init_ex x658 x660 x661)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_tcp_init" ->
  (fun x662 x664 ->
    let CI.CPointer x665 = x664 in
    let CI.CPointer x663 = x662 in luv_stub_86_uv_tcp_init x663 x665)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Size_t)),
  "uv_stream_get_write_queue_size" ->
  (fun x666 ->
    let CI.CPointer x667 = x666 in
    luv_stub_85_uv_stream_get_write_queue_size x667)
| Function
    (CI.Pointer _,
     Function (CI.Primitive CI.Bool, Returns (CI.Primitive CI.Int))),
  "uv_stream_set_blocking" ->
  (fun x668 x670 ->
    let CI.CPointer x669 = x668 in
    luv_stub_84_uv_stream_set_blocking x669 x670)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Bool)), "uv_is_writable" ->
  (fun x671 ->
    let CI.CPointer x672 = x671 in luv_stub_83_uv_is_writable x672)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Bool)), "uv_is_readable" ->
  (fun x673 ->
    let CI.CPointer x674 = x673 in luv_stub_82_uv_is_readable x674)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Uint,
           Function (CI.Pointer _, Returns (CI.Primitive CI.Int))))),
  "uv_try_write2" ->
  (fun x675 x677 x679 x680 ->
    let CI.CPointer x681 = x680 in
    let CI.CPointer x678 = x677 in
    let CI.CPointer x676 = x675 in
    luv_stub_81_uv_try_write2 x676 x678 x679 x681)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function (CI.Primitive CI.Uint, Returns (CI.Primitive CI.Int)))),
  "uv_try_write" ->
  (fun x682 x684 x686 ->
    let CI.CPointer x685 = x684 in
    let CI.CPointer x683 = x682 in luv_stub_80_uv_try_write x683 x685 x686)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Pointer _,
           Function
             (CI.Primitive CI.Uint,
              Function
                (CI.Pointer _,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_write2" ->
  (fun x687 x689 x691 x693 x694 x696 ->
    let CI.Static_funptr x697 = x696 in
    let CI.CPointer x695 = x694 in
    let CI.CPointer x692 = x691 in
    let CI.CPointer x690 = x689 in
    let CI.CPointer x688 = x687 in
    luv_stub_79_uv_write2 x688 x690 x692 x693 x695 x697)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_read_stop" ->
  (fun x698 -> let CI.CPointer x699 = x698 in luv_stub_78_uv_read_stop x699)
| Function
    (CI.Pointer _,
     Function
       (CI.Funptr _, Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))),
  "luv_read_start" ->
  (fun x700 x702 x704 ->
    let CI.Static_funptr x705 = x704 in
    let CI.Static_funptr x703 = x702 in
    let CI.CPointer x701 = x700 in luv_stub_77_luv_read_start x701 x703 x705)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_accept" ->
  (fun x706 x708 ->
    let CI.CPointer x709 = x708 in
    let CI.CPointer x707 = x706 in luv_stub_76_uv_accept x707 x709)
| Function
    (CI.Pointer _,
     Function
       (CI.Primitive CI.Int,
        Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))),
  "uv_listen" ->
  (fun x710 x712 x713 ->
    let CI.Static_funptr x714 = x713 in
    let CI.CPointer x711 = x710 in luv_stub_75_uv_listen x711 x712 x714)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _, Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))),
  "uv_shutdown" ->
  (fun x715 x717 x719 ->
    let CI.Static_funptr x720 = x719 in
    let CI.CPointer x718 = x717 in
    let CI.CPointer x716 = x715 in luv_stub_74_uv_shutdown x716 x718 x720)
| Function (CI.Void, Returns (CI.Funptr x722)), "luv_get_read_trampoline" ->
  (fun x721 ->
    CI.make_fun_ptr x722 (luv_stub_73_luv_get_read_trampoline x721))
| Function (CI.Void, Returns (CI.Funptr x724)),
  "luv_get_connection_trampoline" ->
  (fun x723 ->
    CI.make_fun_ptr x724 (luv_stub_72_luv_get_connection_trampoline x723))
| Function (CI.Void, Returns (CI.Funptr x726)), "luv_get_write_trampoline" ->
  (fun x725 ->
    CI.make_fun_ptr x726 (luv_stub_71_luv_get_write_trampoline x725))
| Function (CI.Void, Returns (CI.Funptr x728)), "luv_get_shutdown_trampoline" ->
  (fun x727 ->
    CI.make_fun_ptr x728 (luv_stub_70_luv_get_shutdown_trampoline x727))
| Function (CI.Void, Returns (CI.Funptr x730)), "luv_get_connect_trampoline" ->
  (fun x729 ->
    CI.make_fun_ptr x730 (luv_stub_69_luv_get_connect_trampoline x729))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_signal_stop" ->
  (fun x731 ->
    let CI.CPointer x732 = x731 in luv_stub_68_uv_signal_stop x732)
| Function
    (CI.Pointer _,
     Function
       (CI.Funptr _,
        Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int)))),
  "uv_signal_start_oneshot" ->
  (fun x733 x735 x737 ->
    let CI.Static_funptr x736 = x735 in
    let CI.CPointer x734 = x733 in
    luv_stub_67_uv_signal_start_oneshot x734 x736 x737)
| Function
    (CI.Pointer _,
     Function
       (CI.Funptr _,
        Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int)))),
  "uv_signal_start" ->
  (fun x738 x740 x742 ->
    let CI.Static_funptr x741 = x740 in
    let CI.CPointer x739 = x738 in luv_stub_66_uv_signal_start x739 x741 x742)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_signal_init" ->
  (fun x743 x745 ->
    let CI.CPointer x746 = x745 in
    let CI.CPointer x744 = x743 in luv_stub_65_uv_signal_init x744 x746)
| Function (CI.Void, Returns (CI.Funptr x748)), "luv_get_signal_trampoline" ->
  (fun x747 ->
    CI.make_fun_ptr x748 (luv_stub_64_luv_get_signal_trampoline x747))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_poll_stop" ->
  (fun x749 -> let CI.CPointer x750 = x749 in luv_stub_63_uv_poll_stop x750)
| Function
    (CI.Pointer _,
     Function
       (CI.Primitive CI.Int,
        Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))),
  "uv_poll_start" ->
  (fun x751 x753 x754 ->
    let CI.Static_funptr x755 = x754 in
    let CI.CPointer x752 = x751 in luv_stub_62_uv_poll_start x752 x753 x755)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Struct _; write = x761; _},
           Returns (CI.Primitive CI.Int)))),
  "uv_poll_init_socket" ->
  (fun x756 x758 x760 ->
    let CI.CPointer x763 = Ctypes.addr (x761 x760) in
    let CI.CPointer x759 = x758 in
    let CI.CPointer x757 = x756 in
    let x762 = x763 in luv_stub_61_uv_poll_init_socket x757 x759 x762)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int)))),
  "uv_poll_init" ->
  (fun x764 x766 x768 ->
    let CI.CPointer x767 = x766 in
    let CI.CPointer x765 = x764 in luv_stub_60_uv_poll_init x765 x767 x768)
| Function (CI.Void, Returns (CI.Funptr x770)), "luv_get_poll_trampoline" ->
  (fun x769 ->
    CI.make_fun_ptr x770 (luv_stub_59_luv_get_poll_trampoline x769))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_async_send" ->
  (fun x771 -> let CI.CPointer x772 = x771 in luv_stub_58_uv_async_send x772)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _, Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))),
  "uv_async_init" ->
  (fun x773 x775 x777 ->
    let CI.Static_funptr x778 = x777 in
    let CI.CPointer x776 = x775 in
    let CI.CPointer x774 = x773 in luv_stub_57_uv_async_init x774 x776 x778)
| Function (CI.Void, Returns (CI.Funptr x780)), "luv_get_async_trampoline" ->
  (fun x779 ->
    CI.make_fun_ptr x780 (luv_stub_56_luv_get_async_trampoline x779))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_idle_stop" ->
  (fun x781 -> let CI.CPointer x782 = x781 in luv_stub_55_uv_idle_stop x782)
| Function
    (CI.Pointer _, Function (CI.Funptr _, Returns (CI.Primitive CI.Int))),
  "uv_idle_start" ->
  (fun x783 x785 ->
    let CI.Static_funptr x786 = x785 in
    let CI.CPointer x784 = x783 in luv_stub_54_uv_idle_start x784 x786)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_idle_init" ->
  (fun x787 x789 ->
    let CI.CPointer x790 = x789 in
    let CI.CPointer x788 = x787 in luv_stub_53_uv_idle_init x788 x790)
| Function (CI.Void, Returns (CI.Funptr x792)), "luv_get_idle_trampoline" ->
  (fun x791 ->
    CI.make_fun_ptr x792 (luv_stub_52_luv_get_idle_trampoline x791))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_check_stop" ->
  (fun x793 -> let CI.CPointer x794 = x793 in luv_stub_51_uv_check_stop x794)
| Function
    (CI.Pointer _, Function (CI.Funptr _, Returns (CI.Primitive CI.Int))),
  "uv_check_start" ->
  (fun x795 x797 ->
    let CI.Static_funptr x798 = x797 in
    let CI.CPointer x796 = x795 in luv_stub_50_uv_check_start x796 x798)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_check_init" ->
  (fun x799 x801 ->
    let CI.CPointer x802 = x801 in
    let CI.CPointer x800 = x799 in luv_stub_49_uv_check_init x800 x802)
| Function (CI.Void, Returns (CI.Funptr x804)), "luv_get_check_trampoline" ->
  (fun x803 ->
    CI.make_fun_ptr x804 (luv_stub_48_luv_get_check_trampoline x803))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_prepare_stop" ->
  (fun x805 ->
    let CI.CPointer x806 = x805 in luv_stub_47_uv_prepare_stop x806)
| Function
    (CI.Pointer _, Function (CI.Funptr _, Returns (CI.Primitive CI.Int))),
  "uv_prepare_start" ->
  (fun x807 x809 ->
    let CI.Static_funptr x810 = x809 in
    let CI.CPointer x808 = x807 in luv_stub_46_uv_prepare_start x808 x810)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_prepare_init" ->
  (fun x811 x813 ->
    let CI.CPointer x814 = x813 in
    let CI.CPointer x812 = x811 in luv_stub_45_uv_prepare_init x812 x814)
| Function (CI.Void, Returns (CI.Funptr x816)), "luv_get_prepare_trampoline" ->
  (fun x815 ->
    CI.make_fun_ptr x816 (luv_stub_44_luv_get_prepare_trampoline x815))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Uint64_t)),
  "uv_timer_get_due_in" ->
  (fun x817 ->
    let CI.CPointer x818 = x817 in luv_stub_43_uv_timer_get_due_in x818)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Uint64_t)),
  "uv_timer_get_repeat" ->
  (fun x819 ->
    let CI.CPointer x820 = x819 in luv_stub_42_uv_timer_get_repeat x820)
| Function
    (CI.Pointer _, Function (CI.Primitive CI.Uint64_t, Returns CI.Void)),
  "uv_timer_set_repeat" ->
  (fun x821 x823 ->
    let CI.CPointer x822 = x821 in luv_stub_41_uv_timer_set_repeat x822 x823)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_timer_again" ->
  (fun x824 ->
    let CI.CPointer x825 = x824 in luv_stub_40_uv_timer_again x825)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_timer_stop" ->
  (fun x826 -> let CI.CPointer x827 = x826 in luv_stub_39_uv_timer_stop x827)
| Function
    (CI.Pointer _,
     Function
       (CI.Funptr _,
        Function
          (CI.Primitive CI.Uint64_t,
           Function (CI.Primitive CI.Uint64_t, Returns (CI.Primitive CI.Int))))),
  "uv_timer_start" ->
  (fun x828 x830 x832 x833 ->
    let CI.Static_funptr x831 = x830 in
    let CI.CPointer x829 = x828 in
    luv_stub_38_uv_timer_start x829 x831 x832 x833)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_timer_init" ->
  (fun x834 x836 ->
    let CI.CPointer x837 = x836 in
    let CI.CPointer x835 = x834 in luv_stub_37_uv_timer_init x835 x837)
| Function (CI.Void, Returns (CI.Funptr x839)), "luv_get_timer_trampoline" ->
  (fun x838 ->
    CI.make_fun_ptr x839 (luv_stub_36_luv_get_timer_trampoline x838))
| Function (CI.Pointer _, Function (CI.Pointer _, Returns CI.Void)),
  "uv_req_set_data" ->
  (fun x840 x842 ->
    let CI.CPointer x843 = x842 in
    let CI.CPointer x841 = x840 in luv_stub_35_uv_req_set_data x841 x843)
| Function (CI.Pointer _, Returns (CI.Pointer x846)), "uv_req_get_data" ->
  (fun x844 ->
    let CI.CPointer x845 = x844 in
    CI.make_ptr x846 (luv_stub_34_uv_req_get_data x845))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_cancel" ->
  (fun x847 -> let CI.CPointer x848 = x847 in luv_stub_33_uv_cancel x848)
| Function (CI.Pointer _, Function (CI.Pointer _, Returns CI.Void)),
  "uv_handle_set_data" ->
  (fun x849 x851 ->
    let CI.CPointer x852 = x851 in
    let CI.CPointer x850 = x849 in luv_stub_32_uv_handle_set_data x850 x852)
| Function (CI.Pointer _, Returns (CI.Pointer x855)), "uv_handle_get_data" ->
  (fun x853 ->
    let CI.CPointer x854 = x853 in
    CI.make_ptr x855 (luv_stub_31_uv_handle_get_data x854))
| Function (CI.Pointer _, Returns (CI.Pointer x858)), "uv_handle_get_loop" ->
  (fun x856 ->
    let CI.CPointer x857 = x856 in
    CI.make_ptr x858 (luv_stub_30_uv_handle_get_loop x857))
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_fileno" ->
  (fun x859 x861 ->
    let CI.CPointer x862 = x861 in
    let CI.CPointer x860 = x859 in luv_stub_29_uv_fileno x860 x862)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_recv_buffer_size" ->
  (fun x863 x865 ->
    let CI.CPointer x866 = x865 in
    let CI.CPointer x864 = x863 in luv_stub_28_uv_recv_buffer_size x864 x866)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_send_buffer_size" ->
  (fun x867 x869 ->
    let CI.CPointer x870 = x869 in
    let CI.CPointer x868 = x867 in luv_stub_27_uv_send_buffer_size x868 x870)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Bool)), "uv_has_ref" ->
  (fun x871 -> let CI.CPointer x872 = x871 in luv_stub_26_uv_has_ref x872)
| Function (CI.Pointer _, Returns CI.Void), "uv_unref" ->
  (fun x873 -> let CI.CPointer x874 = x873 in luv_stub_25_uv_unref x874)
| Function (CI.Pointer _, Returns CI.Void), "uv_ref" ->
  (fun x875 -> let CI.CPointer x876 = x875 in luv_stub_24_uv_ref x876)
| Function (CI.Pointer _, Function (CI.Funptr _, Returns CI.Void)),
  "uv_close" ->
  (fun x877 x879 ->
    let CI.Static_funptr x880 = x879 in
    let CI.CPointer x878 = x877 in luv_stub_23_uv_close x878 x880)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Bool)), "uv_is_closing" ->
  (fun x881 -> let CI.CPointer x882 = x881 in luv_stub_22_uv_is_closing x882)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Bool)), "uv_is_active" ->
  (fun x883 -> let CI.CPointer x884 = x883 in luv_stub_21_uv_is_active x884)
| Function (CI.Void, Returns (CI.Funptr x886)), "luv_get_alloc_trampoline" ->
  (fun x885 ->
    CI.make_fun_ptr x886 (luv_stub_20_luv_get_alloc_trampoline x885))
| Function (CI.Void, Returns (CI.Funptr x888)), "luv_get_close_trampoline" ->
  (fun x887 ->
    CI.make_fun_ptr x888 (luv_stub_19_luv_get_close_trampoline x887))
| Function (CI.Void, Returns CI.Void), "uv_library_shutdown" ->
  luv_stub_18_uv_library_shutdown
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_loop_fork" ->
  (fun x890 -> let CI.CPointer x891 = x890 in luv_stub_17_uv_loop_fork x891)
| Function (CI.Pointer _, Returns CI.Void), "uv_update_time" ->
  (fun x892 ->
    let CI.CPointer x893 = x892 in luv_stub_16_uv_update_time x893)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Uint64_t)), "uv_now" ->
  (fun x894 -> let CI.CPointer x895 = x894 in luv_stub_15_uv_now x895)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)),
  "uv_backend_timeout" ->
  (fun x896 ->
    let CI.CPointer x897 = x896 in luv_stub_14_uv_backend_timeout x897)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_backend_fd" ->
  (fun x898 -> let CI.CPointer x899 = x898 in luv_stub_13_uv_backend_fd x899)
| Function (CI.Pointer _, Returns CI.Void), "uv_stop" ->
  (fun x900 -> let CI.CPointer x901 = x900 in luv_stub_12_uv_stop x901)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Bool)), "uv_loop_alive" ->
  (fun x902 -> let CI.CPointer x903 = x902 in luv_stub_11_uv_loop_alive x903)
| Function (CI.Void, Returns (CI.Pointer x905)), "uv_default_loop" ->
  (fun x904 -> CI.make_ptr x905 (luv_stub_10_uv_default_loop x904))
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_loop_close" ->
  (fun x906 -> let CI.CPointer x907 = x906 in luv_stub_9_uv_loop_close x907)
| Function
    (CI.Pointer _,
     Function
       (CI.Primitive CI.Int,
        Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int)))),
  "uv_loop_configure" ->
  (fun x908 x910 x911 ->
    let CI.CPointer x909 = x908 in
    luv_stub_8_uv_loop_configure x909 x910 x911)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_loop_init" ->
  (fun x912 -> let CI.CPointer x913 = x912 in luv_stub_7_uv_loop_init x913)
| Function
    (CI.Void, Returns (CI.View {CI.ty = CI.Pointer x915; read = x916; _})),
  "luv_version_string" ->
  (fun x914 -> x916 (CI.make_ptr x915 (luv_stub_6_luv_version_string x914)))
| Function (CI.Void, Returns (CI.Primitive CI.Int)), "uv_version" ->
  luv_stub_5_uv_version
| Function
    (CI.Void, Returns (CI.View {CI.ty = CI.Pointer x919; read = x920; _})),
  "luv_version_suffix" ->
  (fun x918 -> x920 (CI.make_ptr x919 (luv_stub_4_luv_version_suffix x918)))
| Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int)),
  "uv_translate_sys_error" -> luv_stub_3_uv_translate_sys_error
| Function
    (CI.Primitive CI.Int,
     Function
       (CI.OCaml CI.Bytes, Function (CI.Primitive CI.Int, Returns CI.Void))),
  "uv_err_name_r" -> luv_stub_2_uv_err_name_r
| Function
    (CI.Primitive CI.Int,
     Function
       (CI.OCaml CI.Bytes, Function (CI.Primitive CI.Int, Returns CI.Void))),
  "uv_strerror_r" -> luv_stub_1_uv_strerror_r
| _, s ->  Printf.ksprintf failwith "No match for %s" s


let foreign_value : type a. string -> a Ctypes.typ -> a Ctypes.ptr =
  fun name t -> match t, name with
| _, s ->  Printf.ksprintf failwith "No match for %s" s
end

module Blocking =
struct

module CI = Cstubs_internals

external luv_stub_blocking_1_uv_run : _ CI.fatptr -> Unsigned.uint32 -> bool
  = "luv_stub_blocking_1_uv_run" 

external luv_stub_blocking_2_uv_pipe_bind : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_blocking_2_uv_pipe_bind" 

external luv_stub_blocking_3_uv_pipe_bind2
  : _ CI.fatptr -> _ CI.fatptr -> Unsigned.size_t -> int -> int
  = "luv_stub_blocking_3_uv_pipe_bind2" 

external luv_stub_blocking_4_luv_get_fs_trampoline : unit -> CI.voidp
  = "luv_stub_blocking_4_luv_get_fs_trampoline" 

external luv_stub_blocking_5_luv_null_fs_callback_pointer : unit -> CI.voidp
  = "luv_stub_blocking_5_luv_null_fs_callback_pointer" 

external luv_stub_blocking_6_uv_fs_req_cleanup : _ CI.fatptr -> unit
  = "luv_stub_blocking_6_uv_fs_req_cleanup" 

external luv_stub_blocking_7_uv_fs_close
  : _ CI.fatptr -> _ CI.fatptr -> int -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_7_uv_fs_close" 

external luv_stub_blocking_8_uv_fs_open
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int -> int ->
    _ CI.fatfunptr -> int
  = "luv_stub_blocking_8_uv_fs_open_byte6" "luv_stub_blocking_8_uv_fs_open" 

external luv_stub_blocking_9_uv_fs_read
  : _ CI.fatptr -> _ CI.fatptr -> int -> _ CI.fatptr -> Unsigned.uint ->
    int64 -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_9_uv_fs_read_byte7" "luv_stub_blocking_9_uv_fs_read" 

external luv_stub_blocking_10_uv_fs_write
  : _ CI.fatptr -> _ CI.fatptr -> int -> _ CI.fatptr -> Unsigned.uint ->
    int64 -> _ CI.fatfunptr -> int
  =
  "luv_stub_blocking_10_uv_fs_write_byte7" "luv_stub_blocking_10_uv_fs_write" 

external luv_stub_blocking_11_uv_fs_unlink
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_11_uv_fs_unlink" 

external luv_stub_blocking_12_uv_fs_mkdir
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_12_uv_fs_mkdir" 

external luv_stub_blocking_13_uv_fs_mkdtemp
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_13_uv_fs_mkdtemp" 

external luv_stub_blocking_14_uv_fs_mkstemp
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_14_uv_fs_mkstemp" 

external luv_stub_blocking_15_uv_fs_rmdir
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_15_uv_fs_rmdir" 

external luv_stub_blocking_16_uv_fs_opendir
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_16_uv_fs_opendir" 

external luv_stub_blocking_17_uv_fs_closedir
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_17_uv_fs_closedir" 

external luv_stub_blocking_18_uv_fs_readdir
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_18_uv_fs_readdir" 

external luv_stub_blocking_19_uv_fs_scandir
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_19_uv_fs_scandir" 

external luv_stub_blocking_20_uv_fs_scandir_next
  : _ CI.fatptr -> _ CI.fatptr -> int
  = "luv_stub_blocking_20_uv_fs_scandir_next" 

external luv_stub_blocking_21_uv_fs_stat
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_21_uv_fs_stat" 

external luv_stub_blocking_22_uv_fs_lstat
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_22_uv_fs_lstat" 

external luv_stub_blocking_23_uv_fs_fstat
  : _ CI.fatptr -> _ CI.fatptr -> int -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_23_uv_fs_fstat" 

external luv_stub_blocking_24_uv_fs_statfs
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_24_uv_fs_statfs" 

external luv_stub_blocking_25_uv_fs_rename
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr ->
    _ CI.fatfunptr -> int = "luv_stub_blocking_25_uv_fs_rename" 

external luv_stub_blocking_26_uv_fs_fsync
  : _ CI.fatptr -> _ CI.fatptr -> int -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_26_uv_fs_fsync" 

external luv_stub_blocking_27_uv_fs_fdatasync
  : _ CI.fatptr -> _ CI.fatptr -> int -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_27_uv_fs_fdatasync" 

external luv_stub_blocking_28_uv_fs_ftruncate
  : _ CI.fatptr -> _ CI.fatptr -> int -> int64 -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_28_uv_fs_ftruncate" 

external luv_stub_blocking_29_uv_fs_copyfile
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int ->
    _ CI.fatfunptr -> int
  =
  "luv_stub_blocking_29_uv_fs_copyfile_byte6" "luv_stub_blocking_29_uv_fs_copyfile"
  

external luv_stub_blocking_30_uv_fs_sendfile
  : _ CI.fatptr -> _ CI.fatptr -> int -> int -> int64 -> Unsigned.size_t ->
    _ CI.fatfunptr -> int
  =
  "luv_stub_blocking_30_uv_fs_sendfile_byte7" "luv_stub_blocking_30_uv_fs_sendfile"
  

external luv_stub_blocking_31_uv_fs_access
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_31_uv_fs_access" 

external luv_stub_blocking_32_uv_fs_chmod
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_32_uv_fs_chmod" 

external luv_stub_blocking_33_uv_fs_fchmod
  : _ CI.fatptr -> _ CI.fatptr -> int -> int -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_33_uv_fs_fchmod" 

external luv_stub_blocking_34_uv_fs_utime
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> float -> float ->
    _ CI.fatfunptr -> int
  =
  "luv_stub_blocking_34_uv_fs_utime_byte6" "luv_stub_blocking_34_uv_fs_utime" 

external luv_stub_blocking_35_uv_fs_futime
  : _ CI.fatptr -> _ CI.fatptr -> int -> float -> float -> _ CI.fatfunptr ->
    int
  =
  "luv_stub_blocking_35_uv_fs_futime_byte6" "luv_stub_blocking_35_uv_fs_futime"
  

external luv_stub_blocking_36_uv_fs_lutime
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> float -> float ->
    _ CI.fatfunptr -> int
  =
  "luv_stub_blocking_36_uv_fs_lutime_byte6" "luv_stub_blocking_36_uv_fs_lutime"
  

external luv_stub_blocking_37_uv_fs_link
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr ->
    _ CI.fatfunptr -> int = "luv_stub_blocking_37_uv_fs_link" 

external luv_stub_blocking_38_uv_fs_symlink
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int ->
    _ CI.fatfunptr -> int
  =
  "luv_stub_blocking_38_uv_fs_symlink_byte6" "luv_stub_blocking_38_uv_fs_symlink"
  

external luv_stub_blocking_39_uv_fs_readlink
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_39_uv_fs_readlink" 

external luv_stub_blocking_40_uv_fs_realpath
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_40_uv_fs_realpath" 

external luv_stub_blocking_41_uv_fs_chown
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int -> int ->
    _ CI.fatfunptr -> int
  =
  "luv_stub_blocking_41_uv_fs_chown_byte6" "luv_stub_blocking_41_uv_fs_chown" 

external luv_stub_blocking_42_uv_fs_fchown
  : _ CI.fatptr -> _ CI.fatptr -> int -> int -> int -> _ CI.fatfunptr -> int
  =
  "luv_stub_blocking_42_uv_fs_fchown_byte6" "luv_stub_blocking_42_uv_fs_fchown"
  

external luv_stub_blocking_43_uv_fs_lchown
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> int -> int ->
    _ CI.fatfunptr -> int
  =
  "luv_stub_blocking_43_uv_fs_lchown_byte6" "luv_stub_blocking_43_uv_fs_lchown"
  

external luv_stub_blocking_44_uv_fs_get_result : _ CI.fatptr -> int64
  = "luv_stub_blocking_44_uv_fs_get_result" 

external luv_stub_blocking_45_uv_fs_get_ptr : _ CI.fatptr -> CI.voidp
  = "luv_stub_blocking_45_uv_fs_get_ptr" 

external luv_stub_blocking_46_uv_fs_get_ptr : _ CI.fatptr -> CI.voidp
  = "luv_stub_blocking_46_uv_fs_get_ptr" 

external luv_stub_blocking_47_luv_fs_get_path : _ CI.fatptr -> CI.voidp
  = "luv_stub_blocking_47_luv_fs_get_path" 

external luv_stub_blocking_48_uv_fs_get_statbuf : _ CI.fatptr -> CI.voidp
  = "luv_stub_blocking_48_uv_fs_get_statbuf" 

external luv_stub_blocking_49_uv_thread_join : _ CI.fatptr -> int
  = "luv_stub_blocking_49_uv_thread_join" 

external luv_stub_blocking_50_uv_mutex_lock : _ CI.fatptr -> unit
  = "luv_stub_blocking_50_uv_mutex_lock" 

external luv_stub_blocking_51_uv_rwlock_rdlock : _ CI.fatptr -> unit
  = "luv_stub_blocking_51_uv_rwlock_rdlock" 

external luv_stub_blocking_52_uv_rwlock_wrlock : _ CI.fatptr -> unit
  = "luv_stub_blocking_52_uv_rwlock_wrlock" 

external luv_stub_blocking_53_uv_sem_wait : _ CI.fatptr -> unit
  = "luv_stub_blocking_53_uv_sem_wait" 

external luv_stub_blocking_54_uv_cond_wait
  : _ CI.fatptr -> _ CI.fatptr -> unit = "luv_stub_blocking_54_uv_cond_wait" 

external luv_stub_blocking_55_uv_cond_timedwait
  : _ CI.fatptr -> _ CI.fatptr -> Unsigned.uint64 -> int
  = "luv_stub_blocking_55_uv_cond_timedwait" 

external luv_stub_blocking_56_uv_barrier_wait : _ CI.fatptr -> bool
  = "luv_stub_blocking_56_uv_barrier_wait" 

external luv_stub_blocking_57_uv_sleep : int -> unit
  = "luv_stub_blocking_57_uv_sleep" 

external luv_stub_blocking_58_uv_random
  : _ CI.fatptr -> _ CI.fatptr -> _ CI.fatptr -> Unsigned.size_t ->
    Unsigned.uint -> _ CI.fatfunptr -> int
  = "luv_stub_blocking_58_uv_random_byte6" "luv_stub_blocking_58_uv_random" 

type 'a result = 'a
type 'a return = 'a
type 'a fn =
 | Returns  : 'a CI.typ   -> 'a return fn
 | Function : 'a CI.typ * 'b fn  -> ('a -> 'b) fn
let map_result f x = f x
let returning t = Returns t
let (@->) f p = Function (f, p)
let foreign : type a b. string -> (a -> b) fn -> (a -> b) =
  fun name t -> match t, name with
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Pointer _,
           Function
             (CI.Primitive CI.Size_t,
              Function
                (CI.Primitive CI.Uint,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_random" ->
  (fun x928 x930 x932 x934 x935 x936 ->
    let CI.Static_funptr x937 = x936 in
    let CI.CPointer x933 = x932 in
    let CI.CPointer x931 = x930 in
    let CI.CPointer x929 = x928 in
    luv_stub_blocking_58_uv_random x929 x931 x933 x934 x935 x937)
| Function (CI.Primitive CI.Int, Returns CI.Void), "uv_sleep" ->
  luv_stub_blocking_57_uv_sleep
| Function (CI.Pointer _, Returns (CI.Primitive CI.Bool)), "uv_barrier_wait" ->
  (fun x939 ->
    let CI.CPointer x940 = x939 in luv_stub_blocking_56_uv_barrier_wait x940)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function (CI.Primitive CI.Uint64_t, Returns (CI.Primitive CI.Int)))),
  "uv_cond_timedwait" ->
  (fun x941 x943 x945 ->
    let CI.CPointer x944 = x943 in
    let CI.CPointer x942 = x941 in
    luv_stub_blocking_55_uv_cond_timedwait x942 x944 x945)
| Function (CI.Pointer _, Function (CI.Pointer _, Returns CI.Void)),
  "uv_cond_wait" ->
  (fun x946 x948 ->
    let CI.CPointer x949 = x948 in
    let CI.CPointer x947 = x946 in
    luv_stub_blocking_54_uv_cond_wait x947 x949)
| Function (CI.Pointer _, Returns CI.Void), "uv_sem_wait" ->
  (fun x950 ->
    let CI.CPointer x951 = x950 in luv_stub_blocking_53_uv_sem_wait x951)
| Function (CI.Pointer _, Returns CI.Void), "uv_rwlock_wrlock" ->
  (fun x952 ->
    let CI.CPointer x953 = x952 in luv_stub_blocking_52_uv_rwlock_wrlock x953)
| Function (CI.Pointer _, Returns CI.Void), "uv_rwlock_rdlock" ->
  (fun x954 ->
    let CI.CPointer x955 = x954 in luv_stub_blocking_51_uv_rwlock_rdlock x955)
| Function (CI.Pointer _, Returns CI.Void), "uv_mutex_lock" ->
  (fun x956 ->
    let CI.CPointer x957 = x956 in luv_stub_blocking_50_uv_mutex_lock x957)
| Function (CI.Pointer _, Returns (CI.Primitive CI.Int)), "uv_thread_join" ->
  (fun x958 ->
    let CI.CPointer x959 = x958 in luv_stub_blocking_49_uv_thread_join x959)
| Function (CI.Pointer _, Returns (CI.Pointer x962)), "uv_fs_get_statbuf" ->
  (fun x960 ->
    let CI.CPointer x961 = x960 in
    CI.make_ptr x962 (luv_stub_blocking_48_uv_fs_get_statbuf x961))
| Function
    (CI.Pointer _,
     Returns (CI.View {CI.ty = CI.Pointer x965; read = x966; _})),
  "luv_fs_get_path" ->
  (fun x963 ->
    let CI.CPointer x964 = x963 in
    x966 (CI.make_ptr x965 (luv_stub_blocking_47_luv_fs_get_path x964)))
| Function
    (CI.Pointer _,
     Returns (CI.View {CI.ty = CI.Pointer x969; read = x970; _})),
  "uv_fs_get_ptr" ->
  (fun x967 ->
    let CI.CPointer x968 = x967 in
    x970 (CI.make_ptr x969 (luv_stub_blocking_46_uv_fs_get_ptr x968)))
| Function (CI.Pointer _, Returns (CI.Pointer x973)), "uv_fs_get_ptr" ->
  (fun x971 ->
    let CI.CPointer x972 = x971 in
    CI.make_ptr x973 (luv_stub_blocking_45_uv_fs_get_ptr x972))
| Function
    (CI.Pointer _,
     Returns (CI.View {CI.ty = CI.Primitive CI.Int64_t; read = x976; _})),
  "uv_fs_get_result" ->
  (fun x974 ->
    let CI.CPointer x975 = x974 in
    x976 (luv_stub_blocking_44_uv_fs_get_result x975))
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x982; _},
           Function
             (CI.Primitive CI.Int,
              Function
                (CI.Primitive CI.Int,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_fs_lchown" ->
  (fun x977 x979 x981 x985 x986 x987 ->
    let CI.Static_funptr x988 = x987 in
    let CI.CPointer x984 = x982 x981 in
    let CI.CPointer x980 = x979 in
    let CI.CPointer x978 = x977 in
    let x983 = x984 in
    luv_stub_blocking_43_uv_fs_lchown x978 x980 x983 x985 x986 x988)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function
             (CI.Primitive CI.Int,
              Function
                (CI.Primitive CI.Int,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_fs_fchown" ->
  (fun x989 x991 x993 x994 x995 x996 ->
    let CI.Static_funptr x997 = x996 in
    let CI.CPointer x992 = x991 in
    let CI.CPointer x990 = x989 in
    luv_stub_blocking_42_uv_fs_fchown x990 x992 x993 x994 x995 x997)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1003; _},
           Function
             (CI.Primitive CI.Int,
              Function
                (CI.Primitive CI.Int,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_fs_chown" ->
  (fun x998 x1000 x1002 x1006 x1007 x1008 ->
    let CI.Static_funptr x1009 = x1008 in
    let CI.CPointer x1005 = x1003 x1002 in
    let CI.CPointer x1001 = x1000 in
    let CI.CPointer x999 = x998 in
    let x1004 = x1005 in
    luv_stub_blocking_41_uv_fs_chown x999 x1001 x1004 x1006 x1007 x1009)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1015; _},
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_realpath" ->
  (fun x1010 x1012 x1014 x1018 ->
    let CI.Static_funptr x1019 = x1018 in
    let CI.CPointer x1017 = x1015 x1014 in
    let CI.CPointer x1013 = x1012 in
    let CI.CPointer x1011 = x1010 in
    let x1016 = x1017 in
    luv_stub_blocking_40_uv_fs_realpath x1011 x1013 x1016 x1019)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1025; _},
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_readlink" ->
  (fun x1020 x1022 x1024 x1028 ->
    let CI.Static_funptr x1029 = x1028 in
    let CI.CPointer x1027 = x1025 x1024 in
    let CI.CPointer x1023 = x1022 in
    let CI.CPointer x1021 = x1020 in
    let x1026 = x1027 in
    luv_stub_blocking_39_uv_fs_readlink x1021 x1023 x1026 x1029)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1035; _},
           Function
             (CI.View {CI.ty = CI.Pointer _; write = x1039; _},
              Function
                (CI.Primitive CI.Int,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_fs_symlink" ->
  (fun x1030 x1032 x1034 x1038 x1042 x1043 ->
    let CI.Static_funptr x1044 = x1043 in
    let CI.CPointer x1041 = x1039 x1038 in
    let CI.CPointer x1037 = x1035 x1034 in
    let CI.CPointer x1033 = x1032 in
    let CI.CPointer x1031 = x1030 in
    let x1036 = x1037 in
    let x1040 = x1041 in
    luv_stub_blocking_38_uv_fs_symlink x1031 x1033 x1036 x1040 x1042 x1044)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1050; _},
           Function
             (CI.View {CI.ty = CI.Pointer _; write = x1054; _},
              Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))))),
  "uv_fs_link" ->
  (fun x1045 x1047 x1049 x1053 x1057 ->
    let CI.Static_funptr x1058 = x1057 in
    let CI.CPointer x1056 = x1054 x1053 in
    let CI.CPointer x1052 = x1050 x1049 in
    let CI.CPointer x1048 = x1047 in
    let CI.CPointer x1046 = x1045 in
    let x1051 = x1052 in
    let x1055 = x1056 in
    luv_stub_blocking_37_uv_fs_link x1046 x1048 x1051 x1055 x1058)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1064; _},
           Function
             (CI.Primitive CI.Float,
              Function
                (CI.Primitive CI.Float,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_fs_lutime" ->
  (fun x1059 x1061 x1063 x1067 x1068 x1069 ->
    let CI.Static_funptr x1070 = x1069 in
    let CI.CPointer x1066 = x1064 x1063 in
    let CI.CPointer x1062 = x1061 in
    let CI.CPointer x1060 = x1059 in
    let x1065 = x1066 in
    luv_stub_blocking_36_uv_fs_lutime x1060 x1062 x1065 x1067 x1068 x1070)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function
             (CI.Primitive CI.Float,
              Function
                (CI.Primitive CI.Float,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_fs_futime" ->
  (fun x1071 x1073 x1075 x1076 x1077 x1078 ->
    let CI.Static_funptr x1079 = x1078 in
    let CI.CPointer x1074 = x1073 in
    let CI.CPointer x1072 = x1071 in
    luv_stub_blocking_35_uv_fs_futime x1072 x1074 x1075 x1076 x1077 x1079)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1085; _},
           Function
             (CI.Primitive CI.Float,
              Function
                (CI.Primitive CI.Float,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_fs_utime" ->
  (fun x1080 x1082 x1084 x1088 x1089 x1090 ->
    let CI.Static_funptr x1091 = x1090 in
    let CI.CPointer x1087 = x1085 x1084 in
    let CI.CPointer x1083 = x1082 in
    let CI.CPointer x1081 = x1080 in
    let x1086 = x1087 in
    luv_stub_blocking_34_uv_fs_utime x1081 x1083 x1086 x1088 x1089 x1091)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function
             (CI.Primitive CI.Int,
              Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))))),
  "uv_fs_fchmod" ->
  (fun x1092 x1094 x1096 x1097 x1098 ->
    let CI.Static_funptr x1099 = x1098 in
    let CI.CPointer x1095 = x1094 in
    let CI.CPointer x1093 = x1092 in
    luv_stub_blocking_33_uv_fs_fchmod x1093 x1095 x1096 x1097 x1099)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1105; _},
           Function
             (CI.Primitive CI.Int,
              Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))))),
  "uv_fs_chmod" ->
  (fun x1100 x1102 x1104 x1108 x1109 ->
    let CI.Static_funptr x1110 = x1109 in
    let CI.CPointer x1107 = x1105 x1104 in
    let CI.CPointer x1103 = x1102 in
    let CI.CPointer x1101 = x1100 in
    let x1106 = x1107 in
    luv_stub_blocking_32_uv_fs_chmod x1101 x1103 x1106 x1108 x1110)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1116; _},
           Function
             (CI.Primitive CI.Int,
              Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))))),
  "uv_fs_access" ->
  (fun x1111 x1113 x1115 x1119 x1120 ->
    let CI.Static_funptr x1121 = x1120 in
    let CI.CPointer x1118 = x1116 x1115 in
    let CI.CPointer x1114 = x1113 in
    let CI.CPointer x1112 = x1111 in
    let x1117 = x1118 in
    luv_stub_blocking_31_uv_fs_access x1112 x1114 x1117 x1119 x1121)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function
             (CI.Primitive CI.Int,
              Function
                (CI.Primitive CI.Int64_t,
                 Function
                   (CI.Primitive CI.Size_t,
                    Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))))))),
  "uv_fs_sendfile" ->
  (fun x1122 x1124 x1126 x1127 x1128 x1129 x1130 ->
    let CI.Static_funptr x1131 = x1130 in
    let CI.CPointer x1125 = x1124 in
    let CI.CPointer x1123 = x1122 in
    luv_stub_blocking_30_uv_fs_sendfile x1123 x1125 x1126 x1127 x1128 x1129
    x1131)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1137; _},
           Function
             (CI.View {CI.ty = CI.Pointer _; write = x1141; _},
              Function
                (CI.Primitive CI.Int,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_fs_copyfile" ->
  (fun x1132 x1134 x1136 x1140 x1144 x1145 ->
    let CI.Static_funptr x1146 = x1145 in
    let CI.CPointer x1143 = x1141 x1140 in
    let CI.CPointer x1139 = x1137 x1136 in
    let CI.CPointer x1135 = x1134 in
    let CI.CPointer x1133 = x1132 in
    let x1138 = x1139 in
    let x1142 = x1143 in
    luv_stub_blocking_29_uv_fs_copyfile x1133 x1135 x1138 x1142 x1144 x1146)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function
             (CI.Primitive CI.Int64_t,
              Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))))),
  "uv_fs_ftruncate" ->
  (fun x1147 x1149 x1151 x1152 x1153 ->
    let CI.Static_funptr x1154 = x1153 in
    let CI.CPointer x1150 = x1149 in
    let CI.CPointer x1148 = x1147 in
    luv_stub_blocking_28_uv_fs_ftruncate x1148 x1150 x1151 x1152 x1154)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_fdatasync" ->
  (fun x1155 x1157 x1159 x1160 ->
    let CI.Static_funptr x1161 = x1160 in
    let CI.CPointer x1158 = x1157 in
    let CI.CPointer x1156 = x1155 in
    luv_stub_blocking_27_uv_fs_fdatasync x1156 x1158 x1159 x1161)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_fsync" ->
  (fun x1162 x1164 x1166 x1167 ->
    let CI.Static_funptr x1168 = x1167 in
    let CI.CPointer x1165 = x1164 in
    let CI.CPointer x1163 = x1162 in
    luv_stub_blocking_26_uv_fs_fsync x1163 x1165 x1166 x1168)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1174; _},
           Function
             (CI.View {CI.ty = CI.Pointer _; write = x1178; _},
              Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))))),
  "uv_fs_rename" ->
  (fun x1169 x1171 x1173 x1177 x1181 ->
    let CI.Static_funptr x1182 = x1181 in
    let CI.CPointer x1180 = x1178 x1177 in
    let CI.CPointer x1176 = x1174 x1173 in
    let CI.CPointer x1172 = x1171 in
    let CI.CPointer x1170 = x1169 in
    let x1175 = x1176 in
    let x1179 = x1180 in
    luv_stub_blocking_25_uv_fs_rename x1170 x1172 x1175 x1179 x1182)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1188; _},
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_statfs" ->
  (fun x1183 x1185 x1187 x1191 ->
    let CI.Static_funptr x1192 = x1191 in
    let CI.CPointer x1190 = x1188 x1187 in
    let CI.CPointer x1186 = x1185 in
    let CI.CPointer x1184 = x1183 in
    let x1189 = x1190 in
    luv_stub_blocking_24_uv_fs_statfs x1184 x1186 x1189 x1192)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_fstat" ->
  (fun x1193 x1195 x1197 x1198 ->
    let CI.Static_funptr x1199 = x1198 in
    let CI.CPointer x1196 = x1195 in
    let CI.CPointer x1194 = x1193 in
    luv_stub_blocking_23_uv_fs_fstat x1194 x1196 x1197 x1199)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1205; _},
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_lstat" ->
  (fun x1200 x1202 x1204 x1208 ->
    let CI.Static_funptr x1209 = x1208 in
    let CI.CPointer x1207 = x1205 x1204 in
    let CI.CPointer x1203 = x1202 in
    let CI.CPointer x1201 = x1200 in
    let x1206 = x1207 in
    luv_stub_blocking_22_uv_fs_lstat x1201 x1203 x1206 x1209)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1215; _},
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_stat" ->
  (fun x1210 x1212 x1214 x1218 ->
    let CI.Static_funptr x1219 = x1218 in
    let CI.CPointer x1217 = x1215 x1214 in
    let CI.CPointer x1213 = x1212 in
    let CI.CPointer x1211 = x1210 in
    let x1216 = x1217 in
    luv_stub_blocking_21_uv_fs_stat x1211 x1213 x1216 x1219)
| Function
    (CI.Pointer _, Function (CI.Pointer _, Returns (CI.Primitive CI.Int))),
  "uv_fs_scandir_next" ->
  (fun x1220 x1222 ->
    let CI.CPointer x1223 = x1222 in
    let CI.CPointer x1221 = x1220 in
    luv_stub_blocking_20_uv_fs_scandir_next x1221 x1223)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1229; _},
           Function
             (CI.Primitive CI.Int,
              Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))))),
  "uv_fs_scandir" ->
  (fun x1224 x1226 x1228 x1232 x1233 ->
    let CI.Static_funptr x1234 = x1233 in
    let CI.CPointer x1231 = x1229 x1228 in
    let CI.CPointer x1227 = x1226 in
    let CI.CPointer x1225 = x1224 in
    let x1230 = x1231 in
    luv_stub_blocking_19_uv_fs_scandir x1225 x1227 x1230 x1232 x1234)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Pointer _,
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_readdir" ->
  (fun x1235 x1237 x1239 x1241 ->
    let CI.Static_funptr x1242 = x1241 in
    let CI.CPointer x1240 = x1239 in
    let CI.CPointer x1238 = x1237 in
    let CI.CPointer x1236 = x1235 in
    luv_stub_blocking_18_uv_fs_readdir x1236 x1238 x1240 x1242)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Pointer _,
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_closedir" ->
  (fun x1243 x1245 x1247 x1249 ->
    let CI.Static_funptr x1250 = x1249 in
    let CI.CPointer x1248 = x1247 in
    let CI.CPointer x1246 = x1245 in
    let CI.CPointer x1244 = x1243 in
    luv_stub_blocking_17_uv_fs_closedir x1244 x1246 x1248 x1250)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1256; _},
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_opendir" ->
  (fun x1251 x1253 x1255 x1259 ->
    let CI.Static_funptr x1260 = x1259 in
    let CI.CPointer x1258 = x1256 x1255 in
    let CI.CPointer x1254 = x1253 in
    let CI.CPointer x1252 = x1251 in
    let x1257 = x1258 in
    luv_stub_blocking_16_uv_fs_opendir x1252 x1254 x1257 x1260)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1266; _},
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_rmdir" ->
  (fun x1261 x1263 x1265 x1269 ->
    let CI.Static_funptr x1270 = x1269 in
    let CI.CPointer x1268 = x1266 x1265 in
    let CI.CPointer x1264 = x1263 in
    let CI.CPointer x1262 = x1261 in
    let x1267 = x1268 in
    luv_stub_blocking_15_uv_fs_rmdir x1262 x1264 x1267 x1270)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1276; _},
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_mkstemp" ->
  (fun x1271 x1273 x1275 x1279 ->
    let CI.Static_funptr x1280 = x1279 in
    let CI.CPointer x1278 = x1276 x1275 in
    let CI.CPointer x1274 = x1273 in
    let CI.CPointer x1272 = x1271 in
    let x1277 = x1278 in
    luv_stub_blocking_14_uv_fs_mkstemp x1272 x1274 x1277 x1280)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1286; _},
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_mkdtemp" ->
  (fun x1281 x1283 x1285 x1289 ->
    let CI.Static_funptr x1290 = x1289 in
    let CI.CPointer x1288 = x1286 x1285 in
    let CI.CPointer x1284 = x1283 in
    let CI.CPointer x1282 = x1281 in
    let x1287 = x1288 in
    luv_stub_blocking_13_uv_fs_mkdtemp x1282 x1284 x1287 x1290)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1296; _},
           Function
             (CI.Primitive CI.Int,
              Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))))),
  "uv_fs_mkdir" ->
  (fun x1291 x1293 x1295 x1299 x1300 ->
    let CI.Static_funptr x1301 = x1300 in
    let CI.CPointer x1298 = x1296 x1295 in
    let CI.CPointer x1294 = x1293 in
    let CI.CPointer x1292 = x1291 in
    let x1297 = x1298 in
    luv_stub_blocking_12_uv_fs_mkdir x1292 x1294 x1297 x1299 x1301)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1307; _},
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_unlink" ->
  (fun x1302 x1304 x1306 x1310 ->
    let CI.Static_funptr x1311 = x1310 in
    let CI.CPointer x1309 = x1307 x1306 in
    let CI.CPointer x1305 = x1304 in
    let CI.CPointer x1303 = x1302 in
    let x1308 = x1309 in
    luv_stub_blocking_11_uv_fs_unlink x1303 x1305 x1308 x1311)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function
             (CI.Pointer _,
              Function
                (CI.Primitive CI.Uint,
                 Function
                   (CI.Primitive CI.Int64_t,
                    Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))))))),
  "uv_fs_write" ->
  (fun x1312 x1314 x1316 x1317 x1319 x1320 x1321 ->
    let CI.Static_funptr x1322 = x1321 in
    let CI.CPointer x1318 = x1317 in
    let CI.CPointer x1315 = x1314 in
    let CI.CPointer x1313 = x1312 in
    luv_stub_blocking_10_uv_fs_write x1313 x1315 x1316 x1318 x1319 x1320
    x1322)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function
             (CI.Pointer _,
              Function
                (CI.Primitive CI.Uint,
                 Function
                   (CI.Primitive CI.Int64_t,
                    Function (CI.Funptr _, Returns (CI.Primitive CI.Int)))))))),
  "uv_fs_read" ->
  (fun x1323 x1325 x1327 x1328 x1330 x1331 x1332 ->
    let CI.Static_funptr x1333 = x1332 in
    let CI.CPointer x1329 = x1328 in
    let CI.CPointer x1326 = x1325 in
    let CI.CPointer x1324 = x1323 in
    luv_stub_blocking_9_uv_fs_read x1324 x1326 x1327 x1329 x1330 x1331 x1333)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.View {CI.ty = CI.Pointer _; write = x1339; _},
           Function
             (CI.Primitive CI.Int,
              Function
                (CI.Primitive CI.Int,
                 Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))))),
  "uv_fs_open" ->
  (fun x1334 x1336 x1338 x1342 x1343 x1344 ->
    let CI.Static_funptr x1345 = x1344 in
    let CI.CPointer x1341 = x1339 x1338 in
    let CI.CPointer x1337 = x1336 in
    let CI.CPointer x1335 = x1334 in
    let x1340 = x1341 in
    luv_stub_blocking_8_uv_fs_open x1335 x1337 x1340 x1342 x1343 x1345)
| Function
    (CI.Pointer _,
     Function
       (CI.Pointer _,
        Function
          (CI.Primitive CI.Int,
           Function (CI.Funptr _, Returns (CI.Primitive CI.Int))))),
  "uv_fs_close" ->
  (fun x1346 x1348 x1350 x1351 ->
    let CI.Static_funptr x1352 = x1351 in
    let CI.CPointer x1349 = x1348 in
    let CI.CPointer x1347 = x1346 in
    luv_stub_blocking_7_uv_fs_close x1347 x1349 x1350 x1352)
| Function (CI.Pointer _, Returns CI.Void), "uv_fs_req_cleanup" ->
  (fun x1353 ->
    let CI.CPointer x1354 = x1353 in
    luv_stub_blocking_6_uv_fs_req_cleanup x1354)
| Function (CI.Void, Returns (CI.Funptr x1356)),
  "luv_null_fs_callback_pointer" ->
  (fun x1355 ->
    CI.make_fun_ptr x1356
      (luv_stub_blocking_5_luv_null_fs_callback_pointer x1355))
| Function (CI.Void, Returns (CI.Funptr x1358)), "luv_get_fs_trampoline" ->
  (fun x1357 ->
    CI.make_fun_ptr x1358 (luv_stub_blocking_4_luv_get_fs_trampoline x1357))
| Function
    (CI.Pointer _,
     Function
       (CI.View {CI.ty = CI.Pointer _; write = x1362; _},
        Function
          (CI.Primitive CI.Size_t,
           Function (CI.Primitive CI.Int, Returns (CI.Primitive CI.Int))))),
  "uv_pipe_bind2" ->
  (fun x1359 x1361 x1365 x1366 ->
    let CI.CPointer x1364 = x1362 x1361 in
    let CI.CPointer x1360 = x1359 in
    let x1363 = x1364 in
    luv_stub_blocking_3_uv_pipe_bind2 x1360 x1363 x1365 x1366)
| Function
    (CI.Pointer _,
     Function
       (CI.View {CI.ty = CI.Pointer _; write = x1370; _},
        Returns (CI.Primitive CI.Int))),
  "uv_pipe_bind" ->
  (fun x1367 x1369 ->
    let CI.CPointer x1372 = x1370 x1369 in
    let CI.CPointer x1368 = x1367 in
    let x1371 = x1372 in luv_stub_blocking_2_uv_pipe_bind x1368 x1371)
| Function
    (CI.Pointer _,
     Function
       (CI.View {CI.ty = CI.Primitive CI.Uint32_t; write = x1376; _},
        Returns (CI.Primitive CI.Bool))),
  "uv_run" ->
  (fun x1373 x1375 ->
    let CI.CPointer x1374 = x1373 in
    let x1377 = x1376 x1375 in luv_stub_blocking_1_uv_run x1374 x1377)
| _, s ->  Printf.ksprintf failwith "No match for %s" s


let foreign_value : type a. string -> a Ctypes.typ -> a Ctypes.ptr =
  fun name t -> match t, name with
| _, s ->  Printf.ksprintf failwith "No match for %s" s
end

