/*
 * Copyright (C) 2014 Jared Boone, ShareBrained Technology, Inc.
 *
 * This file is part of PortaPack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

#include "spectrum_color_lut.hpp"

const std::array<ui::Color, 256> spectrum_rgb2_lut { {
	{   0,   0, 128 },
	{   0,   0, 132 },
	{   0,   0, 136 },
	{   0,   0, 140 },
	{   0,   0, 144 },
	{   0,   0, 148 },
	{   0,   0, 152 },
	{   0,   0, 156 },
	{   0,   0, 160 },
	{   0,   0, 164 },
	{   0,   0, 168 },
	{   0,   0, 172 },
	{   0,   0, 176 },
	{   0,   0, 180 },
	{   0,   0, 184 },
	{   0,   0, 188 },
	{   0,   0, 192 },
	{   0,   0, 195 },
	{   0,   0, 199 },
	{   0,   0, 203 },
	{   0,   0, 207 },
	{   0,   0, 211 },
	{   0,   0, 215 },
	{   0,   0, 219 },
	{   0,   0, 223 },
	{   0,   0, 227 },
	{   0,   0, 231 },
	{   0,   0, 235 },
	{   0,   0, 239 },
	{   0,   0, 243 },
	{   0,   0, 247 },
	{   0,   0, 251 },
	{   0,   0, 255 },
	{   0,   4, 255 },
	{   0,   8, 255 },
	{   0,  12, 255 },
	{   0,  16, 255 },
	{   0,  20, 255 },
	{   0,  24, 255 },
	{   0,  28, 255 },
	{   0,  32, 255 },
	{   0,  36, 255 },
	{   0,  40, 255 },
	{   0,  44, 255 },
	{   0,  48, 255 },
	{   0,  52, 255 },
	{   0,  56, 255 },
	{   0,  60, 255 },
	{   0,  64, 255 },
	{   0,  68, 255 },
	{   0,  72, 255 },
	{   0,  76, 255 },
	{   0,  80, 255 },
	{   0,  84, 255 },
	{   0,  88, 255 },
	{   0,  92, 255 },
	{   0,  96, 255 },
	{   0, 100, 255 },
	{   0, 104, 255 },
	{   0, 108, 255 },
	{   0, 112, 255 },
	{   0, 116, 255 },
	{   0, 120, 255 },
	{   0, 124, 255 },
	{   0, 128, 255 },
	{   0, 131, 255 },
	{   0, 135, 255 },
	{   0, 139, 255 },
	{   0, 143, 255 },
	{   0, 147, 255 },
	{   0, 151, 255 },
	{   0, 155, 255 },
	{   0, 159, 255 },
	{   0, 163, 255 },
	{   0, 167, 255 },
	{   0, 171, 255 },
	{   0, 175, 255 },
	{   0, 179, 255 },
	{   0, 183, 255 },
	{   0, 187, 255 },
	{   0, 191, 255 },
	{   0, 195, 255 },
	{   0, 199, 255 },
	{   0, 203, 255 },
	{   0, 207, 255 },
	{   0, 211, 255 },
	{   0, 215, 255 },
	{   0, 219, 255 },
	{   0, 223, 255 },
	{   0, 227, 255 },
	{   0, 231, 255 },
	{   0, 235, 255 },
	{   0, 239, 255 },
	{   0, 243, 255 },
	{   0, 247, 255 },
	{   0, 251, 255 },
	{   0, 255, 255 },
	{   4, 255, 251 },
	{   8, 255, 247 },
	{  12, 255, 243 },
	{  16, 255, 239 },
	{  20, 255, 235 },
	{  24, 255, 231 },
	{  28, 255, 227 },
	{  32, 255, 223 },
	{  36, 255, 219 },
	{  40, 255, 215 },
	{  44, 255, 211 },
	{  48, 255, 207 },
	{  52, 255, 203 },
	{  56, 255, 199 },
	{  60, 255, 195 },
	{  64, 255, 191 },
	{  68, 255, 187 },
	{  72, 255, 183 },
	{  76, 255, 179 },
	{  80, 255, 175 },
	{  84, 255, 171 },
	{  88, 255, 167 },
	{  92, 255, 163 },
	{  96, 255, 159 },
	{ 100, 255, 155 },
	{ 104, 255, 151 },
	{ 108, 255, 147 },
	{ 112, 255, 143 },
	{ 116, 255, 139 },
	{ 120, 255, 135 },
	{ 124, 255, 131 },
	{ 128, 255, 128 },
	{ 131, 255, 124 },
	{ 135, 255, 120 },
	{ 139, 255, 116 },
	{ 143, 255, 112 },
	{ 147, 255, 108 },
	{ 151, 255, 104 },
	{ 155, 255, 100 },
	{ 159, 255,  96 },
	{ 163, 255,  92 },
	{ 167, 255,  88 },
	{ 171, 255,  84 },
	{ 175, 255,  80 },
	{ 179, 255,  76 },
	{ 183, 255,  72 },
	{ 187, 255,  68 },
	{ 191, 255,  64 },
	{ 195, 255,  60 },
	{ 199, 255,  56 },
	{ 203, 255,  52 },
	{ 207, 255,  48 },
	{ 211, 255,  44 },
	{ 215, 255,  40 },
	{ 219, 255,  36 },
	{ 223, 255,  32 },
	{ 227, 255,  28 },
	{ 231, 255,  24 },
	{ 235, 255,  20 },
	{ 239, 255,  16 },
	{ 243, 255,  12 },
	{ 247, 255,   8 },
	{ 251, 255,   4 },
	{ 255, 255,   0 },
	{ 255, 251,   0 },
	{ 255, 247,   0 },
	{ 255, 243,   0 },
	{ 255, 239,   0 },
	{ 255, 235,   0 },
	{ 255, 231,   0 },
	{ 255, 227,   0 },
	{ 255, 223,   0 },
	{ 255, 219,   0 },
	{ 255, 215,   0 },
	{ 255, 211,   0 },
	{ 255, 207,   0 },
	{ 255, 203,   0 },
	{ 255, 199,   0 },
	{ 255, 195,   0 },
	{ 255, 191,   0 },
	{ 255, 187,   0 },
	{ 255, 183,   0 },
	{ 255, 179,   0 },
	{ 255, 175,   0 },
	{ 255, 171,   0 },
	{ 255, 167,   0 },
	{ 255, 163,   0 },
	{ 255, 159,   0 },
	{ 255, 155,   0 },
	{ 255, 151,   0 },
	{ 255, 147,   0 },
	{ 255, 143,   0 },
	{ 255, 139,   0 },
	{ 255, 135,   0 },
	{ 255, 131,   0 },
	{ 255, 128,   0 },
	{ 255, 124,   0 },
	{ 255, 120,   0 },
	{ 255, 116,   0 },
	{ 255, 112,   0 },
	{ 255, 108,   0 },
	{ 255, 104,   0 },
	{ 255, 100,   0 },
	{ 255,  96,   0 },
	{ 255,  92,   0 },
	{ 255,  88,   0 },
	{ 255,  84,   0 },
	{ 255,  80,   0 },
	{ 255,  76,   0 },
	{ 255,  72,   0 },
	{ 255,  68,   0 },
	{ 255,  64,   0 },
	{ 255,  60,   0 },
	{ 255,  56,   0 },
	{ 255,  52,   0 },
	{ 255,  48,   0 },
	{ 255,  44,   0 },
	{ 255,  40,   0 },
	{ 255,  36,   0 },
	{ 255,  32,   0 },
	{ 255,  28,   0 },
	{ 255,  24,   0 },
	{ 255,  20,   0 },
	{ 255,  16,   0 },
	{ 255,  12,   0 },
	{ 255,   8,   0 },
	{ 255,   4,   0 },
	{ 255,   0,   0 },
	{ 251,   0,   0 },
	{ 247,   0,   0 },
	{ 243,   0,   0 },
	{ 239,   0,   0 },
	{ 235,   0,   0 },
	{ 231,   0,   0 },
	{ 227,   0,   0 },
	{ 223,   0,   0 },
	{ 219,   0,   0 },
	{ 215,   0,   0 },
	{ 211,   0,   0 },
	{ 207,   0,   0 },
	{ 203,   0,   0 },
	{ 199,   0,   0 },
	{ 195,   0,   0 },
	{ 192,   0,   0 },
	{ 188,   0,   0 },
	{ 184,   0,   0 },
	{ 180,   0,   0 },
	{ 176,   0,   0 },
	{ 172,   0,   0 },
	{ 168,   0,   0 },
	{ 164,   0,   0 },
	{ 160,   0,   0 },
	{ 156,   0,   0 },
	{ 152,   0,   0 },
	{ 148,   0,   0 },
	{ 144,   0,   0 },
	{ 140,   0,   0 },
	{ 136,   0,   0 },
	{ 132,   0,   0 },
} };

const std::array<ui::Color, 256> spectrum_rgb3_lut { {
	{   0,   0,   0 },
	{   0,   0,   3 },
	{   0,   0,   6 },
	{   0,   0,   9 },
	{   0,   0,  12 },
	{   0,   0,  15 },
	{   0,   0,  18 },
	{   0,   0,  21 },
	{   0,   0,  24 },
	{   0,   0,  27 },
	{   0,   0,  30 },
	{   0,   0,  33 },
	{   0,   0,  36 },
	{   0,   0,  39 },
	{   0,   0,  42 },
	{   0,   0,  45 },
	{   0,   0,  48 },
	{   0,   0,  51 },
	{   0,   0,  54 },
	{   0,   0,  57 },
	{   0,   0,  60 },
	{   0,   0,  63 },
	{   0,   0,  66 },
	{   0,   0,  69 },
	{   0,   0,  72 },
	{   0,   0,  75 },
	{   0,   0,  78 },
	{   0,   0,  81 },
	{   0,   0,  84 },
	{   0,   0,  87 },
	{   0,   0,  90 },
	{   0,   0,  93 },
	{   0,   0,  96 },
	{   0,   0,  99 },
	{   0,   0, 102 },
	{   0,   0, 105 },
	{   0,   0, 108 },
	{   0,   0, 111 },
	{   0,   0, 114 },
	{   0,   0, 117 },
	{   0,   0, 120 },
	{   0,   0, 123 },
	{   0,   0, 126 },
	{   0,   0, 129 },
	{   0,   0, 132 },
	{   0,   0, 135 },
	{   0,   0, 138 },
	{   0,   0, 141 },
	{   0,   0, 144 },
	{   0,   0, 147 },
	{   0,   0, 150 },
	{   0,   0, 153 },
	{   0,   0, 156 },
	{   0,   0, 159 },
	{   0,   0, 162 },
	{   0,   0, 165 },
	{   0,   0, 168 },
	{   0,   0, 171 },
	{   0,   0, 174 },
	{   0,   0, 177 },
	{   0,   0, 180 },
	{   0,   0, 183 },
	{   0,   0, 186 },
	{   0,   0, 189 },
	{   0,   0, 192 },
	{   0,   0, 195 },
	{   0,   0, 198 },
	{   0,   0, 201 },
	{   0,   0, 204 },
	{   0,   0, 207 },
	{   0,   0, 210 },
	{   0,   0, 213 },
	{   0,   0, 216 },
	{   0,   0, 219 },
	{   0,   0, 222 },
	{   0,   0, 225 },
	{   0,   0, 228 },
	{   0,   0, 231 },
	{   0,   0, 234 },
	{   0,   0, 237 },
	{   0,   0, 240 },
	{   0,   0, 243 },
	{   0,   0, 246 },
	{   0,   0, 249 },
	{   0,   0, 252 },
	{   0,   0, 255 },
	{   0,   3, 252 },
	{   0,   6, 249 },
	{   0,   9, 246 },
	{   0,  12, 243 },
	{   0,  15, 240 },
	{   0,  18, 237 },
	{   0,  21, 234 },
	{   0,  24, 231 },
	{   0,  27, 228 },
	{   0,  30, 225 },
	{   0,  33, 222 },
	{   0,  36, 219 },
	{   0,  39, 216 },
	{   0,  42, 213 },
	{   0,  45, 210 },
	{   0,  48, 207 },
	{   0,  51, 204 },
	{   0,  54, 201 },
	{   0,  57, 198 },
	{   0,  60, 195 },
	{   0,  63, 192 },
	{   0,  66, 189 },
	{   0,  69, 186 },
	{   0,  72, 183 },
	{   0,  75, 180 },
	{   0,  78, 177 },
	{   0,  81, 174 },
	{   0,  84, 171 },
	{   0,  87, 168 },
	{   0,  90, 165 },
	{   0,  93, 162 },
	{   0,  96, 159 },
	{   0,  99, 156 },
	{   0, 102, 153 },
	{   0, 105, 150 },
	{   0, 108, 147 },
	{   0, 111, 144 },
	{   0, 114, 141 },
	{   0, 117, 138 },
	{   0, 120, 135 },
	{   0, 123, 132 },
	{   0, 126, 129 },
	{   0, 129, 126 },
	{   0, 132, 123 },
	{   0, 135, 120 },
	{   0, 138, 117 },
	{   0, 141, 114 },
	{   0, 144, 111 },
	{   0, 147, 108 },
	{   0, 150, 105 },
	{   0, 153, 102 },
	{   0, 156,  99 },
	{   0, 159,  96 },
	{   0, 162,  93 },
	{   0, 165,  90 },
	{   0, 168,  87 },
	{   0, 171,  84 },
	{   0, 174,  81 },
	{   0, 177,  78 },
	{   0, 180,  75 },
	{   0, 183,  72 },
	{   0, 186,  69 },
	{   0, 189,  66 },
	{   0, 192,  63 },
	{   0, 195,  60 },
	{   0, 198,  57 },
	{   0, 201,  54 },
	{   0, 204,  51 },
	{   0, 207,  48 },
	{   0, 210,  45 },
	{   0, 213,  42 },
	{   0, 216,  39 },
	{   0, 219,  36 },
	{   0, 222,  33 },
	{   0, 225,  30 },
	{   0, 228,  27 },
	{   0, 231,  24 },
	{   0, 234,  21 },
	{   0, 237,  18 },
	{   0, 240,  15 },
	{   0, 243,  12 },
	{   0, 246,   9 },
	{   0, 249,   6 },
	{   0, 252,   3 },
	{   0, 255,   0 },
	{   3, 252,   0 },
	{   6, 249,   0 },
	{   9, 246,   0 },
	{  12, 243,   0 },
	{  15, 240,   0 },
	{  18, 237,   0 },
	{  21, 234,   0 },
	{  24, 231,   0 },
	{  27, 228,   0 },
	{  30, 225,   0 },
	{  33, 222,   0 },
	{  36, 219,   0 },
	{  39, 216,   0 },
	{  42, 213,   0 },
	{  45, 210,   0 },
	{  48, 207,   0 },
	{  51, 204,   0 },
	{  54, 201,   0 },
	{  57, 198,   0 },
	{  60, 195,   0 },
	{  63, 192,   0 },
	{  66, 189,   0 },
	{  69, 186,   0 },
	{  72, 183,   0 },
	{  75, 180,   0 },
	{  78, 177,   0 },
	{  81, 174,   0 },
	{  84, 171,   0 },
	{  87, 168,   0 },
	{  90, 165,   0 },
	{  93, 162,   0 },
	{  96, 159,   0 },
	{  99, 156,   0 },
	{ 102, 153,   0 },
	{ 105, 150,   0 },
	{ 108, 147,   0 },
	{ 111, 144,   0 },
	{ 114, 141,   0 },
	{ 117, 138,   0 },
	{ 120, 135,   0 },
	{ 123, 132,   0 },
	{ 126, 129,   0 },
	{ 129, 126,   0 },
	{ 132, 123,   0 },
	{ 135, 120,   0 },
	{ 138, 117,   0 },
	{ 141, 114,   0 },
	{ 144, 111,   0 },
	{ 147, 108,   0 },
	{ 150, 105,   0 },
	{ 153, 102,   0 },
	{ 156,  99,   0 },
	{ 159,  96,   0 },
	{ 162,  93,   0 },
	{ 165,  90,   0 },
	{ 168,  87,   0 },
	{ 171,  84,   0 },
	{ 174,  81,   0 },
	{ 177,  78,   0 },
	{ 180,  75,   0 },
	{ 183,  72,   0 },
	{ 186,  69,   0 },
	{ 189,  66,   0 },
	{ 192,  63,   0 },
	{ 195,  60,   0 },
	{ 198,  57,   0 },
	{ 201,  54,   0 },
	{ 204,  51,   0 },
	{ 207,  48,   0 },
	{ 210,  45,   0 },
	{ 213,  42,   0 },
	{ 216,  39,   0 },
	{ 219,  36,   0 },
	{ 222,  33,   0 },
	{ 225,  30,   0 },
	{ 228,  27,   0 },
	{ 231,  24,   0 },
	{ 234,  21,   0 },
	{ 237,  18,   0 },
	{ 240,  15,   0 },
	{ 243,  12,   0 },
	{ 246,   9,   0 },
	{ 249,   6,   0 },
	{ 252,   3,   0 },
	{ 255,   0,   0 },
} };
