/*
 * Copyright (C) 2015 Jared Boone, ShareBrained Technology, Inc.
 * Copyright (C) 2016 Furrtek
 *
 * This file is part of PortaPack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

#include "dcs.hpp"

namespace dcs {

const uint16_t dcs_parity[DCS_CODES_NB] = {
	0b11000111010, 	// 0
	0b01001001111, 	// 1
	0b01010100101, 	// 2
	0b11011010000, 	// 3
	0b01101110001, 	// 4
	0b11100000100, 	// 5
	0b11111101110, 	// 6
	0b01110011011, 	// 7
	0b00011011001, 	// 8
	0b10010101100, 	// 9
	0b10001000110, 	// 10
	0b00000110011, 	// 11
	0b10110010010, 	// 12
	0b00111100111, 	// 13
	0b00100001101, 	// 14
	0b10101111000, 	// 15
	0b11110001001, 	// 16
	0b01111111100, 	// 17
	0b01100010110, 	// 18
	0b11101100011, 	// 19
	0b01011000010, 	// 20
	0b11010110111, 	// 21
	0b11001011101, 	// 22
	0b01000101000, 	// 23
	0b00101101010, 	// 24
	0b10100011111, 	// 25
	0b10111110101, 	// 26
	0b00110000000, 	// 27
	0b10000100001, 	// 28
	0b00001010100, 	// 29
	0b00010111110, 	// 30
	0b10011001011, 	// 31
	0b10101011100, 	// 32
	0b00100101001, 	// 33
	0b00111000011, 	// 34
	0b10110110110, 	// 35
	0b00000010111, 	// 36
	0b10001100010, 	// 37
	0b10010001000, 	// 38
	0b00011111101, 	// 39
	0b01110111111, 	// 40
	0b11111001010, 	// 41
	0b11100100000, 	// 42
	0b01101010101, 	// 43
	0b11011110100, 	// 44
	0b01010000001, 	// 45
	0b01001101011, 	// 46
	0b11000011110, 	// 47
	0b10011101111, 	// 48
	0b00010011010, 	// 49
	0b00001110000, 	// 50
	0b10000000101, 	// 51
	0b00110100100, 	// 52
	0b10111010001, 	// 53
	0b10100111011, 	// 54
	0b00101001110, 	// 55
	0b01000001100, 	// 56
	0b11001111001, 	// 57
	0b11010010011, 	// 58
	0b01011100110, 	// 59
	0b11101000111, 	// 60
	0b01100110010, 	// 61
	0b01111011000, 	// 62
	0b11110101101, 	// 63
	0b00011110110, 	// 64
	0b10010000011, 	// 65
	0b10001101001, 	// 66
	0b00000011100, 	// 67
	0b10110111101, 	// 68
	0b00111001000, 	// 69
	0b00100100010, 	// 70
	0b10101010111, 	// 71
	0b11000010101, 	// 72
	0b01001100000, 	// 73
	0b01010001010, 	// 74
	0b11011111111, 	// 75
	0b01101011110, 	// 76
	0b11100101011, 	// 77
	0b11111000001, 	// 78
	0b01110110100, 	// 79
	0b00101000101, 	// 80
	0b10100110000, 	// 81
	0b10111011010, 	// 82
	0b00110101111, 	// 83
	0b10000001110, 	// 84
	0b00001111011, 	// 85
	0b00010010001, 	// 86
	0b10011100100, 	// 87
	0b11110100110, 	// 88
	0b01111010011, 	// 89
	0b01100111001, 	// 90
	0b11101001100, 	// 91
	0b01011101101, 	// 92
	0b11010011000, 	// 93
	0b11001110010, 	// 94
	0b01000000111, 	// 95
	0b01110010000, 	// 96
	0b11111100101, 	// 97
	0b11100001111, 	// 98
	0b01101111010, 	// 99
	0b11011011011, 	// 100
	0b01010101110, 	// 101
	0b01001000100, 	// 102
	0b11000110001, 	// 103
	0b10101110011, 	// 104
	0b00100000110, 	// 105
	0b00111101100, 	// 106
	0b10110011001, 	// 107
	0b00000111000, 	// 108
	0b10001001101, 	// 109
	0b10010100111, 	// 110
	0b00011010010, 	// 111
	0b01000100011, 	// 112
	0b11001010110, 	// 113
	0b11010111100, 	// 114
	0b01011001001, 	// 115
	0b11101101000, 	// 116
	0b01100011101, 	// 117
	0b01111110111, 	// 118
	0b11110000010, 	// 119
	0b10011000000, 	// 120
	0b00010110101, 	// 121
	0b00001011111, 	// 122
	0b10000101010, 	// 123
	0b00110001011, 	// 124
	0b10111111110, 	// 125
	0b10100010100, 	// 126
	0b00101100001, 	// 127
	0b11111010111, 	// 128
	0b01110100010, 	// 129
	0b01101001000, 	// 130
	0b11100111101, 	// 131
	0b01010011100, 	// 132
	0b11011101001, 	// 133
	0b11000000011, 	// 134
	0b01001110110, 	// 135
	0b00100110100, 	// 136
	0b10101000001, 	// 137
	0b10110101011, 	// 138
	0b00111011110, 	// 139
	0b10001111111, 	// 140
	0b00000001010, 	// 141
	0b00011100000, 	// 142
	0b10010010101, 	// 143
	0b11001100100, 	// 144
	0b01000010001, 	// 145
	0b01011111011, 	// 146
	0b11010001110, 	// 147
	0b01100101111, 	// 148
	0b11101011010, 	// 149
	0b11110110000, 	// 150
	0b01111000101, 	// 151
	0b00010000111, 	// 152
	0b10011110010, 	// 153
	0b10000011000, 	// 154
	0b00001101101, 	// 155
	0b10111001100, 	// 156
	0b00110111001, 	// 157
	0b00101010011, 	// 158
	0b10100100110, 	// 159
	0b10010110001, 	// 160
	0b00011000100, 	// 161
	0b00000101110, 	// 162
	0b10001011011, 	// 163
	0b00111111010, 	// 164
	0b10110001111, 	// 165
	0b10101100101, 	// 166
	0b00100010000, 	// 167
	0b01001010010, 	// 168
	0b11000100111, 	// 169
	0b11011001101, 	// 170
	0b01010111000, 	// 171
	0b11100011001, 	// 172
	0b01101101100, 	// 173
	0b01110000110, 	// 174
	0b11111110011, 	// 175
	0b10100000010, 	// 176
	0b00101110111, 	// 177
	0b00110011101, 	// 178
	0b10111101000, 	// 179
	0b00001001001, 	// 180
	0b10000111100, 	// 181
	0b10011010110, 	// 182
	0b00010100011, 	// 183
	0b01111100001, 	// 184
	0b11110010100, 	// 185
	0b11101111110, 	// 186
	0b01100001011, 	// 187
	0b11010101010, 	// 188
	0b01011011111, 	// 189
	0b01000110101, 	// 190
	0b11001000000, 	// 191
	0b00100011011, 	// 192
	0b10101101110, 	// 193
	0b10110000100, 	// 194
	0b00111110001, 	// 195
	0b10001010000, 	// 196
	0b00000100101, 	// 197
	0b00011001111, 	// 198
	0b10010111010, 	// 199
	0b11111111000, 	// 200
	0b01110001101, 	// 201
	0b01101100111, 	// 202
	0b11100010010, 	// 203
	0b01010110011, 	// 204
	0b11011000110, 	// 205
	0b11000101100, 	// 206
	0b01001011001, 	// 207
	0b00010101000, 	// 208
	0b10011011101, 	// 209
	0b10000110111, 	// 210
	0b00001000010, 	// 211
	0b10111100011, 	// 212
	0b00110010110, 	// 213
	0b00101111100, 	// 214
	0b10100001001, 	// 215
	0b11001001011, 	// 216
	0b01000111110, 	// 217
	0b01011010100, 	// 218
	0b11010100001, 	// 219
	0b01100000000, 	// 220
	0b11101110101, 	// 221
	0b11110011111, 	// 222
	0b01111101010, 	// 223
	0b01001111101, 	// 224
	0b11000001000, 	// 225
	0b11011100010, 	// 226
	0b01010010111, 	// 227
	0b11100110110, 	// 228
	0b01101000011, 	// 229
	0b01110101001, 	// 230
	0b11111011100, 	// 231
	0b10010011110, 	// 232
	0b00011101011, 	// 233
	0b00000000001, 	// 234
	0b10001110100, 	// 235
	0b00111010101, 	// 236
	0b10110100000, 	// 237
	0b10101001010, 	// 238
	0b00100111111, 	// 239
	0b01111001110, 	// 240
	0b11110111011, 	// 241
	0b11101010001, 	// 242
	0b01100100100, 	// 243
	0b11010000101, 	// 244
	0b01011110000, 	// 245
	0b01000011010, 	// 246
	0b11001101111, 	// 247
	0b10100101101, 	// 248
	0b00101011000, 	// 249
	0b00110110010, 	// 250
	0b10111000111, 	// 251
	0b00001100110, 	// 252
	0b10000010011, 	// 253
	0b10011111001, 	// 254
	0b00010001100, 	// 255
	0b10111100000, 	// 256
	0b00110010101, 	// 257
	0b00101111111, 	// 258
	0b10100001010, 	// 259
	0b00010101011, 	// 260
	0b10011011110, 	// 261
	0b10000110100, 	// 262
	0b00001000001, 	// 263
	0b01100000011, 	// 264
	0b11101110110, 	// 265
	0b11110011100, 	// 266
	0b01111101001, 	// 267
	0b11001001000, 	// 268
	0b01000111101, 	// 269
	0b01011010111, 	// 270
	0b11010100010, 	// 271
	0b10001010011, 	// 272
	0b00000100110, 	// 273
	0b00011001100, 	// 274
	0b10010111001, 	// 275
	0b00100011000, 	// 276
	0b10101101101, 	// 277
	0b10110000111, 	// 278
	0b00111110010, 	// 279
	0b01010110000, 	// 280
	0b11011000101, 	// 281
	0b11000101111, 	// 282
	0b01001011010, 	// 283
	0b11111111011, 	// 284
	0b01110001110, 	// 285
	0b01101100100, 	// 286
	0b11100010001, 	// 287
	0b11010000110, 	// 288
	0b01011110011, 	// 289
	0b01000011001, 	// 290
	0b11001101100, 	// 291
	0b01111001101, 	// 292
	0b11110111000, 	// 293
	0b11101010010, 	// 294
	0b01100100111, 	// 295
	0b00001100101, 	// 296
	0b10000010000, 	// 297
	0b10011111010, 	// 298
	0b00010001111, 	// 299
	0b10100101110, 	// 300
	0b00101011011, 	// 301
	0b00110110001, 	// 302
	0b10111000100, 	// 303
	0b11100110101, 	// 304
	0b01101000000, 	// 305
	0b01110101010, 	// 306
	0b11111011111, 	// 307
	0b01001111110, 	// 308
	0b11000001011, 	// 309
	0b11011100001, 	// 310
	0b01010010100, 	// 311
	0b00111010110, 	// 312
	0b10110100011, 	// 313
	0b10101001001, 	// 314
	0b00100111100, 	// 315
	0b10010011101, 	// 316
	0b00011101000, 	// 317
	0b00000000010, 	// 318
	0b10001110111, 	// 319
	0b01100101100, 	// 320
	0b11101011001, 	// 321
	0b11110110011, 	// 322
	0b01111000110, 	// 323
	0b11001100111, 	// 324
	0b01000010010, 	// 325
	0b01011111000, 	// 326
	0b11010001101, 	// 327
	0b10111001111, 	// 328
	0b00110111010, 	// 329
	0b00101010000, 	// 330
	0b10100100101, 	// 331
	0b00010000100, 	// 332
	0b10011110001, 	// 333
	0b10000011011, 	// 334
	0b00001101110, 	// 335
	0b01010011111, 	// 336
	0b11011101010, 	// 337
	0b11000000000, 	// 338
	0b01001110101, 	// 339
	0b11111010100, 	// 340
	0b01110100001, 	// 341
	0b01101001011, 	// 342
	0b11100111110, 	// 343
	0b10001111100, 	// 344
	0b00000001001, 	// 345
	0b00011100011, 	// 346
	0b10010010110, 	// 347
	0b00100110111, 	// 348
	0b10101000010, 	// 349
	0b10110101000, 	// 350
	0b00111011101, 	// 351
	0b00001001010, 	// 352
	0b10000111111, 	// 353
	0b10011010101, 	// 354
	0b00010100000, 	// 355
	0b10100000001, 	// 356
	0b00101110100, 	// 357
	0b00110011110, 	// 358
	0b10111101011, 	// 359
	0b11010101001, 	// 360
	0b01011011100, 	// 361
	0b01000110110, 	// 362
	0b11001000011, 	// 363
	0b01111100010, 	// 364
	0b11110010111, 	// 365
	0b11101111101, 	// 366
	0b01100001000, 	// 367
	0b00111111001, 	// 368
	0b10110001100, 	// 369
	0b10101100110, 	// 370
	0b00100010011, 	// 371
	0b10010110010, 	// 372
	0b00011000111, 	// 373
	0b00000101101, 	// 374
	0b10001011000, 	// 375
	0b11100011010, 	// 376
	0b01101101111, 	// 377
	0b01110000101, 	// 378
	0b11111110000, 	// 379
	0b01001010001, 	// 380
	0b11000100100, 	// 381
	0b11011001110, 	// 382
	0b01010111011, 	// 383
	0b10000001101, 	// 384
	0b00001111000, 	// 385
	0b00010010010, 	// 386
	0b10011100111, 	// 387
	0b00101000110, 	// 388
	0b10100110011, 	// 389
	0b10111011001, 	// 390
	0b00110101100, 	// 391
	0b01011101110, 	// 392
	0b11010011011, 	// 393
	0b11001110001, 	// 394
	0b01000000100, 	// 395
	0b11110100101, 	// 396
	0b01111010000, 	// 397
	0b01100111010, 	// 398
	0b11101001111, 	// 399
	0b10110111110, 	// 400
	0b00111001011, 	// 401
	0b00100100001, 	// 402
	0b10101010100, 	// 403
	0b00011110101, 	// 404
	0b10010000000, 	// 405
	0b10001101010, 	// 406
	0b00000011111, 	// 407
	0b01101011101, 	// 408
	0b11100101000, 	// 409
	0b11111000010, 	// 410
	0b01110110111, 	// 411
	0b11000010110, 	// 412
	0b01001100011, 	// 413
	0b01010001001, 	// 414
	0b11011111100, 	// 415
	0b11101101011, 	// 416
	0b01100011110, 	// 417
	0b01111110100, 	// 418
	0b11110000001, 	// 419
	0b01000100000, 	// 420
	0b11001010101, 	// 421
	0b11010111111, 	// 422
	0b01011001010, 	// 423
	0b00110001000, 	// 424
	0b10111111101, 	// 425
	0b10100010111, 	// 426
	0b00101100010, 	// 427
	0b10011000011, 	// 428
	0b00010110110, 	// 429
	0b00001011100, 	// 430
	0b10000101001, 	// 431
	0b11011011000, 	// 432
	0b01010101101, 	// 433
	0b01001000111, 	// 434
	0b11000110010, 	// 435
	0b01110010011, 	// 436
	0b11111100110, 	// 437
	0b11100001100, 	// 438
	0b01101111001, 	// 439
	0b00000111011, 	// 440
	0b10001001110, 	// 441
	0b10010100100, 	// 442
	0b00011010001, 	// 443
	0b10101110000, 	// 444
	0b00100000101, 	// 445
	0b00111101111, 	// 446
	0b10110011010, 	// 447
	0b01011000001, 	// 448
	0b11010110100, 	// 449
	0b11001011110, 	// 450
	0b01000101011, 	// 451
	0b11110001010, 	// 452
	0b01111111111, 	// 453
	0b01100010101, 	// 454
	0b11101100000, 	// 455
	0b10000100010, 	// 456
	0b00001010111, 	// 457
	0b00010111101, 	// 458
	0b10011001000, 	// 459
	0b00101101001, 	// 460
	0b10100011100, 	// 461
	0b10111110110, 	// 462
	0b00110000011, 	// 463
	0b01101110010, 	// 464
	0b11100000111, 	// 465
	0b11111101101, 	// 466
	0b01110011000, 	// 467
	0b11000111001, 	// 468
	0b01001001100, 	// 469
	0b01010100110, 	// 470
	0b11011010011, 	// 471
	0b10110010001, 	// 472
	0b00111100100, 	// 473
	0b00100001110, 	// 474
	0b10101111011, 	// 475
	0b00011011010, 	// 476
	0b10010101111, 	// 477
	0b10001000101, 	// 478
	0b00000110000, 	// 479
	0b00110100111, 	// 480
	0b10111010010, 	// 481
	0b10100111000, 	// 482
	0b00101001101, 	// 483
	0b10011101100, 	// 484
	0b00010011001, 	// 485
	0b00001110011, 	// 486
	0b10000000110, 	// 487
	0b11101000100, 	// 488
	0b01100110001, 	// 489
	0b01111011011, 	// 490
	0b11110101110, 	// 491
	0b01000001111, 	// 492
	0b11001111010, 	// 493
	0b11010010000, 	// 494
	0b01011100101, 	// 495
	0b00000010100, 	// 496
	0b10001100001, 	// 497
	0b10010001011, 	// 498
	0b00011111110, 	// 499
	0b10101011111, 	// 500
	0b00100101010, 	// 501
	0b00111000000, 	// 502
	0b10110110101, 	// 503
	0b11011110111, 	// 504
	0b01010000010, 	// 505
	0b01001101000, 	// 506
	0b11000011101, 	// 507
	0b01110111100, 	// 508
	0b11111001001, 	// 509
	0b11100100011, 	// 510
	0b01101010110 	// 511
};

uint32_t dcs_word(uint32_t code) {
	code &= 511;
	return (dcs_parity[code] << 12) | (0b100 << 9) | code;
}

}
