// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListServicesParams creates a new ListServicesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListServicesParams() *ListServicesParams {
	return &ListServicesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListServicesParamsWithTimeout creates a new ListServicesParams object
// with the ability to set a timeout on a request.
func NewListServicesParamsWithTimeout(timeout time.Duration) *ListServicesParams {
	return &ListServicesParams{
		timeout: timeout,
	}
}

// NewListServicesParamsWithContext creates a new ListServicesParams object
// with the ability to set a context for a request.
func NewListServicesParamsWithContext(ctx context.Context) *ListServicesParams {
	return &ListServicesParams{
		Context: ctx,
	}
}

// NewListServicesParamsWithHTTPClient creates a new ListServicesParams object
// with the ability to set a custom HTTPClient for a request.
func NewListServicesParamsWithHTTPClient(client *http.Client) *ListServicesParams {
	return &ListServicesParams{
		HTTPClient: client,
	}
}

/*
ListServicesParams contains all the parameters to send to the API endpoint

	for the list services operation.

	Typically these are written to a http.Request.
*/
type ListServicesParams struct {

	/* ClusterIds.

	   Query param filter: `cluster_id` of the service.
	*/
	ClusterIds []string

	/* ExternalSources.

	   Query param filter: `external_sources`. Returns a service when service's external sources overlap with the external sources specified.
	*/
	ExternalSources []string

	/* InMesh.

	   Query param filter: whether the service is in the service mesh or not. Possible values: `true` or `false`.
	*/
	InMesh *bool

	/* Kind.

	   Query param filter: `kind` of the service. This can be combination of `typical`, `connect-proxy`, `destination`, `api_gateway`, `ingress_gateway`, `terminating_gateway`, `mesh_gateway`.
	*/
	Kind []string

	/* MtlsMode.

	   Query param filter: mTLS mode of the service. Possible values: `permissive`, `strict`.
	*/
	MtlsMode []string

	/* Namespace.

	   Query param filter: `namespace` of the service.
	*/
	Namespace *string

	/* OrderBy.

	   Sorts the services based on a field. Allowed fields: `name`, `health`. The value needs to be of the format `<Field Name> {asc/desc}` For example: `name`, `name asc`, `name desc`.
	*/
	OrderBy []string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this parameter to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The maximum number of results per page to return. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned, which you can use to get the next page of results in subsequent
	requests. A value of zero causes `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this parameter to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* Partition.

	   Query param filter: `partition` of the service.
	*/
	Partition *string

	/* ProjectResourceName.

	   Parent Resource name will be of the form `project/<project_id>`
	*/
	ProjectResourceName string

	/* Query.

	   Search query to filter by. Searches across service `name`, `cluster_id`, `partition`, `namespace`, `sameness_group`, `tags`.
	*/
	Query *string

	/* Status.

	   Query param filter: `status` of the service. This can be combination of `passing`, `warning`, `critical`, `none`.
	*/
	Status []string

	/* Tags.

	   Query param filter: `tags`.
	*/
	Tags []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list services params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListServicesParams) WithDefaults() *ListServicesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list services params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListServicesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list services params
func (o *ListServicesParams) WithTimeout(timeout time.Duration) *ListServicesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list services params
func (o *ListServicesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list services params
func (o *ListServicesParams) WithContext(ctx context.Context) *ListServicesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list services params
func (o *ListServicesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list services params
func (o *ListServicesParams) WithHTTPClient(client *http.Client) *ListServicesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list services params
func (o *ListServicesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterIds adds the clusterIds to the list services params
func (o *ListServicesParams) WithClusterIds(clusterIds []string) *ListServicesParams {
	o.SetClusterIds(clusterIds)
	return o
}

// SetClusterIds adds the clusterIds to the list services params
func (o *ListServicesParams) SetClusterIds(clusterIds []string) {
	o.ClusterIds = clusterIds
}

// WithExternalSources adds the externalSources to the list services params
func (o *ListServicesParams) WithExternalSources(externalSources []string) *ListServicesParams {
	o.SetExternalSources(externalSources)
	return o
}

// SetExternalSources adds the externalSources to the list services params
func (o *ListServicesParams) SetExternalSources(externalSources []string) {
	o.ExternalSources = externalSources
}

// WithInMesh adds the inMesh to the list services params
func (o *ListServicesParams) WithInMesh(inMesh *bool) *ListServicesParams {
	o.SetInMesh(inMesh)
	return o
}

// SetInMesh adds the inMesh to the list services params
func (o *ListServicesParams) SetInMesh(inMesh *bool) {
	o.InMesh = inMesh
}

// WithKind adds the kind to the list services params
func (o *ListServicesParams) WithKind(kind []string) *ListServicesParams {
	o.SetKind(kind)
	return o
}

// SetKind adds the kind to the list services params
func (o *ListServicesParams) SetKind(kind []string) {
	o.Kind = kind
}

// WithMtlsMode adds the mtlsMode to the list services params
func (o *ListServicesParams) WithMtlsMode(mtlsMode []string) *ListServicesParams {
	o.SetMtlsMode(mtlsMode)
	return o
}

// SetMtlsMode adds the mtlsMode to the list services params
func (o *ListServicesParams) SetMtlsMode(mtlsMode []string) {
	o.MtlsMode = mtlsMode
}

// WithNamespace adds the namespace to the list services params
func (o *ListServicesParams) WithNamespace(namespace *string) *ListServicesParams {
	o.SetNamespace(namespace)
	return o
}

// SetNamespace adds the namespace to the list services params
func (o *ListServicesParams) SetNamespace(namespace *string) {
	o.Namespace = namespace
}

// WithOrderBy adds the orderBy to the list services params
func (o *ListServicesParams) WithOrderBy(orderBy []string) *ListServicesParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the list services params
func (o *ListServicesParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the list services params
func (o *ListServicesParams) WithPaginationNextPageToken(paginationNextPageToken *string) *ListServicesParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the list services params
func (o *ListServicesParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the list services params
func (o *ListServicesParams) WithPaginationPageSize(paginationPageSize *int64) *ListServicesParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the list services params
func (o *ListServicesParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the list services params
func (o *ListServicesParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *ListServicesParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the list services params
func (o *ListServicesParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithPartition adds the partition to the list services params
func (o *ListServicesParams) WithPartition(partition *string) *ListServicesParams {
	o.SetPartition(partition)
	return o
}

// SetPartition adds the partition to the list services params
func (o *ListServicesParams) SetPartition(partition *string) {
	o.Partition = partition
}

// WithProjectResourceName adds the projectResourceName to the list services params
func (o *ListServicesParams) WithProjectResourceName(projectResourceName string) *ListServicesParams {
	o.SetProjectResourceName(projectResourceName)
	return o
}

// SetProjectResourceName adds the projectResourceName to the list services params
func (o *ListServicesParams) SetProjectResourceName(projectResourceName string) {
	o.ProjectResourceName = projectResourceName
}

// WithQuery adds the query to the list services params
func (o *ListServicesParams) WithQuery(query *string) *ListServicesParams {
	o.SetQuery(query)
	return o
}

// SetQuery adds the query to the list services params
func (o *ListServicesParams) SetQuery(query *string) {
	o.Query = query
}

// WithStatus adds the status to the list services params
func (o *ListServicesParams) WithStatus(status []string) *ListServicesParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the list services params
func (o *ListServicesParams) SetStatus(status []string) {
	o.Status = status
}

// WithTags adds the tags to the list services params
func (o *ListServicesParams) WithTags(tags []string) *ListServicesParams {
	o.SetTags(tags)
	return o
}

// SetTags adds the tags to the list services params
func (o *ListServicesParams) SetTags(tags []string) {
	o.Tags = tags
}

// WriteToRequest writes these params to a swagger request
func (o *ListServicesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClusterIds != nil {

		// binding items for cluster_ids
		joinedClusterIds := o.bindParamClusterIds(reg)

		// query array param cluster_ids
		if err := r.SetQueryParam("cluster_ids", joinedClusterIds...); err != nil {
			return err
		}
	}

	if o.ExternalSources != nil {

		// binding items for external_sources
		joinedExternalSources := o.bindParamExternalSources(reg)

		// query array param external_sources
		if err := r.SetQueryParam("external_sources", joinedExternalSources...); err != nil {
			return err
		}
	}

	if o.InMesh != nil {

		// query param in_mesh
		var qrInMesh bool

		if o.InMesh != nil {
			qrInMesh = *o.InMesh
		}
		qInMesh := swag.FormatBool(qrInMesh)
		if qInMesh != "" {

			if err := r.SetQueryParam("in_mesh", qInMesh); err != nil {
				return err
			}
		}
	}

	if o.Kind != nil {

		// binding items for kind
		joinedKind := o.bindParamKind(reg)

		// query array param kind
		if err := r.SetQueryParam("kind", joinedKind...); err != nil {
			return err
		}
	}

	if o.MtlsMode != nil {

		// binding items for mtls_mode
		joinedMtlsMode := o.bindParamMtlsMode(reg)

		// query array param mtls_mode
		if err := r.SetQueryParam("mtls_mode", joinedMtlsMode...); err != nil {
			return err
		}
	}

	if o.Namespace != nil {

		// query param namespace
		var qrNamespace string

		if o.Namespace != nil {
			qrNamespace = *o.Namespace
		}
		qNamespace := qrNamespace
		if qNamespace != "" {

			if err := r.SetQueryParam("namespace", qNamespace); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	if o.Partition != nil {

		// query param partition
		var qrPartition string

		if o.Partition != nil {
			qrPartition = *o.Partition
		}
		qPartition := qrPartition
		if qPartition != "" {

			if err := r.SetQueryParam("partition", qPartition); err != nil {
				return err
			}
		}
	}

	// path param project_resource_name
	if err := r.SetPathParam("project_resource_name", o.ProjectResourceName); err != nil {
		return err
	}

	if o.Query != nil {

		// query param query
		var qrQuery string

		if o.Query != nil {
			qrQuery = *o.Query
		}
		qQuery := qrQuery
		if qQuery != "" {

			if err := r.SetQueryParam("query", qQuery); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// binding items for status
		joinedStatus := o.bindParamStatus(reg)

		// query array param status
		if err := r.SetQueryParam("status", joinedStatus...); err != nil {
			return err
		}
	}

	if o.Tags != nil {

		// binding items for tags
		joinedTags := o.bindParamTags(reg)

		// query array param tags
		if err := r.SetQueryParam("tags", joinedTags...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamListServices binds the parameter cluster_ids
func (o *ListServicesParams) bindParamClusterIds(formats strfmt.Registry) []string {
	clusterIdsIR := o.ClusterIds

	var clusterIdsIC []string
	for _, clusterIdsIIR := range clusterIdsIR { // explode []string

		clusterIdsIIV := clusterIdsIIR // string as string
		clusterIdsIC = append(clusterIdsIC, clusterIdsIIV)
	}

	// items.CollectionFormat: "multi"
	clusterIdsIS := swag.JoinByFormat(clusterIdsIC, "multi")

	return clusterIdsIS
}

// bindParamListServices binds the parameter external_sources
func (o *ListServicesParams) bindParamExternalSources(formats strfmt.Registry) []string {
	externalSourcesIR := o.ExternalSources

	var externalSourcesIC []string
	for _, externalSourcesIIR := range externalSourcesIR { // explode []string

		externalSourcesIIV := externalSourcesIIR // string as string
		externalSourcesIC = append(externalSourcesIC, externalSourcesIIV)
	}

	// items.CollectionFormat: "multi"
	externalSourcesIS := swag.JoinByFormat(externalSourcesIC, "multi")

	return externalSourcesIS
}

// bindParamListServices binds the parameter kind
func (o *ListServicesParams) bindParamKind(formats strfmt.Registry) []string {
	kindIR := o.Kind

	var kindIC []string
	for _, kindIIR := range kindIR { // explode []string

		kindIIV := kindIIR // string as string
		kindIC = append(kindIC, kindIIV)
	}

	// items.CollectionFormat: "multi"
	kindIS := swag.JoinByFormat(kindIC, "multi")

	return kindIS
}

// bindParamListServices binds the parameter mtls_mode
func (o *ListServicesParams) bindParamMtlsMode(formats strfmt.Registry) []string {
	mtlsModeIR := o.MtlsMode

	var mtlsModeIC []string
	for _, mtlsModeIIR := range mtlsModeIR { // explode []string

		mtlsModeIIV := mtlsModeIIR // string as string
		mtlsModeIC = append(mtlsModeIC, mtlsModeIIV)
	}

	// items.CollectionFormat: "multi"
	mtlsModeIS := swag.JoinByFormat(mtlsModeIC, "multi")

	return mtlsModeIS
}

// bindParamListServices binds the parameter order_by
func (o *ListServicesParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "multi"
	orderByIS := swag.JoinByFormat(orderByIC, "multi")

	return orderByIS
}

// bindParamListServices binds the parameter status
func (o *ListServicesParams) bindParamStatus(formats strfmt.Registry) []string {
	statusIR := o.Status

	var statusIC []string
	for _, statusIIR := range statusIR { // explode []string

		statusIIV := statusIIR // string as string
		statusIC = append(statusIC, statusIIV)
	}

	// items.CollectionFormat: "multi"
	statusIS := swag.JoinByFormat(statusIC, "multi")

	return statusIS
}

// bindParamListServices binds the parameter tags
func (o *ListServicesParams) bindParamTags(formats strfmt.Registry) []string {
	tagsIR := o.Tags

	var tagsIC []string
	for _, tagsIIR := range tagsIR { // explode []string

		tagsIIV := tagsIIR // string as string
		tagsIC = append(tagsIC, tagsIIV)
	}

	// items.CollectionFormat: "multi"
	tagsIS := swag.JoinByFormat(tagsIC, "multi")

	return tagsIS
}
