#!/bin/bash

if ! test -e kernel.allocation_funcs || ! test -e kernel.gfp_flags ; then
    echo "We need the kernel.allocation_funcs and the kernel.gfp_flags files"
    echo "The scripts to generate them are in smatch_data/"
    exit 1
fi

bin_dir=$(dirname $0)
remove=$(echo ${bin_dir}/../smatch_data/kernel.allocation_funcs_gfp.remove)
tmp=$(mktemp /tmp/smatch.XXXX)

echo "// Automatically generated by add_gfp_to_allocations.sh" > kernel.allocation_funcs_gfp
for i in $(grep -v "//" kernel.allocation_funcs) ; do
    if ! grep -w $i kernel.gfp_flags ; then
	echo $i X
    fi
done >> $tmp

cat $tmp $remove $remove 2> /dev/null | sort | uniq -u >> kernel.allocation_funcs_gfp
rm $tmp

echo "Done.  Created kernel.allocation_funcs_gfp"
