/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  readinfo.h

  Get games sources from different kind of sources
*/

#ifndef MAMORY_READINFO_H
#define MAMORY_READINFO_H

typedef struct s_GameInfo s_GameInfo;

typedef struct s_RomAssociatedGame
{
  unsigned int NbFiles;
  s_GameInfo *Game;
} s_RomAssociatedGame;

typedef struct s_RomContent
{
  unsigned int Size;
  unsigned int CompSize;
  unsigned int CRC;
  unsigned int NbrAssociatedGames;
  s_RomAssociatedGame **AssociatedGames;
} s_RomContent;

#define ROM_CONTENT(x) ((s_RomContent*)x)

typedef struct s_RomHardwareInfo
{
  unsigned char *Region;
  unsigned char *Flags;
  unsigned int Offset;
} s_RomHardwareInfo;


typedef struct s_SharedRomInfo
{
  unsigned char *CloneName;
  unsigned char *RomName;
  unsigned int Status;
  s_RomHardwareInfo *Hardware;
} s_SharedRomInfo;

typedef struct s_GamesListSource s_GamesListSource;

typedef struct s_RomInfo
{
  s_GamesListSource *Source;
//  unsigned char StorageFormat;
  unsigned char *Name;
  unsigned char *GameName;
  unsigned char *Merge;
  unsigned int Status;
#define UNKNOWN_DUMP 0
#define GOOD_DUMP 1
#define NO_GOOD_DUMP_KNOWN 2 // CRC complement
#define NEED_REDUMP 3 //CRC 0
#define NO_ROM 4
  s_RomContent *Content;
  s_RomHardwareInfo *Hardware;
  unsigned int NbrShared;
  s_SharedRomInfo **Shared; 
} s_RomInfo;

#define ROM_INFO(x) ((s_RomInfo *)x)

typedef struct s_ChipInfo
{
  unsigned char *Type ; // cpu|audio
  unsigned char *Flags ;// audio
  unsigned char *Name ;
  unsigned int Clock ;
} s_ChipInfo;

typedef struct s_DisplayInfo
{
  unsigned char *Type ; // raster|vector
  unsigned char Rotate ; // horizontal|vertical if before mame 0.107
                         // 0|90|180|270 if mame 0.107 and after
#define VERTICAL 0
#define HORIZONTAL 1
#define ROTATE_0 2
#define ROTATE_90 4
#define ROTATE_180 8
#define ROTATE_270 16

  unsigned int X ;
  unsigned int Y ;

  /* no more in use from mame 0.107 */
  unsigned char AspectX; 
  unsigned char AspectY;
  unsigned char Flipx; /* TRUE|FALSE */
  unsigned int Colors ; // ????
  float Freq ; // ==refresh in xml
} s_DisplayInfo;

typedef struct s_SoundInfo
{
  unsigned char Channels ;
} s_SoundInfo;

/* Introduced in mame 0.107 */
typedef struct s_ControlInfo
{
  unsigned char *Type;
  unsigned int Minimum;
  unsigned int Maximum;
  unsigned int Sensitivity;
  unsigned int Keydelta;
  unsigned int Reverse; /* TRUE|FALSE */
} s_ControlInfo;

typedef struct s_InputInfo
{
  unsigned char Players ;
  /* removed in mame 0.107
  unsigned char *Control;
  */
  s_ControlInfo **Controls;
  unsigned char NbrControls;
  unsigned char Buttons ;
  unsigned char Coins ;    
  unsigned char *Tilt ;    // yes|no
  unsigned char *Service ; // yes|no
} s_InputInfo;

typedef struct s_DipSwitchInfo
{
  unsigned char *Name ;
  unsigned char **Entries ;
  unsigned char NbrEntries ;
  unsigned char *Default ;
} s_DipSwitchInfo;

typedef struct s_DriverInfo
{
  unsigned char *Status ; // good|preliminary
  unsigned char *Color ;  // good|imperfect|preliminary
  unsigned char *Sound ;  // good|imperfect|preliminary
  unsigned char *Blit;    // plain | dirty
  unsigned char PaletteSize;
} s_DriverInfo;

typedef struct s_DiskHardwareInfo
{
  unsigned char *Region;
  unsigned int Index;
} s_DiskHardwareInfo;

typedef struct s_DiskInfo
{
  unsigned char *Name;
  unsigned char *md5;
  s_DiskHardwareInfo *Hardware;
} s_DiskInfo;  

typedef struct s_MiscGameInfo
{
  unsigned short Year ;
  unsigned char *Manufacturer ;
  unsigned char NbrChips ;
  s_ChipInfo **Chips;
  s_DisplayInfo **Displays;
  unsigned char NbrDisplays;
  s_SoundInfo *Sound;
  s_InputInfo *Input;
  unsigned char NbrDipSwitches ;
  s_DipSwitchInfo **DipSwitches;
  s_DriverInfo *Driver;
} s_MiscGameInfo;


typedef struct s_CloneInfo
{
  unsigned char *Name;
  unsigned char *Description;
  s_MiscGameInfo *Misc;
} s_CloneInfo;

typedef struct s_MoreGameInfo
{
  unsigned char *Description;
  unsigned char *CloneOf;
  unsigned char *RomOf;
  unsigned char *Resource;
  unsigned int NbrClones;
  s_CloneInfo **Clones;
  unsigned char NbrMergedRoms;
  s_RomInfo **MergedRoms;
  unsigned char *SampleOf;
  unsigned char NbrSamples;
  unsigned char **Samples;
  s_MiscGameInfo *Misc;
} s_MoreGameInfo;

struct s_GameInfo
{
  unsigned char StorageMode;
#define STMODE_UNSET 0
#define STMODE_MERGE 1
#define STMODE_SPLIT 2
#define STMODE_FULL 4
  unsigned char StorageFormat;
#define STFMT_UNSET 0
#define STFMT_RAW 1
#define STFMT_ZIP 2
  unsigned char *Name;
  unsigned int NbrRoms;
  s_RomInfo **Roms;
  unsigned int NbrDisks;
  s_DiskInfo **Disks;
  s_MoreGameInfo *More;
};
  
#define MAMEGAME(x) ((s_MameGameInfo *)x)
typedef struct s_GamesList s_GamesList;

struct s_GamesListSource
{
  s_GamesList *GamesList;
  unsigned int Type;
#define TYPE_EXEC 0
#define TYPE_ADMAMELI 1
#define TYPE_DIR 2
#define TYPE_FILE 3
  unsigned char *Source;
  unsigned char *Target;
  unsigned char *TargetVersion;
  unsigned char *Author;
  unsigned char *Version;
  unsigned char *Comment;
  unsigned int StorageMode;
  unsigned int ForceStorageMode;
//  unsigned int StorageFormat;
  unsigned int ForceStorageFormat;
};


typedef struct s_ResourceInfo
{
  unsigned char *Name;
  unsigned int NbrAssociatedGames;
  s_GameInfo **AssociatedGames;
  s_GameInfo *Game;
} s_ResourceInfo;

struct s_GamesList
{
  unsigned int MergedGamesList; // TRUE=1
  unsigned int NbrSources;
  s_GamesListSource **Sources;
  unsigned int NbrResources;
  s_ResourceInfo **Resources;
  unsigned int NbrGames;
  s_GameInfo **Games;
  unsigned int NbrRomContents;
  s_RomContent **RomContents;
  unsigned char NbrSoundSamples;
  unsigned char **SoundSamples;
  unsigned int NbrUnknownTokens;
};

void FreeSharedRomInfo(s_SharedRomInfo *Shared);
void FreeRomInfo(s_RomInfo *Rom);
void FreeDiskInfo(s_DiskInfo *Disk);
void FreeChipInfo(s_ChipInfo *Chip);
void FreeDisplayInfo(s_DisplayInfo *Display);
void FreeSoundInfo(s_SoundInfo *Sound);
void FreeInputInfo(s_InputInfo *Input);
void FreeDipSwitchInfo(s_DipSwitchInfo *DS);
void FreeDriverInfo(s_DriverInfo *Driver);
void FreeGameInfo(s_GameInfo *GameInfo);
void FreeGamesListSource(s_GamesListSource *Source);
void FreeResourceInfo(s_ResourceInfo *Resource);
void FreeGamesList(s_GamesList *LMG);

s_GamesList *GetGamesList(unsigned char *GamesSrc,
			  unsigned char *TempDir);

s_GamesList *MergeGamesLists(s_GamesList *LMG1, s_GamesList *LMG2);


#endif // __READINFO_H


