/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/* memalloc.h

   Safer memory allocation macros 
*/

#ifndef COMMON_MEMALLOC_H
#define COMMON_MEMALLOC_H

inline void *xcalloc(size_t num, size_t size,char *file,int line);
inline void *xmalloc(size_t num,char *file, int line);
inline void *xrealloc(void *p, size_t num,char *file,int line);
inline char *xstrdup(const char *string,char *file, int line);

#ifndef NDEBUG
# define XCALLOC(type,num) ((type*)calloc((num),sizeof(type)))
# define XMALLOC(type,num) ((type*)malloc((num)*sizeof(type)))
# define XREALLOC(p,type,num) ((type*)realloc((p),(num)*sizeof(type)))
# define XFREE(stale) do{if(stale){ free(stale); stale=NULL;}} while(0)
# define XSTRDUP(str) (((str)==NULL?NULL:strdup((str))))
#else
# define XCALLOC(type,num) ((type*)xcalloc((num),sizeof(type),__FILE__,__LINE__))
# define XMALLOC(type,num) ((type*)xmalloc((num)*sizeof(type),__FILE__,__LINE__))
# define XREALLOC(p,type,num) ((type*)xrealloc((p),(num)*sizeof(type),__FILE__,__LINE__))
# define XFREE(stale) do{if(stale){ free(stale); stale=NULL;}} while(0)
# define XSTRDUP(str) (xstrdup((str),__FILE__,__LINE__))
#endif

#endif
