/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.CDFConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class CDFTools
implements CDFConstants {
    private static String cdfbase = System.getProperty("cdf.base");
    private static String separator = System.getProperty("file.separator");
    private static String cmdBase = cdfbase + separator + "bin" + separator;
    private static OutputStream err = System.err;
    public static final int NO_VALUES = 0;
    public static final int NRV_VALUES = 1;
    public static final int RV_VALUES = 2;
    public static final int ALL_VALUES = 3;
    public static final int NAMED_VALUES = 4;
    public static final int NO_REPORTS = 0;
    public static final int REPORT_ERRORS = 1;
    public static final int REPORT_WARNINGS = 2;
    public static final int REPORT_INFORMATION = 4;

    public static void skeletonTable(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, String[] stringArray, int n2, int n3, int n4) throws IOException, InterruptedException {
        if (n4 <= 0) {
            CDFTools.skeletonTable(string, string2, bl, bl2, bl3, bl4, bl5, bl6, n, stringArray, n2, n3, null);
        } else {
            String string3 = new StringBuffer("" + n4 + "d").toString();
            CDFTools.skeletonTable(string, string2, bl, bl2, bl3, bl4, bl5, bl6, n, stringArray, n2, n3, string3);
        }
    }

    public static void skeletonTable(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, String[] stringArray, int n2, int n3, int n4, int n5) throws IOException, InterruptedException {
        if (n4 <= 0 && n5 <= 0) {
            CDFTools.skeletonTable(string, string2, bl, bl2, bl3, bl4, bl5, bl6, n, stringArray, n2, n3, null);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            if (n4 > 0) {
                stringBuffer = stringBuffer.append("" + n4 + "d");
            }
            if (n5 > 0) {
                stringBuffer = n4 > 0 ? stringBuffer.append("," + n5 + "s") : stringBuffer.append("" + n5 + "s");
            }
            CDFTools.skeletonTable(string, string2, bl, bl2, bl3, bl4, bl5, bl6, n, stringArray, n2, n3, stringBuffer.toString());
        }
    }

    public static void skeletonTable(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, String[] stringArray, int n2, int n3, int n4, int n5, int n6) throws IOException, InterruptedException {
        if (n4 <= 0 && n5 <= 0 && n6 <= 0) {
            CDFTools.skeletonTable(string, string2, bl, bl2, bl3, bl4, bl5, bl6, n, stringArray, n2, n3, null);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            if (n4 > 0) {
                stringBuffer = stringBuffer.append("" + n4 + "d");
            }
            if (n5 > 0) {
                stringBuffer = n4 > 0 ? stringBuffer.append("," + n5 + "s") : stringBuffer.append("" + n5 + "s");
            }
            if (n6 > 0) {
                stringBuffer = n4 > 0 || n5 > 0 ? stringBuffer.append("," + n6 + "c") : stringBuffer.append("" + n6 + "c");
            }
            CDFTools.skeletonTable(string, string2, bl, bl2, bl3, bl4, bl5, bl6, n, stringArray, n2, n3, stringBuffer.toString());
        }
    }

    public static void skeletonTable(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, String[] stringArray, int n2, int n3, String string3) throws IOException, InterruptedException {
        CDFTools.skeletonTable(string, string2, bl, bl2, bl3, bl4, bl5, bl6, n, stringArray, n2, n3, string3, null);
    }

    public static void skeletonTable(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, String[] stringArray, int n2, int n3, String string3, String string4) throws IOException, InterruptedException {
        String string5;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cmdBase).append("skeletontable ");
        if (string != null) {
            stringBuffer.append("-skeleton ");
            stringBuffer.append(string + " ");
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                stringBuffer.append("-values nrv ");
                break;
            }
            case 2: {
                stringBuffer.append("-values rv ");
                break;
            }
            case 3: {
                stringBuffer.append("-values all");
                break;
            }
            case 4: {
                stringBuffer.append("-values ");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i] + ",");
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append("-");
        if (!bl) {
            stringBuffer.append("no");
        }
        stringBuffer.append("log ");
        stringBuffer.append("-zmode " + n2 + " ");
        stringBuffer.append("-");
        if (!bl2) {
            stringBuffer.append("no");
        }
        stringBuffer.append("format ");
        if (string4 != null) {
            if (string4.toLowerCase().equals("best")) {
                stringBuffer.append("-advformat \"best \"");
            } else if (string4.toLowerCase().equals("no")) {
                stringBuffer.append("-advformat \"no \"");
            } else if (string4.toLowerCase().equals("metaonly")) {
                stringBuffer.append("-advformat \"metaonly \"");
            } else if (string4.toLowerCase().equals("dataonly")) {
                stringBuffer.append("-advformat \"dataonly \"");
            } else if (string4.toLowerCase().equals("all")) {
                stringBuffer.append("-advformat \"all \"");
            }
        } else {
            stringBuffer.append("-advformat \"best \"");
        }
        stringBuffer.append("-");
        if (!bl3) {
            stringBuffer.append("no");
        }
        stringBuffer.append("neg2posfp0 ");
        if (n3 != 0) {
            stringBuffer.append("-report \"");
            if ((n3 & 1) != 0) {
                stringBuffer.append("errors,");
            }
            if ((n3 & 2) != 0) {
                stringBuffer.append("warnings,");
            }
            if ((n3 & 4) != 0) {
                stringBuffer.append("informationals,");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\" ");
        }
        if (string3 != null) {
            stringBuffer.append("-cache ");
            stringBuffer.append("\"" + string3 + "\" ");
        }
        stringBuffer.append("-");
        if (!bl4) {
            stringBuffer.append("no");
        }
        stringBuffer.append("statistics ");
        stringBuffer.append("-");
        if (!bl5) {
            stringBuffer.append("no");
        }
        stringBuffer.append("screen ");
        stringBuffer.append("-");
        if (!bl6) {
            stringBuffer.append("no");
        }
        stringBuffer.append("page ");
        stringBuffer.append(string2);
        Process process = Runtime.getRuntime().exec(stringBuffer.toString());
        int n4 = process.waitFor();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
        while ((string5 = bufferedReader.readLine()) != null) {
            if (!(err instanceof PrintStream)) continue;
            ((PrintStream)err).println(string5);
        }
    }

    public static void skeletonCDF(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, int n3) throws IOException, InterruptedException {
        if (n3 <= 0) {
            CDFTools.skeletonCDF(string, string2, bl, bl2, bl3, bl4, n, n2, null);
        } else {
            StringBuffer stringBuffer = new StringBuffer("" + n3 + "d");
            CDFTools.skeletonCDF(string, string2, bl, bl2, bl3, bl4, n, n2, stringBuffer.toString());
        }
    }

    public static void skeletonCDF(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, int n3, int n4) throws IOException, InterruptedException {
        if (n3 <= 0 && n4 <= 0) {
            CDFTools.skeletonCDF(string, string2, bl, bl2, bl3, bl4, n, n2, null);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            if (n3 > 0) {
                stringBuffer = stringBuffer.append("" + n3 + "d");
            }
            if (n4 > 0) {
                stringBuffer = n3 > 0 ? stringBuffer.append("," + n4 + "s") : stringBuffer.append("" + n4 + "s");
            }
            CDFTools.skeletonCDF(string, string2, bl, bl2, bl3, bl4, n, n2, stringBuffer.toString());
        }
    }

    public static void skeletonCDF(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, int n3, int n4, int n5) throws IOException, InterruptedException {
        if (n3 <= 0 && n4 <= 0 && n5 <= 0) {
            CDFTools.skeletonCDF(string, string2, bl, bl2, bl3, bl4, n, n2, null);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            if (n3 > 0) {
                stringBuffer = stringBuffer.append("" + n3 + "d");
            }
            if (n4 > 0) {
                stringBuffer = n3 > 0 ? stringBuffer.append("," + n4 + "s") : stringBuffer.append("" + n4 + "s");
            }
            if (n5 > 0) {
                stringBuffer = n3 > 0 || n4 > 0 ? stringBuffer.append("," + n5 + "c") : stringBuffer.append("" + n5 + "c");
            }
            CDFTools.skeletonCDF(string, string2, bl, bl2, bl3, bl4, n, n2, stringBuffer.toString());
        }
    }

    public static void skeletonCDF(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, String string3) throws IOException, InterruptedException {
        String string4;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cmdBase).append("skeletoncdf ");
        if (string2 != null) {
            stringBuffer.append("-cdf ");
            stringBuffer.append(string2 + " ");
        }
        stringBuffer.append("-");
        if (!bl) {
            stringBuffer.append("no");
        }
        stringBuffer.append("delete ");
        stringBuffer.append("-");
        if (!bl2) {
            stringBuffer.append("no");
        }
        stringBuffer.append("log ");
        stringBuffer.append("-zmode " + n + " ");
        stringBuffer.append("-");
        if (!bl3) {
            stringBuffer.append("no");
        }
        stringBuffer.append("neg2posfp0 ");
        if (n2 != 0) {
            stringBuffer.append("-report \"");
            if ((n2 & 1) != 0) {
                stringBuffer.append("errors,");
            }
            if ((n2 & 2) != 0) {
                stringBuffer.append("warnings,");
            }
            if ((n2 & 4) != 0) {
                stringBuffer.append("informationals,");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\" ");
        }
        if (string3 != null) {
            stringBuffer.append("-cache ");
            stringBuffer.append("\"" + string3 + "\" ");
        }
        stringBuffer.append("-");
        if (!bl4) {
            stringBuffer.append("no");
        }
        stringBuffer.append("statistics ");
        stringBuffer.append(string);
        Process process = Runtime.getRuntime().exec(stringBuffer.toString());
        int n3 = process.waitFor();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
        while ((string4 = bufferedReader.readLine()) != null) {
            if (!(err instanceof PrintStream)) continue;
            ((PrintStream)err).println(string4);
        }
    }

    static int cdfElemSize(long l) {
        switch ((int)l) {
            case 41: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 2;
            }
            case 14: {
                return 4;
            }
            case 21: {
                return 4;
            }
            case 22: {
                return 8;
            }
            case 44: {
                return 4;
            }
            case 45: {
                return 8;
            }
            case 31: {
                return 8;
            }
            case 32: {
                return 16;
            }
            case 33: {
                return 8;
            }
            case 51: {
                return 1;
            }
            case 52: {
                return 1;
            }
        }
        return 0;
    }
}

