/*
 * Job subclass to emit progress events
 * Copyright 2018  A Schenck <galiven@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License or (at your option) version 3 or any later version
 * accepted by the membership of KDE e.V. (or its successor approved
 * by the membership of KDE e.V.), which shall act as a proxy
 * defined in Section 14 of version 3 of the license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PROGRESSJOB_H
#define PROGRESSJOB_H

#include <QObject>
#include <ThreadWeaver/Job>
#include <ThreadWeaver/JobInterface>
#include <qobject.h>                    // for QObject
#include <qobjectdefs.h>                // for Q_PROPERTY, Q_OBJECT, Q_SIGNALS
#include <qstring.h>                    // for QString
#include <threadweaver/job.h>           // for Job
#include <threadweaver/jobinterface.h>  // for JobPointer

namespace ThreadWeaver {
class Thread;
}  // namespace ThreadWeaver

/**
 * @class ProgressJob A shared class ThreadWeaver jobs that want to expose
 * started / failed / done events and progress
 */
class ProgressJob : public QObject, public ThreadWeaver::Job
{
	Q_OBJECT
	Q_PROPERTY ( int progress READ progress WRITE setProgress NOTIFY progressChanged )
	Q_PROPERTY ( int totalSteps READ totalSteps WRITE setTotalSteps NOTIFY progressChanged )

public:
	ProgressJob();

	int progress() const;
	int totalSteps() const;
	bool isAborted() const;

Q_SIGNALS:
	void progressChanged ( int progress );

// 	provided by QObjectDecorator
// 	/** This signal is emitted when this job is being processed by a thread. */
// 	void started(ThreadWeaver::JobPointer);
// 	/** This signal is emitted when the job has been finished (no matter if it succeeded or not). */
// 	void done(ThreadWeaver::JobPointer);
// 	/** This job has failed.
// 	*
// 	* This signal is emitted when success() returns false after the job is executed. */
// 	void failed(ThreadWeaver::JobPointer);

protected Q_SLOTS:
	void setProgress ( int progress );
	void setTotalSteps ( int totalSteps );
	void setIsAborted ( bool isAborted );

// 	provided by qobjectdecorator
// protected:
// 	void defaultBegin(const ThreadWeaver::JobPointer& self, ThreadWeaver::Thread *thread) override;
// 	void defaultEnd(const ThreadWeaver::JobPointer& self, ThreadWeaver::Thread *thread) override;

private:
	int m_progress{};
	int m_totalSteps{};
	bool m_isAborted{};
};

#endif // PROGRESSJOB_H
