/***************************************************************************
*	Copyright (C) 2004 by karye												*
*	karye@users.sourceforge.net												*
*																			*
*	This program is free software; you can redistribute it and/or modify	*
*	it under the terms of the GNU General Public License as published by	*
*	the Free Software Foundation; either version 2 of the License, or		*
*	(at your option) any later version.										*
*																			*
*	This program is distributed in the hope that it will be useful,			*
*	but WITHOUT ANY WARRANTY; without even the implied warranty of			*
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
*	GNU General Public License for more details.							*
*																			*
*	You should have received a copy of the GNU General Public License		*
*	along with this program; if not, write to the							*
*	Free Software Foundation, Inc.,											*
*	59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.				*
***************************************************************************/

#include <klocalizedstring.h>  // for i18n
#include <qdatetime.h>         // for QTime
#include <qdebug.h>				// for qWarning

#include "global.h"            // for formatTime, parsePackage

// The constructor for QRegularExpression is very cheap, not worth jumping through
// the Q_GLOBAL_STATIC hoops
// this is for parsing the output of 'emerge --pretend'
QRegularExpression* KurooGlobal::rxEmerge = new QRegularExpression(QStringLiteral("^\\[ebuild([\\s\\w~#*]*)\\]\\s+"	//Also allow * for merging hardmasked packages
													"((\\S+)/(\\S+))"
													"(?:\\s*\\[([^\\]]*)\\])?"
													"(?:\\s*\\[([^\\]]*)\\])?"
													"(?:\\s*USE=\"([^\"]*)\")?"
													"(?:\\s*LINGUAS=\"(?:[^\"]*)\")?"
													"(?:\\s*\\w+=\"(?:[^\"]*)\")*"		//Capture and discard all extra use-expands
													"(?:\\s*(\\d*(,\\d*)*)\\s(?:Ki|k)B)?")); //->Emerge

auto pkgsplit( const QString& package ) -> const QStringList
{
// The original code was pretty similar to what portage does in versions.py, but this time it'll be a more direct port
#define _pkg "[\\w+][\\w+-]*?"
#define _rev "\\d+"
#define _v "(\\d+)((\\.\\d+)*)([a-z]?)((_(pre|p|beta|alpha|rc)\\d*)*)"
#define _vr _v "(-r(" _rev "))?"
#define _pv "(?<pn>" _pkg "(?P<pn_inval>-" _vr ")?)-(?P<ver>" _v ")(-r(?P<rev>" _rev "))?"
#define _pv_re "^" _pv "$"
	static QRegularExpression rxNameVersion(QStringLiteral(_pv_re));
#undef _pv_re
#undef _pv
#undef _vr
#undef _v
#undef _rev
#undef _pkg
	auto match = rxNameVersion.match( package );
	if ( ! match.hasMatch() )
		return QStringList();
	auto pn_inval = match.captured( QStringLiteral("pn_inval") );
	if ( !pn_inval.isEmpty() )
		// package name appears to have a version-like suffix
		return QStringList();
	auto rev = match.captured( QStringLiteral("rev") );
	if ( rev.isEmpty() )
		rev = u'0';
	rev = u'r' + rev;
	return { match.captured( QStringLiteral("pn") ), match.captured( QStringLiteral("ver") ), rev };
}

auto parsePackage( const QString& packageString ) -> const QStringList
{
	static QRegularExpression rxCat(QStringLiteral("^[\\w+][\\w+.-]*$"));
	QStringList list;
	QString nameVersion( packageString );
	nameVersion.remove( u' ' );

	// Parse out the category first
	auto parts = nameVersion.split( u'/' );
	if ( parts.size() == 2 ) {
		if ( rxCat.match( parts[0] ).hasMatch() ) {
			list << parts[0];
			nameVersion = parts[1];
		} else
			qWarning() << __FUNCTION__ << parts[0] << "isn't a valid category name";
	} else if ( parts.size() == 1 )
		list << QString();
	else
		qWarning() << __FUNCTION__ << packageString << "had too many slashes!";

	// Now package name and version
	return list << pkgsplit( nameVersion );
}

auto formatTime( long duration ) -> const QString
{
	QString totalDays;
	int durationDays = 0, totalSeconds = 0;

	durationDays = duration / 86400;
	totalSeconds = duration % 86400;

	if ( durationDays > 0 ) {
		totalDays = i18n( "%1d ", QString::number( durationDays ) );
	}

	QTime emergeTime( 0, 0, 0 );
	emergeTime = emergeTime.addSecs( totalSeconds );
	return totalDays + emergeTime.toString();
}
