/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.mindmap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.image.FigureRenderer;
import org.xmind.gef.image.IExportAreaProvider;
import org.xmind.gef.image.IExportSourceProvider;
import org.xmind.gef.image.ImageExportUtils;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.layers.BackgroundLayer;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapExportViewer;
import org.xmind.ui.mindmap.MindMapViewerExportSourceProvider;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.viewers.ICompositeProvider;

public class MindMapImageExporter {
    private Display display = null;
    private MindMapViewerExportSourceProvider sourceProvider = null;
    private Object input = null;
    private ICompositeProvider parent = null;
    private Insets margins = null;
    private Properties properties = null;
    private int resizeStrategy = 0;
    private int wHint = -1;
    private int hHint = -1;
    private ImageFormat format = ImageFormat.PNG;
    private OutputStream targetStream = null;
    private File targetFile = null;
    private IWorkbook targetWorkbook = null;
    private String targetEntryPath = null;
    private boolean ignoreEntryEncryption = true;
    private GhostShellProvider ghostShellProvider = null;
    private IGraphicalViewer exportViewer = null;
    private OutputStream streamToClose = null;
    private IFileEntry fileEntry = null;
    private IExportAreaProvider area = null;

    public MindMapImageExporter(Display display) {
        this.display = display;
    }

    public void setResize(int strategy, int wHint, int hHint) {
        this.resizeStrategy = strategy;
        this.wHint = wHint;
        this.hHint = hHint;
    }

    public void setImageFormat(ImageFormat format) {
        this.format = format;
    }

    public void setSourceProvider(MindMapViewerExportSourceProvider sourceProvider) {
        this.setSources(sourceProvider, null, null, null, null);
    }

    public void setSourceViewer(IGraphicalViewer viewer) {
        this.setSources(new MindMapViewerExportSourceProvider(viewer, 15), null, null, null, null);
    }

    public void setSourceViewer(IGraphicalViewer viewer, Insets margins) {
        this.setSources(new MindMapViewerExportSourceProvider(viewer, margins), null, null, null, null);
    }

    public void setSourceViewer(IGraphicalViewer viewer, ICompositeProvider parent, Properties properties, Insets margins) {
        IMindMap map = (IMindMap)viewer.getAdapter(IMindMap.class);
        if (map == null || map.getCentralTopic() == map.getSheet().getRootTopic()) {
            this.setSourceViewer(viewer, margins);
        } else {
            this.setSource(new MindMap(map.getSheet()), parent, properties, margins);
        }
    }

    public void setSource(Object input, Properties properties, Insets margins) {
        this.setSources(null, input, null, properties, margins);
    }

    public void setSource(Object input, ICompositeProvider parent, Properties properties, Insets margins) {
        this.setSources(null, input, parent, properties, margins);
    }

    protected void setSources(MindMapViewerExportSourceProvider sourceProvider, Object input, ICompositeProvider parent, Properties properties, Insets margins) {
        this.sourceProvider = sourceProvider;
        this.input = input;
        this.parent = parent;
        this.properties = properties;
        this.margins = margins;
        this.cleanUpSources();
    }

    public void setTargetStream(OutputStream stream) {
        this.setTargets(stream, null, null, null, true);
    }

    public void setTargetFile(File file) {
        this.setTargets(null, file, null, null, true);
    }

    public void setTargetFileEntry(IWorkbook workbook, String entryPath) {
        this.setTargets(null, null, workbook, entryPath, true);
    }

    public void setTargetWorkbook(IWorkbook workbook) {
        this.setTargets(null, null, workbook, null, true);
    }

    public void setTargetFileEntry(IWorkbook workbook, String entryPath, boolean ignoreEncryption) {
        this.setTargets(null, null, workbook, entryPath, ignoreEncryption);
    }

    public void setTargetFileEntry(IWorkbook workbook, boolean ignoreEncryption) {
        this.setTargets(null, null, workbook, null, ignoreEncryption);
    }

    protected void setTargets(OutputStream stream, File file, IWorkbook workbook, String entryPath, boolean ignoreEncryption) {
        this.targetStream = stream;
        this.targetFile = file;
        this.targetWorkbook = workbook;
        this.targetEntryPath = entryPath;
        this.ignoreEntryEncryption = ignoreEncryption;
        this.cleanUpTargets();
    }

    public MindMapViewerExportSourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public Point calcRelativeOrigin() {
        if (this.sourceProvider == null || this.area == null) {
            return null;
        }
        Point origin = this.sourceProvider.getOriginPoint();
        Rectangle bounds = this.area.getExportArea();
        return bounds.getLocation().negate().translate(origin);
    }

    public void initRenderer(FigureRenderer renderer) {
        if (this.sourceProvider == null) {
            this.prepareSourceProvider();
        }
        if (this.area == null) {
            this.area = ImageExportUtils.createExportAreaProvider((Rectangle)this.sourceProvider.getSourceArea(), (int)this.resizeStrategy, (int)this.wHint, (int)this.hHint, (Insets)this.sourceProvider.getMargins());
        }
        renderer.init((IExportSourceProvider)this.sourceProvider, this.area);
    }

    public Image createImage() {
        this.prepareSourceProvider();
        try {
            final FigureRenderer renderer = new FigureRenderer();
            this.initRenderer(renderer);
            final Image[] image = new Image[1];
            final Throwable[] error = new Throwable[1];
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Rectangle bounds = renderer.getBounds();
                        Image img = new Image((Device)MindMapImageExporter.this.display, bounds.width, bounds.height);
                        GC gc = new GC((Drawable)img);
                        if (MindMapImageExporter.this.resizeStrategy == 1) {
                            IFigure[] iFigureArray = renderer.getFigures();
                            int n = iFigureArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IFigure figure = iFigureArray[n2];
                                if (figure instanceof BackgroundLayer) {
                                    Rectangle figureBounds = figure.getBounds();
                                    int longerSideLength = figureBounds.width > figureBounds.height ? figureBounds.width : figureBounds.height;
                                    figure.setBounds(new Rectangle(-longerSideLength, -longerSideLength, longerSideLength * 2, longerSideLength * 2));
                                }
                                ++n2;
                            }
                        }
                        try {
                            renderer.render(gc);
                        }
                        finally {
                            gc.dispose();
                        }
                        image[0] = img;
                    }
                    catch (RuntimeException e) {
                        error[0] = e;
                    }
                    catch (Error e) {
                        error[0] = e;
                    }
                }
            });
            if (error[0] != null) {
                throw new RuntimeException(error[0].getMessage(), error[0]);
            }
            Image image2 = image[0];
            return image2;
        }
        finally {
            this.cleanUpSources();
        }
    }

    public void export() {
        Image image = this.createImage();
        try {
            this.export(image);
        }
        finally {
            image.dispose();
        }
    }

    public void export(Image image) {
        this.prepareTargetStream();
        try {
            ImageExportUtils.saveImage((Image)image, (OutputStream)this.targetStream, (int)this.format.getSWTFormat());
            if (this.fileEntry != null) {
                this.fileEntry.decreaseReference();
                this.fileEntry.increaseReference();
                this.fileEntry = null;
            }
        }
        finally {
            this.cleanUpTargets();
        }
    }

    public void export(InputStream sourceStream) throws IOException {
        this.prepareTargetStream();
        try {
            FileUtils.transfer((InputStream)sourceStream, (OutputStream)this.targetStream, (boolean)true);
            if (this.fileEntry != null) {
                this.fileEntry.decreaseReference();
                this.fileEntry.increaseReference();
                this.fileEntry = null;
            }
        }
        finally {
            this.cleanUpTargets();
        }
    }

    public void prepareSourceProvider() {
        this.cleanUpSources();
        if (this.input != null) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MindMapImageExporter.this.recreateSourceProviderFromInput();
                }
            });
        }
        if (this.sourceProvider == null) {
            throw new IllegalArgumentException("No source to export image from");
        }
    }

    private void recreateSourceProviderFromInput() {
        if (this.parent != null && this.parent.getParent() != null) {
            this.exportViewer = new MindMapExportViewer(this.parent, this.input, this.properties);
        } else {
            this.ghostShellProvider = new GhostShellProvider(this.display);
            this.exportViewer = new MindMapExportViewer(this.ghostShellProvider, this.input, this.properties);
        }
        this.sourceProvider = this.margins != null ? new MindMapViewerExportSourceProvider(this.exportViewer, this.margins) : new MindMapViewerExportSourceProvider(this.exportViewer);
    }

    public void prepareTargetStream() {
        this.cleanUpTargets();
        if (this.targetFile != null) {
            this.recreateTargetStreamFromFile();
        } else if (this.targetWorkbook != null) {
            this.recreateTargetStreamFromFileEntry();
        }
        if (this.targetStream == null) {
            throw new IllegalArgumentException("No target to export image to");
        }
    }

    private void recreateTargetStreamFromFileEntry() {
        IManifest manifest = this.targetWorkbook.getManifest();
        String entryPath = this.targetEntryPath;
        if (entryPath == null) {
            entryPath = MindMapImageExporter.toThumbnailArchivePath(this.format);
        }
        this.fileEntry = manifest.createFileEntry(entryPath, this.format.getMediaType());
        try {
            this.targetStream = this.fileEntry.openOutputStream();
        }
        catch (IOException iOException) {}
        this.streamToClose = this.targetStream;
    }

    private void recreateTargetStreamFromFile() {
        FileUtils.ensureFileParent((File)this.targetFile);
        try {
            this.streamToClose = this.targetStream = new FileOutputStream(this.targetFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void cleanUpSources() {
        if (this.exportViewer != null) {
            if (this.exportViewer.getControl() != null) {
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MindMapImageExporter.this.exportViewer.getControl().dispose();
                    }
                });
            }
            this.exportViewer = null;
        }
        if (this.ghostShellProvider != null) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MindMapImageExporter.this.ghostShellProvider.dispose();
                }
            });
            this.ghostShellProvider = null;
        }
    }

    public void cleanUpTargets() {
        if (this.streamToClose != null) {
            try {
                this.streamToClose.close();
            }
            catch (IOException iOException) {}
            this.streamToClose = null;
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getBackgroundColor() {
        return MindMapImageExporter.getBackgroundColor(this.getSourceProvider().getViewer());
    }

    public static String toThumbnailArchivePath(ImageFormat format) {
        return "Thumbnails/thumbnail" + (String)format.getExtensions().get(0);
    }

    private static String getBackgroundColor(IGraphicalViewer sourceViewer) {
        Color color;
        Layer layer;
        if (sourceViewer != null && (layer = sourceViewer.getLayer(GEF.LAYER_BACKGROUND)) != null && (color = layer.getBackgroundColor()) != null) {
            return ColorUtils.toString((Color)color);
        }
        return "#ffffff";
    }
}

