/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.Page;
import org.xmind.core.IMeta;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyMetadataCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.views.RevisionsPage;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.tabfolder.PageBookPage;

public class WorkbookRevisionsPage
extends PageBookPage
implements ICoreEventListener,
Listener,
IPropertyListener {
    private static final String K_AUTO_SAVE = "Configurations/AutoRevisionGeneration";
    private static final String V_YES = "Yes";
    private static final String V_NO = "No";
    private Button autoSaveOption = null;
    private IWorkbook workbook;
    private ICoreEventRegistration coreEventReg = null;
    private Composite container;

    public WorkbookRevisionsPage(IGraphicalEditor editor) {
        super((IPageChangeProvider)editor);
        this.workbook = (IWorkbook)editor.getAdapter(IWorkbook.class);
    }

    public IGraphicalEditor getEditor() {
        return (IGraphicalEditor)super.getSourcePageProvider();
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.container.setLayout((Layout)gridLayout);
        Composite contentContainer = new Composite(this.container, 0);
        contentContainer.setLayout((Layout)new FillLayout());
        GridData contentLayoutData = new GridData(4, 4, true, true);
        contentLayoutData.widthHint = -1;
        contentLayoutData.heightHint = -1;
        contentContainer.setLayoutData((Object)contentLayoutData);
        super.createControl(contentContainer);
        Composite optionContainer = new Composite(this.container, 0);
        GridLayout optionLayout = new GridLayout(1, false);
        optionLayout.marginWidth = 5;
        optionLayout.marginHeight = 5;
        optionLayout.verticalSpacing = 5;
        optionLayout.horizontalSpacing = 5;
        optionContainer.setLayout((Layout)optionLayout);
        GridData optionLayoutData = new GridData(4, 4, true, false);
        optionLayoutData.widthHint = -1;
        optionLayoutData.heightHint = -1;
        optionContainer.setLayoutData((Object)optionLayoutData);
        this.fillOptions(optionContainer);
        this.handleWorkbookChange();
        this.getEditor().addPropertyListener((IPropertyListener)this);
        this.autoSaveOption.addListener(13, (Listener)this);
    }

    public Control getControl() {
        return this.container;
    }

    public void dispose() {
        this.getEditor().removePropertyListener((IPropertyListener)this);
        if (this.coreEventReg != null) {
            this.coreEventReg.unregister();
            this.coreEventReg = null;
        }
        super.dispose();
    }

    private void fillOptions(Composite parent) {
        this.autoSaveOption = new Button(parent, 96);
        this.autoSaveOption.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        this.autoSaveOption.setText(MindMapMessages.WorkbookRevisionsPage_AutoSaveRevisionsCheck_text);
        this.autoSaveOption.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected Control createDefaultPage(Composite parent) {
        return new Composite(parent, 0);
    }

    protected Page doCreateNestedPage(Object sourcePage) {
        return new RevisionsPage((IGraphicalEditorPage)sourcePage);
    }

    protected void refreshGlobalActionHandlers() {
        super.refreshGlobalActionHandlers();
        IActionRegistry registry = (IActionRegistry)this.getEditor().getAdapter(IActionRegistry.class);
        if (registry != null) {
            this.initGlobalActionHandlers(this.getSite().getActionBars(), registry);
        }
    }

    protected void initGlobalActionHandlers(IActionBars bars, IActionRegistry registry) {
        this.setGlobalActionHandler(bars, registry, ActionFactory.UNDO.getId());
        this.setGlobalActionHandler(bars, registry, ActionFactory.REDO.getId());
    }

    protected void setGlobalActionHandler(IActionBars bars, IActionRegistry registry, String actionId) {
        IAction action = registry.getAction(actionId);
        if (action != null) {
            bars.setGlobalActionHandler(actionId, action);
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        if (K_AUTO_SAVE.equals(event.getTarget())) {
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WorkbookRevisionsPage.this.updateAutoSaveOption();
                }
            });
        }
    }

    private void updateAutoSaveOption() {
        if (this.workbook != null) {
            this.autoSaveOption.setEnabled(true);
            this.autoSaveOption.setSelection(WorkbookRevisionsPage.isAutoSave(this.workbook));
        } else {
            this.autoSaveOption.setEnabled(false);
        }
    }

    private static final boolean isAutoSave(IWorkbook workbook) {
        String value = workbook.getMeta().getValue(K_AUTO_SAVE);
        return value == null || V_YES.equalsIgnoreCase(value);
    }

    public void handleEvent(Event event) {
        if (event.type == 13) {
            boolean selection = ((Button)event.widget).getSelection();
            ModifyMetadataCommand command = new ModifyMetadataCommand(this.workbook, K_AUTO_SAVE, selection ? V_YES : V_NO);
            command.setLabel(selection ? CommandMessages.Command_TurnOnAutoRevisionSaving : CommandMessages.Command_TurnOffAutoRevisionSaving);
            ICommandStack commandStack = this.getEditor().getCommandStack();
            if (commandStack != null) {
                commandStack.execute((Command)command);
            } else {
                command.execute();
            }
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 258) {
            this.handleWorkbookChange();
        }
    }

    private void handleWorkbookChange() {
        IMeta meta;
        if (this.coreEventReg != null) {
            this.coreEventReg.unregister();
            this.coreEventReg = null;
        }
        this.workbook = (IWorkbook)this.getEditor().getAdapter(IWorkbook.class);
        if (this.workbook != null && (meta = this.workbook.getMeta()) instanceof ICoreEventSource) {
            this.coreEventReg = ((ICoreEventSource)meta).registerCoreEventListener("metadata", (ICoreEventListener)this);
        }
        this.updateAutoSaveOption();
    }
}

