/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmind.core.style.IStyle;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.XMLUtils;
import org.xml.sax.SAXException;

public class ThemeGroupCore {
    private static ThemeGroupCore instance = null;
    private static final String GROUP_ID = "id";
    private static final String GROUP_NAME = "name";
    private static final String THEME_ID = "id";
    private static final String THEME_GROUP = "theme-group";
    private static final String THEME_ELEMENT = "theme";
    private static final String DEFAULT_GROUP_ID = "default";
    private static final String USER_GROUP_ID = "user";
    private static final String PATH_STYLES = "styles/";
    private static final String THEME_GROUP_XML = "themeGroups.xml";
    private static final String THEME_PROPERTIES = "themeGroups.properties";
    private List<CategorizedThemeGroup> systemGroups = null;
    private Properties properties = null;
    private CategorizedThemeGroup defaultThemeGroup = null;

    private ThemeGroupCore() {
    }

    public List<CategorizedThemeGroup> getThemeGroups() {
        ArrayList<CategorizedThemeGroup> list = new ArrayList<CategorizedThemeGroup>();
        list.add(this.getDefaultGroup());
        list.addAll(this.getSystemGroups());
        CategorizedThemeGroup group = this.getUserGroup();
        if (group.getItems() != null && !group.getItems().isEmpty()) {
            list.add(group);
        }
        return list;
    }

    private CategorizedThemeGroup getUserGroup() {
        IResourceManager rm = MindMapUI.getResourceManager();
        Set userThemeSets = rm.getUserThemeSheet().getStyles("master-styles");
        ArrayList<IStyle> userThemeList = new ArrayList<IStyle>();
        for (IStyle userStyle : userThemeSets) {
            userThemeList.add(userStyle);
        }
        CategorizedThemeGroup userGroup = new CategorizedThemeGroup(USER_GROUP_ID, MindMapMessages.ThemeGroupCore_UserGroup_name, userThemeList);
        return userGroup;
    }

    private List<CategorizedThemeGroup> getSystemGroups() {
        if (this.systemGroups == null) {
            this.systemGroups = this.createSystemGroups();
        }
        return this.systemGroups;
    }

    private List<CategorizedThemeGroup> createSystemGroups() {
        IResourceManager rm = MindMapUI.getResourceManager();
        Set systemThemeSets = rm.getSystemThemeSheet().getStyles("master-styles");
        Bundle bundle = Platform.getBundle((String)"org.xmind.ui");
        String path = "styles/themeGroups.xml";
        DocumentBuilder documentBuilder = null;
        ArrayList<CategorizedThemeGroup> systemGroups = new ArrayList<CategorizedThemeGroup>();
        try {
            documentBuilder = XMLUtils.getDefaultDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        try {
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
            Document doc = documentBuilder.parse(url.openStream());
            NodeList nodeList = doc.getElementsByTagName(THEME_GROUP);
            int i = 0;
            while (i < nodeList.getLength()) {
                Element ele = (Element)nodeList.item(i);
                String groupId = ele.getAttribute("id");
                String groupName = ele.getAttribute(GROUP_NAME).substring(1);
                groupName = this.getProperties().getProperty(groupName);
                NodeList themeList = ele.getElementsByTagName(THEME_ELEMENT);
                ArrayList<IStyle> themeGroupList = new ArrayList<IStyle>();
                int j = 0;
                while (j < themeList.getLength()) {
                    Element theme = (Element)themeList.item(j);
                    String themeId = theme.getAttribute("id");
                    for (IStyle themeStyle : systemThemeSets) {
                        if (!themeId.equals(themeStyle.getId())) continue;
                        themeGroupList.add(themeStyle);
                        systemThemeSets.remove(themeStyle);
                        break;
                    }
                    ++j;
                }
                CategorizedThemeGroup themeGroup = new CategorizedThemeGroup(groupId, groupName, themeGroupList);
                systemGroups.add(themeGroup);
                ++i;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return systemGroups;
    }

    private CategorizedThemeGroup getDefaultGroup() {
        IResourceManager rm = MindMapUI.getResourceManager();
        IStyle defaultTheme = rm.getDefaultTheme();
        ArrayList<IStyle> defaultThemeList = new ArrayList<IStyle>();
        defaultThemeList.add(defaultTheme);
        this.defaultThemeGroup = new CategorizedThemeGroup(DEFAULT_GROUP_ID, MindMapMessages.ThemeGroupCore_DefaultGroup_name, defaultThemeList);
        return this.defaultThemeGroup;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
        return this.properties;
    }

    private Properties loadProperties() {
        Properties properties;
        block12: {
            Bundle bundle = Platform.getBundle((String)"org.xmind.ui");
            URL propertiesUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("styles/themeGroups.properties"), null);
            properties = new Properties();
            InputStream stream = null;
            try {
                try {
                    stream = propertiesUrl.openStream();
                    properties.load(stream);
                }
                catch (IOException e) {
                    Logger.log(e, "Failed to load default properties file from: themeGroups.properties");
                    if (stream == null) break block12;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return properties;
    }

    public static ThemeGroupCore getInstance() {
        if (instance == null) {
            instance = new ThemeGroupCore();
        }
        return instance;
    }

    public class CategorizedThemeGroup {
        List<IStyle> items = new ArrayList<IStyle>();
        private String name;
        private String id;

        public CategorizedThemeGroup(String id, String name, List<IStyle> items) {
            this.id = id;
            this.name = name;
            this.items = items;
        }

        public String getName() {
            return this.name;
        }

        public List<IStyle> getItems() {
            return this.items;
        }

        public String getId() {
            return this.id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof CategorizedThemeGroup)) {
                return false;
            }
            return ((CategorizedThemeGroup)obj).id.equals(this.id);
        }
    }
}

