/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.ui.internal.editor.AuthorInfoEditor;

public abstract class AuthorInfoViewer {
    private Composite composite;
    private Composite displayWrap;
    private Label display;
    private Composite editorWrap;
    private StackLayout stack;
    private AuthorInfoEditor editor;

    public AuthorInfoViewer(Composite parent) {
        this.createControl(parent);
        this.setEditorVisible(true);
    }

    private void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(parent.getBackground());
        this.stack = new StackLayout();
        this.composite.setLayout((Layout)this.stack);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDisplayWrap(this.composite);
        this.createEditorWrap(this.composite);
    }

    private void createDisplayWrap(Composite parent) {
        this.displayWrap = new Composite(parent, 0);
        this.displayWrap.setBackground(parent.getBackground());
        GridLayout displayWrapLayout = new GridLayout(2, false);
        displayWrapLayout.marginWidth = 5;
        displayWrapLayout.marginHeight = 0;
        displayWrapLayout.verticalSpacing = 0;
        displayWrapLayout.horizontalSpacing = 5;
        this.displayWrap.setLayout((Layout)displayWrapLayout);
        this.createDisplay(this.displayWrap);
    }

    private void createDisplay(Composite parent) {
        this.display = new Label(parent, 0);
        this.display.setBackground(parent.getBackground());
        this.display.setForeground(parent.getDisplay().getSystemColor(15));
        this.display.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
    }

    private void createEditorWrap(Composite parent) {
        this.editorWrap = new Composite(parent, 0);
        this.editorWrap.setBackground(parent.getBackground());
        this.editorWrap.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout durationLayout = new GridLayout(1, false);
        durationLayout.marginWidth = 0;
        durationLayout.marginHeight = 0;
        durationLayout.verticalSpacing = 0;
        durationLayout.horizontalSpacing = 0;
        this.editorWrap.setLayout((Layout)durationLayout);
        this.createEditor(this.editorWrap);
    }

    protected void editLinkActivated() {
        this.editor.startEditing();
    }

    protected void createEditor(Composite parent) {
        this.editor = new AuthorInfoEditor(parent);
        this.editor.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor.addEditorListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
                AuthorInfoViewer.this.refresh();
            }

            public void applyEditorValue() {
                AuthorInfoViewer.this.changeContent();
            }
        });
    }

    protected abstract void refresh();

    protected abstract void changeContent();

    protected void setEditorFocus() {
        this.editor.setFocus();
    }

    public void setEditorVisible(boolean editing) {
        if (!this.composite.isDisposed()) {
            if (editing) {
                this.stack.topControl = this.editorWrap;
                this.displayWrap.setVisible(false);
                this.editorWrap.setVisible(true);
            } else {
                this.stack.topControl = this.displayWrap;
                this.displayWrap.setVisible(true);
                this.editorWrap.setVisible(false);
            }
            this.composite.layout();
            this.editorWrap.layout();
            this.displayWrap.layout();
        }
    }

    public boolean isEditorVisible() {
        return !this.composite.isDisposed() && this.stack.topControl == this.editorWrap;
    }

    public Label getDisplay() {
        return this.display;
    }

    public Control getControl() {
        return this.composite;
    }

    public AuthorInfoEditor getEditor() {
        return this.editor;
    }

    public void setEditor(AuthorInfoEditor editor) {
        this.editor = editor;
    }

    public void setEnabled(boolean enabled) {
        this.editor.setEnabled(enabled);
    }

    public void setFocus() {
        if (this.isEditorVisible()) {
            this.setEditorFocus();
        }
    }
}

