/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.EditDomain;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryNavigablePolicy;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.wizards.TemplateLabelProvider;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.ITemplateGroup;
import org.xmind.ui.mindmap.MindMapUI;

public class NewSheetFromTemplateDialog
extends Dialog
implements ISelectionChangedListener,
IOpenListener {
    private static final int FRAME_WIDTH = 130;
    private static final int FRAME_HEIGHT = 90;
    private ITemplate template;
    private Button chooseButton;
    private boolean chooseButtonVisible;

    public NewSheetFromTemplateDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MindMapMessages.NewSheetFromTemplateDialog_text);
    }

    protected Point getInitialSize() {
        return new Point(531, 540);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(1232);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        NewSheetFromTemplateDialog.applyDialogFont((Control)composite);
        Control pageContent = this.createTemplatesContainer(composite);
        pageContent.setVisible(true);
        return composite;
    }

    private Control createTemplatesContainer(Composite parent) {
        GalleryViewer viewer = new GalleryViewer();
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new GallerySelectTool());
        editDomain.installEditPolicy("org.xmind.ui.gallery.editPolicy.navigable", (IEditPolicy)new GalleryNavigablePolicy());
        viewer.setEditDomain(editDomain);
        Properties properties = viewer.getProperties();
        properties.set("org.xmind.ui.gallery.wrap", true);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("org.xmind.ui.gallery.horizontal", true);
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(130, 90));
        properties.set("constrained", true);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 1, 10, 10, 10, 10, 10, 10));
        Control control = viewer.createControl(parent, 2048);
        control.setLayoutData((Object)new GridData(1808));
        viewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        List<ITemplate> templates = this.loadTemplatesViewerInput();
        this.template = templates.get(0);
        viewer.setInput(templates);
        if (templates.size() > 0) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)templates.get(0)), true);
        }
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.addOpenListener((IOpenListener)this);
        return control;
    }

    private List<ITemplate> loadTemplatesViewerInput() {
        ArrayList<ITemplate> templates = new ArrayList<ITemplate>();
        IResourceManager resourceManager = MindMapUI.getResourceManager();
        List<ITemplateGroup> groups = resourceManager.getSystemTemplateGroups();
        for (ITemplateGroup group : groups) {
            templates.addAll(group.getTemplates());
        }
        templates.addAll(resourceManager.getUserTemplates());
        return templates;
    }

    public ITemplate getTemplate() {
        return this.template;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.chooseButton = this.createButton(parent, 0, MindMapMessages.NewSheetFromTemplateDialog_button_Choose, true);
    }

    public void open(OpenEvent event) {
        this.okPressed();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof StructuredSelection) {
            Object selectedObject = ((StructuredSelection)event.getSelection()).getFirstElement();
            if (selectedObject instanceof ITemplate) {
                this.template = (ITemplate)selectedObject;
                this.chooseButtonVisible = true;
            } else {
                this.chooseButtonVisible = false;
            }
            this.chooseButton.setEnabled(this.chooseButtonVisible);
        }
    }
}

