/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.ViewComparator;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.ui.blackbox.BlackBox;
import org.xmind.ui.blackbox.BlackBoxManager;
import org.xmind.ui.blackbox.IBlackBoxMap;
import org.xmind.ui.blackbox.IBlackBoxVersion;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.views.Messages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;

public class BlackBoxDialog
extends Dialog
implements ICoreEventListener,
ISelectionChangedListener {
    private static final String MAP_REMOVE = "mapRemove";
    private static final String VERSION_REMOVE = "versionRemove";
    private static final String VERSION_ADD = "versionAdd";
    private static final int DELETE_BUTTON_ID = 1025;
    private TreeViewer viewer;
    private MenuManager contextMenu;
    private CoreEventRegister coreEventRegister = new CoreEventRegister((ICoreEventListener)this);
    private IAction openAction;
    private IAction deleteAction;
    private Button openButton;
    private Button deleteButton;
    private IStructuredSelection currentSelection;

    public BlackBoxDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(3312);
        this.setBlockOnOpen(false);
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MindMapMessages.BlackBoxDialog_title);
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 14;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDescriptionArea(composite);
        this.createContentArea(composite);
        this.fillAndRegisterMenu();
        this.registerCoreEvent();
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 13;
        layout.marginHeight = 23;
        layout.horizontalSpacing = 18;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    private void createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        Control viewerControl = this.createViewer(composite);
        viewerControl.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setBackground(parent.getBackground());
        GridLayout middleLayerLayout = new GridLayout(1, false);
        middleLayerLayout.marginWidth = 0;
        middleLayerLayout.marginHeight = 18;
        composite.setLayout((Layout)middleLayerLayout);
        Label descriptionLabel = new Label(composite, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        descriptionLabel.setBackground(composite.getBackground());
        descriptionLabel.setText(Messages.BlackBoxView_Description_text);
        descriptionLabel.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
    }

    private Control createViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 66050);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new BlackBoxContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new BlackBoxLabelProvide());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        TreeViewerColumn col0 = new TreeViewerColumn(this.viewer, 16384);
        col0.getColumn().setText(Messages.BlackBoxView_Versions);
        col0.getColumn().setWidth(200);
        col0.setLabelProvider((CellLabelProvider)new VersionsLabelProvider());
        TreeViewerColumn col1 = new TreeViewerColumn(this.viewer, 16384);
        col1.getColumn().setText(Messages.BlackBoxView_Info);
        col1.getColumn().setWidth(268);
        col1.setLabelProvider((CellLabelProvider)new VersionsInfoLabelProvider());
        this.viewer.setInput((Object)BlackBox.getMaps());
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setComparator((ViewerComparator)new BlackBoxComparator());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new VersionOpenListener());
        return this.viewer.getControl();
    }

    private void fillAndRegisterMenu() {
        this.openAction = new OpenReversionAction();
        this.openAction.setText(Messages.BlackBoxView_OpenVersion);
        this.openAction.setToolTipText(Messages.BlackBoxView_OpenVersion);
        this.openAction.setImageDescriptor(MindMapUI.getImages().get("fldr_obj.gif", true));
        this.openAction.setDisabledImageDescriptor(MindMapUI.getImages().get("fldr_obj.gif", false));
        this.deleteAction = new DeleteBackupsAction();
        this.deleteAction.setText(Messages.BlackBoxView_DeleteBackups);
        this.deleteAction.setToolTipText(Messages.BlackBoxView_DeleteBackups);
        this.deleteAction.setImageDescriptor(MindMapUI.getImages().get("remove.png", true));
        this.deleteAction.setDisabledImageDescriptor(MindMapUI.getImages().get("remove.png", false));
        MenuManager menu = new MenuManager();
        menu.add(this.openAction);
        menu.add(this.deleteAction);
        menu.add((IContributionItem)new Separator("additions"));
        this.contextMenu = new MenuManager("#PopupMenu");
        this.contextMenu.add(this.openAction);
        this.contextMenu.add(this.deleteAction);
        this.viewer.getControl().setMenu(this.contextMenu.createContextMenu(this.viewer.getControl()));
    }

    private void registerCoreEvent() {
        this.coreEventRegister.setNextSourceFrom((Object)BlackBoxManager.getInstance().getLibrary());
        this.coreEventRegister.register(VERSION_ADD);
        this.coreEventRegister.register(VERSION_REMOVE);
        this.coreEventRegister.register(MAP_REMOVE);
    }

    protected void initializeBounds() {
        this.getShell().setBounds(300, 150, 516, 500);
        super.initializeBounds();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.openButton = this.createButton(parent, 11, Messages.BlackBoxView_OpenVersion, false);
        this.openButton.setEnabled(false);
        this.deleteButton = this.createButton(parent, 1025, Messages.BlackBoxView_DeleteBackups, false);
        this.deleteButton.setEnabled(false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (11 == buttonId) {
            this.handleOpen((ISelection)this.currentSelection);
        } else if (12 == buttonId) {
            this.handleClose();
        } else if (1025 == buttonId) {
            this.handleDelete();
        }
    }

    private void handleOpen(ISelection selection) {
        IStructuredSelection ss;
        File reversionFile = null;
        IBlackBoxMap map = null;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            Object element = ss.getFirstElement();
            if (element instanceof IBlackBoxVersion) {
                reversionFile = ((IBlackBoxVersion)element).getFile();
                map = ((IBlackBoxVersion)element).getMap();
            } else if (element instanceof IBlackBoxMap) {
                if (this.viewer.getExpandedState(element)) {
                    this.viewer.collapseToLevel(element, 2);
                } else {
                    this.viewer.expandToLevel(element, 2);
                }
            }
        }
        if (reversionFile == null || !reversionFile.exists() || map == null) {
            return;
        }
        this.handleOpen(reversionFile, map);
    }

    private void handleOpen(File reversionFile, IBlackBoxMap map) {
        try {
            IWorkbook workbook = Core.getWorkbookBuilder().loadFromFile(reversionFile);
            IEditorInput input = MindMapUI.getEditorInputFactory().createEditorInputForPreLoadedWorkbook(workbook, new File(map.getSource()).getName());
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, "org.xmind.ui.MindMapEditor");
            if (workbook instanceof ICoreEventSource2) {
                ((ICoreEventSource2)workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private void handleDelete() {
        ArrayList<IBlackBoxMap> mapsToDelete = new ArrayList<IBlackBoxMap>();
        ArrayList<IBlackBoxVersion> versionsToDelete = new ArrayList<IBlackBoxVersion>();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object element : selection) {
            if (element instanceof IBlackBoxVersion) {
                versionsToDelete.add((IBlackBoxVersion)element);
                continue;
            }
            if (!(element instanceof IBlackBoxMap)) continue;
            mapsToDelete.add((IBlackBoxMap)element);
        }
        if (versionsToDelete.isEmpty() && mapsToDelete.isEmpty()) {
            return;
        }
        if (!versionsToDelete.isEmpty()) {
            for (IBlackBoxVersion version : versionsToDelete) {
                IBlackBoxMap map = version.getMap();
                BlackBox.removeVersion(map, version.getTimestamp());
            }
        }
        if (!mapsToDelete.isEmpty()) {
            for (IBlackBoxMap blackBoxMap : mapsToDelete) {
                BlackBox.removeMap(blackBoxMap);
            }
        }
    }

    private void handleClose() {
        this.close();
    }

    public boolean close() {
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        this.coreEventRegister.unregisterAll();
        return super.close();
    }

    public void handleCoreEvent(CoreEvent event) {
        final String type = event.getType();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BlackBoxDialog.VERSION_REMOVE.equals(type)) {
                    BlackBoxDialog.this.viewer.refresh(true);
                } else if (BlackBoxDialog.VERSION_ADD.equals(type) || BlackBoxDialog.MAP_REMOVE.equals(type)) {
                    BlackBoxDialog.this.viewer.setInput((Object)BlackBox.getMaps());
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.openAction.setEnabled(false);
        this.openButton.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.deleteButton.setEnabled(false);
        if (!(event.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        this.currentSelection = (IStructuredSelection)event.getSelection();
        ArrayList<IBlackBoxVersion> selectVersions = new ArrayList<IBlackBoxVersion>();
        ArrayList<IBlackBoxMap> selectMaps = new ArrayList<IBlackBoxMap>();
        for (Object element : this.currentSelection) {
            if (element instanceof IBlackBoxVersion) {
                selectVersions.add((IBlackBoxVersion)element);
                continue;
            }
            if (!(element instanceof IBlackBoxMap)) continue;
            selectMaps.add((IBlackBoxMap)element);
        }
        if (1 == selectVersions.size() && selectMaps.isEmpty()) {
            this.openAction.setEnabled(true);
            this.openButton.setEnabled(true);
        }
        if (!selectMaps.isEmpty() || !selectVersions.isEmpty()) {
            this.deleteAction.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    public void setDamagedFile(File damagedFile) {
        if (damagedFile == null) {
            return;
        }
        String source = damagedFile.getAbsolutePath();
        IBlackBoxMap map = BlackBox.findMapBySource(source);
        if (map != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)map), true);
        }
    }

    private class BlackBoxComparator
    extends ViewComparator {
        private BlackBoxComparator() {
        }

        public int category(Object element) {
            if (element instanceof IBlackBoxMap) {
                return 0;
            }
            if (element instanceof IBlackBoxVersion) {
                return 1;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 != null && e2 != null && e1 instanceof IBlackBoxVersion && e2 instanceof IBlackBoxVersion) {
                long time2;
                long time1 = Long.parseLong(((IBlackBoxVersion)e1).getTimestamp());
                return time1 - (time2 = Long.parseLong(((IBlackBoxVersion)e2).getTimestamp())) > 0L ? -1 : 1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private static class BlackBoxContentProvider
    implements ITreeContentProvider {
        private BlackBoxContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (IBlackBoxMap[])inputElement;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IBlackBoxMap) {
                return ((IBlackBoxMap)parentElement).getVersions().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IBlackBoxVersion) {
                return ((IBlackBoxVersion)element).getMap();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IBlackBoxMap) {
                return !((IBlackBoxMap)element).getVersions().isEmpty();
            }
            return false;
        }
    }

    private static class BlackBoxLabelProvide
    extends LabelProvider {
        private BlackBoxLabelProvide() {
        }

        public String getText(Object element) {
            if (element instanceof IBlackBoxMap) {
                String filePath = ((IBlackBoxMap)element).getSource();
                int index = filePath.lastIndexOf(File.separatorChar);
                String fileName = index <= 0 ? filePath : filePath.substring(index + 1);
                index = fileName.lastIndexOf(46);
                String fileNoExtension = index <= 0 ? fileName : fileName.substring(0, index);
                return fileNoExtension;
            }
            if (element instanceof IBlackBoxVersion) {
                return ((IBlackBoxVersion)element).getTimestamp();
            }
            return null;
        }
    }

    private class DeleteBackupsAction
    extends Action {
        public DeleteBackupsAction() {
            this.setEnabled(false);
        }

        public void run() {
            BlackBoxDialog.this.handleDelete();
        }
    }

    private class OpenReversionAction
    extends Action {
        public OpenReversionAction() {
            this.setEnabled(false);
        }

        public void run() {
            BlackBoxDialog.this.handleOpen((ISelection)BlackBoxDialog.this.currentSelection);
        }
    }

    private class VersionOpenListener
    implements IDoubleClickListener {
        private VersionOpenListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            BlackBoxDialog.this.handleOpen(event.getSelection());
        }
    }

    private class VersionsInfoLabelProvider
    extends ColumnLabelProvider {
        private VersionsInfoLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IBlackBoxMap) {
                return ((IBlackBoxMap)element).getSource();
            }
            if (element instanceof IBlackBoxVersion) {
                float fileSize = (float)((IBlackBoxVersion)element).getFile().length() / 1024.0f;
                String fss = String.valueOf(fileSize);
                int index = fss.indexOf(46);
                if (index < 0) {
                    return String.valueOf(fss) + "KB";
                }
                return String.valueOf(fss.substring(0, index + 2)) + "KB";
            }
            return null;
        }
    }

    private class VersionsLabelProvider
    extends ColumnLabelProvider {
        private VersionsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IBlackBoxMap) {
                String mapName;
                String path = ((IBlackBoxMap)element).getSource();
                int index = path.lastIndexOf(File.separatorChar);
                String string = mapName = index <= 0 ? path : path.substring(index + 1);
                if (mapName.contains(".")) {
                    mapName = mapName.substring(0, mapName.lastIndexOf(46));
                }
                return mapName;
            }
            if (element instanceof IBlackBoxVersion) {
                Long timestamp = Long.valueOf(((IBlackBoxVersion)element).getTimestamp());
                return String.format("%tF %tT", timestamp, timestamp);
            }
            return null;
        }

        public Image getImage(Object element) {
            ImageDescriptor image;
            if (element instanceof IBlackBoxMap && (image = MindMapUI.getImages().get("icons/xmind_file.16.png")) != null) {
                return image.createImage();
            }
            return null;
        }
    }
}

