/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.HorizontalFlipper;
import org.xmind.gef.draw2d.geometry.ITransformer;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.Insertion;
import org.xmind.ui.internal.branch.TimelineVerticalData;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;

public class TimelineVerticalHeadStructure
extends AbstractBranchStructure {
    private ITransformer t = new HorizontalFlipper();

    @Override
    protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        Point ref = info.getReference();
        int x = ref.x;
        Rectangle topicBounds = info.getCheckedClientArea();
        int y = topicBounds.bottom();
        IFigure pmFigure = plusMinus.getFigure();
        Dimension size = pmFigure.getPreferredSize();
        Rectangle r = new Rectangle(x - size.width / 2, y, size.width, size.height);
        info.put(pmFigure, r);
    }

    @Override
    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        Dimension insSize;
        Rectangle r;
        int majorSpacing = this.getMajorSpacing(branch);
        int minorSpacing = this.getMinorSpacing(branch);
        Point ref = info.getReference();
        this.t.setOrigin(ref);
        TimelineVerticalData tvd = this.getCastedData(branch);
        Rectangle refBounds = info.getCheckedClientArea();
        refBounds = this.t.tr(refBounds);
        int y = refBounds.bottom() + majorSpacing;
        IInsertion insertion = this.getCurrentInsertion(branch);
        BoundaryLayoutHelper helper = this.getBoundaryLayoutHelper(branch);
        int num = subBranches.size();
        int x = ref.x + majorSpacing;
        int yLeftBefore = y;
        int yRightBefore = y;
        int yLeft = y;
        int yRight = y;
        int i = 0;
        while (i < num) {
            this.t.setEnabled(tvd.isLeftwardBranch(i));
            if (tvd.isLeftwardBranch(i)) {
                y = yRight > yLeftBefore + majorSpacing ? yRight : yLeftBefore + majorSpacing;
            } else {
                int n = y = yLeft > yRightBefore + majorSpacing ? yLeft : yRightBefore + majorSpacing;
            }
            if (insertion != null && i == insertion.getIndex()) {
                r = insertion.createRectangle(x, y);
                info.add(this.t.rr(r));
                y += r.height + minorSpacing;
            }
            IBranchPart subBranch = subBranches.get(i);
            IFigure subBranchFigure = subBranch.getFigure();
            Insets ins = helper.getInsets(subBranch);
            ins = this.t.ti(ins);
            Dimension size = subBranchFigure.getPreferredSize();
            Rectangle r2 = new Rectangle(x + ins.left, y + ins.top, size.width, size.height);
            info.put(subBranchFigure, this.t.rr(r2));
            IFigure topicFigure = subBranch.getTopicPart().getFigure();
            if (tvd.isLeftwardBranch(i)) {
                yRightBefore = y + topicFigure.getPreferredSize().height + majorSpacing;
                yRight = y + size.height + ins.getHeight() + minorSpacing;
            } else {
                yLeftBefore = y + topicFigure.getPreferredSize().height + majorSpacing;
                yLeft = y + size.height + ins.getHeight() + minorSpacing;
            }
            ++i;
        }
        if (insertion != null && num == insertion.getIndex() && (insSize = insertion.getSize()) != null) {
            r = new Rectangle(x, y, insSize.width, insSize.height);
            info.add(this.t.rr(r));
        }
    }

    @Override
    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        if (!branch.getSubBranches().isEmpty() && "navigate_right".equals(navReqType)) {
            return this.getSubTopicPart(branch, 0);
        }
        return super.calcNavigation(branch, navReqType);
    }

    @Override
    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if ("navigate_up".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() - 1);
        }
        if ("navigate_down".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() + 1);
        }
        if (!sequential && (this.getCastedData(branch).isLeftwardBranch(sourceChild.getBranchIndex()) ? "navigate_left".equals(navReqType) : "navigate_right".equals(navReqType))) {
            return branch.getTopicPart();
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    @Override
    public int getSourceOrientation(IBranchPart branch) {
        return 4;
    }

    @Override
    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        return this.calcChildTargetOrientation(subBranch);
    }

    private int calcChildTargetOrientation(IBranchPart subBranch) {
        if (subBranch.getParentBranch() != null && this.getCastedData(subBranch.getParentBranch()).isLeftwardBranch(subBranch.getBranchIndex())) {
            return 16;
        }
        return 8;
    }

    @Override
    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        IReferencedFigure topicFigure = (IReferencedFigure)branch.getTopicPart().getFigure();
        Point ref = topicFigure.getReference();
        this.t.setOrigin(ref);
        Point childRef = this.t.tp(this.getChildRef(branch, ref, key));
        Rectangle topicBounds = this.t.tr(topicFigure.getBounds());
        List<IBranchPart> subBranches = branch.getSubBranches();
        int totalHeight = 0;
        if (!subBranches.isEmpty()) {
            int fy = subBranches.get((int)0).getFigure().getBounds().y;
            int ly = subBranches.get(subBranches.size() - 1).getFigure().getBounds().bottom();
            int sly = 0;
            if (subBranches.size() > 1) {
                sly = subBranches.get(subBranches.size() - 2).getFigure().getBounds().bottom();
            }
            totalHeight = ly > sly ? ly - fy : sly - ly;
        }
        int dy = childRef.y - topicBounds.bottom();
        int dx = childRef.x - topicBounds.right();
        if (childRef.x >= topicBounds.x - 100 && childRef.x < topicBounds.right() + 100) {
            if (dy > 0 && dy < totalHeight + 200) {
                return dy;
            }
            int d = dx * dx + dy * dy;
            return d;
        }
        return super.calcChildDistance(branch, key);
    }

    @Override
    protected Object createStructureData(IBranchPart branch) {
        return new TimelineVerticalData(branch);
    }

    @Override
    protected boolean isValidStructureData(IBranchPart branch, Object data) {
        return super.isValidStructureData(branch, data) && data instanceof TimelineVerticalData;
    }

    private TimelineVerticalData getCastedData(IBranchPart branch) {
        return (TimelineVerticalData)super.getStructureData(branch);
    }

    @Override
    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        if (branch.getSubBranches().isEmpty() || branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        ITopicPart topic = branch.getTopicPart();
        if (topic == null) {
            return withDisabled ? 0 : -1;
        }
        IFigure topicFigure = topic.getFigure();
        Point ref = ((IReferencedFigure)topicFigure).getReference();
        this.t.setOrigin(ref);
        Point childRef = this.t.tp(this.getChildRef(branch, ref, key));
        List<IBranchPart> subBranches = branch.getSubBranches();
        int y = childRef.y - ref.y;
        int ret = 0;
        for (IBranchPart sub : subBranches) {
            IFigure tf = sub.getTopicPart().getFigure();
            Point tr = ((IReferencedFigure)tf).getReference();
            int d = tr.y - ref.y;
            if (y < d) {
                return ret;
            }
            ++ret;
        }
        return withDisabled ? subBranches.size() : -1;
    }

    private Dimension calcInsSize(IBranchPart branch, ParentSearchKey key) {
        return key.getFigure().getSize().scale(0.8);
    }

    @Override
    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        return new Insertion(branch, this.calcInsIndex(branch, key, true), this.calcInsSize(branch, key));
    }

    @Override
    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        if (direction == 1) {
            return 1;
        }
        if (direction == 4) {
            return -1;
        }
        return super.getQuickMoveOffset(branch, child, direction);
    }

    @Override
    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        List<IBranchPart> enclosingBranches = summary.getEnclosingBranches();
        if (!enclosingBranches.isEmpty()) {
            IBranchPart sub = enclosingBranches.get(0);
            if (this.getCastedData(branch).isLeftwardBranch(sub.getBranchIndex())) {
                return 8;
            }
            return 16;
        }
        return 8;
    }

    @Override
    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        return 4;
    }

    public boolean isChildLeftwards(IBranchPart branch, IBranchPart child) {
        return this.getCastedData(branch).isLeftwardBranch(child.getBranchIndex());
    }

    @Override
    protected Point calcInsertPosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        int dx;
        List<IBranchPart> subBranches = branch.getSubBranches();
        if (subBranches.isEmpty()) {
            return this.calcFirstChildPosition(branch, key);
        }
        TimelineVerticalData tvd = this.getCastedData(branch);
        int majorSpacing = this.getMajorSpacing(branch);
        int index = this.calcInsIndex(branch, key, true);
        Dimension insSize = key.getFigure().getSize();
        Dimension inventSize = key.getInvent().getSize();
        int x = this.getFigureLocation((IFigure)branch.getFigure()).x;
        int n = dx = tvd.isLeftwardBranch(index) ? majorSpacing + inventSize.width / 2 : -majorSpacing - inventSize.width / 2;
        if (index < 2 && index != subBranches.size()) {
            IBranchPart sub = subBranches.get(index);
            Rectangle bounds = sub.getFigure().getBounds();
            int y = bounds.y - majorSpacing - insSize.height / 2;
            return new Point(x + dx, y);
        }
        if (index == subBranches.size()) {
            IBranchPart sub = subBranches.get(subBranches.size() - 1);
            Rectangle bounds = sub.getTopicPart().getFigure().getBounds();
            return new Point(x + dx, bounds.bottom() + majorSpacing);
        }
        return this.calcInventPosition(subBranches.get(index - 1), subBranches.get(index - 2), key, tvd.isLeftwardBranch(index));
    }

    @Override
    protected Point calcMovePosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        List<Integer> disables = this.getDisableBranches(branch);
        int index = this.calcInsIndex(branch, key, true);
        int oldIndex = this.getOldIndex(branch, child);
        if (disables != null) {
            if (disables.contains(index - 1)) {
                oldIndex = --index;
            } else if (disables.contains(index)) {
                oldIndex = index;
            }
        }
        if (index == oldIndex) {
            IBranchPart sub = subBranches.get(index);
            return this.getFigureLocation(sub.getFigure()).getTranslated(0, 0);
        }
        return this.calcInsertPosition(branch, child, key);
    }

    @Override
    protected Point calcInventPosition(IBranchPart orientation, IBranchPart assist, ParentSearchKey key, boolean isRightOrUp) {
        Dimension insSize = key.getFigure().getSize();
        int minorSpacing = this.getMinorSpacing(orientation.getParentBranch());
        int majorSpacing = this.getMajorSpacing(orientation.getParentBranch());
        IFigure tf = assist.getTopicPart().getFigure();
        Dimension ts = tf.getSize();
        int x = this.getFigureLocation((IFigure)assist.getFigure()).x + (isRightOrUp ? (-ts.width + insSize.width) / 2 : (ts.width - insSize.width) / 2);
        int y1 = assist.getFigure().getBounds().bottom() + minorSpacing;
        int y2 = orientation.getTopicPart().getFigure().getBounds().bottom() + majorSpacing;
        return new Point(x, y1 > y2 ? y1 + insSize.height / 2 : y2 + insSize.height / 2);
    }

    @Override
    protected Point calcFirstChildPosition(IBranchPart branch, ParentSearchKey key) {
        int x = this.getMajorSpacing(branch) + key.getInvent().getSize().width / 2;
        return this.getFigureLocation(branch.getFigure()).getTranslated(x, branch.getFigure().getSize().height / 2 + this.getMajorSpacing(branch) + key.getFigure().getSize().height / 2);
    }
}

