/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.ui.internal.branch.BranchPolicyManager;
import org.xmind.ui.internal.branch.IStructureDescriptor;
import org.xmind.ui.util.Logger;

class AdditionalStructure {
    private BranchPolicyManager manager;
    private IConfigurationElement element;
    private String structureId;
    private Expression condition;
    private IStructureDescriptor structure;

    public AdditionalStructure(BranchPolicyManager manager, IConfigurationElement element) throws CoreException {
        this.manager = manager;
        this.element = element;
        this.load();
    }

    private void load() throws CoreException {
        this.structureId = this.element.getAttribute("structureId");
        if (this.structureId == null) {
            throw new CoreException((IStatus)new Status(4, this.element.getNamespaceIdentifier(), 0, "Invalid extension (missing structure id)", null));
        }
        this.initializeEnablement();
    }

    private void initializeEnablement() {
        IConfigurationElement[] elements = this.element.getChildren("enablement");
        if (elements.length == 0) {
            return;
        }
        try {
            this.condition = ExpressionConverter.getDefault().perform(elements[0]);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to convert expression: " + elements[0].getNamespaceIdentifier());
        }
    }

    public boolean isApplicableTo(IEvaluationContext context) {
        if (this.condition == null) {
            return false;
        }
        try {
            return this.condition.evaluate(context) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            Logger.log(e, "Evaluation failed: " + this.condition);
            return false;
        }
    }

    public IStructureDescriptor getStructure() {
        if (this.structure == null) {
            this.structure = this.loadStructure();
        }
        return this.structure;
    }

    private IStructureDescriptor loadStructure() {
        return this.manager.getStructureDescriptor(this.structureId);
    }

    public String getStructureId() {
        return this.structureId;
    }
}

