/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import java.util.List;
import org.xmind.core.IExtensionElement;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.ideafactory.IdeaFactoryMessages;
import org.xmind.ui.internal.ideafactory.IdeaUtils;

public class DeleteIdeaGroupCommand
extends SourceCommand {
    private ITopic rootTopic;
    private ITopicExtensionElement deletedGroup;
    private ITopicExtensionElement parent;
    private int index = -1;
    private List<ITopicExtensionElement> groupIdeas;
    private ITopicExtensionElement ideaParent;

    public DeleteIdeaGroupCommand(ITopic rootTopic, ITopicExtensionElement deletedGroup) {
        super((Object)rootTopic);
        this.rootTopic = rootTopic;
        this.deletedGroup = deletedGroup;
        this.parent = (ITopicExtensionElement)deletedGroup.getParent();
        this.setLabel(IdeaFactoryMessages.DeleteIdeaGroupCommand_Name);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        if (this.index == -1) {
            List groups = this.parent.getChildren("group");
            this.index = groups.indexOf(this.deletedGroup);
        }
        this.parent.deleteChild((IExtensionElement)this.deletedGroup);
        this.deleteGroupIdeas();
        this.fireCoreEvent(this.rootTopic, "ideaGroupDeleted");
        super.redo();
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        if (this.parent != null) {
            this.parent.addChild((IExtensionElement)this.deletedGroup, this.index);
            this.addGroupIdeas();
            this.fireCoreEvent(this.rootTopic, "ideaGroupAdded");
        }
        super.undo();
    }

    private void deleteGroupIdeas() {
        if (this.groupIdeas == null) {
            this.groupIdeas = IdeaUtils.getGroupIdeas(this.deletedGroup);
        }
        if (this.groupIdeas.size() == 0) {
            return;
        }
        if (this.ideaParent == null) {
            this.ideaParent = (ITopicExtensionElement)this.groupIdeas.get(0).getParent();
        }
        for (ITopicExtensionElement idea : this.groupIdeas) {
            this.ideaParent.deleteChild((IExtensionElement)idea);
        }
    }

    private void addGroupIdeas() {
        if (this.groupIdeas == null) {
            return;
        }
        if (this.groupIdeas.size() == 0) {
            return;
        }
        if (this.ideaParent == null) {
            return;
        }
        for (ITopicExtensionElement idea : this.groupIdeas) {
            this.ideaParent.addChild((IExtensionElement)idea, -1);
        }
    }

    private void fireCoreEvent(ITopic topic, String eventType) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)topic, eventType, (Object)this.deletedGroup, this.index);
        }
    }
}

