/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.ui.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.xmind.signin.XMindNet;
import net.xmind.verify.internal.Messages;
import net.xmind.verify.internal.VerifyPlugin;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseInfoDialog2
extends Dialog {
    private static final String PROP_DISALLOWS_LICENSE_ACTIVATION = "net.xmind.verify.ui.disallowsLicenseActivation";
    private static final String ICON_PATH = "icons/dialog/";
    private static final String PREVIEW_PATH = "icons/dialog/preview/";
    private static final int ID_LICENSE = 100;
    private static final int ID_UPGRADE = 101;
    private static final Map<String, String> images = new HashMap<String, String>();
    private static final Map<String, String> titles;
    private static final Map<String, String> descriptions;
    private static final Map<String, String> hyperlinks;
    private List<String> featureKeys;
    private String featureKey;
    private int targetStatus = 0;
    private ResourceManager resources;
    private Composite stack;
    private Composite allFeaturesPage;
    private Composite singleFeaturePage;
    private Composite previewComposite;
    private Label singleDescription;
    private Label backButton;
    private Label shellTitleLabel;

    static {
        images.put("AudioNotes", "audio_notes");
        images.put("Brainstorm", "brainstorming");
        images.put("FileEncryption", "set_password");
        images.put("Gantt", "gantt_chart");
        images.put("Iconfinder", "iconfinder");
        images.put("StoryPresentation", "slide_base");
        images.put("Export", "export");
        images.put("Themes", "theme");
        titles = new HashMap<String, String>();
        titles.put("AudioNotes", Messages.LicenseInfoDialog2_AudioNotes_shellTitle);
        titles.put("Brainstorm", Messages.LicenseInfoDialog2_Brainstormind_shellTitle);
        titles.put("FileEncryption", Messages.LicenseInfoDialog2_Encryption_shellTitle);
        titles.put("Gantt", Messages.LicenseInfoDialog2_GanttChart_shellTitle);
        titles.put("Iconfinder", Messages.LicenseInfoDialog2_Iconfinder_shellTitle);
        titles.put("StoryPresentation", Messages.LicenseInfoDialog2_SlideBase_shellTitle);
        titles.put("Export", Messages.LicenseInfoDialog2_Export_shellTitle);
        titles.put("Themes", Messages.LicenseInfoDialog2_Theme_shellTitle);
        descriptions = new HashMap<String, String>();
        descriptions.put("AudioNotes", Messages.LicenseInfoDialog2_AudioNotes_description);
        descriptions.put("Brainstorm", Messages.LicenseInfoDialog2_Brainstorming_description);
        descriptions.put("FileEncryption", Messages.LicenseInfoDialog2_FileEnctyption_description);
        descriptions.put("Gantt", Messages.LicenseInfoDialog2_GanttChart_description);
        descriptions.put("Iconfinder", Messages.LicenseInfoDialog2_Iconfinder_description);
        descriptions.put("StoryPresentation", Messages.LicenseInfoDialog2_StoryPresentation_description);
        descriptions.put("Export", Messages.LicenseInfoDialog2_Export_description);
        descriptions.put("Themes", Messages.LicenseInfoDialog2_Themes_description);
        hyperlinks = new HashMap<String, String>();
        hyperlinks.put("Brainstorm", LinkUtils.getLinkByLanguage((boolean)true, (boolean)true, (String)"/xmind/video/brainstorming"));
        hyperlinks.put("Gantt", LinkUtils.getLinkByLanguage((boolean)true, (boolean)true, (String)"/xmind/video/gantt-chart"));
        hyperlinks.put("StoryPresentation", LinkUtils.getLinkByLanguage((boolean)true, (boolean)true, (String)"/xmind/video/presentation"));
        hyperlinks.put("Export", LinkUtils.getLinkByLanguage((boolean)true, (boolean)true, (String)"/xmind/video/export-files"));
    }

    public LicenseInfoDialog2(Shell parentShell, List<String> featureKeys, String actionName, int requiredStatus, int currentStatus, boolean startup, boolean update, String licensedTo) {
        super(parentShell);
        this.featureKeys = featureKeys;
        this.featureKey = featureKeys.size() == 0 ? null : featureKeys.get(featureKeys.size() - 1);
        this.setShellStyle(0x11000C);
        this.setBlockOnOpen(true);
        this.setReturnCode(1);
    }

    public int open() {
        VerifyUI20141031.getUsageDataCollector().increase("ShowProCount");
        for (String featureKey : this.featureKeys) {
            String key = String.format("ShowProCountFor/%s", featureKey);
            VerifyUI20141031.getUsageDataCollector().increase(key);
        }
        return super.open();
    }

    protected Control createContents(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite border = new Composite(parent, 0);
        border.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#cccccc")));
        border.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        border.setLayout((Layout)gridLayout);
        Composite composite = new Composite(border, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f1f1f1")));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        LicenseInfoDialog2.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.createHeader(composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    private void createHeader(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 128, true, false);
        composite.setLayoutData((Object)layoutData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 14;
        gridLayout.marginRight = 8;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createLeftHeader(composite);
        this.createCloseButton(composite);
    }

    private void createLeftHeader(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.shellTitleLabel = new Label(composite, 0);
        this.shellTitleLabel.setBackground(composite.getBackground());
        this.shellTitleLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#000000")));
        GridData layoutData2 = new GridData(0x1000000, 0x1000000, true, true);
        layoutData2.horizontalIndent = 20;
        this.shellTitleLabel.setLayoutData((Object)layoutData2);
        this.shellTitleLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])this.shellTitleLabel.getFont().getFontData(), (int)1))));
        Listener controlMovedListener = this.createControlMovedListener((Control)composite);
        composite.addListener(3, controlMovedListener);
        composite.addListener(5, controlMovedListener);
        composite.addListener(4, controlMovedListener);
    }

    private Listener createControlMovedListener(final Control source) {
        Listener listener = new Listener(){
            Point point = null;
            Point startLocation = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        this.point = source.toDisplay(event.x, event.y);
                        this.startLocation = LicenseInfoDialog2.this.getShell().getLocation();
                        break;
                    }
                    case 5: {
                        if (this.point == null) {
                            return;
                        }
                        Point p2 = source.toDisplay(event.x, event.y);
                        int deltaX = p2.x - this.point.x;
                        int deltaY = p2.y - this.point.y;
                        Rectangle rect = LicenseInfoDialog2.this.getShell().getBounds();
                        rect.x = this.startLocation.x + deltaX;
                        rect.y = this.startLocation.y + deltaY;
                        LicenseInfoDialog2.this.getShell().setLocation(rect.x, rect.y);
                        break;
                    }
                    case 4: {
                        this.point = null;
                    }
                }
            }
        };
        return listener;
    }

    private void createCloseButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(131072, 0x1000000, false, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 4;
        gridLayout.marginHeight = 4;
        composite.setLayout((Layout)gridLayout);
        final Label closeButton = new Label(composite, 0);
        closeButton.setBackground(composite.getBackground());
        closeButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        final Image image = (Image)this.resources.get((DeviceResourceDescriptor)VerifyPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/shell_close.png"));
        final Image hoverImage = (Image)this.resources.get((DeviceResourceDescriptor)VerifyPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/shell_close_hover.png"));
        closeButton.setImage(image);
        MouseTrackListener mouseTrackListener = new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                closeButton.setImage(image);
            }

            public void mouseEnter(MouseEvent e) {
                closeButton.setImage(hoverImage);
            }
        };
        closeButton.addMouseTrackListener(mouseTrackListener);
        composite.addMouseTrackListener(mouseTrackListener);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                LicenseInfoDialog2.this.close();
            }
        };
        closeButton.addMouseListener((MouseListener)mouseAdapter);
        composite.addMouseListener((MouseListener)mouseAdapter);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 630;
        layoutData.heightHint = 430;
        composite.setLayoutData((Object)layoutData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 15;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 27;
        composite.setLayout((Layout)gridLayout);
        Composite border = new Composite(composite, 0);
        border.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#cccccc")));
        border.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 1;
        gridLayout2.marginHeight = 1;
        border.setLayout((Layout)gridLayout2);
        this.stack = new Composite(border, 0);
        this.stack.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        this.stack.setLayoutData((Object)new GridData(4, 4, true, true));
        StackLayout stackLayout = new StackLayout();
        this.stack.setLayout((Layout)stackLayout);
        this.allFeaturesPage = this.createAllFeaturesPage(this.stack);
        this.singleFeaturePage = this.createSingleFeaturePage(this.stack);
        if (this.featureKey != null && images.keySet().contains(this.trim(this.featureKey))) {
            this.turnSingleFeature(this.featureKey);
        } else {
            this.turnAllFeatures();
        }
        return border;
    }

    private Composite createAllFeaturesPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createItemsArea(composite);
        this.createSeparator(composite);
        this.createDescriptionArea(composite);
        return composite;
    }

    private void createItemsArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 128, true, false);
        layoutData.widthHint = 598;
        layoutData.heightHint = 336;
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 20;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(parent.getBackground());
        GridData layoutData2 = new GridData(0x1000000, 0x1000000, true, true);
        composite2.setLayoutData((Object)layoutData2);
        GridLayout layout2 = new GridLayout(4, true);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 3;
        layout2.verticalSpacing = 25;
        composite2.setLayout((Layout)layout2);
        this.createImageItem(composite2, (Image)this.resources.get((DeviceResourceDescriptor)VerifyPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/gantt_chart.png")), Messages.LicenseInfoDialog2_Gantt_item_title, new Runnable(){

            public void run() {
                LicenseInfoDialog2.this.turnSingleFeature("Gantt");
            }
        });
        this.createImageItem(composite2, (Image)this.resources.get((DeviceResourceDescriptor)VerifyPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/export.png")), Messages.LicenseInfoDialog2_Export_item_title, new Runnable(){

            public void run() {
                LicenseInfoDialog2.this.turnSingleFeature("Export");
            }
        });
        this.createImageItem(composite2, (Image)this.resources.get((DeviceResourceDescriptor)VerifyPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/slide_base.png")), Messages.LicenseInfoDialog2_StoryPresentation_item_title, new Runnable(){

            public void run() {
                LicenseInfoDialog2.this.turnSingleFeature("StoryPresentation");
            }
        });
        this.createImageItem(composite2, (Image)this.resources.get((DeviceResourceDescriptor)VerifyPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/brainstorming.png")), Messages.LicenseInfoDialog2_Brainstorming_item_title, new Runnable(){

            public void run() {
                LicenseInfoDialog2.this.turnSingleFeature("Brainstorm");
            }
        });
        this.createImageItem(composite2, (Image)this.resources.get((DeviceResourceDescriptor)VerifyPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/set_password.png")), Messages.LicenseInfoDialog2_FileEncryption_item_title, new Runnable(){

            public void run() {
                LicenseInfoDialog2.this.turnSingleFeature("FileEncryption");
            }
        });
        this.createImageItem(composite2, (Image)this.resources.get((DeviceResourceDescriptor)VerifyPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/iconfinder.png")), Messages.LicenseInfoDialog2_Iconfinder_item_title, new Runnable(){

            public void run() {
                LicenseInfoDialog2.this.turnSingleFeature("Iconfinder");
            }
        });
        this.createImageItem(composite2, (Image)this.resources.get((DeviceResourceDescriptor)VerifyPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/theme.png")), Messages.LicenseInfoDialog2_Theme_item_title, new Runnable(){

            public void run() {
                LicenseInfoDialog2.this.turnSingleFeature("Themes");
            }
        });
        this.createImageItem(composite2, (Image)this.resources.get((DeviceResourceDescriptor)VerifyPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/audio_notes.png")), Messages.LicenseInfoDialog2_AudioNotes_item_title, new Runnable(){

            public void run() {
                LicenseInfoDialog2.this.turnSingleFeature("AudioNotes");
            }
        });
    }

    private void createImageItem(Composite parent, Image image, String title, final Runnable action) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 128, true, false);
        composite.setLayoutData((Object)layoutData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 4;
        composite.setLayout((Layout)gridLayout);
        Label imageLabel = new Label(composite, 0x1000000);
        imageLabel.setBackground(composite.getBackground());
        GridData gridData2 = new GridData(0x1000000, 128, true, false);
        imageLabel.setLayoutData((Object)gridData2);
        imageLabel.setImage(image);
        imageLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        imageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                action.run();
            }
        });
        Label titleLabel = new Label(composite, 64);
        titleLabel.setBackground(composite.getBackground());
        titleLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#323232")));
        titleLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        titleLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])titleLabel.getFont().getFontData(), (int)1))));
        titleLabel.setAlignment(0x1000000);
        titleLabel.setText(title);
    }

    private void createSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#cccccc")));
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.heightHint = 1;
        composite.setLayoutData((Object)layoutData);
        composite.setLayout((Layout)new GridLayout());
    }

    private void createDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 25;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        label.setAlignment(16384);
        label.setBackground(composite.getBackground());
        label.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#323232")));
        label.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])label.getFont().getFontData(), (int)1))));
        label.setText(Messages.LicenseInfoDialog2_description_title);
    }

    private Composite createSingleFeaturePage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createPreviewImage(composite);
        this.createSeparator(composite);
        this.createSingleDescriptionArea(composite);
        return composite;
    }

    private void createPreviewImage(Composite parent) {
        this.previewComposite = new Composite(parent, 0);
        this.previewComposite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 128, true, false);
        layoutData.widthHint = 598;
        layoutData.heightHint = 336;
        this.previewComposite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 0;
        this.previewComposite.setLayout((Layout)layout);
        this.createBackButton(this.previewComposite);
    }

    private void createBackButton(Composite parent) {
        this.backButton = new Label(parent, 0);
        this.backButton.setLayoutData((Object)new GridData(16384, 128, true, false));
        final Image image = (Image)this.resources.get((DeviceResourceDescriptor)AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/preview/button_back.png"));
        final Image hoverImage = (Image)this.resources.get((DeviceResourceDescriptor)AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/dialog/preview/button_back_hover.png"));
        this.backButton.setImage(image);
        this.backButton.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                LicenseInfoDialog2.this.backButton.setImage(image);
            }

            public void mouseEnter(MouseEvent e) {
                LicenseInfoDialog2.this.backButton.setImage(hoverImage);
            }
        });
        this.backButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                LicenseInfoDialog2.this.turnAllFeatures();
            }
        });
    }

    private void createSingleDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 25;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 19;
        composite.setLayout((Layout)layout);
        this.singleDescription = new Label(composite, 64);
        this.singleDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.singleDescription.setAlignment(16384);
        this.singleDescription.setBackground(composite.getBackground());
        this.singleDescription.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#323232")));
        this.singleDescription.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])this.singleDescription.getFont().getFontData(), (int)1))));
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite.getBackground());
        composite2.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 16;
        composite2.setLayout((Layout)layout2);
        Composite separator = new Composite(composite2, 0);
        separator.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#cccccc")));
        GridData layoutData2 = new GridData(0x1000000, 4, false, true);
        layoutData2.widthHint = 1;
        separator.setLayoutData((Object)layoutData2);
        separator.setLayout((Layout)new GridLayout());
        Hyperlink videoHyperlink = new Hyperlink(composite, 4);
        videoHyperlink.setBackground(composite.getBackground());
        videoHyperlink.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        videoHyperlink.setUnderlined(false);
        videoHyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
        videoHyperlink.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])videoHyperlink.getFont().getFontData(), (int)2))));
        videoHyperlink.setText(Messages.LicenseInfoDialog2_video_hyperlink);
        videoHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Program.launch((String)LicenseInfoDialog2.this.getVideoHyperlink(LicenseInfoDialog2.this.featureKey));
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 15;
        layout.marginHeight = 0;
        layout.marginBottom = 15;
        composite.setLayout((Layout)layout);
        this.createLeftBar(composite);
        this.createRightBar(composite);
        return composite;
    }

    private void createLeftBar(Composite parent) {
        Composite leftBar = new Composite(parent, 0);
        leftBar.setBackground(parent.getBackground());
        GridData layoutData2 = new GridData(16384, 0x1000000, true, true);
        leftBar.setLayoutData((Object)layoutData2);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 4;
        layout2.marginHeight = 0;
        leftBar.setLayout((Layout)layout2);
        Hyperlink activateHyperlink = new Hyperlink(leftBar, 4);
        activateHyperlink.setBackground(leftBar.getBackground());
        activateHyperlink.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        activateHyperlink.setText(Messages.LicenseInfoDialog2_activate_hyperlink);
        activateHyperlink.setUnderlined(false);
        activateHyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
        activateHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LicenseInfoDialog2.this.targetSelected(1);
            }
        });
        leftBar.setFocus();
    }

    private void createRightBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setBackground(parent.getBackground());
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 20;
        buttonBar.setLayout((Layout)layout);
        this.createButtonsForButtonBar(buttonBar);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!"true".equals(System.getProperty(PROP_DISALLOWS_LICENSE_ACTIVATION))) {
            this.createButton(parent, 100, Messages.LicenseInfoDialog2_license_button, false);
        }
        this.createButton(parent, 101, Messages.LicenseInfoDialog2_buy_button, false);
    }

    protected void buttonPressed(int buttonId) {
        if (100 == buttonId) {
            this.targetSelected(6);
        } else if (101 == buttonId) {
            this.visitPrice();
        }
        super.buttonPressed(buttonId);
    }

    private Image getPreviewImage(String featureKey) {
        if (featureKey == null || featureKey.equals("")) {
            return null;
        }
        featureKey = this.trim(featureKey);
        String fileName = String.valueOf(images.get(featureKey)) + ".png";
        return (Image)this.resources.get((DeviceResourceDescriptor)VerifyPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)(PREVIEW_PATH + fileName)));
    }

    private String getDescription(String featureKey) {
        if (featureKey == null || featureKey.equals("")) {
            return null;
        }
        featureKey = this.trim(featureKey);
        return descriptions.get(featureKey);
    }

    private String getVideoHyperlink(String featureKey) {
        if (featureKey == null || featureKey.equals("")) {
            return null;
        }
        featureKey = this.trim(featureKey);
        return hyperlinks.get(featureKey);
    }

    private String trim(String featureKey) {
        if (featureKey.startsWith("Export")) {
            return "Export";
        }
        if (featureKey.contains("Theme")) {
            return "Themes";
        }
        return featureKey;
    }

    private void turnAllFeatures() {
        this.featureKey = null;
        this.updateShellTitle(null);
        ((StackLayout)this.stack.getLayout()).topControl = this.allFeaturesPage;
        this.stack.layout(true, true);
    }

    private void turnSingleFeature(String featureKey) {
        this.featureKey = featureKey;
        this.updateShellTitle(featureKey);
        this.updateSingleDescriptionArea(featureKey);
        this.previewComposite.setBackgroundImage(this.getPreviewImage(featureKey));
        this.updateBackButtonBackground();
        this.singleDescription.setText(this.getDescription(featureKey));
        ((StackLayout)this.stack.getLayout()).topControl = this.singleFeaturePage;
        this.stack.layout(true, true);
    }

    private void updateShellTitle(String featureKey) {
        String title = Messages.LicenseInfoDialog2_shell_title;
        if (featureKey != null && titles.keySet().contains(featureKey)) {
            title = titles.get(featureKey);
        }
        this.shellTitleLabel.setText(title);
        this.shellTitleLabel.getParent().layout(true, true);
    }

    private void updateSingleDescriptionArea(String featureKey) {
        int numColumns;
        Composite parent = this.singleDescription.getParent();
        GridLayout gridLayout = (GridLayout)parent.getLayout();
        Control[] children = parent.getChildren();
        boolean hasVideo = hyperlinks.keySet().contains(this.trim(featureKey));
        int n = numColumns = hasVideo ? 3 : 1;
        if (gridLayout.numColumns == numColumns) {
            return;
        }
        gridLayout.numColumns = numColumns;
        children[1].setVisible(hasVideo);
        children[2].setVisible(hasVideo);
        ((GridData)children[1].getLayoutData()).exclude = !hasVideo;
        ((GridData)children[2].getLayoutData()).exclude = !hasVideo;
        parent.layout(true, true);
    }

    private void updateBackButtonBackground() {
        String background = "#ffffff";
        if ("Gantt".equals(this.featureKey)) {
            background = "#f8f8f8";
        } else if ("FileEncryption".equals(this.featureKey)) {
            background = "#ababab";
        }
        this.backButton.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)background)));
    }

    private void targetSelected(int targetStatus) {
        this.targetStatus = targetStatus;
        this.setReturnCode(0);
        this.close();
    }

    private void visitPrice() {
        VerifyUI20141031.getUsageDataCollector().increase("BuyCount");
        for (String featureKey : this.featureKeys) {
            String key = String.format("BuyCountFor/%s", featureKey);
            VerifyUI20141031.getUsageDataCollector().increase(key);
        }
        XMindNet.gotoURL((String)LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)"/xmind/buy/pricing/"), (Object[])new Object[0]);
    }

    public int getTargetStatus() {
        return this.targetStatus;
    }
}

