/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command.transfer;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.UnmappableCharacterException;
import java.util.Arrays;

public class ChunkReader
implements Closeable {
    private static final byte DEFAULT_CHUNK_SEPARATOR = 10;
    private static final String DEFAULT_TEXT_ENCODING = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int DEFAULT_TEXT_BUFFER_SIZE = 1024;
    private static final int DEFAULT_BINARY_BUFFER_SIZE = 3072;
    private static final String EMPTY_TEXT = "";
    private static final byte[] base64ToInt;
    private InputStream in;
    private String textEncoding;
    private byte separator;
    private boolean eof = false;
    private byte[] buffer = new byte[4096];
    private int buffered = 0;
    private byte[] textBuffer = new byte[1024];
    private ChunkInputStream binaryStream = null;
    private byte[] binaryBuffer = new byte[3072];
    private int binaryBuffered = 0;
    private boolean chunkEnded = false;

    static {
        byte[] byArray = new byte[123];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = 62;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = -1;
        byArray[96] = -1;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        base64ToInt = byArray;
    }

    public ChunkReader(InputStream in) {
        this(in, 10, DEFAULT_TEXT_ENCODING);
    }

    public ChunkReader(InputStream in, byte chunkSeparator, String textEncoding) {
        this.in = in;
        this.separator = chunkSeparator;
        this.textEncoding = textEncoding;
    }

    private boolean isStreamEnded() {
        return this.eof && this.buffered <= 0;
    }

    private boolean isBinaryChunkEnded() {
        return this.chunkEnded && this.binaryBuffered <= 0;
    }

    public String readText() throws IOException {
        this.closeBinaryStream(true);
        int size = 0;
        int consumed = 0;
        while (!this.isStreamEnded()) {
            int sep = this.findSep(0);
            int newSize = size + sep;
            if (newSize > this.textBuffer.length) {
                this.textBuffer = Arrays.copyOf(this.textBuffer, Math.max(this.textBuffer.length << 1, newSize));
            }
            if (sep > 0) {
                System.arraycopy(this.buffer, 0, this.textBuffer, size, sep);
            }
            size = newSize;
            int numBuffered = this.buffered;
            if (sep == numBuffered) {
                this.use(numBuffered);
                consumed += numBuffered;
            } else {
                this.use(sep + 1);
                consumed += sep + 1;
                break;
            }
            this.reload();
        }
        if (consumed == 0) {
            return null;
        }
        if (size == 0) {
            return EMPTY_TEXT;
        }
        return new String(this.textBuffer, 0, size, this.textEncoding);
    }

    public InputStream openNextChunkAsStream() throws IOException {
        this.closeBinaryStream(true);
        if (this.isStreamEnded()) {
            return null;
        }
        this.binaryStream = new ChunkInputStream(this.in);
        return this.binaryStream;
    }

    private void closeBinaryStream(boolean drain) throws IOException {
        if (this.binaryStream != null && !this.binaryStream.closed && !this.isBinaryChunkEnded()) {
            if (drain) {
                byte[] buf = new byte[4096];
                while (this.binaryStream.read(buf) > 0) {
                }
            }
            this.binaryStream.close();
            this.binaryStream = null;
        }
    }

    public void close() throws IOException {
        this.closeBinaryStream(false);
        this.in.close();
    }

    private void reload() throws IOException {
        if (this.eof) {
            return;
        }
        if (!this.eof && this.buffered < this.buffer.length) {
            int len = this.buffer.length - this.buffered;
            int read = this.in.read(this.buffer, this.buffered, len);
            if (read < 0) {
                this.eof = true;
                read = 0;
            }
            this.buffered += read;
        }
    }

    private static int base64toInt(byte c) throws IOException {
        byte b = base64ToInt[c];
        if (b < 0) {
            throw new UnmappableCharacterException(1);
        }
        return b;
    }

    private int findSep(int off) {
        int i = off;
        while (i < this.buffered) {
            if (this.buffer[i] == this.separator) {
                return i;
            }
            ++i;
        }
        return this.buffered;
    }

    private void use(int used) {
        if (used >= this.buffered) {
            this.buffered = 0;
        } else {
            int newCount = this.buffered - used;
            System.arraycopy(this.buffer, used, this.buffer, 0, newCount);
            this.buffered = newCount;
        }
    }

    private void refillBinary() throws IOException {
        this.reload();
        if (this.eof) {
            this.chunkEnded = true;
        }
        int used = 0;
        int max = this.buffered - 3;
        int bmax = this.binaryBuffer.length - 2;
        while (used < max && this.binaryBuffered < bmax) {
            byte b3;
            byte b2;
            byte b1;
            byte b0;
            if ((b0 = this.buffer[used++]) == this.separator) {
                this.chunkEnded = true;
                break;
            }
            if ((b1 = this.buffer[used++]) == this.separator) {
                this.chunkEnded = true;
                break;
            }
            if ((b2 = this.buffer[used++]) == this.separator) {
                this.chunkEnded = true;
                break;
            }
            if ((b3 = this.buffer[used++]) == this.separator) {
                this.chunkEnded = true;
                break;
            }
            int c0 = ChunkReader.base64toInt(b0);
            int c1 = ChunkReader.base64toInt(b1);
            this.binaryBuffer[this.binaryBuffered++] = (byte)(c0 << 2 | c1 >> 4);
            if (b2 == 61) continue;
            int c2 = ChunkReader.base64toInt(b2);
            this.binaryBuffer[this.binaryBuffered++] = (byte)(c1 << 4 | c2 >> 2);
            if (b3 == 61) continue;
            int c3 = ChunkReader.base64toInt(b3);
            this.binaryBuffer[this.binaryBuffered++] = (byte)(c2 << 6 | c3);
        }
        this.use(used);
    }

    private void useBinary(int used) {
        if (used >= this.binaryBuffered) {
            this.binaryBuffered = 0;
        } else {
            int newCount = this.binaryBuffered - used;
            System.arraycopy(this.binaryBuffer, used, this.binaryBuffer, 0, newCount);
            this.binaryBuffered = newCount;
        }
    }

    private class ChunkInputStream
    extends FilterInputStream {
        private boolean closed;

        public ChunkInputStream(InputStream in) {
            super(in);
            this.closed = false;
            ChunkReader.this.chunkEnded = false;
        }

        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Stream already closed.");
            }
            if (ChunkReader.this.chunkEnded && ChunkReader.this.binaryBuffered <= 0) {
                return -1;
            }
            if (ChunkReader.this.binaryBuffered <= 0) {
                ChunkReader.this.refillBinary();
            }
            if (ChunkReader.this.chunkEnded && ChunkReader.this.binaryBuffered <= 0) {
                return -1;
            }
            byte b = ChunkReader.this.binaryBuffer[0];
            ChunkReader.this.useBinary(1);
            return b;
        }

        public int read(byte[] b) throws IOException {
            if (this.closed) {
                throw new IOException("Stream already closed.");
            }
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream already closed.");
            }
            if (off < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException("Offset or length out of bounds.");
            }
            int read = 0;
            while (len > 0) {
                if (ChunkReader.this.chunkEnded && ChunkReader.this.binaryBuffered <= 0) break;
                if (ChunkReader.this.binaryBuffered <= 0) {
                    ChunkReader.this.refillBinary();
                }
                if (ChunkReader.this.chunkEnded && ChunkReader.this.binaryBuffered <= 0) break;
                int size = Math.min(len, ChunkReader.this.binaryBuffered);
                System.arraycopy(ChunkReader.this.binaryBuffer, 0, b, off, size);
                read += size;
                off += size;
                len -= size;
                ChunkReader.this.useBinary(size);
            }
            if (read == 0) {
                read = -1;
            }
            return read;
        }

        public void close() throws IOException {
            this.closed = true;
            ChunkReader.this.binaryBuffered = 0;
        }
    }
}

