/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.brainstorm.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.brainstorm.actions.AbstractEditAction;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.dialogs.HyperlinkDialog;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class InsertHyperlinkAction
extends AbstractEditAction
implements ISelectionAction {
    private IEditorPart editor;

    public InsertHyperlinkAction(IGraphicalViewer viewer, IEditorPart editor) {
        super(viewer, "modify_hyperlink");
        this.editor = editor;
        this.setId(MindMapActionFactory.MODIFY_HYPERLINK.getId());
        this.setText(MindMapMessages.ModifyHyperlink_text);
        this.setImageDescriptor(MindMapUI.getImages().get("hyperlink.png", true));
        this.setDisabledImageDescriptor(MindMapUI.getImages().get("hyperlink.png", true));
        this.setActionDefinitionId("org.xmind.ui.command.hyperlink");
    }

    public void setSelection(ISelection selection) {
        this.setEnabled(MindMapUtils.isPropertyModifiable((ISelection)selection, (String)"topicHyperlink", (IViewer)this.getViewer()));
    }

    public void run() {
        if (this.getViewer() == null || this.getViewer().getControl() == null || this.getViewer().getControl().isDisposed()) {
            return;
        }
        EditDomain domain = this.getViewer().getEditDomain();
        if (domain == null) {
            return;
        }
        Shell parentShell = this.getViewer().getControl().getShell();
        ISelection selection = this.getViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            HyperlinkDialog dialog = new HyperlinkDialog(parentShell, this.editor, (IStructuredSelection)selection);
            int retCode = dialog.open();
            if (retCode == 0) {
                this.modifyHyperlink(domain, dialog.getValue());
            } else if (retCode == 3) {
                this.modifyHyperlink(domain, null);
            }
        }
    }

    private void modifyHyperlink(EditDomain domain, String newValue) {
        domain.handleRequest(new Request("modify_hyperlink").setParameter("text", (Object)newValue).setViewer((IViewer)this.getViewer()));
    }
}

