/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RadioInfoFieldGroup
implements ISelectionProvider {
    private Group group;
    private List<Button> buttons = new ArrayList<Button>();
    private boolean grabVerticalSpace;
    private ISelectionChangedListener listener;

    public RadioInfoFieldGroup(boolean grabVerticalSpace) {
        this.grabVerticalSpace = grabVerticalSpace;
    }

    public void fill(Composite parent) {
        this.group = new Group(parent, 0);
        this.group.setLayoutData((Object)new GridData(4, 4, true, this.grabVerticalSpace));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.verticalSpacing = 3;
        layout.horizontalSpacing = 0;
        this.group.setLayout((Layout)layout);
    }

    public void setName(String name) {
        this.group.setText(name == null ? "" : name);
    }

    public String getName() {
        if (this.group == null || this.group.isDisposed()) {
            return "";
        }
        return this.group.getText();
    }

    public Group getNameWidget() {
        return this.group;
    }

    public boolean isDisposed() {
        return this.group.isDisposed();
    }

    public void setFocus() {
        if (!this.group.setFocus() && !this.buttons.isEmpty()) {
            this.buttons.get(0).setFocus();
        }
    }

    public Button addOption(final Object value, String label) {
        final Button button = new Button((Composite)this.group, 80);
        button.setText(label);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        button.setData(value);
        if (this.buttons.isEmpty()) {
            button.setSelection(true);
        }
        this.buttons.add(button);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (button.getSelection()) {
                    RadioInfoFieldGroup.this.fireSelectionChanged(value);
                }
            }
        });
        return button;
    }

    protected void fireSelectionChanged(Object value) {
        if (this.listener != null) {
            this.listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public Object getSelectedValue() {
        for (Button button : this.buttons) {
            if (!button.getSelection()) continue;
            return button.getData();
        }
        return null;
    }

    public void setSelectedValue(Object value) {
        for (Button button : this.buttons) {
            button.setSelection(RadioInfoFieldGroup.equals(value, button.getData()));
        }
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listener = listener;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener == this.listener) {
            this.listener = null;
        }
    }

    public void setSelection(ISelection selection) {
        this.setSelectedValue(((IStructuredSelection)selection).getFirstElement());
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.getSelectedValue());
    }
}

