/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.xmind.share.Info;
import net.xmind.share.Messages;
import net.xmind.share.XmindSharePlugin;
import net.xmind.share.dialog.InfoField;
import net.xmind.share.dialog.UploaderPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.resources.FontUtils;

public class GeneralUploaderPage
extends UploaderPage
implements PropertyChangeListener {
    private static final String LANGUAGE_CHANNEL = "net.xmind.share.dialog.defaultLanguageChannel";
    private InfoField titleField;
    private InfoField descriptionField;
    private Composite privacyText;
    private Label accessibility;
    private Label allowed;

    public GeneralUploaderPage() {
        this.setTitle(Messages.UploaderDialog_GeneralPage_title);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1, 4, true, false));
        this.titleField = new InfoField(false, true, true);
        this.titleField.fill(composite);
        this.titleField.setName(Messages.UploaderDialog_Title_text);
        this.titleField.setText(this.getInfo().getString("Title"));
        this.descriptionField = new InfoField(true, false, false);
        this.descriptionField.fill(composite);
        this.descriptionField.setName(Messages.UploaderDialog_Description_text);
        this.descriptionField.setText(this.getInfo().getString("Description"));
        this.descriptionField.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralUploaderPage.this.getInfo().setProperty("Description", GeneralUploaderPage.this.descriptionField.getText());
            }
        });
        this.createLanguageSection(composite);
        this.createPrivacySection(composite);
        this.setControl((Control)composite);
        this.getInfo().addPropertyChangeListener("Share/Privacy", this);
        this.getInfo().addPropertyChangeListener("Share/Downloadable", this);
    }

    private void createPrivacySection(Composite parent) {
        this.privacyText = new Composite(parent, 0);
        GridLayout layout = new GridLayout(7, false);
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 100;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.privacyText.setLayout((Layout)layout);
        this.privacyText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.privacyText.setBackground(parent.getBackground());
        this.createtePrivacyLabel();
    }

    private void createLanguageSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        label.setText(Messages.UploaderDialog_LanguageChannel_label);
        final Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        ((GridData)combo.getLayoutData()).widthHint = 280;
        combo.setItems(new String[]{"English", "Chinese - \u4e2d\u6587", "French - fran\u00e7ais", "German - Deutsch", "Japanese - \u65e5\u672c\u8a9e", "Spanish - espa\u00f1ol", "Worldwide"});
        final IPreferenceStore prefStore = XmindSharePlugin.getDefault().getPreferenceStore();
        String lang = prefStore.getString(LANGUAGE_CHANNEL);
        if (lang == null || "".equals(lang)) {
            lang = Info.getDefaultLanguageCode();
        }
        this.getInfo().setProperty("Share/LanguageChannel", lang);
        int index = Info.LANGUAGE_CODES.indexOf(lang);
        if (index < 0) {
            index = Info.LANGUAGE_CODES.size() - 1;
        }
        combo.select(index);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index = Math.min(combo.getSelectionIndex(), Info.LANGUAGE_CODES.size() - 1);
                String lang = Info.LANGUAGE_CODES.get(index);
                prefStore.setValue(GeneralUploaderPage.LANGUAGE_CHANNEL, lang);
                GeneralUploaderPage.this.getInfo().setProperty("Share/LanguageChannel", lang);
            }
        });
    }

    public void setFocus() {
        if (this.descriptionField != null && !this.descriptionField.isDisposed()) {
            this.descriptionField.setFocus();
        }
    }

    public void dispose() {
        this.getInfo().removePropertyChangeListener("Share/Privacy", this);
        this.getInfo().removePropertyChangeListener("Share/Downloadable", this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("Share/Privacy".equals(name) || "Share/Downloadable".equals(name)) {
            this.updatePrivacyLabel();
        }
    }

    private void createtePrivacyLabel() {
        if (this.privacyText == null || this.privacyText.isDisposed()) {
            return;
        }
        this.createPrivacyLabel(this.privacyText, Messages.UploaderDialog_Privacy_text, false);
        this.accessibility = this.createPrivacyLabel(this.privacyText, this.getAccessibilityText(), true);
        this.createPrivacyLabel(this.privacyText, NLS.bind((String)Messages.UploaderDialog_Download_text, (Object)". "), false);
        this.allowed = this.createPrivacyLabel(this.privacyText, this.getDownloadableText(), true);
        this.createPrivacyLabel(this.privacyText, ". (", false);
        this.createPrivacyLink(this.privacyText);
        this.createPrivacyLabel(this.privacyText, ")", false);
    }

    private void updatePrivacyLabel() {
        if (this.accessibility != null && !this.accessibility.isDisposed()) {
            this.accessibility.setText(this.getAccessibilityText());
        }
        if (this.allowed != null && !this.allowed.isDisposed()) {
            this.allowed.setText(this.getDownloadableText());
        }
        this.privacyText.layout(true, true);
    }

    private Label createPrivacyLabel(Composite parent, String text, boolean isBold) {
        Label label = new Label(parent, 0);
        if (isBold) {
            label.setFont(FontUtils.getBold((Font)label.getFont()));
        }
        label.setText(text);
        return label;
    }

    private void createPrivacyLink(Composite parent) {
        Hyperlink link = new Hyperlink(parent, 0);
        link.setForeground(link.getDisplay().getSystemColor(9));
        link.setUnderlined(true);
        link.setText(Messages.UploaderDialog_Privacy_link);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                GeneralUploaderPage.this.goToPrivacyPage();
            }
        });
    }

    private String getAccessibilityText() {
        String acc = this.getInfo().getString("Share/Privacy", "1");
        if ("1".equals(acc)) {
            return Messages.UploaderDialog_Privacy_Public_title;
        }
        if ("2".equals(acc)) {
            return Messages.UploaderDialog_Privacy_Private_title;
        }
        return Messages.UploaderDialog_Privacy_Unlisted_title;
    }

    private String getDownloadableText() {
        String value = this.getInfo().getString("Share/Downloadable", "1");
        if ("1".equals(value)) {
            return Messages.UploaderDialog_Privacy_DownloadAllowed;
        }
        return Messages.UploaderDialog_Privacy_DownloadForbidden;
    }

    private void goToPrivacyPage() {
        this.getContainer().showPage("org.xmind.ui.uploader.privacy");
    }

    public InfoField getTitleField() {
        return this.titleField;
    }
}

