/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.gallery;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.core.internal.gallery.DownloadedGalleryGroup;
import org.xmind.core.internal.gallery.DownloadedGalleryItem;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.core.util.DOMUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GallerySheet {
    public static final String TAG_CLIPART = "clipart";
    public static final String TAG_CLIPART_ITEM = "clipart-item";
    public static final String TAG_CLIPART_GROUP = "clipart-group";
    public static final String ATT_TIMESTAMP = "timestamp";
    public static final String ATT_NAME = "name";
    public static final String ATT_DISPLAY_NAME = "display-name";
    public static final String ATT_SOURCE = "source";
    public static final String ATT_PATH = "path";
    private Document implementation = null;

    private GallerySheet(Document impl) {
        this.implementation = impl;
    }

    private Document getImplementation() {
        return this.implementation;
    }

    private Element getSheetElement() {
        return this.getImplementation().getDocumentElement();
    }

    public void save(String filePath) throws IOException {
        FileOutputStream out = new FileOutputStream(filePath);
        try {
            try {
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.getImplementation()), new StreamResult(out));
            }
            catch (Throwable e1) {
                throw new IOException(e1.getLocalizedMessage(), e1);
            }
        }
        catch (Throwable throwable) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((OutputStream)out).close();
        }
        catch (IOException iOException) {}
    }

    public void setTimestamp(long timestamp) {
        this.getSheetElement().setAttribute(ATT_TIMESTAMP, String.valueOf(timestamp));
    }

    public long getTimestamp() {
        String timestamp = this.getSheetElement().getAttribute(ATT_TIMESTAMP);
        if ("".equals(timestamp)) {
            return 0L;
        }
        return Long.valueOf(timestamp);
    }

    public List<IGalleryGroup> getGalleryGroups() {
        ArrayList<IGalleryGroup> galleryGroups = new ArrayList<IGalleryGroup>();
        NodeList childNodes = this.getSheetElement().getChildNodes();
        int index = 0;
        while (index < childNodes.getLength()) {
            if (childNodes.item(index) instanceof Element) {
                DownloadedGalleryGroup galleryGroup = new DownloadedGalleryGroup((Element)childNodes.item(index), this);
                galleryGroups.add(galleryGroup);
            }
            ++index;
        }
        return galleryGroups;
    }

    public IGalleryGroup importGroup(IGalleryGroup sourceGroup) {
        Element groupEle;
        if (sourceGroup instanceof DownloadedGalleryGroup) {
            Element sourceGroupEle = ((DownloadedGalleryGroup)sourceGroup).getImplementation();
            groupEle = (Element)this.implementation.importNode(sourceGroupEle, true);
        } else {
            groupEle = this.implementation.createElement(TAG_CLIPART_GROUP);
            groupEle.setAttribute(ATT_NAME, sourceGroup.getName());
        }
        return new DownloadedGalleryGroup(groupEle, this);
    }

    public DownloadedGalleryItem importItem(IGalleryItem sourceItem) {
        Element itemEle;
        if (sourceItem instanceof DownloadedGalleryItem) {
            Element sourceItemEle = ((DownloadedGalleryItem)sourceItem).getImplementation();
            itemEle = (Element)this.implementation.importNode(sourceItemEle, true);
        } else {
            itemEle = this.implementation.createElement(TAG_CLIPART_ITEM);
            itemEle.setAttribute(ATT_SOURCE, sourceItem.getURL().toExternalForm());
        }
        return new DownloadedGalleryItem(itemEle, this);
    }

    public boolean moveGroupAfter(IGalleryGroup group, IGalleryGroup lastGroup) {
        Node lastParent;
        if (!(group instanceof DownloadedGalleryGroup) || lastGroup != null && !(lastGroup instanceof DownloadedGalleryGroup)) {
            throw new IllegalArgumentException("Not a DownloadedGalleryGroup.");
        }
        DownloadedGalleryGroup theGroup = (DownloadedGalleryGroup)group;
        DownloadedGalleryGroup theLastGroup = (DownloadedGalleryGroup)lastGroup;
        if (theGroup.getOwnedSheet() != this || theLastGroup != null && theLastGroup.getOwnedSheet() != this) {
            throw new IllegalArgumentException("Can not move gallery group that is not owned by the gallery sheet.");
        }
        Element groupEle = theGroup.getImplementation();
        Element lastGroupEle = theLastGroup == null ? null : theLastGroup.getImplementation();
        Node node = lastParent = lastGroupEle == null ? null : lastGroupEle.getParentNode();
        if (lastGroupEle != null && lastParent != this.getSheetElement()) {
            throw new IllegalArgumentException("The last gallery group has invalid parent.");
        }
        Node oldPrev = groupEle.getPreviousSibling();
        Node oldNext = groupEle.getNextSibling();
        Node oldParent = groupEle.getParentNode();
        if (oldParent != null) {
            oldParent.removeChild(groupEle);
        }
        if (lastGroup == null) {
            this.getSheetElement().insertBefore(groupEle, this.getSheetElement().getFirstChild());
        } else {
            this.getSheetElement().insertBefore(groupEle, lastGroupEle.getNextSibling());
        }
        return oldPrev != groupEle.getPreviousSibling() || oldNext != groupEle.getNextSibling() || oldParent != groupEle.getParentNode();
    }

    public void removeGroup(IGalleryGroup group) {
        if (!(group instanceof DownloadedGalleryGroup)) {
            throw new IllegalArgumentException("Not a DownloadedGalleryGroup.");
        }
        DownloadedGalleryGroup theGroup = (DownloadedGalleryGroup)group;
        if (theGroup.getOwnedSheet() != this) {
            throw new IllegalArgumentException("Can not remove gallery group that is not owned by the gallery sheet.");
        }
        Element groupEle = theGroup.getImplementation();
        if (groupEle.getParentNode() != this.getSheetElement()) {
            throw new IllegalArgumentException("The gallery group has invalid parent.");
        }
        this.getSheetElement().removeChild(groupEle);
    }

    public static GallerySheet createFrom(String filePath) {
        return new GallerySheet(GallerySheet.parseDocument(filePath));
    }

    public static GallerySheet createEmpty() {
        Document doc = GallerySheet.createDocument();
        Element docEle = doc.createElement(TAG_CLIPART);
        doc.appendChild(docEle);
        return new GallerySheet(doc);
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DOMUtils.getDefaultDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Document parseDocument(String filePath) {
        Document document;
        FileInputStream stream = new FileInputStream(filePath);
        try {
            document = GallerySheet.getDocumentBuilder().parse(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (SAXException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        stream.close();
        return document;
    }

    private static Document createDocument() {
        return GallerySheet.getDocumentBuilder().newDocument();
    }
}

