/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tabfolder;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.xmind.ui.tabfolder.DelegatedSelectionProvider;
import org.xmind.ui.tabfolder.IPageClosedListener;
import org.xmind.ui.tabfolder.NestedPageSite;

public abstract class PageBookPage
extends Page
implements IPageChangedListener,
IPageClosedListener {
    private IPageChangeProvider provider;
    private PageBook pageBook;
    private Object activeSourcePage;
    private Control defaultPage;
    private Map<Object, Page> pageMap = new HashMap<Object, Page>();
    private DelegatedSelectionProvider selectionProvider = new DelegatedSelectionProvider();
    private IPropertyChangeListener actionBarPropListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Page page;
            if (event.getProperty().equals("org.eclipse.ui.internal.actionHandlers") && (page = PageBookPage.this.getActivePage()) != null && event.getSource() == page.getSite().getActionBars()) {
                PageBookPage.this.refreshGlobalActionHandlers();
            }
        }
    };

    public PageBookPage(IPageChangeProvider sourcePageProvider) {
        this.provider = sourcePageProvider;
    }

    public IPageChangeProvider getSourcePageProvider() {
        return this.provider;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this.selectionProvider);
    }

    protected Object getActiveSourcePage() {
        return this.activeSourcePage;
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.provider.addPageChangedListener((IPageChangedListener)this);
        Object page = this.provider.getSelectedPage();
        if (page != null) {
            this.setActivePage(page);
        }
    }

    public Control getControl() {
        return this.pageBook;
    }

    public void setFocus() {
        this.pageBook.setFocus();
    }

    public void dispose() {
        this.provider.removePageChangedListener((IPageChangedListener)this);
        Object[] pages = this.pageMap.entrySet().toArray();
        int i = 0;
        while (i < pages.length) {
            Map.Entry entry = (Map.Entry)pages[i];
            Object sourcePage = entry.getKey();
            Page nestedPge = (Page)entry.getValue();
            this.disposeNestedPage(nestedPge, sourcePage);
            ++i;
        }
        super.dispose();
    }

    @Override
    public void pageClosed(Object page) {
        Page nestedPage = this.pageMap.remove(page);
        if (nestedPage == null) {
            return;
        }
        this.disposeNestedPage(nestedPage, page);
    }

    protected void disposeNestedPage(Page nestedPage, Object sourcePage) {
        IPageSite site = nestedPage.getSite();
        Control control = nestedPage.getControl();
        if (control != null && !control.isDisposed()) {
            control.dispose();
        }
        nestedPage.dispose();
        ((SubActionBars)site.getActionBars()).removePropertyChangeListener(this.actionBarPropListener);
        ((NestedPageSite)site).dispose();
    }

    public void pageChanged(PageChangedEvent event) {
        this.setActivePage(event.getSelectedPage());
    }

    private void setActivePage(Object sourcePage) {
        if (this.pageBook == null || this.pageBook.isDisposed()) {
            return;
        }
        this.activeSourcePage = sourcePage;
        if (sourcePage != null) {
            this.showNestedPage(sourcePage);
        } else {
            this.showDefaultPage();
        }
        this.refreshGlobalActionHandlers();
        this.getSite().getActionBars().updateActionBars();
        this.getSite().getActionBars().updateActionBars();
    }

    protected void showNestedPage(Object sourcePage) {
        Control pageControl;
        Page activePage = this.pageMap.get(sourcePage);
        if (activePage == null) {
            activePage = this.createNestedPage(sourcePage);
            this.pageMap.put(sourcePage, activePage);
        }
        if ((pageControl = activePage.getControl()) != null && !pageControl.isDisposed()) {
            this.pageBook.showPage(pageControl);
            this.selectionProvider.setDelegate(activePage.getSite().getSelectionProvider());
        }
    }

    private void showDefaultPage() {
        if (this.defaultPage == null || this.defaultPage.isDisposed()) {
            this.defaultPage = this.createDefaultPage((Composite)this.pageBook);
        }
        this.pageBook.showPage(this.defaultPage);
    }

    protected abstract Control createDefaultPage(Composite var1);

    protected Page createNestedPage(Object sourcePage) {
        Page page = this.doCreateNestedPage(sourcePage);
        NestedPageSite site = new NestedPageSite(this.getSite());
        page.init((IPageSite)site);
        if (this.pageBook != null && !this.pageBook.isDisposed()) {
            page.createControl((Composite)this.pageBook);
        }
        ((SubActionBars)site.getActionBars()).addPropertyChangeListener(this.actionBarPropListener);
        return page;
    }

    protected abstract Page doCreateNestedPage(Object var1);

    protected Page getActivePage() {
        return this.activeSourcePage == null ? null : this.pageMap.get(this.activeSourcePage);
    }

    protected void refreshGlobalActionHandlers() {
        Map newActionHandlers;
        IActionBars bars = this.getSite().getActionBars();
        bars.clearGlobalActionHandlers();
        Page page = this.getActivePage();
        if (page != null && (newActionHandlers = ((SubActionBars)page.getSite().getActionBars()).getGlobalActionHandlers()) != null) {
            Set keys = newActionHandlers.entrySet();
            for (Map.Entry entry : keys) {
                bars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
    }
}

