/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.resources;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.ErrorImageDescriptor;

public class ImageUtils {
    private static Display display = null;
    private static ImageRegistry imageRegistry = null;

    private static Display getDisplay() {
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = JFaceResources.getImageRegistry();
        }
        return imageRegistry;
    }

    private ImageUtils() {
    }

    public static Image getImage(String key) {
        return ImageUtils.getImageRegistry().get(key);
    }

    public static ImageDescriptor getDescriptor(String key) {
        return ImageUtils.getImageRegistry().getDescriptor(key);
    }

    public static void putImage(String key, Image image) {
        ImageUtils.getImageRegistry().put(key, image);
    }

    public static void putImageDescriptor(String key, ImageDescriptor descriptor) {
        ImageUtils.getImageRegistry().put(key, descriptor);
    }

    public static boolean disposeImage(String key) {
        Image img = ImageUtils.getImage(key);
        if (img == null) {
            return false;
        }
        ImageUtils.getImageRegistry().remove(key);
        if (!img.isDisposed()) {
            img.dispose();
        }
        return true;
    }

    public static Image getImage(String key, ImageData defaultImageData) {
        Image image = ImageUtils.getImage(key);
        if (image == null) {
            ImageUtils.getImageRegistry().put(key, ImageDescriptor.createFromImageData((ImageData)defaultImageData));
            image = ImageUtils.getImage(key);
        }
        return image;
    }

    public static Image getImage(String key, ImageDescriptor defaultImageDescriptor) {
        ImageDescriptor descriptor = ImageUtils.getImageRegistry().getDescriptor(key);
        if (descriptor == null && defaultImageDescriptor != null) {
            ImageUtils.getImageRegistry().put(key, defaultImageDescriptor);
        }
        return ImageUtils.getImageRegistry().get(key);
    }

    public static Image getImage(ImageDescriptor imgDesc) {
        return imgDesc == null ? null : ImageUtils.getImage(imgDesc.toString(), imgDesc);
    }

    public static Image getSmallIconByRGB(String key, RGB rgb) {
        return ImageUtils.getSmallIconByColor(key, ColorUtils.getColor(rgb));
    }

    public static Image getSmallIconByColor(String key, Color c) {
        Image image = ImageUtils.getImage(key);
        if (image == null) {
            image = new Image((Device)ImageUtils.getDisplay(), 16, 16);
            GC gc = new GC((Drawable)image);
            gc.setBackground(c);
            gc.fillRectangle(image.getBounds());
            gc.dispose();
            ImageUtils.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static Image getFilledImage(String key, Image src, int width, int height) {
        Image image = ImageUtils.getImage(key);
        if (image == null) {
            image = ImageUtils.createFilledImage(src, width, height);
            ImageUtils.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static Image createFilledImage(Image src, int width, int height) {
        Rectangle srcBounds = src.getBounds();
        Image dest = new Image((Device)ImageUtils.getDisplay(), width, height);
        GC gc = new GC((Drawable)dest);
        gc.drawImage(src, 0, 0, srcBounds.width, srcBounds.height, 0, 0, width, height);
        gc.dispose();
        return dest;
    }

    public static Image createFilledImage2(Image src, int width, int height) {
        ImageData srcData = src.getImageData();
        return new Image((Device)ImageUtils.getDisplay(), srcData.scaledTo(width, height));
    }

    public static Image getScaledConstrainedImage(String key, Image src, int width, int height) {
        Image image = ImageUtils.getImage(key);
        if (image == null) {
            image = ImageUtils.createScaledConstrainedImage(src, width, height);
            ImageUtils.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static Image createScaledConstrainedImage(Image src, int width, int height) {
        int y;
        int x;
        ImageData srcData = src.getImageData();
        ImageData destData = new ImageData(width, height, srcData.depth, srcData.palette);
        destData.type = srcData.type;
        destData.transparentPixel = srcData.transparentPixel;
        destData.alpha = -1;
        Point destSize = ImageUtils.getScaledConstrainedSize(srcData.width, srcData.height, width, height);
        int startX = (width - destSize.x) / 2;
        int startY = (height - destSize.y) / 2;
        srcData = srcData.scaledTo(destSize.x, destSize.y);
        if (srcData.transparentPixel != -1) {
            x = 0;
            while (x < width) {
                y = 0;
                while (y < height) {
                    destData.setPixel(x, y, srcData.transparentPixel);
                    ++y;
                }
                ++x;
            }
        } else {
            x = 0;
            while (x < width) {
                y = 0;
                while (y < height) {
                    destData.setAlpha(x, y, 0);
                    ++y;
                }
                ++x;
            }
        }
        int length = destSize.x;
        int[] pixels = new int[length];
        byte[] alphas = null;
        int y2 = 0;
        while (y2 < destSize.y) {
            int i;
            srcData.getPixels(0, y2, length, pixels, 0);
            destData.setPixels(startX, startY + y2, length, pixels, 0);
            if (srcData.alpha == -1 && srcData.alphaData != null) {
                if (alphas == null) {
                    alphas = new byte[length];
                }
                srcData.getAlphas(0, y2, length, alphas, 0);
            } else if (srcData.alpha != -1 && alphas == null) {
                alphas = new byte[length];
                i = 0;
                while (i < alphas.length) {
                    alphas[i] = (byte)srcData.alpha;
                    ++i;
                }
            } else if (alphas == null) {
                alphas = new byte[length];
                i = 0;
                while (i < alphas.length) {
                    alphas[i] = -1;
                    ++i;
                }
            }
            destData.setAlphas(startX, startY + y2, length, alphas, 0);
            ++y2;
        }
        Image image = new Image((Device)ImageUtils.getDisplay(), destData);
        return image;
    }

    private static Point getScaledConstrainedSize(int w, int h, int maxWidth, int maxHeight) {
        if (w == 0 || h == 0) {
            return new Point(0, 0);
        }
        if (maxWidth < 0 && maxHeight < 0) {
            return new Point(w, h);
        }
        if (w <= maxWidth && h <= maxHeight) {
            return new Point(w, h);
        }
        int nw = w * maxHeight / h;
        int nh = h * maxWidth / w;
        if (maxWidth < 0) {
            return new Point(nw, maxHeight);
        }
        if (maxHeight < 0) {
            return new Point(maxWidth, nh);
        }
        if (nw < maxWidth) {
            maxWidth = nw;
        }
        if (nh < maxHeight) {
            maxHeight = nh;
        }
        return new Point(Math.max(1, maxWidth), Math.max(1, maxHeight));
    }

    public static Image createScaledImage(Image src, int width, int height) {
        Rectangle srcBounds = src.getBounds();
        Image image = new Image((Device)ImageUtils.getDisplay(), width, height);
        GC gc = new GC((Drawable)image);
        gc.drawImage(src, 0, 0, srcBounds.width, srcBounds.height, 0, 0, width, height);
        gc.dispose();
        return image;
    }

    public static ImageDescriptor createErrorImage(int width, int height) {
        return new ErrorImageDescriptor(width, height);
    }

    public static Image getErrorImage(int width, int height) {
        String key = "image.common.error#" + width + "," + height;
        Image img = ImageUtils.getImage(key);
        if (img == null && (img = ImageUtils.createErrorImage(width, height).createImage((Device)ImageUtils.getDisplay())) != null) {
            ImageUtils.getImageRegistry().put(key, img);
        }
        return img;
    }

    public static ImageDescriptor scaleImage(Display display, ImageDescriptor imageDesc, int width, int height) {
        if (imageDesc == null) {
            return null;
        }
        ImageData imageData = imageDesc.getImageData();
        if (imageData == null) {
            return imageDesc;
        }
        int newHeight = height;
        int newWidth = imageData.width * newHeight / imageData.height;
        if (newWidth > width) {
            newWidth = width;
            newHeight = imageData.height * newWidth / imageData.width;
        }
        Image newImage = new Image((Device)display, newWidth, newHeight);
        GC gc = new GC((Drawable)newImage);
        Image oldImage = imageDesc.createImage();
        gc.drawImage(oldImage, 0, 0, imageData.width, imageData.height, 0, 0, newWidth, newHeight);
        ImageDescriptor result = ImageDescriptor.createFromImage((Image)newImage);
        oldImage.dispose();
        gc.dispose();
        return result;
    }
}

