/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.internal;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.xmind.core.net";
    public static final String OPTION_HTTP_ASSC = "/debug/http/assc";
    public static final String OPTION_HTTP_REQEUSTS = "/debug/http/requests";
    public static final String CONFIG_DEBUG_HTTP_REQUESTS = "org.xmind.debug.httprequests";
    private static Activator plugin;
    private BundleContext bundleContext;
    private ServiceTracker<DebugOptions, DebugOptions> debugTracker = null;

    public void start(BundleContext context) throws Exception {
        plugin = this;
        this.bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        ServiceTracker<DebugOptions, DebugOptions> theDebugTracker = this.debugTracker;
        if (theDebugTracker != null) {
            theDebugTracker.close();
        }
        this.debugTracker = null;
        this.bundleContext = null;
        plugin = null;
    }

    public Bundle getBundle() {
        return this.bundleContext.getBundle();
    }

    public ILog getLog() {
        return Platform.getLog((Bundle)this.getBundle());
    }

    private synchronized DebugOptions getDebugOptions() {
        if (this.debugTracker == null) {
            this.debugTracker = new ServiceTracker(Activator.getDefault().getBundle().getBundleContext(), DebugOptions.class, null);
            this.debugTracker.open();
        }
        return (DebugOptions)this.debugTracker.getService();
    }

    public static boolean isDebugging(String option) {
        Activator defaultInstance = Activator.getDefault();
        if (defaultInstance == null) {
            return false;
        }
        DebugOptions options = defaultInstance.getDebugOptions();
        return options != null && options.getBooleanOption(PLUGIN_ID + option, false);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(String message) {
        Activator p = Activator.getDefault();
        if (p == null) {
            System.out.println(message);
        } else {
            p.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
        }
    }

    public static void log(Throwable e) {
        Activator.log(e, null);
    }

    public static void log(Throwable e, String message) {
        Activator p = Activator.getDefault();
        if (p == null) {
            if (message != null) {
                System.err.println(message);
            }
            e.printStackTrace();
        } else {
            p.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, e));
        }
    }
}

