/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.net.Field;

public class FieldSet
implements Iterable<Field> {
    private final List<Field> fields;

    public FieldSet() {
        this.fields = new ArrayList<Field>();
    }

    public FieldSet(Collection<Field> fields) {
        this.fields = new ArrayList<Field>(fields);
    }

    public FieldSet(FieldSet source) {
        this.fields = source == null ? new ArrayList<Field>() : new ArrayList<Field>(source.fields);
    }

    public boolean has(String name) {
        if (name == null) {
            return false;
        }
        for (Field field : this.fields) {
            if (!name.equalsIgnoreCase(field.name)) continue;
            return true;
        }
        return false;
    }

    public FieldSet put(String name, Object value) {
        Assert.isLegal((name != null ? 1 : 0) != 0);
        this.remove(name);
        this.add(name, value);
        return this;
    }

    public FieldSet add(String name, Object value) {
        Assert.isLegal((name != null ? 1 : 0) != 0);
        if (value != null) {
            this.fields.add(new Field(name, value));
        }
        return this;
    }

    public FieldSet putAll(FieldSet source) {
        if (source != null) {
            for (Field field : source.fields) {
                this.remove(field.name);
                this.fields.add(field);
            }
        }
        return this;
    }

    public FieldSet addAll(FieldSet source) {
        if (source != null) {
            this.fields.addAll(source.fields);
        }
        return this;
    }

    public FieldSet remove(String name) {
        Assert.isLegal((name != null ? 1 : 0) != 0);
        Iterator<Field> it = this.fields.iterator();
        while (it.hasNext()) {
            Field field = it.next();
            if (!name.equalsIgnoreCase(field.name)) continue;
            it.remove();
        }
        return this;
    }

    public Object get(String name) {
        if (name != null) {
            for (Field field : this.fields) {
                if (!name.equalsIgnoreCase(field.name)) continue;
                return field.value;
            }
        }
        return null;
    }

    public Field get(int index) {
        if (index < 0 || index >= this.fields.size()) {
            return null;
        }
        return this.fields.get(index);
    }

    public String getString(String name) {
        Object value = this.get(name);
        return value != null && value instanceof String ? (String)value : null;
    }

    public int getInt(String name, int defaultValue) {
        Object value = this.get(name);
        return value != null && value instanceof Integer ? (Integer)value : defaultValue;
    }

    public Collection<Field> toList() {
        return Collections.unmodifiableCollection(this.fields);
    }

    @Override
    public Iterator<Field> iterator() {
        final Iterator<Field> it = this.fields.iterator();
        return new Iterator<Field>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Field next() {
                return (Field)it.next();
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }
        };
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public int size() {
        return this.fields.size();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Field field : this.fields) {
            buffer.append(field.name);
            buffer.append(':');
            buffer.append(' ');
            buffer.append(field.value);
            buffer.append('\r');
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public String toSemicolonSeparatedString(boolean quoteValues) {
        StringBuilder buffer = new StringBuilder();
        for (Field field : this.fields) {
            if (buffer.length() > 0) {
                buffer.append(';');
                buffer.append(' ');
            }
            buffer.append(field.name);
            buffer.append('=');
            if (quoteValues) {
                buffer.append('\"');
            }
            buffer.append(field.value);
            if (!quoteValues) continue;
            buffer.append('\"');
        }
        return buffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static FieldSet fromSemicolonSeparatedString(String str) {
        set = new FieldSet();
        name = null;
        value = null;
        buffer = null;
        inQuote = false;
        size = str.length();
        i = 0;
        while (i < size) {
            block17: {
                block19: {
                    block18: {
                        block16: {
                            c = str.charAt(i);
                            if (c != ' ') break block16;
                            if (inQuote) ** GOTO lbl-1000
                            if (buffer != null) {
                                if (name == null) {
                                    name = buffer.toString();
                                    buffer = null;
                                    value = null;
                                } else {
                                    value = buffer == null ? "" : buffer.toString();
                                    set.add(name, value);
                                    name = null;
                                    value = null;
                                    buffer = null;
                                }
                            }
                            break block17;
                        }
                        if (c != '\"') break block18;
                        inQuote = inQuote == false;
                        break block17;
                    }
                    if (c != '=') break block19;
                    if (inQuote) ** GOTO lbl-1000
                    name = buffer == null ? "" : buffer.toString();
                    buffer = null;
                    value = null;
                    break block17;
                }
                if (c == ';' && !inQuote) {
                    if (buffer != null) {
                        if (name == null) {
                            name = buffer.toString();
                            value = "";
                        } else {
                            value = buffer.toString();
                        }
                    }
                    if (name != null) {
                        set.add(name, value == null ? "" : value);
                    }
                    name = null;
                    value = null;
                    buffer = null;
                } else lbl-1000:
                // 3 sources

                {
                    if (buffer == null) {
                        buffer = new StringBuilder();
                    }
                    buffer.append(c);
                }
            }
            ++i;
        }
        if (buffer != null) {
            if (name == null) {
                name = buffer.toString();
                set.add(name, "");
            } else {
                value = buffer.toString();
                set.add(name, value);
            }
        } else if (name != null) {
            set.add(name, "");
        }
        return set;
    }
}

