/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.internal.signedcontent.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xmind.core.Core;
import org.xmind.core.IBoundary;
import org.xmind.core.IControlPoint;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IIdentifiable;
import org.xmind.core.IImage;
import org.xmind.core.IImageSpan;
import org.xmind.core.ILegend;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITopic;
import org.xmind.core.io.ResourceMappingManager;
import org.xmind.core.io.mindmanager.MMConstants;
import org.xmind.core.io.mindmanager.MMResourceMappingManager;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.ILabelRefCounter;
import org.xmind.core.util.IMarkerRefCounter;
import org.xmind.core.util.Point;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.style.StyleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MindManagerExporter
implements MMConstants {
    private static final boolean DEBUG = false;
    private static final String DOCUMENT_XML = "Document.xml";
    private static final String[] SCHEMA_NAMES = new String[]{"MindManagerApplication.xsd", "MindManagerCore.xsd", "MindManagerDelta.xsd", "MindManagerPrimitive.xsd"};
    private static ResourceMappingManager mappings = null;
    private static final double DPM = 2.834645669291339;
    private ISheet sheet;
    private ITopic centralTopic;
    private String targetPath;
    private File tempDir;
    private Map<String, String> id2OId = new HashMap<String, String>();
    private Map<String, String> entryPath2OId = new HashMap<String, String>();
    private Map<String, String> oId2BinUris = new HashMap<String, String>();
    private Map<String, File> entryFiles = new HashMap<String, File>();
    private Document document;
    private IProgressMonitor monitor;
    private List<Map.Entry<Throwable, String>> errors = null;
    private IStyleSheet allStyles = null;
    private List<String> remainingMarkers = null;
    private static Set<String> ICON_TYPES = new HashSet<String>(Arrays.asList("urn:mindjet:Unknown", "urn:mindjet:SmileyHappy", "urn:mindjet:SmileyNeutral", "urn:mindjet:SmileySad", "urn:mindjet:SmileyAngry", "urn:mindjet:SmileyScreaming", "urn:mindjet:Clock", "urn:mindjet:Calendar", "urn:mindjet:Letter", "urn:mindjet:Email", "urn:mindjet:Mailbox", "urn:mindjet:Megaphone", "urn:mindjet:House", "urn:mindjet:Rolodex", "urn:mindjet:Dollar", "urn:mindjet:Euro", "urn:mindjet:FlagRed", "urn:mindjet:FlagBlue", "urn:mindjet:FlagGreen", "urn:mindjet:FlagBlack", "urn:mindjet:FlagOrange", "urn:mindjet:FlagYellow", "urn:mindjet:FlagPurple", "urn:mindjet:TrafficLightsRed", "urn:mindjet:Marker1", "urn:mindjet:Marker2", "urn:mindjet:Marker3", "urn:mindjet:Marker4", "urn:mindjet:Marker5", "urn:mindjet:Marker6", "urn:mindjet:Marker7", "urn:mindjet:Resource1", "urn:mindjet:Resource2", "urn:mindjet:PadlockLocked", "urn:mindjet:PadlockUnlocked", "urn:mindjet:ArrowUp", "urn:mindjet:ArrowRight", "urn:mindjet:TwoEndArrow", "urn:mindjet:Phone", "urn:mindjet:Cellphone", "urn:mindjet:Camera", "urn:mindjet:Fax", "urn:mindjet:Stop", "urn:mindjet:ExclamationMark", "urn:mindjet:QuestionMark", "urn:mindjet:ThumbsUp", "urn:mindjet:OnHold", "urn:mindjet:Hourglass", "urn:mindjet:Emergency", "urn:mindjet:NoEntry", "urn:mindjet:Bomb", "urn:mindjet:Key", "urn:mindjet:Glasses", "urn:mindjet:JudgeHammer", "urn:mindjet:Rocket", "urn:mindjet:Scales", "urn:mindjet:Redo", "urn:mindjet:Lightbulb", "urn:mindjet:CoffeeCup", "urn:mindjet:TwoFeet", "urn:mindjet:Meeting", "urn:mindjet:Check", "urn:mindjet:Note", "urn:mindjet:ThumbsDown", "urn:mindjet:ArrowLeft", "urn:mindjet:ArrowDown", "urn:mindjet:Book", "urn:mindjet:MagnifyingGlass", "urn:mindjet:BrokenConnection", "urn:mindjet:Information", "urn:mindjet:Folder"));

    public MindManagerExporter(ISheet sheet, ITopic centralTopic, String targetPath) {
        this.sheet = sheet;
        this.centralTopic = centralTopic;
        this.targetPath = targetPath;
    }

    public ISheet getSheet() {
        return this.sheet;
    }

    public ITopic getCentralTopic() {
        return this.centralTopic;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public IProgressMonitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void build() throws InvocationTargetException, InterruptedException {
        this.getMonitor().beginTask(null, 100);
        String id = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", System.currentTimeMillis());
        this.tempDir = FileUtils.ensureDirectory((File)new File(Core.getWorkspace().getTempDir("export/mindmanager"), id));
        try {
            try {
                try {
                    this.document = MindManagerExporter.getDocumentBuilder().newDocument();
                }
                catch (ParserConfigurationException e) {
                    throw new InvocationTargetException(e);
                }
                this.checkInterrupted();
                this.writeContent();
                try {
                    FileOutputStream os = new FileOutputStream(new File(this.tempDir, DOCUMENT_XML));
                    DOMUtils.save((Node)this.document, (OutputStream)os, (boolean)true);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                File schemaDir = new File(this.tempDir, "xsd");
                FileUtils.ensureDirectory((File)schemaDir);
                try {
                    String[] stringArray = SCHEMA_NAMES;
                    int n = SCHEMA_NAMES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        InputStream input = MindManagerExporter.class.getResourceAsStream("xsd/" + name);
                        FileOutputStream output = new FileOutputStream(new File(schemaDir, name));
                        FileUtils.transfer((InputStream)input, (OutputStream)output, (boolean)true);
                        ++n2;
                    }
                }
                catch (Exception exception) {}
                ZipOutputStream os = new ZipOutputStream(new File(this.targetPath));
                try {
                    this.encapsulate(null, os);
                }
                finally {
                    os.close();
                }
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            this.clearTempDir();
        }
    }

    private void encapsulate(String entryPath, ZipOutputStream os) throws IOException {
        File source;
        File file = source = entryPath == null ? this.tempDir : new File(this.tempDir, entryPath);
        if (entryPath != null && source.isFile()) {
            os.putNextEntry(new ZipEntry(entryPath));
            FileInputStream is = new FileInputStream(source);
            FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)false);
            is.close();
        } else if (source.isDirectory()) {
            File[] fileArray = source.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File sub = fileArray[n2];
                String name = sub.getName();
                String subEntryPath = entryPath == null ? name : String.valueOf(entryPath) + "/" + name;
                this.encapsulate(subEntryPath, os);
                ++n2;
            }
        }
    }

    private void writeContent() {
        Element mapEle = DOMUtils.createElement((Node)this.document, (String)"ap:Map");
        this.writeMap(mapEle);
    }

    private void writeMap(Element mapEle) {
        MindManagerExporter.writeDirty(mapEle, true);
        this.writeOId(mapEle, (IIdentifiable)this.sheet);
        MindManagerExporter.writeGen(mapEle);
        mapEle.setAttribute("xmlns:ap", "http://schemas.mindjet.com/MindManager/Application/2003");
        mapEle.setAttribute("xmlns:cor", "http://schemas.mindjet.com/MindManager/Core/2003");
        mapEle.setAttribute("xmlns:pri", "http://schemas.mindjet.com/MindManager/Primitive/2003");
        mapEle.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        String loc = "http://schemas.mindjet.com/MindManager/Application/2003 http://schemas.mindjet.com/MindManager/Application/2003 http://schemas.mindjet.com/MindManager/Core/2003 http://schemas.mindjet.com/MindManager/Core/2003 http://schemas.mindjet.com/MindManager/Delta/2003 http://schemas.mindjet.com/MindManager/Delta/2003 http://schemas.mindjet.com/MindManager/Primitive/2003 http://schemas.mindjet.com/MindManager/Primitive/2003";
        mapEle.setAttribute("xsi:schemaLocation", loc);
        Element customEle = DOMUtils.createElement((Node)mapEle, (String)"cor:Custom");
        customEle.setAttribute("Index", "0");
        MindManagerExporter.writeDirty(customEle, false);
        customEle.setAttribute("Uri", "http://schemas.mindjet.com/MindManager/UpdateCompatibility/2004");
        customEle.setAttribute("cst0:UpdatedCategories", "true");
        customEle.setAttribute("cst0:UpdatedVisibilityStyle", "true");
        customEle.setAttribute("xmlns:cst0", "http://schemas.mindjet.com/MindManager/UpdateCompatibility/2004");
        this.writeOneTopic(mapEle);
        this.writeRelationships(mapEle);
        this.writeStyleGroup(mapEle);
        this.writeMapViewGroup(mapEle);
        this.writeDocumentGroup(mapEle);
        this.writeMarkersSetGroup(mapEle);
    }

    private void writeOneTopic(Element mapEle) {
        Element oneTopicEle = DOMUtils.createElement((Node)mapEle, (String)"ap:OneTopic");
        this.writeTopic(oneTopicEle, this.getCentralTopic());
    }

    private void writeTopic(Element parentEle, ITopic topic) {
        Element topicEle = DOMUtils.createElement((Node)parentEle, (String)"ap:Topic");
        MindManagerExporter.writeDirty(topicEle, true);
        this.writeOId(topicEle, (IIdentifiable)topic);
        MindManagerExporter.writeGen(topicEle);
        ArrayList<String> icons = new ArrayList<String>();
        ArrayList<String> tasks = new ArrayList<String>();
        this.collectMarkers(topic, icons, tasks);
        IStyle style = this.getStyle((IStyled)topic);
        this.writeSubTopics(topicEle, topic);
        this.writeFloatingTopics(topicEle, topic);
        this.writeCallouts(topicEle, topic);
        this.writeOneBoundary(topicEle, topic);
        this.writeOneImage(topicEle, topic);
        this.writeTopicViewGroup(topicEle, topic);
        this.writeText(topicEle, topic, style);
        this.writeColor(topicEle, (IStyled)topic, style, false);
        this.writeNotesGroup(topicEle, topic);
        this.writeOffset(topicEle, topic);
        this.writeIconsGroup(topicEle, topic, icons);
        this.writeSubTopicShape(topicEle, topic, style);
        this.writeTopicLayout(topicEle, topic);
        this.writeSubTopicsShape(topicEle, topic, style);
        this.writeHyperlink(topicEle, topic);
        this.writeTask(topicEle, topic, tasks);
        this.writeAttachmentGroup(topicEle, topic);
        this.writeTextLabels(topicEle, topic);
    }

    private IStyle getStyle(IStyled styleOwner) {
        if (styleOwner != null) {
            String styleId = styleOwner.getStyleId();
            if (styleId == null) {
                return null;
            }
            return this.getSheet().getOwnedWorkbook().getStyleSheet().findStyle(styleId);
        }
        return null;
    }

    private void collectMarkers(ITopic topic, List<String> icons, List<String> tasks) {
        IMarkerSheet markerSheet = topic.getOwnedWorkbook().getMarkerSheet();
        for (IMarkerRef mr : topic.getMarkerRefs()) {
            IMarkerGroup group;
            String icon;
            String markerId = mr.getMarkerId();
            IMarker marker = markerSheet.findMarker(markerId);
            if (marker == null || (icon = MindManagerExporter.convertIcon(markerId)) == null || (group = marker.getParent()) == null) continue;
            String groupId = group.getId();
            if ("taskMakers".equals(groupId) || "priorityMarkers".equals(groupId)) {
                tasks.add(icon);
                continue;
            }
            icons.add(icon);
        }
    }

    private static String convertIcon(String markerId) {
        return MindManagerExporter.getMapping("marker", markerId, null);
    }

    private void writeSubTopics(Element topicEle, ITopic topic) {
        if (topic.hasChildren("attached")) {
            Element subtopicsEle = DOMUtils.createElement((Node)topicEle, (String)"ap:SubTopics");
            for (ITopic subtopic : topic.getChildren("attached")) {
                this.writeTopic(subtopicsEle, subtopic);
            }
        }
    }

    private void writeFloatingTopics(Element topicEle, ITopic topic) {
        if (topic.equals(this.getCentralTopic()) && topic.hasChildren("detached")) {
            Element topicsEle = DOMUtils.createElement((Node)topicEle, (String)"ap:FloatingTopics");
            for (ITopic subtopic : topic.getChildren("detached")) {
                this.writeTopic(topicsEle, subtopic);
            }
        }
    }

    private void writeCallouts(Element topicEle, ITopic topic) {
        if (topic.hasChildren("callout")) {
            Element topicsEle = DOMUtils.createElement((Node)topicEle, (String)"ap:FloatingTopics");
            for (ITopic subtopic : topic.getChildren("callout")) {
                this.writeTopic(topicsEle, subtopic);
            }
        }
    }

    private void writeOneBoundary(Element topicEle, ITopic topic) {
        IBoundary boundary = this.findOneBoundary(topic);
        if (boundary == null) {
            return;
        }
        Element oneBoundaryEle = DOMUtils.createElement((Node)topicEle, (String)"ap:OneBoundary");
        Element boundaryEle = DOMUtils.createElement((Node)oneBoundaryEle, (String)"ap:Boundary");
        MindManagerExporter.writeDirty(boundaryEle, true);
        String oId = this.findOId(boundary.getId());
        oId = oId == null ? this.getOId(boundary.getId()) : MMEncoder.generateId();
        boundaryEle.setAttribute("OId", oId);
        MindManagerExporter.writeGen(boundaryEle);
        IStyle style = this.getStyle((IStyled)boundary);
        this.writeColor(boundaryEle, (IStyled)boundary, style, true);
        this.writeLineStyle(boundaryEle, (IStyled)boundary, style);
        this.writeBoundaryShape(boundaryEle, boundary, style);
    }

    private IBoundary findOneBoundary(ITopic topic) {
        if (topic.equals(this.getCentralTopic())) {
            return null;
        }
        for (IBoundary b : topic.getBoundaries()) {
            if (!b.isMasterBoundary()) continue;
            return b;
        }
        ITopic parent = topic.getParent();
        if (parent == null) {
            return null;
        }
        Set boundaries = parent.getBoundaries();
        if (boundaries.isEmpty()) {
            return null;
        }
        int index = topic.getIndex();
        for (IBoundary b : boundaries) {
            int startIndex = b.getStartIndex();
            int endIndex = b.getEndIndex();
            if (startIndex > index || index > endIndex) continue;
            return b;
        }
        return null;
    }

    private void writeLineStyle(Element ele, IStyled styleOwner, IStyle style) {
        String width;
        String dashStyle = style == null ? null : MindManagerExporter.convertDashStyle(style.getProperty("line-pattern"));
        String string = width = style == null ? null : MindManagerExporter.convertLineWidth(style.getProperty("line-width"));
        if (dashStyle != null && width != null) {
            Element lineStyleEle = DOMUtils.createElement((Node)ele, (String)"ap:LineStyle");
            MindManagerExporter.writeDirty(lineStyleEle, true);
            if (dashStyle != null) {
                lineStyleEle.setAttribute("LineDashStyle", dashStyle);
            }
            if (width != null) {
                lineStyleEle.setAttribute("LineWidth", width);
            }
        }
    }

    private static String convertDashStyle(String dash) {
        return MindManagerExporter.getMapping("lineStyle", dash, null);
    }

    private static String convertLineWidth(String width) {
        int w = MindManagerExporter.parseInt(width = StyleUtils.trimNumber((String)width), -1);
        if (w > 0) {
            switch (w) {
                case 1: {
                    return "1.000000";
                }
                case 2: {
                    return "2.250000";
                }
                case 3: {
                    return "3.000000";
                }
                case 4: {
                    return "4.500000";
                }
                case 5: {
                    return "6.000000";
                }
            }
        }
        return null;
    }

    private void writeBoundaryShape(Element boundaryEle, IBoundary b, IStyle style) {
        String shape;
        String string = shape = style == null ? null : MindManagerExporter.convertBoundaryShape(style.getProperty("shape-class"));
        if (shape != null) {
            Element ele = DOMUtils.createElement((Node)boundaryEle, (String)"ap:BoundaryShape");
            MindManagerExporter.writeDirty(ele, true);
            ele.setAttribute("BoundaryShape", shape);
        }
    }

    private static String convertBoundaryShape(String shape) {
        return MindManagerExporter.getMapping("boundaryShape", shape, null);
    }

    private void writeOneImage(Element topicEle, ITopic topic) {
        IImage image = topic.getImage();
        String source = image.getSource();
        if (source == null) {
            return;
        }
        String uri = source;
        if (HyperlinkUtils.isAttachmentURL((String)source)) {
            String entryPath = HyperlinkUtils.toAttachmentPath((String)source);
            uri = this.getBinUri(entryPath);
        }
        Element oneImageEle = DOMUtils.createElement((Node)topicEle, (String)"ap:OneImage");
        Element imageEle = DOMUtils.createElement((Node)oneImageEle, (String)"ap:Image");
        MindManagerExporter.writeDirty(imageEle, true);
        this.writeOId(imageEle, null);
        MindManagerExporter.writeGen(imageEle);
        Element imageDataEle = DOMUtils.createElement((Node)imageEle, (String)"ap:ImageData");
        MindManagerExporter.writeDirty(imageDataEle, true);
        imageDataEle.setAttribute("ImageType", "urn:mindjet:PngImage");
        MindManagerExporter.writeUri(imageDataEle, uri);
        int w = image.getWidth();
        int h = image.getHeight();
        if (w != -1 || h != -1) {
            Element sizeEle = DOMUtils.createElement((Node)imageEle, (String)"ap:ImageSize");
            MindManagerExporter.writeDirty(sizeEle, true);
            if (w != -1) {
                sizeEle.setAttribute("Width", Float.toString(MindManagerExporter.dots2MM(w)));
            }
            if (h != -1) {
                sizeEle.setAttribute("Height", Float.toString(MindManagerExporter.dots2MM(h)));
            }
        }
    }

    private static void writeUri(Element parentEle, String uri) {
        Element uriEle = DOMUtils.createElement((Node)parentEle, (String)"cor:Uri");
        uriEle.setAttribute("xsi:nil", "false");
        uriEle.setTextContent(uri);
    }

    private void writeTopicViewGroup(Element topicEle, ITopic topic) {
        Element topicViewGroupEle = DOMUtils.createElement((Node)topicEle, (String)"ap:TopicViewGroup");
        topicViewGroupEle.setAttribute("ViewIndex", "0");
        if (topic.equals(this.getCentralTopic()) && !topic.getAllChildren().isEmpty() || !topic.equals(this.getCentralTopic()) && topic.hasChildren("attached")) {
            Element collapsedEle = DOMUtils.createElement((Node)topicViewGroupEle, (String)"ap:Collapsed");
            collapsedEle.setAttribute("Collapsed", Boolean.toString(topic.isFolded()));
            MindManagerExporter.writeDirty(collapsedEle, !topic.equals(this.getCentralTopic()));
        }
    }

    private void writeText(Element topicEle, ITopic topic, IStyle style) {
        if (!topic.hasTitle()) {
            return;
        }
        Element textEle = DOMUtils.createElement((Node)topicEle, (String)"ap:Text");
        MindManagerExporter.writeDirty(textEle, true);
        textEle.setAttribute("PlainText", topic.getTitleText());
        textEle.setAttribute("ReadOnly", "false");
        MindManagerExporter.writeFont(textEle, style);
    }

    private static void writeFont(Element textEle, IStyle style) {
        String color = style == null ? null : MindManagerExporter.convertColor(style.getProperty("fo:color"));
        String fontName = style == null ? null : style.getProperty("fo:font-family");
        String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
        fontName = availableFontName != null ? availableFontName : fontName;
        String size = style == null ? null : style.getProperty("fo:font-size");
        boolean bold = StyleUtils.isBold((IStyle)style);
        boolean italic = StyleUtils.isItalic((IStyle)style);
        boolean underline = StyleUtils.isUnderline((IStyle)style);
        boolean strikethrough = StyleUtils.isStrikeout((IStyle)style);
        MindManagerExporter.writeFont(textEle, color, fontName, size, bold ? Boolean.TRUE : null, italic ? Boolean.TRUE : null, underline ? Boolean.TRUE : null, strikethrough ? Boolean.TRUE : null);
    }

    private static String convertColor(String color) {
        return MindManagerExporter.convertColor(color, null);
    }

    private static String convertColor(String color, String opacity) {
        if (color != null) {
            if (color.startsWith("#")) {
                color = color.substring(1);
            }
            try {
                int rgb = Integer.parseInt(color, 16);
                int a = opacity == null ? 255 : (int)(Double.parseDouble(StyleUtils.trimNumber((String)opacity)) * 255.0);
                return String.format("%02X%02X%02X%02X", a, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    private static void writeFont(Element parentEle, String color, String name, String size, Boolean bold, Boolean italic, Boolean underline, Boolean strikethrough) {
        Element fontEle = DOMUtils.createElement((Node)parentEle, (String)"ap:Font");
        if (color != null) {
            fontEle.setAttribute("Color", color);
        }
        if (name != null) {
            String availableFontName = FontUtils.getAAvailableFontNameFor((String)name);
            String string = name = availableFontName != null ? availableFontName : name;
            if ("$system$".equals(name)) {
                name = JFaceResources.getDefaultFontDescriptor().getFontData()[0].getName();
            }
            fontEle.setAttribute("Name", name);
        }
        if (size != null) {
            fontEle.setAttribute("Size", StyleUtils.trimNumber((String)size));
        }
        if (bold != null) {
            fontEle.setAttribute("Bold", bold.toString());
        }
        if (italic != null) {
            fontEle.setAttribute("Italic", italic.toString());
        }
        if (underline != null) {
            fontEle.setAttribute("Underline", underline.toString());
        }
        if (strikethrough != null) {
            fontEle.setAttribute("Strikethrough", strikethrough.toString());
        }
    }

    private void writeColor(Element ele, IStyled styleOwner, IStyle style, boolean transparent) {
        String fillColor = MindManagerExporter.getFillColor(styleOwner, style, transparent);
        String lineColor = this.getLineColor(styleOwner, style);
        if (fillColor != null || lineColor != null) {
            Element colorEle = DOMUtils.createElement((Node)ele, (String)"ap:Color");
            MindManagerExporter.writeDirty(colorEle, true);
            if (fillColor != null) {
                colorEle.setAttribute("FillColor", fillColor);
            }
            if (lineColor != null) {
                colorEle.setAttribute("LineColor", lineColor);
            }
        }
    }

    private static String getFillColor(IStyled styleOwner, IStyle style, boolean transparent) {
        String shape;
        if (styleOwner instanceof ITopic && style != null && ("org.xmind.topicShape.noBorder".equals(shape = style.getProperty("shape-class")) || "org.xmind.topicShape.underline".equals(shape))) {
            return "00000000";
        }
        String alpha = transparent && style != null ? style.getProperty("svg:opacity") : null;
        return MindManagerExporter.convertColor(style == null ? null : style.getProperty("svg:fill"), alpha);
    }

    private String getLineColor(IStyled styleOwner, IStyle style) {
        ITopic topic;
        String lineColor;
        String string = lineColor = style == null ? null : style.getProperty("line-color");
        if (lineColor == null && styleOwner instanceof ITopic && (topic = (ITopic)styleOwner).isAttached()) {
            this.getCentralTopic().equals(topic.getParent());
        }
        lineColor = MindManagerExporter.convertColor(lineColor);
        return lineColor;
    }

    private void writeNotesGroup(Element topicEle, ITopic topic) {
        if (topic.getNotes().isEmpty()) {
            return;
        }
        String plain = null;
        INotesContent content = topic.getNotes().getContent("plain");
        if (content instanceof IPlainNotesContent) {
            plain = ((IPlainNotesContent)content).getTextContent();
        }
        Element notesGroupEle = DOMUtils.createElement((Node)topicEle, (String)"ap:NotesGroup");
        Element notesDataEle = DOMUtils.createElement((Node)notesGroupEle, (String)"ap:NotesXhtmlData");
        MindManagerExporter.writeDirty(notesDataEle, true);
        if (plain != null) {
            notesDataEle.setAttribute("PreviewPlainText", plain);
        }
        Element htmlEle = DOMUtils.createElement((Node)notesDataEle, (String)"xhtml:html");
        htmlEle.setAttribute("xmlns:xhtml", "http://www.w3.org/1999/xhtml");
        content = topic.getNotes().getContent("html");
        if (content instanceof IHtmlNotesContent) {
            ArrayList<NotesData> notesDataList = new ArrayList<NotesData>();
            for (IParagraph p : ((IHtmlNotesContent)content).getParagraphs()) {
                this.writeParagraph(htmlEle, p, notesDataList);
            }
            this.writeNotesData(notesGroupEle, topic, notesDataList);
        }
    }

    private void writeParagraph(Element ele, IParagraph p, List<NotesData> notesDataList) {
        String align;
        Element pEle = DOMUtils.createElement((Node)ele, (String)"p");
        IStyle style = this.getStyle((IStyled)p);
        String string = align = style == null ? null : style.getProperty("fo:text-align");
        if (align != null) {
            pEle.setAttribute("align", align);
        }
        pEle.setAttribute("style", "margin: 0.0px 0.0px 0.0px 0.0px");
        Element fontEle = DOMUtils.createElement((Node)pEle, (String)"font");
        for (ISpan span : p.getSpans()) {
            this.writeSpan(fontEle, span, notesDataList);
        }
    }

    private void writeSpan(Element ele, ISpan span, List<NotesData> notesDataList) {
        if (span instanceof IImageSpan) {
            this.writeImageSpan(ele, (IImageSpan)span, notesDataList);
        } else if (span instanceof ITextSpan) {
            this.writeTextSpan(ele, (ITextSpan)span);
        } else if (span instanceof IHyperlinkSpan) {
            this.writeHyperlinkSpan(ele, (IHyperlinkSpan)span, notesDataList);
        }
    }

    private void writeHyperlinkSpan(Element ele, IHyperlinkSpan span, List<NotesData> notesDataList) {
        Element aEle = DOMUtils.createElement((Node)ele, (String)"a");
        aEle.setAttribute("href", span.getHref());
        for (ISpan childSpan : span.getSpans()) {
            this.writeSpan(aEle, childSpan, notesDataList);
        }
    }

    private void writeImageSpan(Element ele, IImageSpan span, List<NotesData> notesDataList) {
        String entryPath;
        String imageUri;
        String source = span.getSource();
        if (source != null && HyperlinkUtils.isAttachmentURL((String)source) && (imageUri = this.getImageUri(entryPath = HyperlinkUtils.toAttachmentPath((String)source), notesDataList)) != null) {
            Element imgEle = DOMUtils.createElement((Node)ele, (String)"img");
            imgEle.setAttribute("src", imageUri);
            imgEle.setAttribute("alt", imageUri);
        }
    }

    private String getImageUri(String entryPath, List<NotesData> notesDataList) {
        String binUri = this.getBinUri(entryPath);
        if (binUri != null) {
            NotesData nd = this.findNotesData(binUri, notesDataList);
            if (nd != null) {
                return nd.imageUri;
            }
            int index = notesDataList.size();
            nd = new NotesData(index, binUri);
            notesDataList.add(nd);
            return nd.imageUri;
        }
        return null;
    }

    private NotesData findNotesData(String uri, List<NotesData> notesDataList) {
        for (NotesData nd : notesDataList) {
            if (!uri.equals(nd.uri)) continue;
            return nd;
        }
        return null;
    }

    private static int parseInt(String value, int defaultValue) {
        if (value != null) {
            try {
                return Integer.parseInt(StyleUtils.trimNumber((String)value));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private void writeTextSpan(Element ele, ITextSpan span) {
        boolean italic;
        boolean strikeout;
        boolean underline;
        boolean bold;
        IStyle style = this.getStyle((IStyled)span);
        String fontName = style == null ? null : style.getProperty("fo:font-family");
        String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
        fontName = availableFontName != null ? availableFontName : fontName;
        String color = style == null ? null : style.getProperty("fo:color");
        String bg = style == null ? null : style.getProperty("fo:background-color");
        int size = MindManagerExporter.parseInt(style == null ? null : style.getProperty("fo:font-size"), -1);
        if (fontName != null || color != null || bg != null || size > 0) {
            ele = DOMUtils.createElement((Node)ele, (String)"font");
            if (fontName != null) {
                ele.setAttribute("face", fontName);
            }
            if (color != null) {
                ele.setAttribute("color", color);
            }
            StringBuilder styleBuffer = new StringBuilder(20);
            if (size > 0) {
                styleBuffer.append("font-size:");
                styleBuffer.append(size);
                styleBuffer.append("pt");
            }
            if (bg != null) {
                if (styleBuffer.length() > 0) {
                    styleBuffer.append("; ");
                }
                styleBuffer.append("background:");
                styleBuffer.append(bg);
            }
            if (styleBuffer.length() > 0) {
                ele.setAttribute("style", styleBuffer.toString());
            }
        }
        if (bold = StyleUtils.isBold((IStyle)style)) {
            ele = DOMUtils.createElement((Node)ele, (String)"b");
        }
        if (underline = StyleUtils.isUnderline((IStyle)style)) {
            ele = DOMUtils.createElement((Node)ele, (String)"u");
        }
        if (strikeout = StyleUtils.isStrikeout((IStyle)style)) {
            ele = DOMUtils.createElement((Node)ele, (String)"s");
        }
        if (italic = StyleUtils.isItalic((IStyle)style)) {
            ele = DOMUtils.createElement((Node)ele, (String)"i");
        }
        Text text = this.document.createTextNode(span.getTextContent());
        ele.appendChild(text);
    }

    private void writeNotesData(Element notesGroupEle, ITopic topic, List<NotesData> notesDataList) {
        int i = 0;
        while (i < notesDataList.size()) {
            Element notesDataEle = DOMUtils.createElement((Node)notesGroupEle, (String)"ap:NotesData");
            notesDataEle.setAttribute("Index", Integer.toString(i));
            MindManagerExporter.writeDirty(notesDataEle, true);
            NotesData notesData = notesDataList.get(i);
            notesDataEle.setAttribute("ImageUri", notesData.imageUri);
            Element uriEle = DOMUtils.createElement((Node)notesDataEle, (String)"cor:Uri");
            uriEle.setAttribute("xsi:nil", "false");
            uriEle.setTextContent(notesData.uri);
            ++i;
        }
    }

    private void writeOffset(Element topicEle, ITopic topic) {
        if (topic.hasPosition()) {
            Element offsetEle = DOMUtils.createElement((Node)topicEle, (String)"ap:Offset");
            if ("detached".equals(topic.getType())) {
                offsetEle.setAttribute("OffsetPriority", "0");
            }
            MindManagerExporter.writeDirty(offsetEle, true);
            Point position = topic.getPosition();
            int x = position.x;
            int y = position.y;
            offsetEle.setAttribute("CX", Float.toString(MindManagerExporter.dots2MM(x)));
            offsetEle.setAttribute("CY", Float.toString(MindManagerExporter.dots2MM(y)));
            return;
        }
        if (topic.isAttached() && this.getCentralTopic().equals(topic.getParent())) {
            Element offsetEle = DOMUtils.createElement((Node)topicEle, (String)"ap:Offset");
            MindManagerExporter.writeDirty(offsetEle, true);
            List children = this.getCentralTopic().getChildren("attached");
            int num = children.size();
            int index = children.indexOf(topic);
            String x = MindManagerExporter.isLeft(index, num) ? "-30.000000" : "30.000000";
            offsetEle.setAttribute("CX", x);
            offsetEle.setAttribute("CY", "0.000000");
            return;
        }
        Element offsetEle = DOMUtils.createElement((Node)topicEle, (String)"ap:Offset");
        MindManagerExporter.writeDirty(offsetEle, false);
        offsetEle.setAttribute("CX", "0.000000");
        offsetEle.setAttribute("CY", "0.000000");
    }

    private static boolean isLeft(int index, int num) {
        return num == 3 && index == 2 || num > 3 && index >= num / 2;
    }

    private void writeIconsGroup(Element topicEle, ITopic topic, List<String> icons) {
        if (icons.isEmpty()) {
            return;
        }
        Element iconsGroupEle = DOMUtils.createElement((Node)topicEle, (String)"ap:IconsGroup");
        Element iconsEle = DOMUtils.createElement((Node)iconsGroupEle, (String)"ap:Icons");
        for (String icon : icons) {
            Element iconEle = DOMUtils.createElement((Node)iconsEle, (String)"ap:Icon");
            iconEle.setAttribute("xsi:type", "ap:StockIcon");
            iconEle.setAttribute("IconType", icon);
        }
    }

    private void writeTopicLayout(Element topicEle, ITopic topic) {
        if (topic.getImage().getSource() == null) {
            return;
        }
        String imgAlign = topic.getImage().getAlignment();
        String align = MindManagerExporter.convertImageAlign(imgAlign);
        if (align == null) {
            return;
        }
        Element topicLayoutEle = DOMUtils.createElement((Node)topicEle, (String)"ap:TopicLayout");
        MindManagerExporter.writeDirty(topicLayoutEle, true);
        topicLayoutEle.setAttribute("TopicTextAndImagePosition", align);
    }

    private static String convertImageAlign(String imgAlign) {
        return MindManagerExporter.getMapping("imageAlignment", imgAlign, null);
    }

    private void writeSubTopicShape(Element topicEle, ITopic topic, IStyle style) {
        String shape;
        String string = shape = style == null ? null : style.getProperty("shape-class");
        if (shape == null) {
            return;
        }
        if ((shape = MindManagerExporter.convertTopicShape(shape, null)) == null) {
            return;
        }
        Element ele = DOMUtils.createElement((Node)topicEle, (String)"ap:SubTopicShape");
        MindManagerExporter.writeDirty(ele, true);
        ele.setAttribute("SubTopicShape", shape);
    }

    private static String convertTopicShape(String shape, String defaultShape) {
        return MindManagerExporter.getMapping("topicShape", shape, defaultShape);
    }

    private void writeSubTopicsShape(Element topicEle, ITopic topic, IStyle style) {
        String line;
        String string = line = style == null ? null : style.getProperty("line-class");
        if (line != null) {
            line = MindManagerExporter.convertConnectionStyle(line, null);
        }
        String structureClass = topic.getStructureClass();
        ArrayList<String> attrs = new ArrayList<String>();
        if ("org.xmind.ui.map".equals(structureClass)) {
            attrs.add("SubTopicsAlignment");
            attrs.add("urn:mindjet:Center");
            attrs.add("SubTopicsGrowth");
            attrs.add("urn:mindjet:Horizontal");
            attrs.add("SubTopicsGrowthDirection");
            attrs.add("urn:mindjet:LeftAndRight");
        } else if ("org.xmind.ui.org-chart.down".equals(structureClass)) {
            attrs.add("SubTopicsGrowth");
            attrs.add("urn:mindjet:Vertical");
            attrs.add("SubTopicsVerticalAlignment");
            attrs.add("urn:mindjet:Middle");
            attrs.add("SubTopicsVerticalGrowthDirection");
            attrs.add("urn:mindjet:Down");
        } else if ("org.xmind.ui.org-chart.up".equals(structureClass)) {
            attrs.add("SubTopicsGrowth");
            attrs.add("urn:mindjet:Vertical");
            attrs.add("SubTopicsVerticalAlignment");
            attrs.add("urn:mindjet:Middle");
            attrs.add("SubTopicsVerticalGrowthDirection");
            attrs.add("urn:mindjet:Up");
        } else if ("org.xmind.ui.tree.right".equals(structureClass)) {
            attrs.add("SubTopicsAlignment");
            attrs.add("urn:mindjet:Bottom");
            attrs.add("SubTopicsGrowth");
            attrs.add("urn:mindjet:Horizontal");
            attrs.add("SubTopicsGrowthDirection");
            attrs.add("urn:mindjet:Right");
        } else if ("org.xmind.ui.tree.left".equals(structureClass)) {
            attrs.add("SubTopicsAlignment");
            attrs.add("urn:mindjet:Bottom");
            attrs.add("SubTopicsGrowth");
            attrs.add("urn:mindjet:Horizontal");
            attrs.add("SubTopicsGrowthDirection");
            attrs.add("urn:mindjet:Left");
        } else if ("org.xmind.ui.logic-chart.right".equals(structureClass)) {
            attrs.add("SubTopicsAlignment");
            attrs.add("urn:mindjet:Center");
            attrs.add("SubTopicsGrowth");
            attrs.add("urn:mindjet:Horizontal");
            attrs.add("SubTopicsGrowthDirection");
            attrs.add("urn:mindjet:Right");
        } else if ("org.xmind.ui.logic-chart.left".equals(structureClass)) {
            attrs.add("SubTopicsAlignment");
            attrs.add("urn:mindjet:Center");
            attrs.add("SubTopicsGrowth");
            attrs.add("urn:mindjet:Horizontal");
            attrs.add("SubTopicsGrowthDirection");
            attrs.add("urn:mindjet:Left");
        }
        if (line != null || !attrs.isEmpty()) {
            Element ele = DOMUtils.createElement((Node)topicEle, (String)"ap:SubTopicsShape");
            MindManagerExporter.writeDirty(ele, true);
            if (line != null) {
                ele.setAttribute("SubTopicsConnectionStyle", line);
            }
            if (!attrs.isEmpty()) {
                Iterator it = attrs.iterator();
                while (it.hasNext()) {
                    ele.setAttribute((String)it.next(), (String)it.next());
                }
            }
        }
    }

    private static String convertConnectionStyle(String line, String defaultValue) {
        return MindManagerExporter.getMapping("branchConnection", line, defaultValue);
    }

    private void writeHyperlink(Element topicEle, ITopic topic) {
        String url = topic.getHyperlink();
        if (url != null && !HyperlinkUtils.isAttachmentURL((String)url)) {
            boolean absolute = false;
            if (HyperlinkUtils.isInternalURL((String)url)) {
                String id = HyperlinkUtils.toElementID((String)url);
                if (id != null) {
                    String OId = this.getOId(id);
                    url = "#xpointer(/descendant-or-self::ap:Topic[@OId='" + OId + "'])";
                }
            } else if (url.startsWith("file:")) {
                String path = FilePathParser.toPath((String)url.substring(5));
                absolute = !FilePathParser.isPathRelative((String)path);
                url = "\"" + path + "\"";
            }
            Element hyperlinkEle = DOMUtils.createElement((Node)topicEle, (String)"ap:Hyperlink");
            MindManagerExporter.writeDirty(hyperlinkEle, true);
            hyperlinkEle.setAttribute("Name", "");
            hyperlinkEle.setAttribute("HyperlinkSourceHandling", "urn:mindjet:CopySource");
            hyperlinkEle.setAttribute("HyperlinkType", "urn:mindjet:Unknown");
            hyperlinkEle.setAttribute("Url", url);
            hyperlinkEle.setAttribute("Hidden", "false");
            hyperlinkEle.setAttribute("Target", "");
            hyperlinkEle.setAttribute("Absolute", Boolean.toString(absolute));
            hyperlinkEle.setAttribute("CachedName", "");
        }
    }

    private void writeTask(Element topicEle, ITopic topic, List<String> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        Element taskEle = DOMUtils.createElement((Node)topicEle, (String)"ap:Task");
        MindManagerExporter.writeDirty(taskEle, true);
        for (String task : tasks) {
            if (task.startsWith("urn")) {
                taskEle.setAttribute("TaskPriority", task);
                continue;
            }
            taskEle.setAttribute("TaskPercentage", task);
        }
    }

    private void writeTextLabels(Element topicEle, ITopic topic) {
        Set labels = topic.getLabels();
        if (labels.isEmpty()) {
            return;
        }
        Element labelsEle = DOMUtils.createElement((Node)topicEle, (String)"ap:TextLabels");
        MindManagerExporter.writeDirty(labelsEle, true);
        for (String label : labels) {
            Element labelEle = DOMUtils.createElement((Node)labelsEle, (String)"ap:TextLabel");
            labelEle.setAttribute("TextLabelName", label);
        }
    }

    private void writeAttachmentGroup(Element topicEle, ITopic topic) {
        String url = topic.getHyperlink();
        if (url == null || !HyperlinkUtils.isAttachmentURL((String)url)) {
            return;
        }
        String entryPath = HyperlinkUtils.toAttachmentPath((String)url);
        String oId = this.getAttOId(entryPath);
        String uri = this.getBinUri(entryPath);
        if (oId == null || uri == null) {
            return;
        }
        Element attGroupEle = DOMUtils.createElement((Node)topicEle, (String)"ap:AttachmentGroup");
        Element attDataEle = DOMUtils.createElement((Node)attGroupEle, (String)"ap:AttachmentData");
        attDataEle.setAttribute("Index", "0");
        attDataEle.setAttribute("AttachmentId", oId);
        MindManagerExporter.writeDirty(attDataEle, true);
        attDataEle.setAttribute("Type", "urn:mindjet:File");
        attDataEle.setAttribute("FileName", topic.hasTitle() ? topic.getTitleText() : FileUtils.getFileName((String)entryPath));
        IFileEntry entry = this.getSheet().getOwnedWorkbook().getManifest().getFileEntry(entryPath);
        if (entry != null) {
            attDataEle.setAttribute("FileSize", Long.toString(entry.getSize()));
        }
        MindManagerExporter.writeUri(attDataEle, uri);
    }

    private void writeRelationships(Element mapEle) {
        Set rels = this.getSheet().getRelationships();
        if (rels.isEmpty()) {
            return;
        }
        Element relsEle = DOMUtils.createElement((Node)mapEle, (String)"ap:Relationships");
        for (IRelationship r : rels) {
            this.writeRelationship(relsEle, r);
        }
    }

    private void writeRelationship(Element relsEle, IRelationship r) {
        String beginRef = this.findOId(r.getEnd1Id());
        String endRef = this.findOId(r.getEnd2Id());
        if (beginRef == null || endRef == null) {
            return;
        }
        Element relEle = DOMUtils.createElement((Node)relsEle, (String)"ap:Relationship");
        MindManagerExporter.writeDirty(relEle, true);
        this.writeOId(relEle, (IIdentifiable)r);
        MindManagerExporter.writeGen(relEle);
        IStyle style = this.getStyle((IStyled)r);
        boolean autoRouting = this.writeConnectionGroup(relEle, r, 0, beginRef, style);
        this.writeColor(relEle, (IStyled)r, style, false);
        this.writeLineStyle(relEle, (IStyled)r, style);
        this.writeAutoRoute(relEle, r, autoRouting &= this.writeConnectionGroup(relEle, r, 1, endRef, style));
        this.writeRelLineShape(relEle, r, style);
    }

    private boolean writeConnectionGroup(Element relEle, IRelationship r, int index, String objRef, IStyle style) {
        Point position;
        boolean autoRouting;
        Element connGroupEle = DOMUtils.createElement((Node)relEle, (String)"ap:ConnectionGroup");
        connGroupEle.setAttribute("Index", Integer.toString(index));
        Element connEle = DOMUtils.createElement((Node)connGroupEle, (String)"ap:Connection");
        MindManagerExporter.writeDirty(connEle, true);
        IControlPoint cp = r.getControlPoint(index);
        boolean bl = autoRouting = cp == null;
        if (!autoRouting && (position = cp.getPosition()) != null) {
            connEle.setAttribute("CX", Float.toString(MindManagerExporter.dots2MM(position.x)));
            connEle.setAttribute("CY", Float.toString(MindManagerExporter.dots2MM(position.y)));
        }
        Element objRefEle = DOMUtils.createElement((Node)connEle, (String)"ap:ObjectReference");
        objRefEle.setAttribute("OIdRef", objRef);
        String arrow = style == null ? null : style.getProperty(index == 0 ? "arrow-begin-class" : "arrow-end-class");
        String connShape = MindManagerExporter.convertConnectionShape(arrow, index == 0 ? "urn:mindjet:NoArrow" : "urn:mindjet:Arrow");
        if (connShape != null) {
            Element connStyleEle = DOMUtils.createElement((Node)connGroupEle, (String)"ap:ConnectionStyle");
            MindManagerExporter.writeDirty(connStyleEle, true);
            connStyleEle.setAttribute("ConnectionShape", connShape);
        }
        return autoRouting;
    }

    private static String convertConnectionShape(String arrow, String defaultValue) {
        return MindManagerExporter.getMapping("arrowShape", arrow, defaultValue);
    }

    private void writeAutoRoute(Element relEle, IRelationship r, boolean autoRouting) {
        Element autoRouteEle = DOMUtils.createElement((Node)relEle, (String)"ap:AutoRoute");
        MindManagerExporter.writeDirty(autoRouteEle, true);
        autoRouteEle.setAttribute("AutoRouting", Boolean.toString(autoRouting));
    }

    private void writeRelLineShape(Element relEle, IRelationship r, IStyle style) {
        String shape = MindManagerExporter.convertRelLineShape(style == null ? null : style.getProperty("shape-class"));
        if (shape != null) {
            Element ele = DOMUtils.createElement((Node)relEle, (String)"ap:RelationshipLineShape");
            MindManagerExporter.writeDirty(ele, true);
            ele.setAttribute("LineShape", shape);
        }
    }

    private static String convertRelLineShape(String shape) {
        return MindManagerExporter.getMapping("relaitonshipShape", shape, null);
    }

    private void writeStyleGroup(Element mapEle) {
        Element styleGroupEle = DOMUtils.createElement((Node)mapEle, (String)"ap:StyleGroup");
        this.writeRootTopicDefaultsGroup(styleGroupEle);
        this.writeRootSubTopicDefaultsGroup(styleGroupEle, 0);
        this.writeRootSubTopicDefaultsGroup(styleGroupEle, 1);
        this.writeCalloutTopicDefaultsGroup(styleGroupEle);
        this.writeCalloutSubTopicDefaultsGroup(styleGroupEle, 0);
        this.writeLabelTopicDefaultsGroup(styleGroupEle);
        this.writeLabelSubTopicDefaultsGroup(styleGroupEle, 0);
        this.writeOrgChartTopicDefaultsGroup(styleGroupEle);
        this.writeOrgChartSubTopicDefaultsGroup(styleGroupEle, 0);
        this.writeOrgChartSubTopicDefaultsGroup(styleGroupEle, 1);
        this.writeRelationshipDefaultsGroup(styleGroupEle);
        this.writeBoundaryDefaultsGroup(styleGroupEle);
        this.writeImageDefaultsGroup(styleGroupEle);
        IStyle style = this.getStyle((IStyled)this.getSheet());
        this.writeStructure(styleGroupEle, style);
        this.writeBackgroundFill(styleGroupEle, style);
        this.writeBackgroundImageData(styleGroupEle, style);
        this.writeNotesDefaultFont(styleGroupEle, style);
    }

    private IStyle getTheme() {
        String themeId = this.getSheet().getThemeId();
        if (themeId == null) {
            return null;
        }
        return this.getSheet().getOwnedWorkbook().getStyleSheet().findStyle(themeId);
    }

    private void writeRootTopicDefaultsGroup(Element styleGroupEle) {
        Element parentEle = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:RootTopicDefaultsGroup");
        IStyle theme = this.getTheme();
        IStyleSheet all = this.getAllStyles();
        String themeKey = "centralTopic";
        this.writeDefaultColor(parentEle, theme, all, themeKey, "ff99ccff", "ff808080");
        this.writeDefaultText(parentEle, theme, all, themeKey, "urn:mindjet:Center", "urn:mindjet:Top", "urn:mindjet:SentenceStyle", "Central Topic");
        this.writeDefaultSubTopicShape(parentEle, theme, all, themeKey, "urn:mindjet:RoundedRectangle", "urn:mindjet:Rectangle", 3.0f, 3.0f, 3.0f, 3.0f, 2.5f, 2.5f, 2.5f, 2.5f);
        this.writeDefaultLabelFloatingTopicShape(parentEle, "urn:mindjet:None", "urn:mindjet:None", 0.0f, 0.0f, 0.0f, 0.0f, 2.5f, 2.5f, 2.5f, 2.5f);
        this.writeDefaultCalloutFloatingTopicShape(parentEle, "urn:mindjet:None", "urn:mindjet:None", 0.0f, 0.0f, 0.0f, 0.0f, 2.5f, 2.5f, 2.5f, 2.5f);
        MindManagerExporter.writeDefaultTopicLayout(parentEle, "urn:mindjet:Center", "urn:mindjet:Center", "urn:mindjet:TextRightImageLeft", "urn:mindjet:AutoWidth", 50.0f, 5.0f, 1.0f);
        this.writeDefaultSubTopicsShape(parentEle, theme, all, themeKey, "urn:mindjet:Center", "urn:mindjet:Center", "urn:mindjet:Straight", "urn:mindjet:Horizontal", "urn:mindjet:LeftAndRight", "urn:mindjet:Vertical", 1.0f, "urn:mindjet:Middle", "urn:mindjet:Down", 30.0f, 10.0f, 7.0f, 1.0f, 1, "urn:mindjet:Center", "urn:mindjet:Inside", "urn:mindjet:Elbow", "urn:mindjet:Outside", "urn:mindjet:Inside");
        this.writeDefaultSubTopicsVisibility(parentEle, false);
    }

    private void writeDefaultColor(Element parentEle, IStyle theme, IStyleSheet all, String themeKey, String defFillColor, String defLineColor) {
        String fillColor = null;
        String lineColor = null;
        if (defFillColor != null) {
            String shape = this.getDefaultValue(theme, all, themeKey, "shape-class");
            if ("org.xmind.topicShape.noBorder".equals(shape) || "org.xmind.topicShape.underline".equals(shape)) {
                fillColor = "00000000";
            } else {
                fillColor = MindManagerExporter.convertColor(this.getDefaultValue(theme, all, themeKey, "svg:fill"));
                if (fillColor == null && !"none".equals(defFillColor)) {
                    fillColor = defFillColor;
                }
            }
        }
        if (defLineColor != null && (lineColor = MindManagerExporter.convertColor(this.getDefaultValue(theme, all, themeKey, "line-color"))) == null && !"none".equals(defLineColor)) {
            lineColor = defLineColor;
        }
        if (fillColor != null || lineColor != null) {
            Element defColorEle = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultColor");
            MindManagerExporter.writeDirty(defColorEle, false);
            if (fillColor != null) {
                defColorEle.setAttribute("FillColor", fillColor);
            }
            if (lineColor != null) {
                defColorEle.setAttribute("LineColor", lineColor);
            }
        }
    }

    private String getDefaultValue(IStyle theme, IStyleSheet all, String themeKey, String key) {
        IStyle style;
        String value = null;
        if (theme != null && (style = theme.getDefaultStyle(themeKey)) != null) {
            value = style.getProperty(key);
        }
        if (value == null && all != null && (style = all.findStyle(themeKey)) != null) {
            value = style.getProperty(key);
        }
        return value;
    }

    private void writeDefaultText(Element parentEle, IStyle theme, IStyleSheet all, String themeKey, String textAlign, String vTextAlign, String textCapitalization, String plainText) {
        String textColor = MindManagerExporter.convertColor(this.getDefaultValue(theme, all, themeKey, "fo:color"));
        String fontName = this.getDefaultValue(theme, all, themeKey, "fo:font-family");
        String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
        fontName = availableFontName != null ? availableFontName : fontName;
        String size = this.getDefaultValue(theme, all, themeKey, "fo:font-size");
        String fontWeight = this.getDefaultValue(theme, all, themeKey, "fo:font-weight");
        String fontStyle = this.getDefaultValue(theme, all, themeKey, "fo:font-style");
        String textDecoration = this.getDefaultValue(theme, all, themeKey, "fo:text-decoration");
        boolean bold = fontWeight != null && fontWeight.contains("bold");
        boolean italic = fontStyle != null && fontStyle.contains("italic");
        boolean underline = textDecoration != null && textDecoration.contains("underline");
        boolean strikethrough = textDecoration != null && textDecoration.contains("line-through");
        MindManagerExporter.writeDefaultText(parentEle, textAlign, vTextAlign, textCapitalization, plainText, textColor, fontName, size, bold ? Boolean.TRUE : null, italic ? Boolean.TRUE : null, underline ? Boolean.TRUE : null, strikethrough ? Boolean.TRUE : null);
    }

    private static void writeDefaultText(Element parentEle, String textAlign, String vTextAlign, String textCap, String plainText, String color, String name, String size, Boolean bold, Boolean italic, Boolean underline, Boolean strikethrough) {
        Element defTextEle = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultText");
        if (textAlign != null) {
            defTextEle.setAttribute("TextAlignment", textAlign);
        }
        if (textCap != null) {
            defTextEle.setAttribute("TextCapitalization", textCap);
        }
        if (vTextAlign != null) {
            defTextEle.setAttribute("VerticalTextAlignment", vTextAlign);
        }
        MindManagerExporter.writeDirty(defTextEle, false);
        if (plainText != null) {
            defTextEle.setAttribute("PlainText", plainText);
        }
        defTextEle.setAttribute("ReadOnly", "false");
        MindManagerExporter.writeFont(defTextEle, color, name, size, bold, italic, underline, strikethrough);
    }

    private void writeDefaultSubTopicShape(Element parentEle, IStyle theme, IStyleSheet all, String themeKey, String defShape, String vDefShape, float l, float r, float t, float b, float vl, float vr, float vt, float vb) {
        Element defSubTopicShapeEle = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultSubTopicShape");
        MindManagerExporter.writeDirty(defSubTopicShapeEle, false);
        String brainyShape = this.getDefaultValue(theme, all, themeKey, "shape-class");
        if (defShape != null) {
            String shape = MindManagerExporter.convertTopicShape(brainyShape, defShape);
            defSubTopicShapeEle.setAttribute("SubTopicShape", shape);
        }
        MindManagerExporter.writeMargins(defSubTopicShapeEle, l, r, t, b);
        MindManagerExporter.writeVerticalMargins(defSubTopicShapeEle, vl, vr, vt, vb);
        if (vDefShape != null) {
            String vShape = vDefShape;
            defSubTopicShapeEle.setAttribute("VerticalSubTopicShape", vShape);
        }
    }

    private static void writeMargins(Element ele, float l, float r, float t, float b) {
        if (l >= 0.0f) {
            ele.setAttribute("LeftMargin", Float.toString(l));
        }
        if (r >= 0.0f) {
            ele.setAttribute("RightMargin", Float.toString(r));
        }
        if (t >= 0.0f) {
            ele.setAttribute("TopMargin", Float.toString(t));
        }
        if (b >= 0.0f) {
            ele.setAttribute("BottomMargin", Float.toString(b));
        }
    }

    private static void writeVerticalMargins(Element ele, float vl, float vr, float vt, float vb) {
        if (vl >= 0.0f) {
            ele.setAttribute("VerticalLeftMargin", Float.toString(vl));
        }
        if (vr >= 0.0f) {
            ele.setAttribute("VerticalRightMargin", Float.toString(vr));
        }
        if (vt >= 0.0f) {
            ele.setAttribute("VerticalTopMargin", Float.toString(vt));
        }
        if (vb >= 0.0f) {
            ele.setAttribute("VerticalBottomMargin", Float.toString(vb));
        }
    }

    private void writeDefaultLabelFloatingTopicShape(Element parentEle, String shape, String vShape, float l, float r, float t, float b, float vl, float vr, float vt, float vb) {
        Element ele = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultLabelFloatingTopicShape");
        if (shape != null) {
            ele.setAttribute("LabelFloatingTopicShape", shape);
        }
        MindManagerExporter.writeDirty(ele, false);
        MindManagerExporter.writeMargins(ele, l, r, t, b);
        MindManagerExporter.writeVerticalMargins(ele, vl, vr, vt, vb);
        if (vShape != null) {
            ele.setAttribute("VerticalLabelFloatingTopicShape", vShape);
        }
    }

    private void writeDefaultCalloutFloatingTopicShape(Element parentEle, String shape, String vShape, float l, float r, float t, float b, float vl, float vr, float vt, float vb) {
        Element defCalloutFloatingTopicShapeEle = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultCalloutFloatingTopicShape");
        MindManagerExporter.writeDirty(defCalloutFloatingTopicShapeEle, false);
        if (shape != null) {
            defCalloutFloatingTopicShapeEle.setAttribute("CalloutFloatingTopicShape", shape);
        }
        MindManagerExporter.writeMargins(defCalloutFloatingTopicShapeEle, l, r, t, b);
        MindManagerExporter.writeVerticalMargins(defCalloutFloatingTopicShapeEle, vl, vr, vt, vb);
        if (vShape != null) {
            defCalloutFloatingTopicShapeEle.setAttribute("VerticalCalloutFloatingTopicShape", vShape);
        }
    }

    private static void writeDefaultTopicLayout(Element parentEle, String hAlign, String vAlign, String textImagePos, String widthControl, float width, float minHeight, float padding) {
        Element defTopicLayoutEle = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultTopicLayout");
        MindManagerExporter.writeDirty(defTopicLayoutEle, false);
        if (hAlign != null) {
            defTopicLayoutEle.setAttribute("TopicLayoutHorizontalAlignment", hAlign);
        }
        if (vAlign != null) {
            defTopicLayoutEle.setAttribute("TopicLayoutVerticalAlignment", vAlign);
        }
        if (textImagePos != null) {
            defTopicLayoutEle.setAttribute("TopicTextAndImagePosition", textImagePos);
        }
        if (widthControl != null) {
            defTopicLayoutEle.setAttribute("TopicWidthControl", widthControl);
        }
        if (width >= 0.0f) {
            defTopicLayoutEle.setAttribute("Width", Float.toString(width));
        }
        if (minHeight >= 0.0f) {
            defTopicLayoutEle.setAttribute("MinimumHeight", Float.toString(minHeight));
        }
        if (padding >= 0.0f) {
            defTopicLayoutEle.setAttribute("Padding", Float.toString(padding));
        }
    }

    private void writeDefaultSubTopicsShape(Element parentEle, IStyle theme, IStyleSheet all, String themeKey, String align, String connPoint, String defConnStyle, String growth, String growthDir, String shape, float shapeWidthF, String vAlign, String vGrowthDir, float distParent, float vDistParent, float distSiblings, float vDistSiblings, int depth, String alignDualVertical, String treeConnPoint, String vDefConnStyle, String vConnPoint, String vTreeConnPoint) {
        Element defSubTopicsShapeEle = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultSubTopicsShape");
        if (align != null) {
            defSubTopicsShapeEle.setAttribute("SubTopicsAlignment", align);
        }
        if (connPoint != null) {
            defSubTopicsShapeEle.setAttribute("SubTopicsConnectionPoint", connPoint);
        }
        String brainyConnStyle = this.getDefaultValue(theme, all, themeKey, "line-class");
        if (defConnStyle != null) {
            String connStyle = MindManagerExporter.convertConnectionStyle(brainyConnStyle, defConnStyle);
            defSubTopicsShapeEle.setAttribute("SubTopicsConnectionStyle", connStyle);
        }
        if (growth != null) {
            defSubTopicsShapeEle.setAttribute("SubTopicsGrowth", growth);
        }
        if (growthDir != null) {
            defSubTopicsShapeEle.setAttribute("SubTopicsGrowthDirection", growthDir);
        }
        if (shape != null) {
            defSubTopicsShapeEle.setAttribute("SubTopicsShape", shape);
        }
        if (shapeWidthF >= 0.0f) {
            defSubTopicsShapeEle.setAttribute("SubTopicsShapeWidthFactor", Float.toString(shapeWidthF));
        }
        if (vAlign != null) {
            defSubTopicsShapeEle.setAttribute("SubTopicsVerticalAlignment", vAlign);
        }
        if (vGrowthDir != null) {
            defSubTopicsShapeEle.setAttribute("SubTopicsVerticalGrowthDirection", vGrowthDir);
        }
        MindManagerExporter.writeDirty(defSubTopicsShapeEle, false);
        if (distParent >= 0.0f) {
            defSubTopicsShapeEle.setAttribute("DistanceFromParent", Float.toString(distParent));
        }
        if (vDistParent >= 0.0f) {
            defSubTopicsShapeEle.setAttribute("VerticalDistanceFromParent", Float.toString(vDistParent));
        }
        if (distSiblings >= 0.0f) {
            defSubTopicsShapeEle.setAttribute("DistanceBetweenSiblings", Float.toString(distSiblings));
        }
        if (vDistSiblings >= 0.0f) {
            defSubTopicsShapeEle.setAttribute("VerticalDistanceBetweenSiblings", Float.toString(vDistSiblings));
        }
        if (depth >= 0) {
            defSubTopicsShapeEle.setAttribute("SubTopicsDepth", Integer.toString(depth));
        }
        if (alignDualVertical != null) {
            defSubTopicsShapeEle.setAttribute("SubTopicsAlignmentDualVertical", alignDualVertical);
        }
        if (treeConnPoint != null) {
            defSubTopicsShapeEle.setAttribute("SubTopicsTreeConnectionPoint", treeConnPoint);
        }
        if (vDefConnStyle != null) {
            String vConnStyle = vDefConnStyle;
            defSubTopicsShapeEle.setAttribute("VerticalSubTopicsConnectionStyle", vConnStyle);
        }
        if (vConnPoint != null) {
            defSubTopicsShapeEle.setAttribute("VerticalSubTopicsConnectionPoint", vConnPoint);
        }
        if (vTreeConnPoint != null) {
            defSubTopicsShapeEle.setAttribute("VerticalSubTopicsTreeConnectionPoint", vTreeConnPoint);
        }
    }

    private void writeDefaultSubTopicsVisibility(Element parentEle, boolean hidden) {
        Element defSubTopicsVisibilityEle = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultSubTopicsVisibility");
        MindManagerExporter.writeDirty(defSubTopicsVisibilityEle, false);
        defSubTopicsVisibilityEle.setAttribute("Hidden", Boolean.toString(hidden));
    }

    private void writeRootSubTopicDefaultsGroup(Element styleGroupEle, int level) {
        Element parentEle = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:RootSubTopicDefaultsGroup");
        parentEle.setAttribute("Level", Integer.toString(level));
        IStyle theme = this.getTheme();
        IStyleSheet all = this.getAllStyles();
        String themeKey = level == 0 ? "mainTopic" : "subTopic";
        this.writeDefaultColor(parentEle, theme, all, themeKey, level == 0 ? "ffffffff" : "00000000", null);
        this.writeDefaultText(parentEle, theme, all, themeKey, "urn:mindjet:Left", "urn:mindjet:Center", "urn:mindjet:None", level == 0 ? "Main Topic" : "Subtopic");
        String defShape = level == 0 ? "urn:mindjet:RoundedRectangle" : "urn:mindjet:Line";
        float m = level == 0 ? 0.5f : 0.2f;
        float vm = level == 0 ? 2.0f : 1.0f;
        this.writeDefaultSubTopicShape(parentEle, theme, all, themeKey, defShape, "urn:mindjet:Rectangle", m, m, m, m, vm, vm, vm, vm);
        if (level == 0) {
            Element defTopicLayoutEle = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultTopicLayout");
            MindManagerExporter.writeDirty(defTopicLayoutEle, false);
            defTopicLayoutEle.setAttribute("Width", "66.848358154296875");
        }
        this.writeDefaultSubTopicsShape(parentEle, theme, all, themeKey, "urn:mindjet:Center", "urn:mindjet:Outside", level == 0 ? "urn:mindjet:RoundedElbow" : null, "urn:mindjet:Horizontal", "urn:mindjet:AutomaticHorizontal", "urn:mindjet:Vertical", -1.0f, level == 0 ? "urn:mindjet:Middle" : null, level == 0 ? "urn:mindjet:AutomaticVertical" : null, level == 0 ? 2.0f : -1.0f, 10.0f, 1.4f, 1.0f, -1, "urn:mindjet:Bottom", null, "urn:mindjet:Elbow", "urn:mindjet:Outside", null);
        this.writeDefaultSubTopicsVisibility(parentEle, false);
    }

    private void writeCalloutTopicDefaultsGroup(Element styleGroupEle) {
        Element parentEle = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:CalloutTopicDefaultsGroup");
        this.writeDefaultColor(parentEle, "fffff794", "ff808080");
        MindManagerExporter.writeDefaultText(parentEle, "urn:mindjet:Left", null, "urn:mindjet:None", "Callout", "ff000000", "Arial", "9.000000", Boolean.TRUE, null, null, null);
        this.writeDefaultCalloutFloatingTopicShape(parentEle, "urn:mindjet:RoundedRectangleBalloon", null, 0.5f, 0.5f, 0.5f, 0.5f, -1.0f, -1.0f, -1.0f, -1.0f);
        this.writeDefaultSubTopicsShape(parentEle, null, null, null, "urn:mindjet:Center", "urn:mindjet:Outside", "urn:mindjet:RoundedElbow", "urn:mindjet:Horizontal", "urn:mindjet:AutomaticHorizontal", "urn:mindjet:Vertical", -1.0f, "urn:mindjet:Middle", "urn:mindjet:AutomaticVertical", 2.0f, 10.0f, 1.4f, 1.0f, -1, "urn:mindjet:Center", null, null, null, null);
        this.writeDefaultSubTopicsVisibility(parentEle, false);
    }

    private void writeDefaultColor(Element parentEle, String fillColor, String lineColor) {
        this.writeDefaultColor(parentEle, null, null, null, fillColor, lineColor);
    }

    private void writeCalloutSubTopicDefaultsGroup(Element styleGroupEle, int level) {
        Element parentEle = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:CalloutSubTopicDefaultsGroup");
        parentEle.setAttribute("Level", Integer.toString(level));
        this.writeDefaultColor(parentEle, "00000000", "ff808080");
        MindManagerExporter.writeDefaultText(parentEle, "urn:mindjet:Left", null, "urn:mindjet:None", "Subtopic", "ff000000", "Arial", "10.000000", Boolean.FALSE, null, null, null);
        this.writeDefaultSubTopicShape(parentEle, null, null, null, "urn:mindjet:Line", null, 0.2f, 0.2f, 0.2f, 0.2f, -1.0f, -1.0f, -1.0f, -1.0f);
        this.writeDefaultSubTopicsShape(parentEle, null, null, null, "urn:mindjet:Center", "urn:mindjet:Outside", null, "urn:mindjet:Horizontal", "urn:mindjet:AutomaticHorizontal", "urn:mindjet:Vertical", -1.0f, "urn:mindjet:Middle", "urn:mindjet:AutomaticVertical", -1.0f, 10.0f, 1.4f, 1.0f, -1, "urn:mindjet:Center", null, null, null, null);
        this.writeDefaultSubTopicsVisibility(parentEle, false);
    }

    private void writeLabelTopicDefaultsGroup(Element styleGroupEle) {
        Element parentEle = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:LabelTopicDefaultsGroup");
        IStyle theme = this.getTheme();
        IStyleSheet all = this.getAllStyles();
        String themeKey = "floatingTopic";
        this.writeDefaultColor(parentEle, theme, all, themeKey, "ffffffff", "ff808080");
        this.writeDefaultText(parentEle, theme, all, themeKey, "urn:mindjet:Left", null, "urn:mindjet:None", "Floating Topic");
        String shape = MindManagerExporter.convertTopicShape(this.getDefaultValue(theme, all, themeKey, "shape-class"), "urn:mindjet:RoundedRectangle");
        this.writeDefaultLabelFloatingTopicShape(parentEle, shape, null, 0.7f, 0.7f, 0.7f, 0.7f, 2.5f, 2.5f, 2.5f, 2.5f);
        this.writeDefaultSubTopicsShape(parentEle, theme, all, themeKey, "urn:mindjet:Center", "urn:mindjet:Outside", "urn:mindjet:RoundedElbow", "urn:mindjet:Horizontal", "urn:mindjet:AutomaticHorizontal", "urn:mindjet:Vertical", -1.0f, "urn:mindjet:Middle", "urn:mindjet:AutomaticVertical", 2.0f, 10.0f, 1.4f, 1.4f, 1, "urn:mindjet:Center", null, "urn:mindjet:Elbow", "urn:mindjet:Outside", null);
        this.writeDefaultSubTopicsVisibility(parentEle, false);
    }

    private void writeLabelSubTopicDefaultsGroup(Element styleGroupEle, int level) {
        Element parentEle = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:LabelSubTopicDefaultsGroup");
        parentEle.setAttribute("Level", Integer.toString(level));
        IStyle theme = this.getTheme();
        IStyleSheet all = this.getAllStyles();
        String themeKey = "subTopic";
        this.writeDefaultColor(parentEle, theme, all, themeKey, "00000000", "ff808080");
        this.writeDefaultText(parentEle, theme, all, themeKey, "urn:mindjet:Left", null, "urn:mindjet:None", "Subtopic");
        this.writeDefaultSubTopicShape(parentEle, theme, all, themeKey, "urn:mindjet:Line", "urn:mindjet:Rectangle", 0.2f, 0.2f, 0.2f, 0.2f, 2.0f, 2.0f, 2.0f, 2.0f);
        this.writeDefaultSubTopicsShape(parentEle, theme, all, themeKey, "urn:mindjet:Center", "urn:mindjet:Outside", null, "urn:mindjet:Horizontal", "urn:mindjet:AutomaticHorizontal", "urn:mindjet:Vertical", -1.0f, "urn:mindjet:Middle", "urn:mindjet:AutomaticVertical", -1.0f, 10.0f, 1.4f, 1.4f, -1, "urn:mindjet:Bottom", null, "urn:mindjet:Elbow", null, null);
        this.writeDefaultSubTopicsVisibility(parentEle, false);
    }

    private void writeOrgChartTopicDefaultsGroup(Element styleGroupEle) {
        Element parentEle = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:OrgChartTopicDefaultsGroup");
        this.writeDefaultColor(parentEle, "ffffffff", null);
        MindManagerExporter.writeDefaultText(parentEle, "urn:mindjet:Center", "urn:mindjet:Top", "urn:mindjet:None", "Org-Chart Topic", "ff000000", "Arial", "12.000000", Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
        this.writeDefaultSubTopicShape(parentEle, null, null, null, null, "urn:mindjet:RoundedRectangle", -1.0f, -1.0f, -1.0f, -1.0f, 2.5f, 2.5f, 2.5f, 2.5f);
        this.writeDefaultLabelFloatingTopicShape(parentEle, null, "urn:mindjet:RoundedRectangle", -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f);
        this.writeDefaultCalloutFloatingTopicShape(parentEle, null, "urn:mindjet:RoundedRectangleBalloon", -1.0f, -1.0f, -1.0f, -1.0f, 2.5f, 2.5f, 2.5f, 2.5f);
        MindManagerExporter.writeDefaultTopicLayout(parentEle, "urn:mindjet:Center", "urn:mindjet:Center", "urn:mindjet:TextRightImageLeft", "urn:mindjet:AutoWidth", 50.0f, 5.0f, 1.0f);
        this.writeDefaultSubTopicsShape(parentEle, null, null, null, "urn:mindjet:Center", null, null, "urn:mindjet:Vertical", "urn:mindjet:AutomaticHorizontal", "urn:mindjet:Vertical", 1.0f, "urn:mindjet:Middle", "urn:mindjet:AutomaticVertical", 5.0f, 10.0f, 1.0f, 1.4f, 1, "urn:mindjet:Center", null, "urn:mindjet:Elbow", "urn:mindjet:Outside", null);
        this.writeDefaultSubTopicsVisibility(parentEle, false);
    }

    private void writeOrgChartSubTopicDefaultsGroup(Element styleGroupEle, int level) {
        Element parentEle = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:OrgChartSubTopicDefaultsGroup");
        parentEle.setAttribute("Level", Integer.toString(level));
        this.writeDefaultColor(parentEle, "00000000", null);
        MindManagerExporter.writeDefaultText(parentEle, "urn:mindjet:Center", "urn:mindjet:Top", "urn:mindjet:None", "Topic", "ff000000", "Arial", "10.000000", Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
        this.writeDefaultSubTopicShape(parentEle, null, null, null, level == 0 ? null : "urn:mindjet:Rectangle", "urn:mindjet:Rectangle", -1.0f, -1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, 2.0f);
        this.writeDefaultCalloutFloatingTopicShape(parentEle, null, "urn:mindjet:RectangleBalloon", -1.0f, -1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, 2.0f);
        MindManagerExporter.writeDefaultTopicLayout(parentEle, "urn:mindjet:Center", "urn:mindjet:Center", "urn:mindjet:TextRightImageLeft", "urn:mindjet:AutoWidth", 50.0f, 5.0f, 1.0f);
        this.writeDefaultSubTopicsShape(parentEle, null, null, null, "urn:mindjet:Bottom", "urn:mindjet:Outside", "urn:mindjet:Elbow", "urn:mindjet:Horizontal", "urn:mindjet:AutomaticHorizontal", "urn:mindjet:Vertical", 1.0f, "urn:mindjet:Middle", "urn:mindjet:AutomaticVertical", 5.0f, 10.0f, 1.4f, 1.0f, 1, "urn:mindjet:Center", null, "urn:mindjet:Elbow", "urn:mindjet:Outside", null);
        if (level == 0) {
            this.writeDefaultSubTopicsVisibility(parentEle, false);
        }
    }

    private void writeRelationshipDefaultsGroup(Element styleGroupEle) {
        Element parentEle = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:RelationshipDefaultsGroup");
        IStyle theme = this.getTheme();
        IStyleSheet all = this.getAllStyles();
        String themeKey = "relationship";
        this.writeDefaultColor(parentEle, theme, all, themeKey, "00000000", "ffff6600");
        this.writeDefaultLineStyle(parentEle, theme, all, themeKey, "urn:mindjet:RoundDot", "3.000000");
        this.writeDefaultConnStyle(parentEle, theme, all, themeKey, 0, "urn:mindjet:NoArrow");
        this.writeDefaultConnStyle(parentEle, theme, all, themeKey, 1, "urn:mindjet:OpenArrow");
        this.writeDefaultRelLineShape(parentEle, theme, all, themeKey, "urn:mindjet:Bezier");
    }

    private void writeDefaultLineStyle(Element parentEle, IStyle theme, IStyleSheet all, String themeKey, String defDashStyle, String defLineWidth) {
        Element ele = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultLineStyle");
        MindManagerExporter.writeDirty(ele, false);
        if (defDashStyle != null) {
            String dashStyle = this.getDefaultValue(theme, all, themeKey, "line-pattern");
            if ((dashStyle = MindManagerExporter.convertDashStyle(dashStyle)) == null) {
                dashStyle = defDashStyle;
            }
            ele.setAttribute("LineDashStyle", dashStyle);
        }
        if (defLineWidth != null) {
            String lineWidth = this.getDefaultValue(theme, all, themeKey, "line-width");
            if ((lineWidth = MindManagerExporter.convertLineWidth(lineWidth)) == null) {
                lineWidth = defLineWidth;
            }
            ele.setAttribute("LineWidth", lineWidth);
        }
    }

    private void writeDefaultConnStyle(Element parentEle, IStyle theme, IStyleSheet all, String themeKey, int index, String defConnShape) {
        Element ele = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultConnectionStyle");
        ele.setAttribute("Index", Integer.toString(index));
        MindManagerExporter.writeDirty(ele, false);
        if (defConnShape != null) {
            String connShape = this.getDefaultValue(theme, all, themeKey, index == 0 ? "arrow-begin-class" : "arrow-end-class");
            connShape = MindManagerExporter.convertConnectionShape(connShape, defConnShape);
            ele.setAttribute("ConnectionShape", connShape);
        }
    }

    private void writeDefaultRelLineShape(Element parentEle, IStyle theme, IStyleSheet all, String themeKey, String defLineShape) {
        Element ele = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultRelationshipLineShape");
        MindManagerExporter.writeDirty(ele, false);
        if (defLineShape != null) {
            String lineShape = this.getDefaultValue(theme, all, themeKey, "shape-class");
            if ((lineShape = MindManagerExporter.convertRelLineShape(lineShape)) == null) {
                lineShape = defLineShape;
            }
            ele.setAttribute("LineShape", lineShape);
        }
    }

    private void writeBoundaryDefaultsGroup(Element styleGroupEle) {
        Element parentEle = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:BoundaryDefaultsGroup");
        IStyle theme = this.getTheme();
        IStyleSheet all = this.getAllStyles();
        String themeKey = "boundary";
        this.writeDefaultLineStyle(parentEle, theme, all, themeKey, "urn:mindjet:Solid", "0.500000");
        this.writeDefaultBoundaryShape(parentEle, theme, all, themeKey, "urn:mindjet:CurvedLine", 0.0f);
    }

    private void writeDefaultBoundaryShape(Element parentEle, IStyle theme, IStyleSheet all, String themeKey, String defShape, float defMargin) {
        Element ele = DOMUtils.createElement((Node)parentEle, (String)"ap:DefaultBoundaryShape");
        MindManagerExporter.writeDirty(ele, false);
        if (defShape != null) {
            String shape = MindManagerExporter.convertBoundaryShape(this.getDefaultValue(theme, all, themeKey, "shape-class"));
            if (shape == null) {
                shape = defShape;
            }
            ele.setAttribute("BoundaryShape", shape);
        }
        if (defMargin >= 0.0f) {
            ele.setAttribute("Margin", Float.toString(defMargin));
        }
    }

    private void writeImageDefaultsGroup(Element styleGroupEle) {
        DOMUtils.createElement((Node)styleGroupEle, (String)"ap:ImageDefaultsGroup");
    }

    private void writeStructure(Element styleGroupEle, IStyle style) {
        String tapered;
        Element ele = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:Structure");
        ele.setAttribute("StructureGrowthDirection", "urn:mindjet:Automatic");
        MindManagerExporter.writeDirty(ele, false);
        ele.setAttribute("UseAutoLayout", "true");
        ele.setAttribute("MinimumMainTopicsHeight", "40.000000");
        ele.setAttribute("FadeNotSelectedObjects", "true");
        ele.setAttribute("UseCurveAntialiasing", "true");
        ele.setAttribute("UseTextAntialiasing", "true");
        String string = tapered = style == null ? null : style.getProperty("line-tapered");
        if (tapered == null) {
            tapered = this.getDefaultValue(this.getTheme(), this.getAllStyles(), "map", "line-tapered");
        }
        float lineWidth = Boolean.parseBoolean(tapered) ? 5.0f : 0.1f;
        ele.setAttribute("MainTopicLineWidth", Float.toString(lineWidth));
        ele.setAttribute("VerticalMainTopicLineWidth", Float.toString(lineWidth));
        ele.setAttribute("SiblingSpacing", "0.000000");
        ele.setAttribute("ParentChildSpacing", "0.000000");
        ele.setAttribute("UseOrganicLines", "false");
        ele.setAttribute("HideCollapseSign", "false");
    }

    private void writeBackgroundFill(Element styleGroupEle, IStyle style) {
        String fillColor;
        Element ele = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:BackgroundFill");
        MindManagerExporter.writeDirty(ele, false);
        String string = fillColor = style == null ? null : style.getProperty("svg:fill");
        if (fillColor == null) {
            fillColor = this.getDefaultValue(this.getTheme(), this.getAllStyles(), "map", "svg:fill");
        }
        if ((fillColor = MindManagerExporter.convertColor(fillColor)) == null) {
            fillColor = "fffffff7";
        }
        ele.setAttribute("FillColor", fillColor);
    }

    private void writeBackgroundImageData(Element styleGroupEle, IStyle style) {
        String opacity;
        String imageUrl;
        String string = imageUrl = style == null ? null : style.getProperty("background");
        if (imageUrl == null || !HyperlinkUtils.isAttachmentURL((String)imageUrl)) {
            return;
        }
        String entryPath = HyperlinkUtils.toAttachmentPath((String)imageUrl);
        String uri = this.getBinUri(entryPath);
        if (uri == null) {
            return;
        }
        Element ele = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:BackgroundImageData");
        MindManagerExporter.writeDirty(ele, true);
        ele.setAttribute("ImageTileOption", "urn:mindjet:NoFlip");
        ele.setAttribute("ImageType", "urn:mindjet:PngImage");
        String string2 = opacity = style == null ? null : style.getProperty("svg:opacity");
        if (opacity == null) {
            opacity = this.getDefaultValue(this.getTheme(), this.getAllStyles(), "map", "svg:opacity");
        }
        if (opacity != null) {
            try {
                int transparency = (int)((1.0 - Double.parseDouble(opacity)) * 100.0);
                ele.setAttribute("Transparency", Integer.toString(transparency));
                ele.setAttribute("CustomImageType", "");
            }
            catch (NumberFormatException numberFormatException) {}
        }
        MindManagerExporter.writeUri(ele, uri);
    }

    private void writeNotesDefaultFont(Element styleGroupEle, IStyle style) {
        Element ele = DOMUtils.createElement((Node)styleGroupEle, (String)"ap:NotesDefaultFont");
        ele.setAttribute("Color", "ff000000");
        ele.setAttribute("Size", "10.000000");
        MindManagerExporter.writeDirty(ele, false);
        ele.setAttribute("Name", "Arial");
    }

    private void writeMapViewGroup(Element mapEle) {
    }

    private void writeDocumentGroup(Element mapEle) {
    }

    private void writeMarkersSetGroup(Element mapEle) {
        Element markersSetGroupEle = DOMUtils.createElement((Node)mapEle, (String)"ap:MarkersSetGroup");
        ILegend legend = this.getSheet().getLegend();
        this.writeIconMarkersSets(markersSetGroupEle, legend);
        this.writeMarkers(markersSetGroupEle, "ap:IconMarkers", "ap:IconMarker", "ap:StockIconMarker", "ap:OneStockIcon", "IconType", legend, "Pro", "urn:mindjet:ThumbsUp", "Con", "urn:mindjet:ThumbsDown", "Question", "urn:mindjet:QuestionMark", "Attention", "urn:mindjet:ExclamationMark", "Decision", "urn:mindjet:JudgeHammer", "Date", "urn:mindjet:Calendar", "Cost", "urn:mindjet:Dollar", "Alarm", "urn:mindjet:Emergency");
        MindManagerExporter.writeName(markersSetGroupEle, "ap:FillColorMarkersName", "Fill Colors");
        MindManagerExporter.writeName(markersSetGroupEle, "ap:TextColorMarkersName", "Font Colors");
        MindManagerExporter.writeName(markersSetGroupEle, "ap:TaskPercentageMarkersName", "Task Complete (%)");
        this.writeMarkers(markersSetGroupEle, "ap:TaskPercentageMarkers", "ap:TaskPercentageMarker", null, "ap:TaskPercentage", "TaskPercentage", legend, "Task start", "0", "Quarter done", "25", "Half done", "50", "Three quarters done", "75", "Task done", "100");
        MindManagerExporter.writeName(markersSetGroupEle, "ap:TaskPriorityMarkersName", "Task Priorities");
        this.writeMarkers(markersSetGroupEle, "ap:TaskPriorityMarkers", "ap:TaskPriorityMarker", null, "ap:TaskPriority", "TaskPriority", legend, "Priority 1", "urn:mindjet:Prio1", "Priority 2", "urn:mindjet:Prio2", "Priority 3", "urn:mindjet:Prio3", "Priority 4", "urn:mindjet:Prio4", "Priority 5", "urn:mindjet:Prio5");
        this.writeRemainingMarkers(markersSetGroupEle, legend);
        this.writeTextLabelsMarkersSets(markersSetGroupEle);
    }

    private void writeIconMarkersSets(Element markersSetGroupEle, ILegend legend) {
        Element markersSetsEle = DOMUtils.createElement((Node)markersSetGroupEle, (String)"ap:IconMarkersSets");
        this.writeIconMarkersSet(markersSetsEle, legend, "Smileys", "Happy", "urn:mindjet:SmileyHappy", "Neutual", "urn:mindjet:SmileyNeutral", "Upset", "urn:mindjet:SmileyAngry", "Sad", "urn:mindjet:SmileySad", "Furious", "urn:mindjet:SmileyScreaming");
        this.writeIconMarkersSet(markersSetsEle, legend, "Arrows", "Up", "urn:mindjet:ArrowUp", "Down", "urn:mindjet:ArrowDown", "Left", "urn:mindjet:ArrowLeft", "Right", "urn:mindjet:ArrowRight");
        this.writeIconMarkersSet(markersSetsEle, legend, "Flags", "Yes", "urn:mindjet:FlagGreen", "Maybe", "urn:mindjet:FlagYellow", "Discuss", "urn:mindjet:FlagOrange", "Risk", "urn:mindjet:FlagRed", "Move", "urn:mindjet:FlagPurple", "Defer", "urn:mindjet:FlagBlue", "No", "urn:mindjet:FlagBlack");
    }

    private void writeIconMarkersSet(Element markersSetsEle, ILegend legend, String setName, String ... markers) {
        Element markersSetEle = DOMUtils.createElement((Node)markersSetsEle, (String)"ap:IconMarkersSet");
        MindManagerExporter.writeDirty(markersSetEle, false);
        this.writeOId(markersSetEle, null);
        MindManagerExporter.writeGen(markersSetEle);
        Element nameEle = DOMUtils.createElement((Node)markersSetEle, (String)"ap:Name");
        MindManagerExporter.writeDirty(nameEle, false);
        nameEle.setAttribute("Name", setName);
        this.writeMarkers(markersSetEle, "ap:IconMarkers", "ap:IconMarker", "ap:StockIconMarker", "ap:OneStockIcon", "IconType", legend, markers);
    }

    private void writeMarkers(Element parentEle, String markersEleName, String markerEleName, String xsiType, String iconEleName, String iconAttrName, ILegend legend, String ... markers) {
        Element markersEle = DOMUtils.createElement((Node)parentEle, (String)markersEleName);
        this.writeMarkers(markersEle, markerEleName, xsiType, iconEleName, iconAttrName, legend, markers);
    }

    private void writeMarkers(Element markersEle, String markerEleName, String xsiType, String iconEleName, String iconAttrName, ILegend legend, String ... markers) {
        int i = 0;
        while (i < markers.length) {
            String name = markers[i];
            String type = markers[i + 1];
            Element markerEle = DOMUtils.createElement((Node)markersEle, (String)markerEleName);
            if (xsiType != null) {
                markerEle.setAttribute("xsi:type", xsiType);
            }
            MindManagerExporter.writeDirty(markerEle, false);
            this.writeOId(markerEle, null);
            MindManagerExporter.writeGen(markerEle);
            String markerId = MindManagerExporter.getMappings().getDestination("marker", type);
            if (markerId != null) {
                name = this.getMarkerName(markerId, legend);
            }
            MindManagerExporter.writeName(markerEle, null, name);
            Element iconEle = DOMUtils.createElement((Node)markerEle, (String)iconEleName);
            MindManagerExporter.writeDirty(iconEle, false);
            iconEle.setAttribute(iconAttrName, type);
            i += 2;
        }
    }

    private String getMarkerName(String markerId, ILegend legend) {
        if (this.remainingMarkers == null) {
            IMarkerRefCounter counter = (IMarkerRefCounter)this.getSheet().getAdapter(IMarkerRefCounter.class);
            this.remainingMarkers = counter != null ? new ArrayList<String>(counter.getCountedRefs()) : new ArrayList<String>();
        }
        this.remainingMarkers.remove(markerId);
        return legend.getMarkerDescription(markerId);
    }

    private static void writeName(Element parentEle, String eleName, String name) {
        if (eleName == null) {
            eleName = "ap:Name";
        }
        Element ele = DOMUtils.createElement((Node)parentEle, (String)eleName);
        MindManagerExporter.writeDirty(ele, false);
        ele.setAttribute("Name", name);
    }

    private void writeRemainingMarkers(Element markersSetGroupEle, ILegend legend) {
        if (this.remainingMarkers == null || this.remainingMarkers.isEmpty()) {
            return;
        }
        ArrayList<String> markers = new ArrayList<String>(this.remainingMarkers.size() * 2);
        for (String markerId : this.remainingMarkers) {
            String icon = MindManagerExporter.getMapping("marker", markerId, null);
            if (icon == null || !ICON_TYPES.contains(icon)) continue;
            String name = legend.getMarkerDescription(markerId);
            if (name == null) {
                name = "";
            }
            markers.add(name);
            markers.add(icon);
        }
        if (markers.isEmpty()) {
            return;
        }
        Element markersEle = DOMUtils.getFirstChildElementByTag((Node)markersSetGroupEle, (String)"ap:IconMarkers");
        if (markersEle != null) {
            this.writeMarkers(markersEle, "ap:IconMarker", "ap:StockIconMarker", "ap:OneStockIcon", "IconType", legend, markers.toArray(new String[0]));
        } else {
            this.writeMarkers(markersSetGroupEle, "ap:IconMarkers", "ap:IconMarker", "ap:StockIconMarker", "ap:OneStockIcon", "IconType", legend, markers.toArray(new String[0]));
        }
    }

    private void writeTextLabelsMarkersSets(Element markersSetGroupEle) {
        ILabelRefCounter labelReg = (ILabelRefCounter)this.getSheet().getAdapter(ILabelRefCounter.class);
        if (labelReg == null) {
            return;
        }
        Collection labels = labelReg.getCountedRefs();
        if (labels.isEmpty()) {
            return;
        }
        Element setsEle = DOMUtils.createElement((Node)markersSetGroupEle, (String)"ap:TextLabelMarkersSets");
        Element setEle = DOMUtils.createElement((Node)setsEle, (String)"ap:TextLabelMarkersSet");
        MindManagerExporter.writeDirty(setEle, false);
        this.writeOId(setEle, null);
        MindManagerExporter.writeGen(setEle);
        MindManagerExporter.writeName(setEle, null, "Default");
        Element labelsEle = DOMUtils.createElement((Node)setEle, (String)"ap:TextLabelMarkers");
        for (String label : labels) {
            Element labelEle = DOMUtils.createElement((Node)labelsEle, (String)"ap:TextLabelMarker");
            MindManagerExporter.writeDirty(labelEle, false);
            this.writeOId(labelEle, null);
            MindManagerExporter.writeGen(labelEle);
            MindManagerExporter.writeName(labelEle, null, label);
        }
    }

    private IStyleSheet getAllStyles() {
        if (this.allStyles == null) {
            this.allStyles = MindMapUI.getResourceManager().getDefaultStyleSheet();
        }
        return this.allStyles;
    }

    private void writeOId(Element ele, IIdentifiable element) {
        if (element == null) {
            ele.setAttribute("OId", MMEncoder.generateId());
        } else {
            ele.setAttribute("OId", this.getOId(element.getId()));
        }
    }

    private String findOId(String id) {
        return this.id2OId.get(id);
    }

    private String getOId(String id) {
        String oId = this.findOId(id);
        if (oId == null) {
            oId = MMEncoder.generateId();
            this.id2OId.put(id, oId);
        }
        return oId;
    }

    private String getAttOId(String entryPath) {
        String uri = this.entryPath2OId.get(entryPath);
        if (uri == null && !this.entryPath2OId.containsKey(entryPath)) {
            uri = this.createAttOId(entryPath);
            this.entryPath2OId.put(entryPath, uri);
        }
        return uri;
    }

    private String createAttOId(String entryPath) {
        InputStream is;
        String oId = MMEncoder.generateId();
        String entryName = "bin/" + oId + ".bin";
        String binUri = "mmarch://" + entryName;
        this.oId2BinUris.put(oId, binUri);
        File tempFile = FileUtils.ensureFileParent((File)new File(this.getTempDir(), entryName));
        this.entryFiles.put(entryName, tempFile);
        IFileEntry entry = this.getSheet().getOwnedWorkbook().getManifest().getFileEntry(entryPath);
        if (entry != null && (is = entry.getInputStream()) != null) {
            try {
                FileUtils.transfer((InputStream)is, (OutputStream)new FileOutputStream(tempFile), (boolean)true);
            }
            catch (IOException e) {
                this.log(e, "Failed to copy attachment ");
            }
        }
        return oId;
    }

    private String getBinUri(String entryPath) {
        return this.oId2BinUris.get(this.getAttOId(entryPath));
    }

    private static void writeDirty(Element ele, boolean dirty) {
        ele.setAttribute("Dirty", dirty ? "0000000000000001" : "0000000000000000");
    }

    private static void writeGen(Element ele) {
        ele.setAttribute("Gen", "0000000000000000");
    }

    private void clearTempDir() {
        if (this.tempDir != null) {
            FileUtils.delete((File)this.tempDir);
            this.tempDir = null;
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (this.getMonitor().isCanceled()) {
            throw new InterruptedException();
        }
    }

    public List<Map.Entry<Throwable, String>> getErrors() {
        return this.errors;
    }

    protected void log(final Throwable e, final String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Map.Entry<Throwable, String>>();
        }
        this.errors.add(new Map.Entry<Throwable, String>(){

            @Override
            public String setValue(String value) {
                return message;
            }

            @Override
            public String getValue() {
                return message;
            }

            @Override
            public Throwable getKey() {
                return e;
            }
        });
    }

    private static float dots2MM(int dots) {
        return (float)((double)dots / 2.834645669291339);
    }

    private static String getMapping(String type, String destinationId, String defaultId) {
        String sourceId;
        if (destinationId != null && (sourceId = MindManagerExporter.getMappings().getSource(type, destinationId)) != null) {
            return sourceId;
        }
        return defaultId;
    }

    private static ResourceMappingManager getMappings() {
        if (mappings == null) {
            mappings = MMResourceMappingManager.getInstance();
        }
        return mappings;
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return DOMUtils.getDefaultDocumentBuilder();
    }

    private static class MMEncoder {
        private static Random generator = new Random(System.currentTimeMillis());
        private static String zeroes = "0000000000000000";

        private MMEncoder() {
        }

        public static String generateId() {
            String s = String.valueOf(zeroes) + Long.toString(generator.nextLong());
            s = s.substring(s.length() - 16);
            byte[] bs = s.getBytes();
            bs = Base64.encode((byte[])bs);
            return new String(bs);
        }
    }

    private static class NotesData {
        String uri;
        String imageUri;

        NotesData(int index, String uri) {
            this.uri = uri;
            this.imageUri = String.format("mmnotes://%d.png", index);
        }
    }
}

