/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.xmind.core.ISheet;
import org.xmind.core.ISheetSetting;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.util.DOMUtils;

public class SheetSetting
implements ISheetSetting {
    private Element sheetEle;
    private SheetImpl ownedSheet;

    public SheetSetting(Element sheetEle, SheetImpl ownedSheet) {
        this.sheetEle = sheetEle;
        this.ownedSheet = ownedSheet;
    }

    public boolean isInfoItemVisible(String type, String key, String defaultMode) {
        String mode = this.getInfoItemMode(type, "mode");
        if (mode == null) {
            mode = defaultMode;
        }
        return mode != null && mode.equals("card");
    }

    public void setInfoItemVisible(String type, String key, String defaultMode, boolean visible) {
        if (visible) {
            if (!this.isInfoItemVisible(type, key, defaultMode)) {
                this.setInfoItemMode(type, key, "card");
                this.fireValueChange(this.ownedSheet, "visibility", Boolean.FALSE, Boolean.TRUE);
            }
        } else if (this.isInfoItemVisible(type, key, defaultMode)) {
            this.setInfoItemMode(type, key, "icon");
            this.fireValueChange(this.ownedSheet, "visibility", Boolean.TRUE, Boolean.FALSE);
        }
    }

    public String getInfoItemMode(String type, String key) {
        Element infoItemEle = this.getInfoItemEle(type);
        if (infoItemEle == null) {
            return null;
        }
        return DOMUtils.getAttribute(infoItemEle, "mode");
    }

    public void setInfoItemMode(String type, String key, String value) {
        Element infoItemEle = this.ensureInfoItemEle(type);
        DOMUtils.setAttribute(infoItemEle, key, value);
    }

    public Element getSheetEle() {
        return this.sheetEle;
    }

    public SheetImpl getOwnedSheet() {
        return this.ownedSheet;
    }

    private Element getInfoItemEle(String type) {
        if (this.sheetEle != null) {
            Element settingsEle = DOMUtils.getFirstChildElementByTag(this.sheetEle, "sheet-settings");
            if (settingsEle == null) {
                return null;
            }
            Element infoItemsEle = DOMUtils.getFirstChildElementByTag(settingsEle, "info-items");
            if (infoItemsEle == null) {
                return null;
            }
            Element[] infoItemEles = DOMUtils.getChildElementsByTag(infoItemsEle, "info-item");
            if (infoItemEles == null || infoItemEles.length == 0) {
                return null;
            }
            Element[] elementArray = infoItemEles;
            int n = infoItemEles.length;
            int n2 = 0;
            while (n2 < n) {
                Element infoItemEle = elementArray[n2];
                String eleType = DOMUtils.getAttribute(infoItemEle, "type");
                if (type.equals(eleType)) {
                    return infoItemEle;
                }
                ++n2;
            }
        }
        return null;
    }

    private Element ensureInfoItemEle(String type) {
        Element sheetSettingsEle = DOMUtils.ensureChildElement(this.sheetEle, "sheet-settings");
        Element infoItemsEle = DOMUtils.ensureChildElement(sheetSettingsEle, "info-items");
        Element infoItemEle = this.getInfoItemEle(type);
        if (infoItemEle == null) {
            infoItemEle = DOMUtils.createElement(infoItemsEle, "info-item");
            DOMUtils.setAttribute(infoItemEle, "type", type);
        }
        return infoItemEle;
    }

    private void fireValueChange(ISheet sheet, String visibility, Boolean oldValue, Boolean newValue) {
        if (sheet instanceof ICoreEventSource) {
            this.getCoreEventSupport(sheet).dispatchValueChange((ICoreEventSource)((Object)sheet), visibility, oldValue, newValue);
        }
    }

    private ICoreEventSupport getCoreEventSupport(ISheet sheet) {
        return sheet.getAdapter(ICoreEventSupport.class);
    }
}

