/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionLine;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionPointList;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;

public class PrecisionPolygon {
    private PrecisionPointList points;

    public PrecisionPolygon() {
        this.points = new PrecisionPointList();
    }

    public PrecisionPolygon(int size) {
        this.points = new PrecisionPointList(size);
    }

    public PrecisionPolygon(PrecisionPointList points) {
        this.points = points.getCopy();
    }

    public PrecisionPointList getPoints() {
        return this.points;
    }

    public boolean contains(PrecisionPoint toTest, boolean outline) {
        this.translate(-toTest.x, -toTest.y);
        PrecisionPoint prev = this.getPoint(this.points.size() - 1);
        int t1 = prev.x >= 0.0 ? (prev.y >= 0.0 ? 0 : 3) : (prev.y >= 0.0 ? 1 : 2);
        int sum = 0;
        int i = 0;
        if (prev.x != 0.0 || prev.y != 0.0) {
            while (i < this.points.size()) {
                int t2;
                double f;
                PrecisionPoint current = this.getPoint(i);
                if (current.x == 0.0 && current.y == 0.0 && outline || (f = current.y * prev.x - current.x * prev.y) == 0.0 && prev.x * current.x <= 0.0 && prev.y * current.y <= 0.0 && outline) break;
                int n = current.x >= 0.0 ? (current.y >= 0.0 ? 0 : 3) : (t2 = current.y >= 0.0 ? 1 : 2);
                if (t2 == (t1 + 1) % 4) {
                    ++sum;
                } else if (t2 == (t1 + 3) % 4) {
                    --sum;
                } else if (t2 == (t1 + 2) % 4) {
                    sum = f > 0.0 ? (sum += 2) : (sum -= 2);
                }
                t1 = t2;
                prev = current;
                ++i;
            }
        }
        boolean result = i < this.points.size() && outline || sum > 0;
        this.translate(toTest.x, toTest.y);
        return result;
    }

    public PrecisionPointList intersect(PrecisionLine line, double tolerance) {
        PrecisionPointList result = new PrecisionPointList();
        int i = 0;
        while (i < this.points.size()) {
            PrecisionLine l = this.getLine(i);
            PrecisionPoint p = l.intersect(line, tolerance);
            if (p != null) {
                result.addPoint(p);
            }
            ++i;
        }
        return result;
    }

    public PrecisionPointList intersect(PrecisionLine line) {
        return this.intersect(line, 1.0E-4);
    }

    public PrecisionPoint intersectFarthest(PrecisionLine line, double tolerance) {
        PrecisionPoint result = null;
        int i = 0;
        while (i < this.points.size()) {
            PrecisionLine l = this.getLine(i);
            PrecisionPoint p = l.intersect(line, tolerance);
            if (p != null && (result == null || p != null && p.getDistance2(line.getOrigin()) > result.getDistance2(line.getOrigin()))) {
                result = p;
            }
            ++i;
        }
        return result;
    }

    public PrecisionPoint intersectFarthest(PrecisionLine line) {
        return this.intersectFarthest(line, 1.0E-4);
    }

    public PrecisionPoint intersectNearest(PrecisionLine line, double tolerance) {
        PrecisionPoint result = null;
        int i = 0;
        while (i < this.points.size()) {
            PrecisionLine l = this.getLine(i);
            PrecisionPoint p = l.intersect(line, tolerance);
            if (p != null && (result == null || p.getDistance2(line.getOrigin()) < result.getDistance2(line.getOrigin()))) {
                result = p;
            }
            ++i;
        }
        return result;
    }

    public PrecisionPoint intersectNearest(PrecisionLine line) {
        return this.intersectNearest(line, 1.0E-4);
    }

    public PrecisionLine getLine(int index) {
        if (index < 0 || index >= this.points.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.points.size());
        }
        PrecisionPoint origin = this.points.getPoint(index);
        PrecisionPoint terminus = index < this.points.size() - 1 ? this.points.getPoint(index + 1) : this.points.getPoint(0);
        return new PrecisionLine(origin, terminus);
    }

    public PrecisionPolygon getCopy() {
        return new PrecisionPolygon(this.points.getCopy());
    }

    public void addAll(PrecisionPointList source) {
        this.points.addAll(source);
    }

    public void addPoint(double x, double y) {
        this.points.addPoint(x, y);
    }

    public void addPoint(PrecisionPoint p) {
        this.points.addPoint(p);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PrecisionPolygon)) {
            return false;
        }
        PrecisionPolygon p = (PrecisionPolygon)obj;
        return p.points.equals(this.points);
    }

    public PrecisionRectangle getBounds() {
        return this.points.getBounds();
    }

    public PrecisionPoint getFirstPoint() {
        return this.points.getFirstPoint();
    }

    public PrecisionPoint getLastPoint() {
        return this.points.getLastPoint();
    }

    public PrecisionPoint getMidPoint() {
        return this.points.getMidPoint();
    }

    public PrecisionPoint getPoint(int index) {
        return this.points.getPoint(index);
    }

    public int hashCode() {
        return this.points.hashCode();
    }

    public void insertPoint(PrecisionPoint p, int index) {
        this.points.insertPoint(p, index);
    }

    public void removeAllPoints() {
        this.points.removeAllPoints();
    }

    public PrecisionPoint removePoint(int index) {
        return this.points.removePoint(index);
    }

    public void reverse() {
        this.points.reverse();
    }

    public void scale(double amount) {
        this.points.scale(amount);
    }

    public void setPoint(PrecisionPoint p, int index) {
        this.points.setPoint(p, index);
    }

    public void setSize(int newSize) {
        this.points.setSize(newSize);
    }

    public int size() {
        return this.points.size();
    }

    public PrecisionPoint[] toArray() {
        return this.points.toArray();
    }

    public String toString() {
        return this.points.toString();
    }

    public void translate(double dx, double dy) {
        this.points.translate(dx, dy);
    }

    public void translate(PrecisionDimension d) {
        this.points.translate(d);
    }

    public static final PrecisionPolygon createFromRect(PrecisionRectangle r) {
        PrecisionPolygon result = new PrecisionPolygon();
        result.addPoint(r.getTopLeft());
        result.addPoint(r.getTopRight());
        result.addPoint(r.getBottomRight());
        result.addPoint(r.getBottomLeft());
        return result;
    }
}

