/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointList {
    private int num;
    private int min;
    private int max;
    private List<Point> points;
    public static final int POINTS_MAX = 4;
    public static final int POINTS_MIN = 2;

    public PointList() {
        this(2, 4);
    }

    public PointList(int min, int max) {
        this.min = min;
        this.max = max;
        this.num = min;
        this.points = new ArrayList<Point>(max);
        int i = 0;
        while (i < max) {
            this.points.add(null);
            ++i;
        }
    }

    public PointList(PointList another) {
        this(another.min, another.max);
        this.setNumPoints(another.getNumPoints());
        int i = 0;
        while (i < this.max) {
            this.setPoint(i, another.getPoint(i));
            ++i;
        }
    }

    public int getNumPoints() {
        return this.num;
    }

    public boolean setNumPoints(int points) {
        int n = Math.max(this.min, Math.min(this.max, points));
        if (n == this.num) {
            return false;
        }
        this.num = n;
        return true;
    }

    public Point getPoint(int index) {
        if (index < 0 || index >= this.num) {
            return null;
        }
        Point p = this.points.get(index);
        return p == null ? null : new Point(p);
    }

    public boolean setPoint(int index, Point p) {
        if (index < 0 || index >= this.num) {
            return false;
        }
        Point old = this.getPoint(index);
        if (p == old || p != null && p.equals((Object)old)) {
            return false;
        }
        this.points.set(index, p == null ? null : new Point(p));
        return true;
    }

    public List<Point> getPoints() {
        return new ArrayList<Point>(this.points).subList(0, this.num);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PointList)) {
            return false;
        }
        PointList pm = (PointList)obj;
        return this.min == pm.min && this.max == pm.max && this.num == pm.num && this.points.equals(pm.points);
    }
}

