/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.Figure;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IAnchorListener;
import org.xmind.gef.draw2d.IConnectionFigure;

public abstract class ConnectionFigure
extends Figure
implements IAnchorListener,
IConnectionFigure {
    private IAnchor sourceAnchor;
    private IAnchor targetAnchor;

    public ConnectionFigure() {
    }

    public ConnectionFigure(IAnchor sourceAnchor, IAnchor targetAnchor) {
        this.setSourceAnchor(sourceAnchor);
        this.setTargetAnchor(targetAnchor);
    }

    public IAnchor getSourceAnchor() {
        return this.sourceAnchor;
    }

    public IAnchor getTargetAnchor() {
        return this.targetAnchor;
    }

    public void setSourceAnchor(IAnchor anchor) {
        if (anchor == this.sourceAnchor) {
            return;
        }
        if (this.sourceAnchor != null) {
            this.unhookSourceAnchor(this.sourceAnchor);
        }
        this.sourceAnchor = anchor;
        if (anchor != null) {
            this.hookSourceAnchor(anchor);
        }
        this.revalidate();
        this.repaint();
    }

    public void setTargetAnchor(IAnchor anchor) {
        if (anchor == this.targetAnchor) {
            return;
        }
        if (this.targetAnchor != null) {
            this.unhookTargetAnchor(this.targetAnchor);
        }
        this.targetAnchor = anchor;
        if (anchor != null) {
            this.hookTargetAnchor(anchor);
        }
        this.revalidate();
        this.repaint();
    }

    protected void unhookSourceAnchor(IAnchor anchor) {
        anchor.removeAnchorListener(this);
    }

    protected void hookSourceAnchor(IAnchor anchor) {
        anchor.addAnchorListener(this);
    }

    protected void unhookTargetAnchor(IAnchor anchor) {
        anchor.removeAnchorListener(this);
    }

    protected void hookTargetAnchor(IAnchor anchor) {
        anchor.addAnchorListener(this);
    }

    public void anchorMoved(IAnchor anchor) {
        if (anchor.getOwner() != this) {
            this.revalidate();
        }
    }
}

