/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder.model;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.ui.internal.iconfinder.model.Author;
import org.xmind.ui.internal.iconfinder.model.Category;
import org.xmind.ui.internal.iconfinder.model.Price;

public class Iconset {
    private JSONObject iconset;

    public Iconset(JSONObject iconset) {
        this.iconset = iconset;
    }

    public List<Author> getAuthors() {
        ArrayList<Author> authors = new ArrayList<Author>();
        JSONArray authorsArray = this.iconset.optJSONArray("authors");
        int i = 0;
        while (i < authorsArray.length()) {
            Author author = new Author(authorsArray.optJSONObject(i));
            authors.add(author);
            ++i;
        }
        return authors;
    }

    public List<Category> getCategories() {
        ArrayList<Category> categories = new ArrayList<Category>();
        JSONArray categoriesArray = this.iconset.optJSONArray("categories");
        int i = 0;
        while (i < categoriesArray.length()) {
            Category category = new Category(categoriesArray.optJSONObject(i));
            categories.add(category);
            ++i;
        }
        return categories;
    }

    public int getIconsCount() {
        return this.iconset.optInt("icons_count");
    }

    public int getId() {
        return this.iconset.optInt("iconset_id");
    }

    public String getIdentifier() {
        return this.iconset.optString("identifier");
    }

    public boolean isPremium() {
        return this.iconset.optBoolean("is_premium");
    }

    public String getName() {
        return this.iconset.optString("name");
    }

    public List<Price> getPrices() {
        ArrayList<Price> prices = new ArrayList<Price>();
        JSONArray pricesArray = this.iconset.optJSONArray("prices");
        int i = 0;
        while (i < pricesArray.length()) {
            Price price = new Price(pricesArray.optJSONObject(i));
            prices.add(price);
            ++i;
        }
        return prices;
    }
}

