/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.iconfinder.DownloadJobPool;
import org.xmind.ui.internal.iconfinder.IconfinderActivator;
import org.xmind.ui.internal.iconfinder.IconfinderDownloadJob;
import org.xmind.ui.internal.iconfinder.IconfinderEvent;
import org.xmind.ui.internal.iconfinder.IconfinderListener;
import org.xmind.ui.internal.iconfinder.IconfinderModelPage;
import org.xmind.ui.internal.iconfinder.Messages;
import org.xmind.ui.internal.iconfinder.model.Category;
import org.xmind.ui.internal.iconfinder.model.Format;
import org.xmind.ui.internal.iconfinder.model.Icon;
import org.xmind.ui.internal.iconfinder.model.Iconset;
import org.xmind.ui.internal.iconfinder.model.Raster;
import org.xmind.ui.internal.iconfinder.model.Style;

public class IconfinderCore {
    private static final String DOMAIN = LinkUtils.getLinkByLanguage((boolean)true, (boolean)true, (String)"/_api/iconfinder");
    private static final String PATH_SEARCH_ICONS = "/icons/search";
    private static final String PATH_LIST_ICONS_WITH_ICONSET_IDENTIFIER = "/iconsets/{0}/icons";
    private static final String PATH_GET_ICON_DETAIL_WITH_ICON_ID = "/icons/{0}";
    private static final String PATH_DOWNLOAD_ICON = "/download?url={0}";
    private static final String PATH_SEARCH_ICONSET_ALL = "/iconsets";
    private static final String PATH_SEARCH_ICONSET_AUTHENTICATED = "/user/iconsets";
    private static final String PATH_SEARCH_ICONSET_WITH_STYLE_IDENTIFIER = "/styles/{0}/iconsets";
    private static final String PATH_SEARCH_ICONSET_WITH_CATEGORY_IDENTIFIER = "/categories/{0}/iconsets";
    private static final String PATH_SEARCH_ICONSET_WITH_USER_ID = "/users/{0}/iconsets";
    private static final String PATH_SEARCH_ICONSET_WITH_AUTHOR_ID = "/authors/{0}/iconsets";
    private static final String PATH_GET_ICON_SET_DETAIL_WITH_ID = "/iconsets/{0}";
    private static final String PATH_GET_ICON_SET_DETAIL_WITH_IDENTIFIER = "/iconsets/{0}";
    private static final String PATH_LIST_CATEGORY_ALL = "/categories";
    private static final String PATH_GET_CATEGORY_DETAIL_WITH_CATRGORY_IDENTIFIER = "/categories/{0}";
    private static final String PATH_LIST_STYLE_ALL = "/styles";
    private static final String PATH_GET_STYLE_DETAIL_WITH_STYLE_IDENTIFIER = "/styles/{0}";
    public static final String DIR_ICONFINDER_CACHED_ROOT = ".iconfinderCached";
    public static final String DIR_ICONS_CACHED = ".iconsCached";
    public static final String DIR_ICONFINDER_SESSION_CACHED = ".iconfinderSessionCached";
    public static final String DIR_SESSIONS = "sessions";
    public static final String DIR_CATEGORIES = "categories";
    public static final String DIR_STYLES = "styles";
    public static final String DIR_SESSION_ICONS = "icons";
    public static final String DIR_SESSION_ICON_DETAILS = "iconDetails";
    public static final String DIR_SESSION_ICONSET_DETAILS = "iconsetDetails";
    public static final String DIR_SESSION_ICON_PREVIEW = "iconPreview";
    public static final String DIR_SESSION_ICONS_ICONJSONS = "iconJsons";
    public static final String INTERNAL_CATEGORY_STYLE_IDENTIFIER_ALL = "All";
    public static final String INTERNAL_ICONSET_SEARCH_PREFIX = "iconset:";
    private static IconfinderCore INSTANCE = new IconfinderCore();
    public static final int[] ICON_SIZE_PRIORITY_ARRAY = new int[]{64, 96, 128, 256};
    private DownloadJobPool downloadJobPool;
    private Map<String, ListenerList> listeners = new HashMap<String, ListenerList>();
    private IconfinderModelPage modelPage;

    private IconfinderCore() {
        this.downloadJobPool = new DownloadJobPool();
    }

    public static final IconfinderCore getInstance() {
        return INSTANCE;
    }

    public void cancelJobs() {
        this.downloadJobPool.cancelRemaining();
        Job.getJobManager().cancel((Object)this);
        this.downloadJobPool = new DownloadJobPool();
    }

    public static List<Icon> getIcons(String iconsetIdentifier, int atMost, String sessionId) {
        File iconsDir = iconsetIdentifier == null ? IconfinderCore.getIconsDiretoryBasedOn(sessionId) : IconfinderCore.getIconsDirOfIconset(sessionId, iconsetIdentifier);
        List<Icon> icons = IconfinderCore.getIcons(sessionId, iconsDir);
        int size = Math.min(atMost, icons.size());
        return icons.subList(0, size);
    }

    public static int getTotalIconsSize(String iconsetIdentifier, String sessionId) {
        File iconsDir = iconsetIdentifier == null ? IconfinderCore.getIconsDiretoryBasedOn(sessionId) : IconfinderCore.getIconsDirOfIconset(sessionId, iconsetIdentifier);
        new ArrayList();
        File iconJsonsDir = new File(iconsDir, DIR_SESSION_ICONS_ICONJSONS);
        if (iconJsonsDir.exists() && iconJsonsDir.isDirectory()) {
            File[] jsons;
            File[] fileArray = jsons = iconJsonsDir.listFiles();
            int n = jsons.length;
            int n2 = 0;
            while (n2 < n) {
                File json = fileArray[n2];
                JSONObject iconJsonObject = IconfinderCore.readObject(json);
                Object count = iconJsonObject.opt("total_count");
                if (count != null) {
                    return (Integer)count;
                }
                ++n2;
            }
        }
        return 0;
    }

    public static List<Icon> getIcons(String sessionId, File iconsDir) {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        File iconJsonsDir = new File(iconsDir, DIR_SESSION_ICONS_ICONJSONS);
        if (iconJsonsDir.exists() && iconJsonsDir.isDirectory()) {
            List<File> jsonFileList = Arrays.asList(iconJsonsDir.listFiles());
            Collections.sort(jsonFileList, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    if (f1 != null && f2 != null) {
                        String intName1 = f1.getName();
                        String intName2 = f2.getName();
                        int index1 = intName1.lastIndexOf(46);
                        int index2 = intName2.lastIndexOf(46);
                        if (index1 < 0 || index2 < 0) {
                            return 0;
                        }
                        String int1 = intName1.substring(0, index1);
                        String int2 = intName2.substring(0, index2);
                        return (int1.length() - int2.length()) * intName1.compareTo(intName2);
                    }
                    return 0;
                }
            });
            for (File json : jsonFileList) {
                JSONObject iconJsonObject = IconfinderCore.readObject(json);
                JSONArray iconsArray = iconJsonObject.optJSONArray(DIR_SESSION_ICONS);
                int i = 0;
                while (i < iconsArray.length()) {
                    Icon icon = new Icon(iconsArray.optJSONObject(i));
                    if (!icon.isPremium() && !icons.contains(icon)) {
                        icons.add(icon);
                    }
                    ++i;
                }
            }
        }
        return icons;
    }

    public static List<Category> getCategories() {
        ArrayList<Category> categories = new ArrayList<Category>();
        JSONObject categoryJsonObject = new JSONObject();
        categoryJsonObject.put("name", (Object)INTERNAL_CATEGORY_STYLE_IDENTIFIER_ALL);
        categoryJsonObject.put("identifier", (Object)INTERNAL_CATEGORY_STYLE_IDENTIFIER_ALL);
        categories.add(new Category(categoryJsonObject));
        File categoriesDir = IconfinderCore.getCategoriesDir();
        File categoriesFile = new File(categoriesDir, "categories.json");
        if (categoriesFile.exists()) {
            JSONObject categoryObject = IconfinderCore.readObject(categoriesFile);
            JSONArray categoriesArray = categoryObject.optJSONArray(DIR_CATEGORIES);
            int length = categoriesArray.length();
            int i = 0;
            while (i < length) {
                Category category = new Category(categoriesArray.optJSONObject(i));
                categories.add(category);
                ++i;
            }
        }
        return categories;
    }

    public static List<Style> getStyles() {
        File stylesDir = IconfinderCore.getStylesDirectory();
        ArrayList<Style> styles = new ArrayList<Style>();
        JSONObject styleJsonObject = new JSONObject();
        styleJsonObject.put("name", (Object)INTERNAL_CATEGORY_STYLE_IDENTIFIER_ALL);
        styleJsonObject.put("identifier", (Object)INTERNAL_CATEGORY_STYLE_IDENTIFIER_ALL);
        styles.add(new Style(styleJsonObject));
        File stylesFile = new File(stylesDir, "styles.json");
        if (stylesFile.exists()) {
            JSONObject styleObject = IconfinderCore.readObject(stylesFile);
            JSONArray stylesArray = styleObject.optJSONArray(DIR_STYLES);
            int length = stylesArray.length();
            int i = 0;
            while (i < length) {
                Style style = new Style(stylesArray.optJSONObject(i));
                styles.add(style);
                ++i;
            }
        }
        return styles;
    }

    public void addIconfinderListener(String sessionId, IconfinderListener listener) {
        if (this.listeners.containsKey(sessionId)) {
            ListenerList listenerList = this.listeners.get(sessionId);
            listenerList.add((Object)listener);
        } else {
            ListenerList listenerList = new ListenerList();
            listenerList.add((Object)listener);
            this.listeners.put(sessionId, listenerList);
        }
    }

    public void removeIconfinderListener(String sessionId, IconfinderListener listener) {
        if (this.listeners.containsKey(sessionId)) {
            ListenerList listenerList = this.listeners.get(sessionId);
            listenerList.remove((Object)listener);
            if (listenerList.isEmpty()) {
                this.listeners.remove(sessionId);
            }
        }
    }

    private void fireIconfinderEvent(String sessionId, int type, Object source) {
        if (this.listeners.containsKey(sessionId)) {
            Object[] listeners;
            ListenerList listenerList = this.listeners.get(sessionId);
            IconfinderEvent event = new IconfinderEvent(type, source);
            Object[] objectArray = listeners = listenerList.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IconfinderListener)listener).handlerIconfinderEvent(event);
                ++n2;
            }
        }
    }

    public void requestIcons(String searchIconContent, String category, String style, int offset, final String sessionId, final boolean deamon) {
        String sourceUri = IconfinderCore.generateUriForSearchIconsWith(searchIconContent, category, style, offset);
        final File iconsDir = IconfinderCore.getIconsDiretoryBasedOn(sessionId);
        File iconJsonDir = IconfinderCore.getIconJsonsBasedOn(sessionId);
        String jsonName = String.valueOf(offset) + ".json";
        final File targetJsonFile = new File(iconJsonDir, jsonName);
        String targetJsonUri = targetJsonFile.getAbsolutePath();
        IconfinderDownloadJob downloadJsonJob = new IconfinderDownloadJob(Messages.Iconfinder_DownloadIconsInfo_jobName, sourceUri, targetJsonUri, "org.xmind.ui.iconfinder");
        if (targetJsonFile.exists()) {
            downloadJsonJob.setLastModificationTime(targetJsonFile.lastModified());
        }
        downloadJsonJob.setSystem(deamon);
        downloadJsonJob.setCaller(this.modelPage);
        this.downloadJobPool.scheduleDownloadJob(downloadJsonJob, new Runnable(){

            @Override
            public void run() {
                JSONObject jsonObject = null;
                if (targetJsonFile.exists()) {
                    jsonObject = IconfinderCore.readObject(targetJsonFile);
                }
                IconfinderCore.this.fireIconfinderEvent(sessionId, 2, jsonObject);
                if (!targetJsonFile.exists()) {
                    return;
                }
                IconfinderCore.this.dowloadIconsBasedOnIconJsonFile(sessionId, iconsDir, targetJsonFile, deamon);
            }
        });
    }

    public void requestAllCategories(final String sessionId) {
        File categoriesDir = IconfinderCore.getCategoriesDir();
        File targetJsonFile = new File(categoriesDir, "categories.json");
        if (targetJsonFile.exists()) {
            this.fireIconfinderEvent(sessionId, 4, null);
            return;
        }
        String sourceUri = IconfinderCore.generateUriForAllCategories();
        String targetJsonUri = targetJsonFile.getAbsolutePath();
        IconfinderDownloadJob downloadCategoriesJob = new IconfinderDownloadJob("Download all categories from iconfinder", sourceUri, targetJsonUri, "org.xmind.ui.iconfinder");
        downloadCategoriesJob.setSystem(true);
        this.downloadJobPool.scheduleDownloadJob(downloadCategoriesJob, new Runnable(){

            @Override
            public void run() {
                IconfinderCore.this.fireIconfinderEvent(sessionId, 4, null);
            }
        });
    }

    public void requestAllStyles(final String sessionId) {
        File stylesDir = IconfinderCore.getStylesDirectory();
        File targetJsonFile = new File(stylesDir, "styles.json");
        if (targetJsonFile.exists()) {
            this.fireIconfinderEvent(sessionId, 8, null);
            return;
        }
        String sourceUri = IconfinderCore.generateUriForAllStyles();
        String targetJsonUri = targetJsonFile.getAbsolutePath();
        IconfinderDownloadJob downloadStylesJob = new IconfinderDownloadJob("Download styles info from iconfinder", sourceUri, targetJsonUri, "org.xmind.ui.iconfinder");
        downloadStylesJob.setSystem(true);
        this.downloadJobPool.scheduleDownloadJob(downloadStylesJob, new Runnable(){

            @Override
            public void run() {
                IconfinderCore.this.fireIconfinderEvent(sessionId, 8, null);
            }
        });
    }

    public void requestIconsByIconset(String searchIconsetContent, int after, int existedCount, final String sessionId, final boolean deamon) {
        String sourceUri = IconfinderCore.generateUriForSearchIconsByIconset(searchIconsetContent, after);
        final File iconsDirOfIconset = IconfinderCore.getIconsDirOfIconset(sessionId, searchIconsetContent);
        File iconJsonsDirOfIconset = IconfinderCore.getIconJsonsDirOfIconset(sessionId, searchIconsetContent);
        String jsonName = String.valueOf(existedCount) + ".json";
        final File targetJsonFile = new File(iconJsonsDirOfIconset, jsonName);
        String targetJsonUri = targetJsonFile.getAbsolutePath();
        File iconsetDetailsDir = IconfinderCore.getIconsetDetailsDirBasedOn(sessionId);
        final File iconsetDetailFile = new File(iconsetDetailsDir, String.valueOf(searchIconsetContent) + ".json");
        if (iconsetDetailFile.exists()) {
            Iconset iconset = null;
            JSONObject jsonObject = IconfinderCore.readObject(iconsetDetailFile);
            if (jsonObject != null) {
                iconset = new Iconset(jsonObject);
            }
            this.fireIconfinderEvent(sessionId, 16, iconset);
        } else {
            IconfinderDownloadJob downloadIconsetDetailJob = new IconfinderDownloadJob(Messages.Iconfinder_DownloadIconsetDetail_jobName, IconfinderCore.generateUriForIconsetDetails(searchIconsetContent), iconsetDetailFile.getAbsolutePath(), "org.xmind.ui.iconfinder");
            downloadIconsetDetailJob.setSystem(deamon);
            this.downloadJobPool.scheduleDownloadJob(downloadIconsetDetailJob, new Runnable(){

                @Override
                public void run() {
                    JSONObject jsonObject;
                    Iconset iconset = null;
                    if (iconsetDetailFile.exists() && (jsonObject = IconfinderCore.readObject(iconsetDetailFile)) != null) {
                        iconset = new Iconset(jsonObject);
                    }
                    IconfinderCore.this.fireIconfinderEvent(sessionId, 16, iconset);
                }
            });
        }
        IconfinderDownloadJob downloadJsonJob = new IconfinderDownloadJob(Messages.Iconfinder_DownloadIconsInfo_OfIconset_jobName, sourceUri, targetJsonUri, "org.xmind.ui.iconfinder");
        this.downloadJobPool.scheduleDownloadJob(downloadJsonJob, new Runnable(){

            @Override
            public void run() {
                JSONObject jsonObject = null;
                if (targetJsonFile.exists()) {
                    jsonObject = IconfinderCore.readObject(targetJsonFile);
                }
                IconfinderCore.this.fireIconfinderEvent(sessionId, 2, jsonObject);
                if (!targetJsonFile.exists()) {
                    return;
                }
                IconfinderCore.this.dowloadIconsBasedOnIconJsonFile(sessionId, iconsDirOfIconset, targetJsonFile, deamon);
            }
        });
    }

    public void requestIconsetBy(Icon icon, final String sessionId, final boolean deamon) {
        int iconId = icon.getIconId();
        String sourceIconDetailsUri = IconfinderCore.generateUriForIconDetails(iconId);
        File iconDetailsDir = IconfinderCore.getIconDetailsDirBasedOn(sessionId);
        final File targetIconDetailsFile = new File(iconDetailsDir, String.valueOf(iconId) + ".json");
        if (targetIconDetailsFile.exists()) {
            this.downloadIconsBasedOnIconDetailsFile(sessionId, targetIconDetailsFile, deamon);
        } else {
            String targetIconDetailsPath = targetIconDetailsFile.getAbsolutePath();
            IconfinderDownloadJob downloadIconDetailJsonJob = new IconfinderDownloadJob(String.valueOf(Messages.Iconfinder_DownloadIconDetails_jobName) + iconId, sourceIconDetailsUri, targetIconDetailsPath, "org.xmind.ui.iconfinder");
            downloadIconDetailJsonJob.setSystem(deamon);
            this.downloadJobPool.scheduleDownloadJob(downloadIconDetailJsonJob, new Runnable(){

                @Override
                public void run() {
                    if (!targetIconDetailsFile.exists()) {
                        return;
                    }
                    IconfinderCore.this.downloadIconsBasedOnIconDetailsFile(sessionId, targetIconDetailsFile, deamon);
                }
            });
        }
    }

    private void downloadIconsBasedOnIconDetailsFile(final String sessionId, File targetIconDetailsFile, final boolean deamon) {
        JSONObject iconDetailObject = IconfinderCore.readObject(targetIconDetailsFile);
        if (iconDetailObject == null) {
            return;
        }
        JSONObject iconsetObject = iconDetailObject.optJSONObject("iconset");
        Iconset iconset = new Iconset(iconsetObject);
        String iconsetIdentifier = iconset.getIdentifier();
        this.fireIconfinderEvent(sessionId, 16, iconset);
        String sourceIconsFromIconsetUri = IconfinderCore.generateUriForListIconsWith(iconsetIdentifier);
        final File iconsDirOfIconset = IconfinderCore.getIconsDirOfIconset(sessionId, iconsetIdentifier);
        File iconJsonsDirOfIconset = IconfinderCore.getIconJsonsDirOfIconset(sessionId, iconsetIdentifier);
        final File targetIconJsonFile = new File(iconJsonsDirOfIconset, "0.json");
        if (!targetIconJsonFile.exists()) {
            String targetIconJsonPath = targetIconJsonFile.getAbsolutePath();
            IconfinderDownloadJob downloadIconsJsonJob = new IconfinderDownloadJob(Messages.Iconfinder_DownloadIconsInfo_jobName, sourceIconsFromIconsetUri, targetIconJsonPath, "org.xmind.ui.iconfinder");
            downloadIconsJsonJob.setSystem(deamon);
            this.downloadJobPool.scheduleDownloadJob(downloadIconsJsonJob, new Runnable(){

                @Override
                public void run() {
                    JSONObject jsonObject = null;
                    if (targetIconJsonFile.exists()) {
                        jsonObject = IconfinderCore.readObject(targetIconJsonFile);
                    }
                    IconfinderCore.this.fireIconfinderEvent(sessionId, 2, jsonObject);
                    if (!targetIconJsonFile.exists()) {
                        return;
                    }
                    IconfinderCore.this.dowloadIconsBasedOnIconJsonFile(sessionId, iconsDirOfIconset, targetIconJsonFile, deamon);
                }
            });
        } else {
            JSONObject jsonObject = null;
            if (targetIconJsonFile.exists()) {
                jsonObject = IconfinderCore.readObject(targetIconJsonFile);
            }
            this.fireIconfinderEvent(sessionId, 2, jsonObject);
            this.dowloadIconsBasedOnIconJsonFile(sessionId, iconsDirOfIconset, targetIconJsonFile, deamon);
        }
        File iconsetDetailsDir = IconfinderCore.getIconsetDetailsDirBasedOn(sessionId);
        final File iconsetDetailFile = new File(iconsetDetailsDir, String.valueOf(iconsetIdentifier) + ".json");
        if (iconsetDetailFile.exists()) {
            this.fireIconfinderEvent(sessionId, 16, iconset);
        } else {
            IconfinderDownloadJob downloadIconsetDetailJob = new IconfinderDownloadJob(Messages.Iconfinder_DownloadIconsetDetail_jobName, IconfinderCore.generateUriForIconsetDetails(iconsetIdentifier), iconsetDetailFile.getAbsolutePath(), "org.xmind.ui.iconfinder");
            downloadIconsetDetailJob.setSystem(deamon);
            this.downloadJobPool.scheduleDownloadJob(downloadIconsetDetailJob, new Runnable(){

                @Override
                public void run() {
                    JSONObject jsonObject;
                    Iconset iconset = null;
                    if (iconsetDetailFile.exists() && (jsonObject = IconfinderCore.readObject(iconsetDetailFile)) != null) {
                        iconset = new Iconset(jsonObject);
                    }
                    IconfinderCore.this.fireIconfinderEvent(sessionId, 16, iconset);
                }
            });
        }
    }

    private void dowloadIconsBasedOnIconJsonFile(String sessionId, File iconsDir, File targetIconJsonFile, boolean deamon) {
        JSONObject iconJsonObject = IconfinderCore.readObject(targetIconJsonFile);
        if (iconJsonObject == null) {
            return;
        }
        ArrayList<Icon> icons = new ArrayList<Icon>();
        JSONArray iconsArray = iconJsonObject.optJSONArray(DIR_SESSION_ICONS);
        int i = 0;
        while (i < iconsArray.length()) {
            Icon icon = new Icon(iconsArray.optJSONObject(i));
            File previewFile = IconfinderCore.getIconPreviewFile(sessionId, icon.getIconId());
            if (!icon.isPremium() && !previewFile.exists()) {
                icons.add(icon);
            }
            ++i;
        }
        for (Icon icon : icons) {
            this.downloadIconPreview(sessionId, icon, deamon);
        }
    }

    public void downloadIconPreview(final String sessionId, final Icon icon, boolean deamon) {
        String sourceUri = IconfinderCore.getIconPreviewUri(icon);
        if (sourceUri != null) {
            File iconPreviewFile = IconfinderCore.getIconPreviewFile(sessionId, icon.getIconId());
            final String targetPath = iconPreviewFile.getAbsolutePath();
            IconfinderDownloadJob downloadIconsJob = new IconfinderDownloadJob(Messages.Iconfinder_DownloadIcon_jobName, sourceUri, targetPath);
            if (iconPreviewFile.exists()) {
                downloadIconsJob.setLastModificationTime(iconPreviewFile.lastModified());
            }
            downloadIconsJob.setSystem(deamon);
            downloadIconsJob.setCaller(this.modelPage);
            this.downloadJobPool.scheduleDownloadJob(downloadIconsJob, new Runnable(){

                @Override
                public void run() {
                    if (new File(targetPath).exists()) {
                        IconfinderCore.this.fireIconfinderEvent(sessionId, 1, icon);
                    }
                }
            });
        }
    }

    public static void downloadIconImage(Icon icon, boolean deamon, Integer size) {
        Format format = IconfinderCore.getRequiredFormat(icon, size);
        if (format != null) {
            String downloadUri = format.getDownloadUrl();
            String sourceUri = IconfinderCore.generateUriForDownloadIcon(downloadUri);
            File targetFile = IconfinderCore.getIconFile(icon.getIconId());
            if (targetFile.exists()) {
                targetFile.delete();
            }
            String targetPath = targetFile.getAbsolutePath();
            IconfinderDownloadJob downloadIconJob = new IconfinderDownloadJob(Messages.Iconfinder_DownloadIcon_jobName, sourceUri, targetPath);
            if (targetFile.exists()) {
                long lastModifiedTime = targetFile.lastModified();
                downloadIconJob.setLastModificationTime(lastModifiedTime);
            }
            downloadIconJob.setSystem(deamon);
            downloadIconJob.schedule();
            try {
                downloadIconJob.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            VerifyUI20141031.getUsageDataCollector().increase("DownloadIconCount");
        }
    }

    public static void blockDowloadIconImage(final Icon[] icons, final Integer size) {
        final ProgressMonitorDialog runner = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        runner.setCancelable(true);
        runner.setOpenOnRun(true);
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                runner.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Icon[] iconArray = icons;
                        int n = icons.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Icon icon = iconArray[n2];
                            IconfinderCore.downloadIconImage(icon, false, size);
                            ++n2;
                        }
                    }
                });
            }
        });
    }

    public static String getIconPreviewUri(Icon icon) {
        Format format = IconfinderCore.getRequiredFormat(icon, null);
        return format == null ? null : format.getPreviewUrl();
    }

    private static Format getRequiredFormat(Icon icon, Integer size) {
        List<Raster> rasters = icon.getRasterSizes();
        Raster priorityRaster = null;
        Raster maxSizeRaster = null;
        if (size != null) {
            for (Raster r : rasters) {
                if (r.getSize() == size.intValue()) {
                    priorityRaster = r;
                    break;
                }
                if ((maxSizeRaster == null || r == null || r.getSize() <= maxSizeRaster.getSize()) && maxSizeRaster != null) continue;
                maxSizeRaster = r;
            }
        } else {
            int[] nArray = ICON_SIZE_PRIORITY_ARRAY;
            int n = ICON_SIZE_PRIORITY_ARRAY.length;
            int n2 = 0;
            while (n2 < n) {
                int prioritySize = nArray[n2];
                if (priorityRaster == null) {
                    for (Raster r : rasters) {
                        if (r.getSize() == prioritySize) {
                            priorityRaster = r;
                            break;
                        }
                        if ((maxSizeRaster == null || r == null || r.getSize() <= maxSizeRaster.getSize()) && maxSizeRaster != null) continue;
                        maxSizeRaster = r;
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }
        Raster raster = priorityRaster = priorityRaster != null ? priorityRaster : maxSizeRaster;
        if (priorityRaster != null) {
            List<Format> formats = priorityRaster.getFormats();
            for (Format f : formats) {
                if (!"png".equals(f.getFormatType())) continue;
                return f;
            }
        }
        return null;
    }

    public static JSONObject readObject(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            JSONObject jSONObject = new JSONObject(new JSONTokener((InputStream)fis));
            return jSONObject;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static String generateUriForAllCategories() {
        return String.valueOf(DOMAIN) + PATH_LIST_CATEGORY_ALL + "?count=60";
    }

    private static String generateUriForAllStyles() {
        return String.valueOf(DOMAIN) + PATH_LIST_STYLE_ALL + "?count=60";
    }

    private static String generateUriForIconDetails(int iconId) {
        return String.valueOf(DOMAIN) + NLS.bind((String)PATH_GET_ICON_DETAIL_WITH_ICON_ID, (Object)iconId);
    }

    private static String generateUriForIconsetDetails(String iconsetIdentifier) {
        return String.valueOf(DOMAIN) + NLS.bind((String)"/iconsets/{0}", (Object)iconsetIdentifier);
    }

    private static String generateUriForListIconsWith(String iconsetIdentifier) {
        return String.valueOf(DOMAIN) + NLS.bind((String)PATH_LIST_ICONS_WITH_ICONSET_IDENTIFIER, (Object)iconsetIdentifier) + "?count=25";
    }

    private static final String generateUriForDownloadIcon(String downloadUrl) {
        String iconUrl = "";
        try {
            iconUrl = URLEncoder.encode(downloadUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return String.valueOf(DOMAIN) + NLS.bind((String)PATH_DOWNLOAD_ICON, (Object)iconUrl);
    }

    private static String generateUriForSearchIconsByIconset(String searchIconsetContent, int after) {
        StringBuffer uri = new StringBuffer();
        uri.append(DOMAIN);
        uri.append(NLS.bind((String)PATH_LIST_ICONS_WITH_ICONSET_IDENTIFIER, (Object)searchIconsetContent));
        uri.append("?count=25");
        if (after != 0) {
            uri.append("&after=");
            uri.append(after);
        }
        return uri.toString();
    }

    private static String generateUriForSearchIconsWith(String searchIconContent, String category, String style, int offset) {
        StringBuffer result = new StringBuffer();
        result.append(DOMAIN);
        result.append(PATH_SEARCH_ICONS);
        result.append("?query=");
        result.append(searchIconContent);
        if (category != null) {
            result.append("&category=");
            result.append(category);
        }
        if (style != null) {
            result.append("&style=");
            result.append(style);
        }
        result.append("&offset=");
        result.append(offset);
        result.append("&count=25");
        result.append("&premium=0");
        result.append("&vector=0");
        result.append("&license=commercial-nonattribution");
        return result.toString();
    }

    public static File getIconfinderRootDirectory() {
        File root = IconfinderActivator.getDefault().getStateLocation().toFile();
        File cachedDir = new File(root, DIR_ICONFINDER_CACHED_ROOT);
        FileUtils.ensureDirectory((File)cachedDir);
        return cachedDir;
    }

    public static File getIconfinderCachedIconsDirectory() {
        File cachedRootDir = IconfinderCore.getIconfinderRootDirectory();
        File cachedIcons = new File(cachedRootDir, DIR_ICONS_CACHED);
        FileUtils.ensureDirectory((File)cachedIcons);
        return cachedIcons;
    }

    public static File getIconfinderSessionDirectory() {
        File cachedRootDir = IconfinderCore.getIconfinderRootDirectory();
        File cachedSessionDir = new File(cachedRootDir, DIR_ICONFINDER_SESSION_CACHED);
        FileUtils.ensureDirectory((File)cachedSessionDir);
        return cachedSessionDir;
    }

    public static File getStylesDirectory() {
        File cachedRootDir = IconfinderCore.getIconfinderSessionDirectory();
        File stylesDir = new File(cachedRootDir, DIR_STYLES);
        FileUtils.ensureDirectory((File)stylesDir);
        return stylesDir;
    }

    public static File getCategoriesDir() {
        File cachedRootDir = IconfinderCore.getIconfinderSessionDirectory();
        File categoriesDir = new File(cachedRootDir, DIR_CATEGORIES);
        FileUtils.ensureDirectory((File)categoriesDir);
        return categoriesDir;
    }

    public static File getSessionsDirectory() {
        File cachedRootDir = IconfinderCore.getIconfinderSessionDirectory();
        File sessions = new File(cachedRootDir, DIR_SESSIONS);
        FileUtils.ensureDirectory((File)sessions);
        return sessions;
    }

    public static File getSessionDir(String sessionId) {
        File sessionsDir = IconfinderCore.getSessionsDirectory();
        File session = new File(sessionsDir, sessionId);
        FileUtils.ensureDirectory((File)session);
        return session;
    }

    public static File getIconsDiretoryBasedOn(String sessionId) {
        File session = IconfinderCore.getSessionDir(sessionId);
        File iconsDir = new File(session, DIR_SESSION_ICONS);
        FileUtils.ensureDirectory((File)iconsDir);
        return iconsDir;
    }

    public static File getIconDetailsDirBasedOn(String sessionId) {
        File session = IconfinderCore.getSessionDir(sessionId);
        File detailsDir = new File(session, DIR_SESSION_ICON_DETAILS);
        FileUtils.ensureDirectory((File)detailsDir);
        return detailsDir;
    }

    public static File getIconJsonsBasedOn(String sessionId) {
        File iconsDir = IconfinderCore.getIconsDiretoryBasedOn(sessionId);
        File iconJsons = new File(iconsDir, DIR_SESSION_ICONS_ICONJSONS);
        FileUtils.ensureDirectory((File)iconJsons);
        return iconJsons;
    }

    public static File getIconsetDirBasedOn(String sessionId, String iconsetIdentifier) {
        File session = IconfinderCore.getSessionDir(sessionId);
        File iconset = new File(session, iconsetIdentifier);
        FileUtils.ensureDirectory((File)iconset);
        return iconset;
    }

    public static File getIconsetDetailsDirBasedOn(String sessionId) {
        File session = IconfinderCore.getSessionDir(sessionId);
        File detailsDir = new File(session, DIR_SESSION_ICONSET_DETAILS);
        FileUtils.ensureDirectory((File)detailsDir);
        return detailsDir;
    }

    public static File getIconsDirOfIconset(String sessionId, String iconsetIdentifier) {
        File iconsetDir = IconfinderCore.getIconsetDirBasedOn(sessionId, iconsetIdentifier);
        return new File(iconsetDir, DIR_SESSION_ICONS);
    }

    public static File getIconJsonsDirOfIconset(String sessionId, String iconsetIdentifier) {
        File iconsDirOfIconset = IconfinderCore.getIconsDirOfIconset(sessionId, iconsetIdentifier);
        return new File(iconsDirOfIconset, DIR_SESSION_ICONS_ICONJSONS);
    }

    public static File getIconFile(int iconId) {
        File cachedIconsDir = IconfinderCore.getIconfinderCachedIconsDirectory();
        return new File(cachedIconsDir, String.valueOf(iconId) + ".png");
    }

    public static File getIconPreviewDir(String sessionId) {
        File sessionDir = IconfinderCore.getSessionDir(sessionId);
        File iconPreviewDir = new File(sessionDir, DIR_SESSION_ICON_PREVIEW);
        FileUtils.ensureDirectory((File)iconPreviewDir);
        return iconPreviewDir;
    }

    public static File getIconPreviewFile(String sessionId, int iconId) {
        File iconPreviewDir = IconfinderCore.getIconPreviewDir(sessionId);
        return new File(iconPreviewDir, String.valueOf(iconId) + "_preview.png");
    }

    public void setModelPage(IconfinderModelPage modelPage) {
        this.modelPage = modelPage;
    }

    public IconfinderModelPage getModelPage() {
        return this.modelPage;
    }
}

