/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.List;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.xmind.ui.gantt2.viewer.IHasOffset;
import org.xmind.ui.gantt2.viewer.IOffsetProvider;

public abstract class OffsetLayout
extends AbstractHintLayout
implements IOffsetProvider {
    private OffsetCache offsetCache = null;

    public OffsetLayout() {
        this.setObserveVisibility(true);
    }

    protected OffsetCache calculateOffset(IFigure container) {
        List children = container.getChildren();
        int offset = 0;
        boolean hasOffset = false;
        boolean first = true;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (this.doesChildHaveOffset(child) && (!this.isObservingVisibility() || child.isVisible())) {
                hasOffset = true;
                int childOffset = ((IHasOffset)child).getOffset();
                if (first) {
                    offset = childOffset;
                    first = false;
                } else {
                    offset = Math.min(offset, childOffset);
                }
            }
            ++i;
        }
        return new OffsetCache(offset, hasOffset);
    }

    protected boolean doesChildHaveOffset(IFigure child) {
        return child instanceof IHasOffset && ((IHasOffset)child).hasOffset();
    }

    protected OffsetCache getOffsetCache(IFigure container) {
        if (this.offsetCache == null) {
            this.offsetCache = this.calculateOffset(container);
        }
        return this.offsetCache;
    }

    public int getOffset(IFigure container) {
        return this.getOffsetCache((IFigure)container).offset;
    }

    public boolean hasOffset(IFigure container) {
        return this.getOffsetCache((IFigure)container).hasOffset;
    }

    public void invalidate() {
        this.offsetCache = null;
        super.invalidate();
    }

    protected static class OffsetCache {
        int offset;
        boolean hasOffset;

        public OffsetCache(int offset, boolean hasOffset) {
            this.offset = offset;
            this.hasOffset = hasOffset;
        }
    }
}

