/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.xmind.core.Core;
import org.xmind.core.internal.Workspace;

public class WorkspaceConfigurer {
    public static final String INSTANCE_LOCATION = "${osgi.instance.area}";
    public static final String USER_HOME = "${user.home}";
    private static final Pattern EXPANSION = Pattern.compile("\\$\\{([^\\}]+)\\}");

    private WorkspaceConfigurer() {
        throw new AssertionError();
    }

    public static void setDefaultWorkspaceLocation(String path) {
        String location = WorkspaceConfigurer.expandWorkspaceLocation(path);
        File dir = new File(location);
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        ((Workspace)Core.getWorkspace()).setDefaultWorkingDirectory(location);
    }

    private static String expandWorkspaceLocation(String path) {
        String oldWorkspaceLocation;
        if (INSTANCE_LOCATION.equals(path) && new File(oldWorkspaceLocation = WorkspaceConfigurer.expandWorkspaceLocation(String.valueOf(path) + "/.xmind")).isDirectory()) {
            return oldWorkspaceLocation;
        }
        File instanceLocation = WorkspaceConfigurer.calculateInstanceDir();
        Properties p = new Properties();
        p.putAll((Map<?, ?>)System.getProperties());
        p.put(INSTANCE_LOCATION.substring(2, INSTANCE_LOCATION.length() - 1), instanceLocation.getAbsolutePath());
        StringBuffer buffer = new StringBuffer(path.length() * 2);
        Matcher m = EXPANSION.matcher(path);
        while (m.find()) {
            String value = p.getProperty(m.group(1));
            if (value == null) {
                value = m.group();
            }
            value = value.replaceAll("([\\\\\\$])", "\\\\$1");
            m.appendReplacement(buffer, value);
        }
        m.appendTail(buffer);
        return buffer.toString();
    }

    private static File calculateInstanceDir() {
        Location loc = Platform.getInstanceLocation();
        if (loc == null) {
            return WorkspaceConfigurer.calculateDefaultInstanceDir();
        }
        URL url = loc.getURL();
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException iOException) {
            return WorkspaceConfigurer.calculateDefaultInstanceDir();
        }
        String file = url.getFile();
        if (file == null || "".equals(file)) {
            return WorkspaceConfigurer.calculateDefaultInstanceDir();
        }
        return new File(file);
    }

    private static File calculateDefaultInstanceDir() {
        String homeDir = System.getProperty("user.home");
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            return new File(new File(new File(homeDir, "Application Data"), "XMind"), "workspace-cathy");
        }
        if ("macosx".equals(os)) {
            return new File(new File(new File(homeDir, "Library"), "XMind"), "workspace-cathy");
        }
        return new File(new File(homeDir, ".xmind"), "workspace-cathy");
    }
}

