/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSource;
import net.coobird.thumbnailator.util.exif.ExifFilterUtils;
import net.coobird.thumbnailator.util.exif.ExifUtils;
import net.coobird.thumbnailator.util.exif.Orientation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImageSource
extends AbstractImageSource<File> {
    private static final int FIRST_IMAGE_INDEX = 0;
    private final File sourceFile;

    public FileImageSource(File sourceFile) {
        if (sourceFile == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.sourceFile = sourceFile;
    }

    public FileImageSource(String sourceFilePath) {
        if (sourceFilePath == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.sourceFile = new File(sourceFilePath);
    }

    @Override
    public BufferedImage read() throws IOException {
        if (!this.sourceFile.exists()) {
            throw new FileNotFoundException("Could not find file: " + this.sourceFile.getAbsolutePath());
        }
        ImageInputStream iis = ImageIO.createImageInputStream(this.sourceFile);
        if (iis == null) {
            throw new IOException("Could not open file: " + this.sourceFile.getAbsolutePath());
        }
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        if (!readers.hasNext()) {
            String sourcePath = this.sourceFile.getPath();
            throw new UnsupportedFormatException("<unknown>", "No suitable ImageReader found for " + sourcePath + ".");
        }
        ImageReader reader = readers.next();
        reader.setInput(iis);
        this.inputFormatName = reader.getFormatName();
        try {
            Orientation orientation;
            if (this.param.useExifOrientation() && (orientation = ExifUtils.getExifOrientation(reader, 0)) != null && orientation != Orientation.TOP_LEFT) {
                List<ImageFilter> filters = this.param.getImageFilters();
                filters.add(0, ExifFilterUtils.getFilterForOrientation(orientation));
            }
        }
        catch (Exception exception) {}
        ImageReadParam irParam = reader.getDefaultReadParam();
        int width = reader.getWidth(0);
        int height = reader.getHeight(0);
        if (this.param != null && this.param.getSourceRegion() != null) {
            Region region = this.param.getSourceRegion();
            Rectangle sourceRegion = region.calculate(width, height);
            irParam.setSourceRegion(sourceRegion);
        }
        if (this.param != null && "true".equals(System.getProperty("thumbnailator.conserveMemoryWorkaround")) && width > 1800 && height > 1800 && (long)(width * height * 4) > Runtime.getRuntime().freeMemory() / 4L) {
            int subsampling = 1;
            if (this.param.getSize() != null && this.param.getSize().width * 2 < width && this.param.getSize().height * 2 < height) {
                double widthScaling = (double)width / (double)this.param.getSize().width;
                double heightScaling = (double)height / (double)this.param.getSize().height;
                subsampling = (int)Math.floor(Math.min(widthScaling, heightScaling));
            } else if (this.param.getSize() == null) {
                subsampling = (int)Math.max(1.0, Math.floor(1.0 / Math.max(this.param.getHeightScalingFactor(), this.param.getWidthScalingFactor())));
            }
            while (width / subsampling < 600 || height / subsampling < 600) {
                --subsampling;
            }
            if (this.param.getSize() == null) {
                try {
                    Class<?> c = this.param.getClass();
                    Field heightField = c.getDeclaredField("heightScalingFactor");
                    Field widthField = c.getDeclaredField("widthScalingFactor");
                    heightField.setAccessible(true);
                    widthField.setAccessible(true);
                    heightField.set(this.param, this.param.getHeightScalingFactor() * (double)subsampling);
                    widthField.set(this.param, this.param.getWidthScalingFactor() * (double)subsampling);
                }
                catch (Exception exception) {
                    subsampling = 1;
                }
            }
            irParam.setSourceSubsampling(subsampling, subsampling, 0, 0);
        }
        BufferedImage img = reader.read(0, irParam);
        reader.dispose();
        iis.close();
        return this.finishedReading(img);
    }

    @Override
    public File getSource() {
        return this.sourceFile;
    }
}

