/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.sharing;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.core.command.Command;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.IReturnValueConsumer;
import org.xmind.core.command.ReturnValue;
import org.xmind.core.command.arguments.Attributes;
import org.xmind.core.command.binary.IBinaryEntry;
import org.xmind.core.command.binary.IBinaryStore;
import org.xmind.core.command.binary.INamedEntry;
import org.xmind.core.command.remote.IRemoteCommandService;
import org.xmind.core.command.remote.Options;
import org.xmind.core.internal.sharing.AbstractSharedMap;
import org.xmind.core.internal.sharing.LocalNetworkSharing;
import org.xmind.core.sharing.ISharedLibrary;

public class RemoteSharedMap
extends AbstractSharedMap {
    private IRemoteCommandService remoteServer;
    private INamedEntry resourceCache = null;

    public RemoteSharedMap(IRemoteCommandService remoteServer, ISharedLibrary library, String id, String name, byte[] thumbnailData, boolean missing) {
        super(library, id, name, thumbnailData);
        this.setMissing(missing);
        this.remoteServer = remoteServer;
    }

    public InputStream getResourceAsStream(IProgressMonitor loadingProgress) {
        loadingProgress.beginTask(null, 100);
        IBinaryEntry cache = this.getResourceCache(loadingProgress);
        try {
            InputStream inputStream = cache == null ? null : cache.openInputStream();
            return inputStream;
        }
        catch (IOException e) {
            LocalNetworkSharing.log("Failed to load resource from cache.", e);
            return null;
        }
        finally {
            loadingProgress.done();
        }
    }

    private synchronized IBinaryEntry getResourceCache(IProgressMonitor loadingProgress) {
        if (this.resourceCache == null) {
            this.resourceCache = this.loadResourceIntoCache(loadingProgress);
        }
        return this.resourceCache;
    }

    private Attributes getAttributes() {
        Attributes data = new Attributes();
        data.with("contact-id", LocalNetworkSharing.getDefault().getSharingService().getLocalLibrary().getContactID());
        return data;
    }

    private INamedEntry loadResourceIntoCache(IProgressMonitor loadingProgress) {
        final INamedEntry[] cache = new INamedEntry[]{null};
        this.remoteServer.execute(loadingProgress, (ICommand)new Command("sharing.core.xmind.org", "sharing/file/" + this.getID(), this.getAttributes(), null, null), new IReturnValueConsumer(){

            public IStatus consumeReturnValue(IProgressMonitor monitor, IStatus returnValue) {
                block5: {
                    IBinaryEntry entry;
                    IBinaryStore caches;
                    if (returnValue.isOK() && returnValue instanceof ReturnValue && (caches = ((ReturnValue)returnValue).getBinaryEntries()) != null && (entry = caches.getEntry("content")) != null) {
                        try {
                            cache[0] = RemoteSharedMap.this.saveResourceCache(monitor, entry);
                        }
                        catch (IOException e) {
                            LocalNetworkSharing.log("Failed to cache shared filed.", e);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!monitor.isCanceled()) break block5;
                            return Status.CANCEL_STATUS;
                        }
                    }
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        }, Options.DEFAULT);
        return cache[0];
    }

    private INamedEntry saveResourceCache(IProgressMonitor monitor, IBinaryEntry entry) throws IOException, InterruptedException {
        InputStream input = entry.openInputStream();
        try {
            INamedEntry iNamedEntry = this.getRemoteCaches().addEntry(monitor, input);
            return iNamedEntry;
        }
        finally {
            input.close();
        }
    }

    protected synchronized void invalidateResourceCache() {
        if (this.resourceCache != null) {
            this.getRemoteCaches().removeEntry(this.resourceCache.getName());
            this.resourceCache = null;
        }
    }

    private IBinaryStore getRemoteCaches() {
        return LocalNetworkSharing.getDefault().getRemoteCaches();
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RemoteSharedMap)) {
            return false;
        }
        RemoteSharedMap that = (RemoteSharedMap)obj;
        return this.getID().equals(that.getID()) && this.remoteServer.getInfo().getId().equals((Object)that.remoteServer.getInfo().getId());
    }

    public String toString() {
        return "RemoteSharedMap(" + this.getResourceName() + "@" + this.getID() + ")";
    }
}

